/**************************************************************************
 * 
 * Class:  Emulator
 * Author: Mark Roseman
 *
 * Simple vt-100 style terminal emulator, using a text buffer to manage
 * output.  This is based heavily on the emulator in InterViews 2.5.
 * 
 * Revision History:
 * 
 * Date     Modifier  Description
 * -------- --------- -------------------------------------------------------
 * 05/28/92 MR        initial version
 *
 **************************************************************************/

/*
 *  This file is part of GroupKit.
 *
 *  (c) Copyright 1992 Department of Computer Science, University of
 *      Calgary, Calgary, Alberta, Canada.  All rights reserved.
 *    
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appears in all copies.  The University
 *  of Calgary makes no representations about the suitability of this
 *  software for any purpose.  It is provided "as is" without express or
 *  implied warranty.
 */


#ifndef emulator_h
#define emulator_h

#include <InterViews/enter-scope.h>

class TextBuf;

class Emulator {
public:
    Emulator (TextBuf* t) { device = -1; text = t; within = 0; }
    void SetDevice (int fd) { device = fd; }
    void Write(const char*, int);
protected:
    int device;			/* needed for reply on terminal id */
    TextBuf* text;		/* output destination */
    int within;
    char escbuffer[50];

    void SetAttributes(int args[], int n);
    void Args(const char*, int len, int& bc, int& n, int args[]);
    boolean Valid(int, int numargs, int args[]);
    void DefaultArgs(int, int& numargs, int args[]);
    void SaveEscape(const char*, int blen, int bp);
    void CompleteEscape(const char*, int blen, int& bp);
    boolean ParseEscape(
	const char*, int blen, int obp, int& bc, int& c,
	int args[], int& numargs
    );
    void DoEscape(int, int args[], int nargs);
};


#endif


