/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <suntool/tool_hs.h>
#include "paintop.h"

static short	arrow_cursor_array[16]  =  {
	0xC000,0xE000,0xF000,0xF800,0xFC00,0xF000,0x9000,0x1800,
	0x1800,0x0C00,0x0C00,0x0600,0x0600,0x0300,0x0300,0x0100 };
mpr_static(arrow_cursor_pr, 16, 16, 1, arrow_cursor_array);
struct cursor	arrow_cursor  =  { 0, 0, MERGE, &arrow_cursor_pr };

static short	bull_cursor_array[16] = {
	0x0F00,0x30C0,0x4020,0x4020,0x8010,0x8610,0x8610,0x8010,
	0x4020,0x4020,0x30C0,0x0F00,0x0000,0x0000,0x0000,0x0000
	};
mpr_static(bull_cursor_pr, 16, 16, 1, bull_cursor_array);
struct cursor	bull_cursor  =  { 5, 5, INV_PAINT, &bull_cursor_pr };

static short	buster_cursor_array[16] = {
	0x0FE0,0x1010,0x2008,0x5004,0x8802,0x8402,0x8202,0x8102,
	0x8082,0x8042,0x8022,0x4014,0x2008,0x1010,0x0FE0,0x0000, };
mpr_static(buster_cursor_pr, 16, 16, 1, buster_cursor_array);
struct cursor	buster_cursor  =  { 7, 7, MERGE, &buster_cursor_pr };

static short	char_cursor_data[16] = {
		0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00,
		0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00, 0xFF00,
		};
mpr_static(char_cursor_pr, 16, 16, 1, char_cursor_data);
struct cursor	char_cursor  =  { 0, 13, INV_PAINT, &char_cursor_pr };

static short	crosshair_cursor_data[16] = {
		0x1000, 0x1000, 0x1000, 0xFE00, 0x1000, 0x1000, 0x1000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		};
mpr_static(crosshair_cursor_pr, 16, 16, 1, crosshair_cursor_data);
struct cursor	crosshair_cursor  =  { 3, 3, INV_PAINT, &crosshair_cursor_pr };

struct cursor	null_cursor  =  { 0, 0, MERGE, 0 };

static short	magnifier_cursor_array[16] = {
		0x0F80, 0x3060, 0x4010, 0x4010, 0x8008, 0x8008, 0x8008, 0x8008,
		0x8008, 0x4010, 0x4010, 0x3078, 0x0F9C, 0x000E, 0x0007, 0x0003,
		};
mpr_static(magnifier_cursor_pr, 16, 16, 1, magnifier_cursor_array);
struct cursor	magnifier_cursor  =  { 6, 6, MERGE, &magnifier_cursor_pr };

static short	pencil_cursor_array[16] = {
		0x0000, 0x0018, 0x0024, 0x0075, 0x009B, 0x0117, 0x022E, 0x045C,
		0x08B8, 0x1170, 0x22E0, 0x25C0, 0x7B80, 0x6700, 0x8600, 0x0800,
		};
mpr_static(pencil_cursor_pr, 16, 16, 1, pencil_cursor_array);
struct cursor	pencil_cursor  =  { 0, 14, MERGE, &pencil_cursor_pr };

static short	pick15_cursor_array[16] = {
		0x0FE0,0x1010,0x2008,0x4004,0x8002,0x8002,0x8002,0x8002,
		0x8002,0x8002,0x8002,0x4004,0x2008,0x1010,0x0FE0,0x0000, };
mpr_static(pick15_cursor_pr, 16, 16, 1, pick15_cursor_array);
struct cursor	pick15_cursor  =  { 7, 7, MERGE, &pick15_cursor_pr };

static short	pick9_cursor_array[16] = {
		0x3E00, 0x4100, 0x8080, 0x8080, 0x8080, 0x8080, 0x8080, 0x4100,
		0x3E00, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		};
mpr_static(pick9_cursor_pr, 16, 16, 1, pick9_cursor_array);
struct cursor	pick9_cursor  =  { 4, 4, MERGE, &pick9_cursor_pr };

static short	vbar_cursor_array[16] = {
		0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
		0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000,
		};
mpr_static(vbar_cursor_pr, 16, 16, 1, vbar_cursor_array);
struct cursor	vbar_cursor  =  { 0, 13, INV_PAINT, &vbar_cursor_pr };

static short	wait_cursor_array[16] = {
		0xFFE0,0x4040,0x4040,0x3F80,0x3F80,0x1F00,0x0E00,0x0400,
		0x0A00,0x1100,0x2080,0x2080,0x4040,0x4040,0xFFE0,0x0000, };
mpr_static(wait_cursor_pr, 16, 16, 1, wait_cursor_array);
struct cursor	wait_cursor = { 7, 5, MERGE, &wait_cursor_pr };

struct cursor	*cur_cursor = &arrow_cursor;  /* current cursor */
