unit CleanUp;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, iniFiles;

type
  TCleanUpDlg = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    DlgCheckBox: TCheckBox;
    AuxCheckBox: TCheckBox;
    BakCheckBox: TCheckBox;
    BblCheckBox: TCheckBox;
    BlgCheckBox: TCheckBox;
    DviCheckBox: TCheckBox;
    GloCheckBox: TCheckBox;
    IdxCheckBox: TCheckBox;
    IlgCheckBox: TCheckBox;
    IndCheckBox: TCheckBox;
    LofCheckBox: TCheckBox;
    LogCheckBox: TCheckBox;
    LotCheckBox: TCheckBox;
    TocCheckBox: TCheckBox;
    BClearMarks: TButton;
    BSetMarks: TButton;
    BReset: TButton;
    procedure OKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BSetMarksClick(Sender: TObject);
    procedure BClearMarksClick(Sender: TObject);
    procedure BResetClick(Sender: TObject);
  private
    procedure DeleteFiles (template: string);
  public
    { Public declarations }
  end;

var
  CleanUpDlg: TCleanUpDlg;

implementation

uses Frame;

{$R *.DFM}

procedure TCleanUpDlg.OKBtnClick(Sender: TObject);
begin
  if  DlgCheckBox.Checked then DeleteFiles ('*.dlg');
  if  AuxCheckBox.Checked then DeleteFiles ('*.aux');
  if  BakCheckBox.Checked then DeleteFiles ('*.bak');
  if  BblCheckBox.Checked then DeleteFiles ('*.bbl');
  if  BlgCheckBox.Checked then DeleteFiles ('*.blg');
  if  DviCheckBox.Checked then DeleteFiles ('*.dvi');
  if  GloCheckBox.Checked then DeleteFiles ('*.glo');
  if  IdxCheckBox.Checked then DeleteFiles ('*.idx');
  if  IlgCheckBox.Checked then DeleteFiles ('*.ilg');
  if  IndCheckBox.Checked then DeleteFiles ('*.ind');
  if  LofCheckBox.Checked then DeleteFiles ('*.lof');
  if  LogCheckBox.Checked then DeleteFiles ('*.log');
  if  LotCheckBox.Checked then DeleteFiles ('*.lot');
  if  TocCheckBox.Checked then DeleteFiles ('*.toc');
end;


procedure TCleanUpDlg.DeleteFiles (template: string);
var searchRec: TSearchRec;
    success: integer;
begin
  success := FindFirst (template, faArchive, searchRec);
  while success = 0 do
  begin
    DeleteFile (searchRec.Name);
    success := FindNext (searchRec);
  end;
  FindClose (SearchRec);
end;


procedure TCleanUpDlg.FormCreate(Sender: TObject);
var iniFile: TIniFile;
begin
  iniFile := TIniFile.Create (FrameForm.iniFileName);

  DlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'dlg', false);
  AuxCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'aux', false);
  BakCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'bak', false);
  BblCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'bbl', false);
  BlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'blg', false);
  DviCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'dvi', false);
  GloCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'glo', false);
  IdxCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'idx', false);
  IlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'ilg', false);
  IndCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'ind', false);
  LofCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'lof', false);
  LogCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'log', false);
  LotCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'lot', false);
  TocCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'toc', false);

  iniFile.Free;
end;

procedure TCleanUpDlg.FormDestroy(Sender: TObject);
var iniFile: TIniFile;
begin
  if FrameForm.lockIniFile = false then //*DS* ini file may be locked in network environment
  begin
    iniFile := TIniFile.Create (FrameForm.userIniFileName);

    iniFile.WriteBool ('CleanUp', 'dlg', DlgCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'aux', AuxCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'bak', BakCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'bbl', BblCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'blg', BlgCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'dvi', DviCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'glo', GloCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'idx', IdxCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'ilg', IlgCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'ind', IndCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'lof', LofCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'log', LogCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'lot', LotCheckBox.Checked);
    iniFile.WriteBool ('CleanUp', 'toc', TocCheckBox.Checked);

    iniFile.Free;
  end;
end;

//*PN*
procedure TCleanUpDlg.BSetMarksClick(Sender: TObject);
begin
  DlgCheckBox.Checked := true;
  AuxCheckBox.Checked := true;
  BakCheckBox.Checked := true;
  BBLCheckBox.Checked := true;
  BlgCheckBox.Checked := true;
  DviCheckBox.Checked := true;
  GloCheckBox.Checked := true;
  IdxCheckBox.Checked := true;
  IlgCheckBox.Checked := true;
  IndCheckBox.Checked := true;
  LofCheckBox.Checked := true;
  LogCheckBox.Checked := true;
  LotCheckBox.Checked := true;
  TocCheckBox.Checked := true;
end;

procedure TCleanUpDlg.BClearMarksClick(Sender: TObject);
begin
  DlgCheckBox.Checked := false;
  AuxCheckBox.Checked := false;
  BakCheckBox.Checked := false;
  BBLCheckBox.Checked := false;
  BlgCheckBox.Checked := false;
  DviCheckBox.Checked := false;
  GloCheckBox.Checked := false;
  IdxCheckBox.Checked := false;
  IlgCheckBox.Checked := false;
  IndCheckBox.Checked := false;
  LofCheckBox.Checked := false;
  LogCheckBox.Checked := false;
  LotCheckBox.Checked := false;
  TocCheckBox.Checked := false;
end;

procedure TCleanUpDlg.BResetClick(Sender: TObject);
var iniFile: TIniFile;
begin
  iniFile := TIniFile.Create (FrameForm.iniFileName);

  DlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'dlg', false);
  AuxCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'aux', false);
  BakCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'bak', false);
  BblCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'bbl', false);
  BlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'blg', false);
  DviCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'dvi', false);
  GloCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'glo', false);
  IdxCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'idx', false);
  IlgCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'ilg', false);
  IndCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'ind', false);
  LofCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'lof', false);
  LogCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'log', false);
  LotCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'lot', false);
  TocCheckBox.Checked := iniFile.ReadBool ('CleanUp', 'toc', false);

  iniFile.Free;

end;

end.
