# Copyright (C) 1999 - Martin Strauss - under terms of GPL
#####################################################
# show help
# ok !
proc Help {NAME} {
 global T HLP
 global hlppath hlptxt hlpfile
 if [info exists HLP($NAME)] {
 
  # Liste vorhandener Hilfen
  set ii 0
  foreach i $HLP($NAME) {
   if [string match "$T(language)*" $i] {
    incr ii
    lappend liste $i "$T(language) $ii"
   }
  }
  foreach i $HLP($NAME) {
   if ![string match "$T(language)*" $i] {
    incr ii
    lappend liste $i "[lindex [split $i "/"] 0] $ii"
   }
  }
  HLP_open $NAME [lindex $liste 0] [lindex $liste 1]
  if [winfo exists .whelp] {
   .whelp.f2.mb.m delete 0 end
   foreach {i t} $liste {
   .whelp.f2.mb.m add command -label $t -command "HLP_open $NAME $i {$t}"
   }
   .whelp.f2.e delete 0 end
   .whelp.f2.e insert 0 $NAME
  }
 }
 HLP_gif $NAME
}
###############################################
# help from inside a text
# ok !
proc HelpTo {NAME} {
 global T HLP
 set flag 1
 set key [$NAME get insert insert+1c]
 if ![string compare $key "\\"] then {
  set strt insert+1c
 } else {
  set strt insert
 }
 set ID [array startsearch HLP] 
 while {[array anymore HLP $ID]} {
  set elm [array nextelement HLP $ID]
  set velm [$NAME get $strt insert+[expr [string length $elm] + 1]c]
  if ![string compare $elm $velm] then {
   Help $elm
   set flag 0
  }
 }
 array donesearch HLP $ID
 if $flag then {
   Help $T(Helpto-Help)
 }
}
##########################
##########################
proc HLP_load {} {
 global hlppath HLP
 if [file exists $hlppath/index] {
  set f [open $hlppath/index r]
  set L [read $f]
  close $f
  array set HLP $L
 } {set HLP(ERROR) ERROR}
}
proc HLP_open {NAME FILE Text} {
 global T hlppath hlptxt hlpfile
 if ![winfo exists .whelp] {set hlpfile ""} 
 if {[string compare $FILE $hlpfile] != 0} {
  if [file exists "$hlppath/$FILE"] then {
   set f [open "$hlppath/$FILE" r]
   HLP_plainwindow
   .whelp.f2.mb configure -text $Text
   .whelp.f.l configure -state normal
   .whelp.f.l delete 1.0 end
   .whelp.f.l insert 1.0 [read $f]
   .whelp.f.l configure -state disabled
   close $f
   set hlpfile $FILE
   set pos [.whelp.f.l search "::" 1.0 end]
   while {$pos!=""} {
    .whelp.f.l tag add invisible $pos "$pos lineend"
    set pos [.whelp.f.l search "::" "$pos+1c" end]
   }
   set ksp "::"
   set ksp [.whelp.f.l search -- $ksp$NAME$ksp pos]
   if {$ksp != ""} then {
    .whelp.f.l mark set pos $ksp
    .whelp.f.l see pos
   }
   focus .whelp
  } {
   if [winfo exists .whelp] then {
    .whelp.f.l configure -state normal
    .whelp.f.l delete 1.0 end
    eval ".whelp.f.l insert 1.0 \"$T(whelp-no-source)\""
    .whelp.f.l configure -state disabled
   }
  }
 }
}
proc HLP_plainwindow {} {
 global T
 if ![winfo exists .whelp] then {
  toplevel .whelp
  wm title .whelp $T(whelp-titel)
 
  frame .whelp.f

  scrollbar .whelp.f.vscroll -relief sunken -command {.whelp.f.l yview}
  text .whelp.f.l -yscroll {.whelp.f.vscroll set}
  pack .whelp.f.vscroll  -side right -fill y
  pack .whelp.f.l -expand yes -fill both
  frame .whelp.f2
  menubutton .whelp.f2.mb -menu .whelp.f2.mb.m
  menu .whelp.f2.mb.m
  button .whelp.f2.butup -text up -command {
   .whelp.f.l tag remove show 1.0 end
   set ksp [.whelp.f.l search -backwards -- [.whelp.f2.e get] pos]
   if {$ksp != ""} then {
    .whelp.f.l mark set pos $ksp
    .whelp.f.l see pos
    .whelp.f.l tag add show pos "pos wordend"
   } 
  }
  button .whelp.f2.butdown -text down -command {
   .whelp.f.l tag remove show 1.0 end
   set ksp [.whelp.f.l search -- [.whelp.f2.e get] pos+1c]
   if {$ksp != ""} then {
    .whelp.f.l mark set pos $ksp
    .whelp.f.l see pos
    .whelp.f.l tag add show pos "pos wordend"
   } 
  }
  entry .whelp.f2.e
  button .whelp.f2.butQ -text $T(quit) -command {
   destroy .whelp
  }
  
  pack .whelp.f -expand yes -fill y
  pack .whelp.f2.mb .whelp.f2.butup .whelp.f2.butdown .whelp.f2.e .whelp.f2.butQ -side left
  pack .whelp.f2
  COLOR .whelp 
  .whelp.f.l tag add invisible 1.0 1.0
  .whelp.f.l tag add show 1.0 1.0
  .whelp.f.l tag configure invisible -foreground [.whelp.f.l cget -bg]
  .whelp.f.l tag configure show -foreground Red
  .whelp.f.l tag raise invisible
   .whelp.f.l mark set pos 1.0
 }
}
proc HLP_gif Name {
 global gifpath I_txt
 if [info exists I_txt($Name)] {
  if [file exists "$gifpath/$I_txt($Name).gif"] then {
   if ![winfo exists .whelpgif] then {
    toplevel .whelpgif
  
    button .whelpgif.butQ -image [Bild $Name] -command {
     destroy .whelpgif
    }
    pack .whelpgif.butQ
    COLOR .whelpgif
   } else {
    .whelpgif.butQ configure -image [Bild $Name]
    focus .whelpgif
   }
  } {
   if [winfo exists .whelpgif] then { 
    .whelpgif.butQ configure -image MasterBildSlaveOff
   }
  }
 } {
  if [winfo exists .whelpgif] then { 
   .whelpgif.butQ configure -image MasterBildSlaveOff
  }
 }
}