/* macintosh.c  4.5.1993
 *
 * Functions calling Macintosh file system and user interface
 * routines for use by rtf2LaTeX by Erwin Wechtl.
 *
 * Written and copyright (c) 1993 by Alex Viskovatoff
 * (visko@harvard.edu). Permission is granted to
 * distribute and modify this file.
 */

#include <MacHeaders>
#include "macintosh.h"

static char home_pathname_buf[PATHNAME_LENGTH];

static char *make_pathname(char *q,long dir_id, int vol_num)
{
	CInfoPBRec	directory;
	Str31		dir_name;
	int			n;
	directory.dirInfo.ioDrDirID = dir_id;
	directory.dirInfo.ioVRefNum = vol_num;
	directory.dirInfo.ioFDirIndex = -1;
	directory.dirInfo.ioNamePtr = dir_name;
	for (;;directory.dirInfo.ioDrDirID = directory.dirInfo.ioDrParID) {
		*q-- = ':';
		PBGetCatInfoSync(&directory);
		for (n=*dir_name; n; n--) *q-- = (char) dir_name[n];
		if (directory.dirInfo.ioDrDirID == 2) break;
	}
	return q+1;
}	

char *get_home_dir()
{
	FCBPBRec	home_dir;
	Str31		dir_name;
	Str31		apName;
	int			pathRefNum;
	Handle		apParam;
	char 	   *p = home_pathname_buf+PATHNAME_LENGTH-1;
	GetAppParms(&apName,&pathRefNum,&apParam);
	home_dir.ioRefNum = pathRefNum;
	home_dir.ioFCBIndx = 0;
	home_dir.ioNamePtr = dir_name;
	PBGetFCBInfoSync(&home_dir);
	*p-- = 0;
	return make_pathname(p,home_dir.ioFCBParID,home_dir.ioFCBVRefNum);
}

static pascal Boolean not_rtf_file_p(ioParam *parms)
{
	StringPtr name = parms->ioNamePtr;
	char *p, *q;
	static char extension[] = ".rtf";
	int i;
	if (name[0] < 5) return TRUE;
	for (i=4, p = (char*) name + name[0] - 3, q=extension; i; i--)
		if (*p++ != *q++) return TRUE;
	return FALSE;
}

char *get_file_from_dialog()
{
	static char	buf[PATHNAME_LENGTH];
	SFReply		reply;
	Point		dialog_loc = {100,100};
	long		text_file_type = 'TEXT';
	SFGetFile(dialog_loc,"\p0",&not_rtf_file_p,1,&text_file_type,NULL,&reply);
	if (reply.good) {
		WDPBRec		working_dir;
		CInfoPBRec	directory;
		Str31		ioName;
		int n;
		unsigned char *p;
		char *pname_start;
		char *q = buf+PATHNAME_LENGTH-1;
		unsigned char *filename = reply.fName;
		*q-- = 0;
		for (n=*filename; n; n--) *q-- = filename[n];
		working_dir.ioVRefNum = reply.vRefNum;
		working_dir.ioNamePtr = filename;
		working_dir.ioWDIndex = 0;
		PBGetWDInfoSync(&working_dir);
		return make_pathname(q,working_dir.ioWDDirID,working_dir.ioWDVRefNum);
	}
	else return NULL;
}
