/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFString;
import de.tu_darmstadt.sp.paul.filter.ASCIIHexDecodeInputFilter;
import de.tu_darmstadt.sp.paul.filter.ASCIIHexDecodeOutputFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;

public class PDFBinString
extends PDFString {
    String val;
    static final char OPENING_QUOTE = '<';
    static final char CLOSING_QUOTE = '>';

    public PDFBinString(String init) {
        this.val = init;
    }

    public PDFBinString(String init, Object flag) {
        ASCIIHexDecodeInputFilter readfilter = new ASCIIHexDecodeInputFilter(new ByteArrayInputStream(init.getBytes()));
        StringBuffer buf = new StringBuffer();
        try {
            int c;
            while ((c = readfilter.read()) != -1) {
                buf.append((char)c);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error decoding HexString with ASCIIHexDecodeInputFilter: " + e.toString());
        }
        this.val = buf.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof PDFBinString && this.val.equals(((PDFBinString)obj).val);
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public String toString() {
        return this.val;
    }

    public void write(Writer out) throws IOException {
        out.write(60);
        ByteArrayOutputStream bufStream = new ByteArrayOutputStream();
        new ASCIIHexDecodeOutputFilter(bufStream).write(this.val.getBytes());
        out.write(bufStream.toString());
        out.write(62);
    }
}

