/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import java.io.InputStream;
import org.mariadb.jdbc.internal.common.PacketFetcher;
import org.mariadb.jdbc.internal.common.packet.RawPacket;

public class SyncPacketFetcher
implements PacketFetcher {
    private final InputStream inputStream;

    public SyncPacketFetcher(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public RawPacket getRawPacket() throws IOException {
        return RawPacket.nextPacket(this.inputStream);
    }

    @Override
    public void clearInputStream() throws IOException {
        int available = this.inputStream.available();
        while (available > 0) {
            available = (int)((long)available - this.inputStream.skip(available));
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

