/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.rendering.Glyph2D;

final class Type1Glyph2D
implements Glyph2D {
    private static final Log LOG = LogFactory.getLog(Type1Glyph2D.class);
    private final Map<Integer, GeneralPath> cache = new HashMap<Integer, GeneralPath>();
    private final PDSimpleFont font;

    Type1Glyph2D(PDSimpleFont font) {
        this.font = font;
    }

    @Override
    public GeneralPath getPathForCharacterCode(int code) {
        if (this.cache.containsKey(code)) {
            return this.cache.get(code);
        }
        try {
            GeneralPath path;
            String name = this.font.getEncoding().getName(code);
            if (!this.font.hasGlyph(name)) {
                LOG.warn("No glyph for " + code + " (" + name + ") in font " + this.font.getName());
            }
            if ((path = this.font.getPath(name)) == null) {
                path = this.font.getPath(".notdef");
            }
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            LOG.error("Glyph rendering failed", e);
            return new GeneralPath();
        }
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

