/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.utils;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;

public final class COSUtils {
    private static final Log LOGGER = LogFactory.getLog(COSUtils.class);

    private COSUtils() {
    }

    public static boolean isDictionary(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && obj.getObject() instanceof COSDictionary;
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSDictionary;
    }

    public static boolean isString(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && (obj.getObject() instanceof COSString || obj.getObject() instanceof COSName);
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSString || elt instanceof COSName;
    }

    public static boolean isStream(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && obj.getObject() instanceof COSStream;
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSStream;
    }

    public static boolean isInteger(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && obj.getObject() instanceof COSInteger;
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSInteger;
    }

    public static boolean isNumeric(COSBase elt, COSDocument doc) {
        return COSUtils.isInteger(elt, doc) || COSUtils.isFloat(elt, doc);
    }

    public static boolean isFloat(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && obj.getObject() instanceof COSFloat;
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSFloat;
    }

    public static boolean isArray(COSBase elt, COSDocument doc) {
        if (elt instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)elt);
                COSObject obj = doc.getObjectFromPool(key);
                return obj != null && obj.getObject() instanceof COSArray;
            }
            catch (IOException e) {
                return false;
            }
        }
        return elt instanceof COSArray;
    }

    public static COSArray getAsArray(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj != null && obj.getObject() instanceof COSArray) {
                    return (COSArray)obj.getObject();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSArray) {
            return (COSArray)cbase;
        }
        return null;
    }

    public static String getAsString(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj != null && obj.getObject() instanceof COSString) {
                    return ((COSString)obj.getObject()).getString();
                }
                if (obj != null && obj.getObject() instanceof COSName) {
                    return ((COSName)obj.getObject()).getName();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSString) {
            return ((COSString)cbase).getString();
        }
        if (cbase instanceof COSName) {
            return ((COSName)cbase).getName();
        }
        return null;
    }

    public static COSDictionary getAsDictionary(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj != null && obj.getObject() instanceof COSDictionary) {
                    return (COSDictionary)obj.getObject();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSDictionary) {
            return (COSDictionary)cbase;
        }
        return null;
    }

    public static COSStream getAsStream(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj != null && obj.getObject() instanceof COSStream) {
                    return (COSStream)obj.getObject();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSStream) {
            return (COSStream)cbase;
        }
        return null;
    }

    public static Float getAsFloat(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj == null) {
                    return null;
                }
                if (obj.getObject() instanceof COSNumber) {
                    return Float.valueOf(((COSNumber)obj.getObject()).floatValue());
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSNumber) {
            return Float.valueOf(((COSNumber)cbase).floatValue());
        }
        return null;
    }

    public static Integer getAsInteger(COSBase cbase, COSDocument cDoc) {
        if (cbase instanceof COSObject) {
            try {
                COSObjectKey key = new COSObjectKey((COSObject)cbase);
                COSObject obj = cDoc.getObjectFromPool(key);
                if (obj == null) {
                    return null;
                }
                if (obj.getObject() instanceof COSNumber) {
                    return ((COSNumber)obj.getObject()).intValue();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        if (cbase instanceof COSNumber) {
            return ((COSNumber)cbase).intValue();
        }
        return null;
    }

    public static void closeDocumentQuietly(COSDocument document) {
        try {
            if (document != null) {
                document.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error occured during the close of a COSDocument : " + e.getMessage());
        }
    }

    public static void closeDocumentQuietly(PDDocument document) {
        if (document != null) {
            COSUtils.closeDocumentQuietly(document.getDocument());
        }
    }
}

