#pragma once

#include <string>

using namespace std;

// 'input': the latex formula to convert
// 'len'  : the length of 'input'; use a value <0 to indicate that 'input' is null terminated
// 'errorIndex': on error, this gives the location in 'input' where the error was found

bool convertFormula( const char *input, int len, int *errorIndex );

// raw copy, i.e., without the '<math>' tag
const char *getMathMLOutput();

// 'buf': the buffer where the output will be written to
// 'display: flag indicating whether the output is either an inline or a display equation
bool getMathMLOutput(string &buf, bool display);

// function for obtaining the error message

const char *getLastError();
