/*  Main program for ETTOTEX in C
    ANSI C

    4 Apr 91 JCC  Ignore end-of-file character. Convert char constants
                  to K&R (i.e., \000 not \x0).
   29 Mar 91 JCC  Remove CRs on input -- to work with UNIX.
   27 Mar 91 JCC  Handle several adjacent mathcodes.
   23 Mar 91 JCC  Get it working
   10 Mar 91 JCC  Start
*/

#include <stdio.h>
#include <string.h>

#include "etdefs.h"

#define SIGNON       "ET to TeX converter, C version 1.02.  JCC  4 Apr 91\n"
#define MAXFILENAME  100

#define UNDEF        "\\undef" /* String for undefined Greek */

#define FALSE 0
#define TRUE  1
#define CR    13

/* ========== TYPES: ========= */
typedef char       *transtring;
typedef transtring greektran[256];

/* ==== GLOBAL VARIABLES: ======= */
greektran greektable;

/* ===== FUNCTION DECLARATIONS: ======= */
void  init (void);
int   process_et_file (char *sourcename, char *destname);
int   exist (char* filename);
int peekchar (FILE *source);
void fixmath (FILE *source, FILE *dest);
int isETmath (char c);
int ismath (char c);


/* ===========  TRANSLATION TABLE =========== */
#include "ettran.inc"  /* Definition of translation of Greek/symbol */

int main (int argc, char *argv[])
{  char sourcename[MAXFILENAME+1], destname[MAXFILENAME+1];
      /* Leave space for the null! */

   printf (SIGNON);
   if (argc < 2)
      {
      puts ("Usage:  ettotexc file");
      puts (" converts file.et to file.tex.");
      return (1);
      }

   init();
   strncpy (sourcename, argv[1], MAXFILENAME-4);
   strncpy (destname, argv[1], MAXFILENAME-4);
   strcat  (sourcename, ".et");
   strcat  (destname, ".tex");
   if (!exist (sourcename)) {
      printf ("%s%s%s", "Source file ", sourcename, " does not exist.\n");
      return (2);
   }
   return (process_et_file (sourcename, destname));
}

int process_et_file (char *sourcename, char *destname)
{  FILE *source, *dest;
   int c;
   int numlines;

   numlines = 0;
   source = fopen (sourcename, "r");
   dest   = fopen (destname, "w");
   while ((c = getc(source)) != EOF) {
      switch (c) {
         case symbol:    if (!feof (source)) {
                           c = getc(source) % 256;
                           if (greektable[c])
                              fputs (greektable[c], dest);
                           else fprintf (dest, "%s{%i}", UNDEF, c);
                         };
                         break;
         case bksp:      fputs ("\\llap ", dest); break;

         case beginsub:  fputs ("_{", dest); break;
         case endsub:    fputs ("}", dest); break;
         case beginsup:  fputs ("^{", dest); break;
         case endsup:    fputs ("}", dest); break;
                         /* In following prevent trouble if an ET begin
                            or end math or eq is followed by another math
                            begin or end; translation of begin or end math
                            to single $ changes meaning when immediately
                            followed by another $ in translation: */
         case beginmath: fputs ("$", dest); fixmath(source, dest); break;
         case endmath:   fputs ("$", dest); fixmath(source, dest); break;
         case begineq:   fputs ("$$", dest); fixmath(source, dest); break;
         case endeq:     fputs ("$$", dest); fixmath(source, dest); break;
         case beginarg:  fputs ("{", dest); break;
         case endarg:    fputs ("}", dest); break;
         case beginfrac: fputs ("\\frac ", dest); break;
         case endfrac:   break;

         case beginlog:  fputs ("\\beginlog ", dest); break;
         case endlog:    fputs ("\\endlog ", dest); break;
         case beginmac:  fputs ("\\beginmac ", dest); break;
         case endmac:    fputs ("\\endmac ", dest); break;

         case CR: break; /* ignore carriage return (for UNIX!) */

         case TeXActiveCh:
         case CommentChar:
         default: putc (c, dest);
            if (c == '$') {
              /* Prevent trouble if TeX math toggle is followed by
                 ET begin or end math or equation: */
              if (isETmath (peekchar(source))) putc (' ', dest);
            } else if (c == '\n') {
               numlines++;
               if (numlines % 50 == 0)
                  fprintf (stderr, "[%i]%c", numlines, CR);
            }
      }
   }
   fclose (source);
   fclose (dest);
   printf ("%i lines processed\n", numlines);
   return (0);
}

int peekchar (FILE *source) {
   return (ungetc( getc(source), source));
}

void fixmath (FILE *source, FILE *dest){
   /* If next character is math toggle etc, insert space */
   if (ismath(peekchar(source))) putc (' ', dest);
}

int isETmath (char c) {
   return ((c==beginmath) || (c==endmath) || (c==begineq) || (c==endeq));
}

int ismath (char c) {
   return (isETmath(c) || (c=='$'));
}

void init (void)
{ int c;
  char *p;

  for (c=0; c<=255; c++) greektable[c] = NULL;
  p = translate;
  while (*p) {
     c = (*p) %256;
     p++;
     greektable[c] = p;
     p += strlen (p) + 1;   /* Allow for null at end. */
  }
};

/* ======== UTILS: =========*/

int exist (char* filename)
{ FILE* stream;
  stream = fopen (filename, "r");
  if (stream != NULL) {
     fclose (stream);
     return (TRUE);
  } else {
     return (FALSE);
  }
}

