/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.injectors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.Emjection;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.injectors.ParameterNameBinding;
import org.picocontainer.injectors.SingleMemberInjector;
import org.picocontainer.monitors.NullComponentMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorInjector<T>
extends SingleMemberInjector<T> {
    private transient List<Constructor<T>> sortedMatchingConstructors;
    private transient AbstractInjector.ThreadLocalCyclicDependencyGuard<T> instantiationGuard;
    private boolean rememberChosenConstructor = true;
    private transient CtorAndAdapters<T> chosenConstructor;
    private boolean enableEmjection = false;
    private boolean allowNonPublicClasses = false;

    public ConstructorInjector(Object componentKey, Class<?> componentImplementation, Parameter ... parameters) {
        this(componentKey, (Class)componentImplementation, parameters, (ComponentMonitor)new NullComponentMonitor(), false);
    }

    public ConstructorInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
    }

    public ConstructorInjector(Object componentKey, Class componentImplementation, Parameter[] parameters, ComponentMonitor monitor, boolean useNames, boolean rememberChosenCtor) throws AbstractInjector.NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, monitor, useNames);
        this.rememberChosenConstructor = rememberChosenCtor;
    }

    private CtorAndAdapters<T> getGreediestSatisfiableConstructor(PicoContainer guardedContainer, Class<? extends T> componentImplementation) {
        CtorAndAdapters<T> ctor = null;
        try {
            if (this.chosenConstructor == null) {
                ctor = this.getGreediestSatisfiableConstructor(guardedContainer);
            }
            if (this.rememberChosenConstructor) {
                if (this.chosenConstructor == null) {
                    this.chosenConstructor = ctor;
                } else {
                    ctor = this.chosenConstructor;
                }
            }
        }
        catch (AbstractInjector.AmbiguousComponentResolutionException e) {
            e.setComponent(this.getComponentImplementation());
            throw e;
        }
        return ctor;
    }

    protected CtorAndAdapters<T> getGreediestSatisfiableConstructor(PicoContainer container) throws PicoCompositionException {
        HashSet<Constructor<T>> conflicts = new HashSet<Constructor<T>>();
        HashSet<Type> unsatisfiableDependencyTypes = new HashSet<Type>();
        HashMap<ResolverKey, Parameter.Resolver> resolvers = new HashMap<ResolverKey, Parameter.Resolver>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        Constructor<T> greediestConstructor = null;
        Parameter[] greediestConstructorsParameters = null;
        ComponentAdapter[] greediestConstructorsParametersComponentAdapters = null;
        int lastSatisfiableConstructorSize = -1;
        Type unsatisfiedDependency = null;
        Constructor<T> unsatisfiedConstructor = null;
        for (Constructor<T> sortedMatchingConstructor : this.sortedMatchingConstructors) {
            try {
                boolean failedDependency = false;
                Type[] parameterTypes = sortedMatchingConstructor.getGenericParameterTypes();
                this.fixGenericParameterTypes(sortedMatchingConstructor, parameterTypes);
                Annotation[] bindings = this.getBindings(sortedMatchingConstructor.getParameterAnnotations());
                Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes.length);
                ComponentAdapter[] currentAdapters = new ComponentAdapter[currentParameters.length];
                for (int j = 0; j < currentParameters.length; ++j) {
                    Type expectedType = this.box(parameterTypes[j]);
                    ParameterNameBinding expectedNameBinding = new ParameterNameBinding(this.getParanamer(), sortedMatchingConstructor, j);
                    ResolverKey resolverKey = new ResolverKey(expectedType, this.useNames() ? expectedNameBinding.getName() : null, this.useNames(), bindings[j], currentParameters[j]);
                    Parameter.Resolver resolver = (Parameter.Resolver)resolvers.get(resolverKey);
                    if (resolver == null) {
                        resolver = currentParameters[j].resolve(container, this, null, expectedType, expectedNameBinding, this.useNames(), bindings[j]);
                        resolvers.put(resolverKey, resolver);
                    }
                    if (resolver.isResolved()) {
                        currentAdapters[j] = resolver.getComponentAdapter();
                        continue;
                    }
                    unsatisfiableDependencyTypes.add(expectedType);
                    unsatisfiedDependency = this.box(parameterTypes[j]);
                    unsatisfiedConstructor = sortedMatchingConstructor;
                    failedDependency = true;
                }
                if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                    if (conflicts.isEmpty()) {
                        return new CtorAndAdapters<T>(greediestConstructor, greediestConstructorsParameters, greediestConstructorsParametersComponentAdapters);
                    }
                    conflicts.add(sortedMatchingConstructor);
                    continue;
                }
                if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                    conflicts.add(sortedMatchingConstructor);
                    conflicts.add(greediestConstructor);
                    continue;
                }
                if (failedDependency) continue;
                greediestConstructor = sortedMatchingConstructor;
                greediestConstructorsParameters = currentParameters;
                greediestConstructorsParametersComponentAdapters = currentAdapters;
                lastSatisfiableConstructorSize = parameterTypes.length;
            }
            catch (AbstractInjector.AmbiguousComponentResolutionException e) {
                e.setMember(sortedMatchingConstructor);
                throw e;
            }
        }
        if (!conflicts.isEmpty()) {
            throw new PicoCompositionException(conflicts.size() + " satisfiable constructors is too many for '" + this.getComponentImplementation() + "'. Constructor List:" + ((Object)conflicts).toString().replace(this.getComponentImplementation().getName(), "<init>").replace("public <i", "<i"));
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new AbstractInjector.UnsatisfiableDependenciesException(this.getComponentImplementation().getName() + " has unsatisfied dependency '" + unsatisfiedDependency + "' for constructor '" + unsatisfiedConstructor + "'" + " from " + container);
        }
        if (greediestConstructor == null) {
            HashSet<Constructor<T>> nonMatching = new HashSet<Constructor<T>>();
            for (Constructor<T> constructor : this.getConstructors()) {
                nonMatching.add(constructor);
            }
            throw new PicoCompositionException("Either the specified parameters do not match any of the following constructors: " + ((Object)nonMatching).toString() + "; OR the constructors were not accessible for '" + this.getComponentImplementation().getName() + "'");
        }
        return new CtorAndAdapters(greediestConstructor, greediestConstructorsParameters, greediestConstructorsParametersComponentAdapters);
    }

    private String toList(Set<Type> unsatisfiableDependencyTypes) {
        StringBuilder sb = new StringBuilder();
        for (Type next : unsatisfiableDependencyTypes) {
            sb.append(next.toString().replace("class ", ""));
            sb.append(", ");
        }
        String s = sb.toString();
        return s.substring(0, s.lastIndexOf(", "));
    }

    public void enableEmjection(boolean enableEmjection) {
        this.enableEmjection = enableEmjection;
    }

    public ConstructorInjector<T> withNonPublicConstructors() {
        this.allowNonPublicClasses = true;
        return this;
    }

    private void fixGenericParameterTypes(Constructor<T> ctor, Type[] parameterTypes) {
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (!(parameterType instanceof TypeVariable)) continue;
            parameterTypes[i] = ctor.getParameterTypes()[i];
        }
    }

    @Override
    public T getComponentInstance(final PicoContainer container, Type into) throws PicoCompositionException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard<T>(){

                @Override
                public T run(Object instance) {
                    CtorAndAdapters ctorAndAdapters = ConstructorInjector.this.getGreediestSatisfiableConstructor(this.guardedContainer, ConstructorInjector.this.getComponentImplementation());
                    ComponentMonitor componentMonitor = ConstructorInjector.this.currentMonitor();
                    Constructor ctor = ctorAndAdapters.getConstructor();
                    try {
                        Object[] ctorParameters = ctorAndAdapters.getParameterArguments(this.guardedContainer);
                        ctor = componentMonitor.instantiating(container, ConstructorInjector.this, ctor);
                        if (ctorAndAdapters == null) {
                            throw new NullPointerException("Component Monitor " + componentMonitor + " returned a null constructor from method 'instantiating' after passing in " + ctorAndAdapters);
                        }
                        long startTime = System.currentTimeMillis();
                        Object inst = ConstructorInjector.this.newInstance(ctor, ctorParameters);
                        componentMonitor.instantiated(container, ConstructorInjector.this, ctor, inst, ctorParameters, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InvocationTargetException e) {
                        componentMonitor.instantiationFailed(container, ConstructorInjector.this, ctor, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoCompositionException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        return ConstructorInjector.this.caughtInstantiationException(componentMonitor, ctor, e, container);
                    }
                    catch (IllegalAccessException e) {
                        return ConstructorInjector.this.caughtIllegalAccessException(componentMonitor, ctor, e, container);
                    }
                }
            };
        }
        this.instantiationGuard.setGuardedContainer(container);
        T inst = this.instantiationGuard.observe(this.getComponentImplementation(), null);
        this.decorate(inst, container);
        return inst;
    }

    private void decorate(T inst, PicoContainer container) {
        if (this.enableEmjection) {
            Emjection.setupEmjection(inst, container);
        }
    }

    private List<Constructor<T>> getSortedMatchingConstructors() {
        Constructor<T>[] allConstructors;
        ArrayList<Constructor<T>> matchingConstructors = new ArrayList<Constructor<T>>();
        for (Constructor<T> constructor : allConstructors = this.getConstructors()) {
            int modifiers = constructor.getModifiers();
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (modifiers & 1) == 0) continue;
            if ((modifiers & 1) == 0) {
                constructor.setAccessible(true);
            }
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator<Constructor>(){

                @Override
                public int compare(Constructor arg0, Constructor arg1) {
                    return arg1.getParameterTypes().length - arg0.getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private Constructor<T>[] getConstructors() {
        return AccessController.doPrivileged(new PrivilegedAction<Constructor<T>[]>(){

            @Override
            public Constructor<T>[] run() {
                return ConstructorInjector.this.getComponentImplementation().getDeclaredConstructors();
            }
        });
    }

    @Override
    public void verify(final PicoContainer container) throws PicoCompositionException {
        if (this.verifyingGuard == null) {
            this.verifyingGuard = new AbstractInjector.ThreadLocalCyclicDependencyGuard(){

                public Object run(Object instance) {
                    Constructor constructor = ConstructorInjector.this.getGreediestSatisfiableConstructor(this.guardedContainer).getConstructor();
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    Parameter[] currentParameters = ConstructorInjector.this.parameters != null ? ConstructorInjector.this.parameters : ConstructorInjector.this.createDefaultParameters(parameterTypes.length);
                    for (int i = 0; i < currentParameters.length; ++i) {
                        currentParameters[i].verify(container, ConstructorInjector.this, ConstructorInjector.this.box(parameterTypes[i]), new ParameterNameBinding(ConstructorInjector.this.getParanamer(), constructor, i), ConstructorInjector.this.useNames(), ConstructorInjector.this.getBindings(constructor.getParameterAnnotations())[i]);
                    }
                    return null;
                }
            };
        }
        this.verifyingGuard.setGuardedContainer(container);
        this.verifyingGuard.observe(this.getComponentImplementation(), null);
    }

    @Override
    public String getDescriptor() {
        return "ConstructorInjector-";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CtorAndAdapters<TYPE> {
        private final Constructor<TYPE> ctor;
        private final Parameter[] constructorParameters;
        private final ComponentAdapter[] injecteeAdapters;

        public CtorAndAdapters(Constructor<TYPE> ctor, Parameter[] parameters, ComponentAdapter[] injecteeAdapters) {
            this.ctor = ctor;
            this.constructorParameters = parameters;
            this.injecteeAdapters = injecteeAdapters;
        }

        public Constructor<TYPE> getConstructor() {
            return this.ctor;
        }

        public Object[] getParameterArguments(PicoContainer container) {
            Type[] parameterTypes = this.ctor.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Type parameterType = parameterTypes[i];
                if (!(parameterType instanceof TypeVariable)) continue;
                parameterTypes[i] = this.ctor.getParameterTypes()[i];
            }
            ConstructorInjector.this.boxParameters(parameterTypes);
            Object[] result = new Object[this.constructorParameters.length];
            Annotation[] bindings = ConstructorInjector.this.getBindings(this.ctor.getParameterAnnotations());
            for (int i = 0; i < this.constructorParameters.length; ++i) {
                result[i] = ConstructorInjector.this.getParameter(container, this.ctor, i, parameterTypes[i], bindings[i], this.constructorParameters[i], this.injecteeAdapters[i]);
            }
            return result;
        }

        public ComponentAdapter[] getInjecteeAdapters() {
            return this.injecteeAdapters;
        }

        public Parameter[] getParameters() {
            return this.constructorParameters;
        }
    }

    private static final class ResolverKey {
        private final Type expectedType;
        private final String pName;
        private final boolean useNames;
        private final Annotation binding;
        private final Parameter currentParameter;

        private ResolverKey(Type expectedType, String pName, boolean useNames, Annotation binding, Parameter currentParameter) {
            this.expectedType = expectedType;
            this.pName = pName;
            this.useNames = useNames;
            this.binding = binding;
            this.currentParameter = currentParameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolverKey that = (ResolverKey)o;
            if (this.useNames != that.useNames) {
                return false;
            }
            if (this.binding != null ? !((Object)this.binding).equals(that.binding) : that.binding != null) {
                return false;
            }
            if (!this.currentParameter.equals(that.currentParameter)) {
                return false;
            }
            if (!this.expectedType.equals(that.expectedType)) {
                return false;
            }
            return !(this.pName != null ? !this.pName.equals(that.pName) : that.pName != null);
        }

        public int hashCode() {
            int result = this.expectedType.hashCode();
            result = 31 * result + (this.pName != null ? this.pName.hashCode() : 0);
            result = 31 * result + (this.useNames ? 1 : 0);
            result = 31 * result + (this.binding != null ? ((Object)this.binding).hashCode() : 0);
            result = 31 * result + this.currentParameter.hashCode();
            return result;
        }
    }
}

