<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Generated by mkstyle for beginlatex.xml on 2002-07-23T00:40:24 -->
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:m="http://www.w3.org/1998/Math/MathML"
  exclude-result-prefixes="m">

  <xsl:output method="text" encoding="iso-8859-1"/>
  <xsl:strip-space elements="*"/>

  <xsl:param name="style">
    <xsl:text>typebook</xsl:text>
  </xsl:param>

  <xsl:template match="/">
    <xsl:text>\documentclass[</xsl:text>
    <xsl:choose>
      <xsl:when test="$style='tugbook'">
        <xsl:text>letterpaper</xsl:text>
      </xsl:when>
      <xsl:when test="$style='typebook'">
        <xsl:text>12pt,a4paper</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>a4paper</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>,twoside]{report}&#x000A;</xsl:text>
    <xsl:text>\usepackage{</xsl:text>
    <xsl:value-of select="$style"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\begin{document}&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{document}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="book">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="bookinfo">
    <!-- title, author, edition, legal, other, release, rev -->
    <xsl:text>\title{</xsl:text>
    <xsl:apply-templates select="title"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\subtitle{</xsl:text>
    <xsl:apply-templates select="subtitle"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\author{</xsl:text>
    <xsl:value-of select="author/firstname"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="author/surname"/>
    <!--
    <xsl:text>\\[1em]{\fontseries{m}\selectfont </xsl:text>
    <xsl:apply-templates select="author/affiliation"/>
    <xsl:text>}</xsl:text>
-->
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\date{v.</xsl:text>
    <xsl:value-of select="revhistory/revision[1]/revnumber"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="edition"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\legal{%</xsl:text>
    <xsl:apply-templates select="legalnotice" mode="verso"/>
    <xsl:text>}</xsl:text>
    <xsl:text>\maketitle&#x000A;</xsl:text>
    <xsl:apply-templates select="othercredit" mode="verso"/>
    <xsl:text>\par\vfill
</xsl:text>
    <xsl:apply-templates select="releaseinfo" mode="verso"/>
    <xsl:text>\par\vfill
</xsl:text>
  </xsl:template>

  <xsl:template match="affiliation">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="orgname">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="orgdiv">
    <xsl:text>\\
\textit{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="bookinfo/author |
                       bookinfo/edition | 
                       bookinfo/legalnotice | 
                       bookinfo/othercredit | 
                       bookinfo/releaseinfo | 
                       bookinfo/revhistory"/>

  <xsl:template match="othercredit" mode="verso">
    <xsl:text>\subsubsection*{Acknowledgments}
</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="contrib">
    <xsl:apply-templates/>
    <xsl:text>\par 
</xsl:text>
  </xsl:template>

  <xsl:template match="authorblurb">
    <xsl:text>\par\vspace*{2pc}\noindent\ignorespaces </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="releaseinfo" mode="verso">
    <xsl:text>\subsubsection*{Technical~note}
</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="legalnotice" mode="verso">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="toc">
    <xsl:apply-templates/>
    <xsl:text>\tableofcontents&#x000A;\listofexercises&#x000A;\listoftables&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="toc/title">
    <xsl:text>\renewcommand{\contentsname}{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}
</xsl:text>
  </xsl:template>

  <xsl:template match="preface | section | bookinfo/title">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="preface/title">
    <xsl:text>\prelim{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="footnote/para[1]">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="section[not(parent::section)]/title">
    <xsl:text>\subsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}\addcontentsline{toc}{subsection}{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="section/section/title">
    <xsl:text>\subsubsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}\addcontentsline{toc}{subsubsection}{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="para">
    <xsl:text>&#x000A;</xsl:text>
    <xsl:if test="@role='cont'">
      <xsl:text>\noindent </xsl:text>
    </xsl:if>
    <xsl:if test="@remap='\raggedleft'">
      <xsl:text>{\raggedleft&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}%&#x000A;</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>&#x000A;</xsl:text>
    <xsl:if test="@remap='\raggedleft'">
      <xsl:text>\par}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="para" mode="aftertable">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="productname[not(parent::title)]">
    <xsl:text>\product</xsl:text>
    <xsl:if test="@remap">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="@remap"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:text>{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="productname[parent::title]">
    <xsl:text>\emph{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="indexterm">
    <xsl:text>\index{</xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="@significance='preferred'">
      <xsl:text>|textbf</xsl:text>
    </xsl:if>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="primary">
    <xsl:variable name="prival">
      <xsl:call-template name="squeeze">
        <xsl:with-param name="string">
          <xsl:value-of select="string(.)"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:variable>
    <xsl:if test="@sortas">
      <xsl:value-of select="@sortas"/>
      <xsl:text>@</xsl:text>
    </xsl:if>
    <xsl:value-of select="$prival"/>
    <xsl:if test="@remap">
      <xsl:text>@</xsl:text>
      <xsl:value-of select="@remap"/>
      <xsl:text>{</xsl:text>
      <xsl:value-of select="$prival"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="secondary | tertiary">
    <xsl:text>!</xsl:text>
    <xsl:if test="@sortas">
      <xsl:value-of select="@sortas"/>
      <xsl:text>@</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="see">
    <xsl:text>|see{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="beginpage">
    <xsl:text>\clearpage&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="itemizedlist">
    <xsl:text>\begin{itemize}
</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
    <xsl:if test="@mark">
      <xsl:text>\renewcommand{\labelitemi}{\raisebox{-.25ex}{</xsl:text>
      <xsl:value-of select="@mark"/>
      <xsl:text>}}
</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\end{itemize}
</xsl:text>
  </xsl:template>

  <xsl:template match="itemizedlist[not(parent::para)]/listitem | 
                        orderedlist[not(parent::para)]/listitem">
    <xsl:text>\item</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="acronym">
    <xsl:choose>
      <!-- If there is text content, display it, because
           it's the defining instance (should be an ID too) -->
      <xsl:when test=".!=''">
        <xsl:apply-templates/>
        <xsl:choose>
          <!-- If there is an ID as well, put it in parentheses, 
               it's the acronym. This used to be \textsc and all
               lowercase but there's no need with Palatino -->
          <xsl:when test="@id">
            <xsl:text> (</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>)</xsl:text>
            <!-- now index them -->
            <xsl:text>\index{</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>@</xsl:text>
            <!-- used to be needed to protect the \textsc
            <xsl:if test="ancestor::footnote or 
                          ancestor::title or 
                          ancestor::term">
              <xsl:text>\string </xsl:text>
            </xsl:if>
-->
            <xsl:value-of select="@id"/>
            <xsl:text>|textbf}\index{</xsl:text>
            <!--
            <xsl:if test="ancestor::footnote or 
                          ancestor::title or 
                          ancestor::term">
              <xsl:text>\string </xsl:text>
            </xsl:if>
-->
            <xsl:text>Acronyms@</xsl:text>
            <xsl:if test="ancestor::footnote or 
                          ancestor::title or 
                          ancestor::term">
              <xsl:text>\string</xsl:text>
            </xsl:if>
            <xsl:text>\textbf{Acronyms}, defined!</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>@</xsl:text>
            <!--
            <xsl:if test="ancestor::footnote or 
                          ancestor::title or 
                          ancestor::term">
              <xsl:text>\string </xsl:text>
            </xsl:if>
-->
            <xsl:value-of select="@id"/>
            <xsl:text>|textbf}</xsl:text>
          </xsl:when>
          <!-- Text content but no ID is possibly an error -->
          <xsl:otherwise>
            <xsl:text>% no definition for this acronym (maybe OK)&#x000A;</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- No text content means we need just use the acronym -->
      <xsl:otherwise>
        <xsl:choose>
          <!-- Check the acronym is in ref 
               (DocBook doesn't provide an IDREF) -->
          <xsl:when test="@ref">
            <xsl:value-of select="@ref"/>
            <xsl:text>\index{</xsl:text>
            <xsl:value-of select="@ref"/>
            <xsl:text>@</xsl:text>
            <!--
            <xsl:if test="ancestor::footnote or 
                          ancestor::title or 
                          ancestor::term">
              <xsl:text>\string </xsl:text>
            </xsl:if>
-->
            <xsl:value-of select="@ref"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <!-- nothing means an error -->
            <xsl:text>\ddag\marginal{\ddag~Acronym with no content or reference}</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="emphasis">
    <xsl:choose>
      <xsl:when test="@role='enhance' or @role='high'">
        <xsl:text>\emph{\textbf{</xsl:text>
          <xsl:apply-templates/>
        <xsl:text>}}</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::emphasis">
        <xsl:text>\textbf{</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>\emph{</xsl:text>
          <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="wordasword">
    <xsl:text>`</xsl:text>
    <xsl:if test="parent::quote">
      <xsl:text>`</xsl:text>
    </xsl:if>
      <xsl:apply-templates/>
    <xsl:text>'</xsl:text>
    <xsl:if test="parent::quote">
      <xsl:text>'</xsl:text>
    </xsl:if>
    <xsl:if test="count(following-sibling::text())=0">
      <xsl:text>\thinspace</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="citation">
    <xsl:text>\emph{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="citetitle">
    <!-- if the content is non-null and the @pubwork is given, use it
         eg "the article", "the book", etc, and put the content title 
         in `quotes' followed by "in" before the rest of the citation -->
    <xsl:if test=".!='' and @pubwork">
      <xsl:if test="@pubwork">
        <xsl:text>the </xsl:text>
        <xsl:value-of select="@pubwork"/>
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:text>`</xsl:text>
        <xsl:apply-templates/>
      <xsl:text>'</xsl:text>
      <xsl:text> in </xsl:text>
    </xsl:if>
    <!-- if there is a ref, use it... -->
    <xsl:if test="@ref">
      <xsl:choose>
        <!-- Both means make a short citation without the title, ie author/year -->
        <xsl:when test="@show='both'">
          <xsl:text>\citeauthoryear{</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>}</xsl:text>
        </xsl:when>
        <!-- otherwise we do print the title... -->
        <xsl:otherwise>
          <!-- ...but before we do, see if there's a need to give the author.
               Author alone means make it a possessive before the title -->
          <xsl:if test="@show='author' or @show='authoronly'">
            <xsl:text>\authorof{</xsl:text>
            <xsl:value-of select="@ref"/>
            <xsl:text>}</xsl:text>
            <xsl:if test="@show='author'">
              <xsl:text>'s </xsl:text>
            </xsl:if>
          </xsl:if>
          <!-- now the title, with or without footnote -->
          <xsl:choose>
            <xsl:when test="@ref='null'">
              <xsl:text></xsl:text>
            </xsl:when>
            <!-- first a dummy to force title to be skipped -->
            <xsl:when test="@show='authoronly'">
              <xsl:text></xsl:text>
            </xsl:when>
            <xsl:when test="@show='dateonly'">
              <xsl:text>\citeyear{</xsl:text>
              <xsl:value-of select="@ref"/>
              <xsl:text>}</xsl:text>
            </xsl:when>
            <xsl:when test="@show='none'">
              <xsl:text>\titleof{</xsl:text>
              <xsl:value-of select="@ref"/>
              <xsl:text>}</xsl:text>
            </xsl:when>
            <!-- show must imply title, the default (see DTD) -->
            <xsl:otherwise>
              <xsl:choose>
                <xsl:when test="@condition='nocite'">
                  <xsl:text>\titleof{</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:text>\titlecite{</xsl:text>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:value-of select="@ref"/>
              <xsl:text>}</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
          <!-- date if requested -->
          <xsl:if test="@show='date'">
            <xsl:text>~(\citeyear{</xsl:text>
            <xsl:value-of select="@ref"/>
            <xsl:text>})</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <!-- end of test for @ref -->
    </xsl:if>
    <!-- if the content is non-null and no @pubwork, print it 
         in slanted (preceded by a space if there was an xref) -->
    <xsl:if test=".!='' and not(@pubwork)">
      <xsl:if test="@ref">
        <xsl:text> </xsl:text>
      </xsl:if>
      <xsl:text>\textsl{</xsl:text>
      <xsl:apply-templates/>
      <xsl:text>}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="systemitem">
    <xsl:variable name="delim">
      <xsl:text>+</xsl:text>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="ancestor::footnote or @class='resource'">
        <xsl:text>\url</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="ancestor::biblioentry">
          <xsl:text>\protect</xsl:text>
        </xsl:if>
        <xsl:text>\verb</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:value-of select="$delim"/>
    <xsl:apply-templates/>
    <xsl:value-of select="$delim"/>
  </xsl:template>

  <xsl:template match="calloutlist">
    <xsl:text>\begin{center}</xsl:text>
    <xsl:value-of select="@remap"/>
    <xsl:text>&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{center}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="callout">
    <xsl:text>\begin{minipage}{</xsl:text>
    <xsl:value-of select="@remap"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{minipage}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="footnote">
    <!-- footnote xreflabel is only for use in HTML to fake up the
         letter used by footnotes in minipages -->
    <xsl:choose>
      <xsl:when test="ancestor::tgroup">
        <xsl:text>\tablefootnote</xsl:text>
        <xsl:choose>
          <xsl:when test="@id">
            <xsl:text>{</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:when test="@usenote">
            <xsl:text>{</xsl:text>
            <xsl:value-of select="@usenote"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>{TF-</xsl:text>
            <xsl:value-of select="count(preceding::footnote[ancestor::tgroup][not(@usenote)])+1"/>
            <!--
            <xsl:number count="footnote[ancestor::tgroup]" level="any"/>
-->
            <xsl:text>}</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>\footnote</xsl:text>
        <xsl:text>{</xsl:text>
        <xsl:apply-templates/>
        <xsl:if test="@id">
          <xsl:text>\label{</xsl:text>
          <xsl:value-of select="@id"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
        <xsl:text>}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="sidebar">
    <xsl:text>\begin{sidebar}</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\end{sidebar}</xsl:text>
  </xsl:template>

  <xsl:template match="sidebar/title">
    <xsl:text>\subsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="personname">
    <xsl:text>\person{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="personname/firstname">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="personname/surname">
    <xsl:text> </xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="chapter">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="appendix">
    <xsl:if test="count(preceding-sibling::appendix)=0">
      <xsl:text>\appendix&#x000A;</xsl:text>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="@colwidth">
        <!-- multicols gets turned on after \chapter -->
        <xsl:apply-templates/>
        <xsl:text>&#x000A;\end{multicols}&#x000A;</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="chapter/title | appendix/title">
    <xsl:text>\chapter</xsl:text>
    <xsl:if test="following-sibling::subtitle or
                  processing-instruction('LaTeX')">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="."/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:text>{</xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="following-sibling::subtitle">
      <xsl:text>\\\LARGE\itshape </xsl:text>
      <xsl:apply-templates 
        select="following-sibling::subtitle" mode="addin"/>
    </xsl:if>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="parent::chapter and
                  count(parent::chapter/preceding-sibling::chapter)=0">
      <xsl:text>\pagenumbering{arabic}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="parent::appendix/@colwidth">
      <xsl:text>\begin{multicols}{2}\small\gfdl&#x000A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="chapter/subtitle | appendix/subtitle"/>

  <xsl:template match="chapter/subtitle | appendix/subtitle" mode="addin">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="note[not(parent::para)]">
    <xsl:if test="@role!='marginal'">
      <xsl:text>\begin{note}&#x000A;</xsl:text>
        <xsl:apply-templates/>
      <xsl:text>\end{note}&#x000A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="note/title">
    <xsl:text>\subsubsection*{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="xref">
    <!-- Remember this ID for future use -->
    <xsl:variable name="thisid">
      <xsl:value-of select="@linkend"/>
    </xsl:variable>
    <!-- Try to decide how to format the referential text -->
    <xsl:choose>
      <!-- 1. If this is a specifically requested page reference, 
              that's all there is -->
      <xsl:when test="@role='page'">
        <xsl:text>p</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>p</xsl:text>
        </xsl:if>
        <xsl:text>.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- 2. If the user has explicitly provided a label word, 
              use it instead of anything else -->
      <xsl:when test="@remap">
        <xsl:value-of select="@remap"/>
        <!-- and assume it has been correctly pluralised if @endterm used -->
        <xsl:text>~\ref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- 3. Identify Tables, Figures, and Exercises etc -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::table">
        <xsl:text>Table</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>~</xsl:text>
      </xsl:when>
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::figure">
        <xsl:text>Figure</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>~</xsl:text>
        <!-- what is this doing here?
        <xsl:if test="//*[@id=$thisid]/ancestor::sidebar">
          <xsl:text>\ref{</xsl:text>
          <xsl:value-of select="@id"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
-->
      </xsl:when>
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::example">
        <xsl:text>Exercise</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>~</xsl:text>
      </xsl:when>
      <!-- 3a. Informal tables just get a mention -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::informaltable">
        <xsl:text>the table</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text> on </xsl:text>
        <xsl:text>p</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>p</xsl:text>
        </xsl:if>
        <xsl:text>.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>--\pageref{</xsl:text>
          <xsl:value-of select="@endterm"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
      </xsl:when>
      <!-- 4. If it's a sidebar, be more explicit -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::sidebar">
        <xsl:text>the panel</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text> `</xsl:text>
        <xsl:value-of 
          select="//*[@id=$thisid]/ancestor-or-self::sidebar/title"/>
        <xsl:text>' \testpage[</xsl:text>
        <xsl:choose>
          <xsl:when test="following::sidebar[@id=$thisid]">
            <xsl:text>below</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>above</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>]{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- 5. Be even more explicit if it's a procedural step -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::procedure">
        <xsl:text>step</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>~\ref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
        <!-- pageno only if needed...but how? -->
        <xsl:text> in the procedure on p.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- 6. If it's in a Prelim 
              it won't have a number so use the title -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::preface">
        <!-- if it's just a paragraph, see if location is significant -->
        <xsl:if test="name(//*[@id=$thisid])='para' and
                      not(//*[@id=$thisid]/ancestor-or-self::listitem)">
          <xsl:choose>
            <xsl:when test="count(//*[@id=$thisid]/preceding-sibling::para)=0">
              <xsl:text>the first paragraph of </xsl:text>
            </xsl:when>
            <xsl:when test="count(//*[@id=$thisid]/following-sibling::para)=0">
              <xsl:text>the last paragraph of </xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:if>
        <xsl:text>the </xsl:text>
        <xsl:value-of 
          select="//*[@id=$thisid]/ancestor-or-self::preface/title"/>
        <xsl:text> on p.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- 7. If this is a list item, be explicit -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::listitem">
        <xsl:text>item</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>~\ref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>}</xsl:text>
        <!--  Only add the pointer if it's to another list! -->
        <xsl:if test="count(ancestor::orderedlist |
                      //*[@id=$thisid]/ancestor::orderedlist) > 1 or
                      count(ancestor::itemizedlist|
                      //*[@id=$thisid]/ancestor::itemizedlist) > 1 or
                      count(ancestor::variablelist|
                      //*[@id=$thisid]/ancestor::variablelist) > 1">
          <xsl:text>the list on p.\thinspace\pageref{</xsl:text>
          <xsl:value-of select="$thisid"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
      </xsl:when>
      <!-- 8. If this is a whole list itself, do similar but add section ref -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::orderedlist |
                      //*[@id=$thisid]/ancestor-or-self::itemizedlist |
                      //*[@id=$thisid]/ancestor-or-self::variablelist">
        <xsl:text>the list</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text> on p</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>p</xsl:text>
        </xsl:if>
        <xsl:text>.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>} in \S\thinspace</xsl:text>
      </xsl:when>
      <!-- 9. If this is within the sectional text of a chapter or appendix,
              no matter how deep, use the Section sign -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::sect1">
        <!-- if it's just a paragraph, see if location is significant -->
        <xsl:if test="name(//*[@id=$thisid])='para' and
                      not(//*[@id=$thisid]/ancestor-or-self::listitem)">
          <xsl:choose>
            <xsl:when test="count(//*[@id=$thisid]/preceding-sibling::para)=0">
              <xsl:text>the first paragraph of </xsl:text>
            </xsl:when>
            <xsl:when test="count(//*[@id=$thisid]/following-sibling::para)=0">
              <xsl:text>the last paragraph of </xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:if>
        <xsl:text>\S</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>s</xsl:text>
        </xsl:if>
        <xsl:text>\thinspace</xsl:text>
      </xsl:when>
      <!-- 10. If this is a ref to a whole chapter or appendix -->
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::chapter">
        <xsl:text>\chaptername~</xsl:text>
      </xsl:when>
      <xsl:when test="//*[@id=$thisid]/ancestor-or-self::appendix">
        <xsl:text>Appendi</xsl:text>
        <xsl:choose>
          <xsl:when test="@endterm">
            <xsl:text>ces</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>x</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>~</xsl:text>
      </xsl:when>
      <!-- 11. Otherwise it must be for a pageref: we're out of options -->
      <xsl:otherwise>
        <xsl:text>p</xsl:text>
        <xsl:if test="@endterm">
          <xsl:text>p</xsl:text>
        </xsl:if>
        <xsl:text>.\thinspace\pageref{</xsl:text>
        <xsl:value-of select="$thisid"/>
        <xsl:text>} in \S\thinspace</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <!-- OK, now we decide if we need to output the reference -->
    <!-- Omit it for target classes already handled above -->
    <xsl:if test="not(@role='page') and
                  not(@remap) and
                  not(//*[@id=$thisid]/ancestor-or-self::sidebar) and
                  not(//*[@id=$thisid]/ancestor-or-self::procedure) and
                  not(//*[@id=$thisid]/ancestor-or-self::preface) and
                  not(//*[@id=$thisid]/ancestor-or-self::listitem) and
                  not(//*[@id=$thisid]/ancestor-or-self::informaltable)">
      <xsl:text>\ref{</xsl:text>
      <xsl:value-of select="$thisid"/>
      <xsl:text>}</xsl:text>
      <xsl:if test="@endterm">
        <xsl:text> to \ref{</xsl:text>
        <xsl:value-of select="@endterm"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="warning">
    <xsl:text>\begin{warning}
</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
      <xsl:apply-templates/>
    <xsl:text>\end{warning}
</xsl:text>
  </xsl:template>

  <xsl:template match="warning/title">
    <xsl:text>\subsubsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="sect1 | sect2 | sect3">
    <xsl:if test="@condition">
      <xsl:value-of select="@condition"/>
      <xsl:text>&#x000A;</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="sect1/title">
    <xsl:if test="../@label">
      <xsl:text>\setcounter{section}{</xsl:text>
      <xsl:value-of select="../@label - 1"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:text>\section{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="sect2/title">
    <xsl:text>\subsection{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}
</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="sect3/title">
    <xsl:text>\subsubsection{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}
</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="quote">
    <xsl:text>`</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>'</xsl:text>
  </xsl:template>

  <xsl:template match="firstterm">
    <xsl:text>\textbf{\textit{</xsl:text>
    <xsl:choose>
      <xsl:when test=".=''">
        <xsl:value-of select="@id"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>}}\label{</xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>}\index{</xsl:text>
    <xsl:choose>
      <xsl:when test=".=''">
        <xsl:value-of select="@id"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>@\textbf{\textit{</xsl:text>
    <xsl:choose>
      <xsl:when test=".=''">
        <xsl:value-of select="@id"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>}}}</xsl:text>
  </xsl:template>

  <xsl:template match="trademark">
    <xsl:apply-templates/>
    <xsl:text>\index{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="literal">
    <xsl:variable name="delim">
      <xsl:choose>
        <xsl:when test="@remap">
          <xsl:value-of select="@remap"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>+</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="userinput">
        <xsl:text>\texttt{</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::footnote">
        <xsl:text>\url</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="ancestor::biblioentry">
          <xsl:text>\protect</xsl:text>
        </xsl:if>
        <xsl:text>\verb</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="not(userinput)">
      <xsl:value-of select="$delim"/>
      <xsl:value-of select="normalize-space(.)"/>
      <xsl:value-of select="$delim"/>
    </xsl:if>
  </xsl:template>

  <xsl:template name="squeeze">
    <xsl:param name="string">
      <xsl:text></xsl:text>
    </xsl:param>
    <xsl:param name="LF">
      <xsl:text>&#x000A;</xsl:text>
    </xsl:param>
    <xsl:param name="CR">
      <xsl:text>&#x000D;</xsl:text>
    </xsl:param>
    <xsl:param name="TAB">
      <xsl:text>&#x0009;</xsl:text>
    </xsl:param>
    <xsl:choose>
      <xsl:when test="contains($string,$LF)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,$LF),' ')"/>
            <xsl:choose>
              <xsl:when test="substring(substring-after($string,$LF),1,1)=' ' or
                              substring(substring-after($string,$LF),1,1)=$TAB">
                <xsl:value-of select="substring(substring-after($string,$LF),2)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="substring-after($string,$LF)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,$CR)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,$CR),' ')"/>
            <xsl:choose>
              <xsl:when test="substring(substring-after($string,$CR),1,1)=' ' or
                              substring(substring-after($string,$CR),1,1)=$TAB">
                <xsl:value-of select="substring(substring-after($string,$CR),2)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="substring-after($string,$CR)"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,$TAB)">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="translate($string,$TAB,' ')"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="contains($string,'  ')">
        <xsl:call-template name="squeeze">
          <xsl:with-param name="string">
            <xsl:value-of select="concat(substring-before($string,'  '),
                                  ' ',substring-after($string,'  '))"/>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$string"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="programlisting">
    <xsl:text>\begin{</xsl:text>
    <xsl:if test="@colwidth='left'">
      <xsl:text>shifted</xsl:text>
    </xsl:if>
    <xsl:text>sourcecode}</xsl:text>
    <xsl:choose>
      <xsl:when test="ancestor::variablelist |
                      ancestor::orderedlist |
                      ancestor::itemizedlist |
                      ancestor::procedure">
        <!-- not procedures because they may need long commands -->
        <xsl:text>[-\leftmargin]</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::simplesect[@remap='multicols']">
        <xsl:text>[-.3\columnwidth]</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:if test="@condition">
      <xsl:text>\fontencoding{T1}\fontfamily{</xsl:text>
      <xsl:value-of select="@condition"/>
      <xsl:text>}\selectfont\renewcommand{\ttdefault}{</xsl:text>
      <xsl:value-of select="@condition"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>\begin{Verbatim}[fontsize=\</xsl:text>
    <xsl:choose>
      <xsl:when test="@width">
        <xsl:value-of select="@width"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>small</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@remap">
      <xsl:text>,</xsl:text>
      <xsl:value-of select="@remap"/>
    </xsl:if>
    <xsl:text>]</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{Verbatim}&#x000A;\end{</xsl:text>
    <xsl:if test="@colwidth='left'">
      <xsl:text>shifted</xsl:text>
    </xsl:if>
    <xsl:text>sourcecode}</xsl:text>
    <xsl:if test="parent::informalexample and following-sibling::*">
      <xsl:text>\vspace*{-\baselineskip}\begin{quote}\fontencoding{T1}\fontfamily{cmr}\selectfont\def\sfdefault{cmss}\def\bfdefault{bf}\noindent</xsl:text>
    </xsl:if>
    <xsl:text>&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="example">
    <xsl:text>\begin{exercise}&#x000A;</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:text>\addcontentsline{loe}{section}{\numberline{</xsl:text>
    <xsl:number level="any"/>
    <xsl:text>}</xsl:text>
    <xsl:value-of select="title"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{exercise}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="example/title">
    <xsl:text>\subsubsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="informalexample">
    <xsl:text>\begin{example}&#x000A;</xsl:text>
      <xsl:apply-templates/>
      <!-- quote environment is started in the programlisting template -->
      <xsl:if test="*[not(programlisting)]">
        <xsl:text>\end{quote}</xsl:text>
      </xsl:if>
    <xsl:text>\end{example}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="informaltable">
    <xsl:text>\begingroup\small </xsl:text>
    <xsl:if test="@id and 
                  not(descendant::tgroup) and 
                  not(descendant::blockinfo)">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:if test="@pgwide='left'">
      <xsl:text>\par\medskip\moveleft\itemindent\vbox{</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:if test="@pgwide='left'">
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>\endgroup</xsl:text>
  </xsl:template>

  <xsl:template match="informaltable/blockinfo/title">
    <xsl:text>\subsubsection*{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="ancestor::informaltable/@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="ancestor::informaltable/@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>\addcontentsline{lot}{subsubsection}{</xsl:text>
    <xsl:value-of select="."/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="colspec">
    <!-- flush with LH margin can be specified in first colspec,
         otherwise left to LaTeX to add shoulder -->
    <xsl:if test="count(preceding-sibling::colspec)=0 and
                  @colsep='flush'">
      <xsl:text>@{}</xsl:text>
    </xsl:if>
    <!-- @role can hold any "pre" code -->
    <xsl:if test="@role">
      <xsl:text>&#x003E;{</xsl:text>
      <xsl:value-of select="@role"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <!-- DANGER: remember \columnwidth in LaTeX refers to the width of the
         current set (text width) and has *nothing* to do with columns in
         tables! -->
    <xsl:choose>
      <!-- specifying a width means you want paragraphic cells -->
      <xsl:when test="@colwidth">
        <!-- specifying an alignment means you want it (so use \pbs) -->
        <xsl:choose>
          <xsl:when test="@align='left'">
            <xsl:text>&gt;{\pbs{\raggedright}}</xsl:text>
          </xsl:when>
          <xsl:when test="@align='right'">
            <xsl:text>&gt;{\pbs{\raggedleft}}</xsl:text>
          </xsl:when>
          <xsl:when test="@align='center'">
            <xsl:text>&gt;{\pbs{\centering}}</xsl:text>
          </xsl:when>
        </xsl:choose>
        <!-- colname holds the para-cell type {p|b|m} from array package -->
        <xsl:choose>
          <xsl:when test="@colname='b' or @colname='m'">
            <xsl:value-of select="@colname"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>p</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>{</xsl:text>
        <!-- now find the width -->
        <xsl:choose>
          <xsl:when test="contains(@colwidth,'%')">
            <xsl:value-of select="number(translate(@colwidth,'%','')) div 100"/>
            <xsl:text>\columnwidth</xsl:text>
          </xsl:when>
          <xsl:when test="not(contains(@colwidth,'%'))">
            <xsl:value-of select="@colwidth"/>
          </xsl:when>
          <!-- if colwidth is present but empty, assume 1/(cols+1) -->
          <xsl:otherwise>
            <xsl:value-of select="1 div (ancestor::tgroup/@cols + 1)"/>
            <xsl:text>\columnwidth</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- no colwidth? just use the first letter for alignment -->
      <xsl:otherwise>
        <xsl:value-of select="substring(@align,1,1)"/>
      </xsl:otherwise>
    </xsl:choose>
    <!-- charoff is abused to hold any post-cell data -->
    <xsl:if test="@charoff">
      <xsl:text>&lt;{</xsl:text>
      <xsl:value-of select="@charoff"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <!-- Stuff to do on the last colspec -->
    <xsl:if test="count(following-sibling::colspec)=0">
      <!-- see if cells need framing -->
      <xsl:if test="ancestor::informaltable[@frame='all']">
        <xsl:text>|</xsl:text>
      </xsl:if>
      <!-- see if right-hand shoulder needs omitting -->
      <xsl:if test="@colsep='flush'">
        <xsl:text>@{}</xsl:text>
      </xsl:if>
      <!-- now close the {tabular}{} col specs argument -->
      <xsl:text>}</xsl:text>
      <!-- framed tables need initial horizontal rule -->
      <xsl:if test="ancestor::informaltable[@frame='all']">
        <xsl:text>\hline</xsl:text>
      </xsl:if>
      <!-- newline before rows begin -->
      <xsl:text>&#x000A;</xsl:text>
      <!-- if the table specified a rowsep, use it on the first row -->
      <xsl:if test="ancestor::informaltable[@rowsep]">
        <xsl:text>\vrule height</xsl:text>
        <xsl:value-of select="ancestor::informaltable/@rowsep"/>
        <xsl:text> width0pt </xsl:text>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="table/title" mode="incaption">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tgroup">
    <!-- for a formal table, use the title and ID -->
    <xsl:if test="../title">
      <xsl:text>\caption{\small </xsl:text>
      <xsl:apply-templates select="../title" mode="incaption"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="ancestor::table/@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="ancestor::table/@id"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <!-- centering the table provides some useful space below the caption -->
    <xsl:if test="not(parent::informaltable/@pgwide='left')">
      <xsl:text>\begin{center}&#x000A;</xsl:text>
    </xsl:if>
    <!-- informal table IDs need to go inside the centered environment -->
    <xsl:if test="ancestor::informaltable[@id]">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="ancestor::informaltable/@id"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <!-- set any global column separation -->
    <xsl:if test="ancestor::informaltable[@colsep]">
      <xsl:text>\setlength{\tabcolsep}{</xsl:text>
      <xsl:value-of select="ancestor::informaltable/@colsep"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="ancestor::table[@colsep]">
      <xsl:text>\setlength{\tabcolsep}{</xsl:text>
      <xsl:value-of select="ancestor::table/@colsep"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:if test="@colsep">
      <xsl:text>\setlength{\tabcolsep}{</xsl:text>
      <xsl:value-of select="@colsep"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <!-- abuse colwidth on table for the rule thickness -->
    <xsl:if test="ancestor::informaltable[@colwidth]">
      <xsl:text>\setlength{\arrayrulewidth}{</xsl:text>
      <xsl:value-of select="ancestor::informaltable/@colwidth"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <!-- FINALLY, start the tabular setting -->
    <xsl:text>\begin{tabular}{</xsl:text>
    <!-- insert initial vertical rule for framed tables -->
    <xsl:if test="ancestor::informaltable[@frame='all']">
      <xsl:text>|</xsl:text>
    </xsl:if>
    <!-- use all the colspecs -->
    <!-- note the closing } is added by last()/col -->
    <!-- and use all the rest of the table -->
    <xsl:apply-templates/>
    <!-- add closing rules if needed -->
    <xsl:if test="ancestor::informaltable[@frame='all']">
      <xsl:text>\hline&#x000A;</xsl:text>
    </xsl:if>
    <xsl:text>\end{tabular}&#x000A;</xsl:text>
    <xsl:if test="descendant::footnote[not(@usenote)]">
      <xsl:text>\renewcommand{\theenumi}{\textit{\alph{enumi}}}</xsl:text>
      <xsl:text>\footnotesize</xsl:text>
      <xsl:text>\begin{enumerate*}</xsl:text>
      <xsl:for-each select="descendant::footnote[not(@usenote)]">
        <xsl:text>\item </xsl:text>
        <xsl:apply-templates/>
        <xsl:choose>
          <xsl:when test="@id">
            <xsl:text>\label{</xsl:text>
            <xsl:value-of select="@id"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>\label{TF-</xsl:text>
            <xsl:value-of 
              select="count(preceding::footnote[ancestor::tgroup][not(@usenote)])+1"/>
            <xsl:text>}</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:for-each>
      <xsl:text>\end{enumerate*}</xsl:text>
    </xsl:if>
    <xsl:if test="simplelist|para">
      <xsl:text>\par\smallskip\footnotesize
</xsl:text>
      <xsl:apply-templates select="simplelist|para" mode="aftertable"/>
    </xsl:if>
    <xsl:if test="not(parent::informaltable/@pgwide='left')">
      <xsl:text>\end{center}&#x000A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="tgroup/para | tgroup/simplelist"/>

  <xsl:template match="simplelist">
    <xsl:text>\begin{itemize*}
</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{itemize*}
</xsl:text>
  </xsl:template>

  <xsl:template match="simplelist" mode="aftertable">
    <xsl:text>\begin{itemize*}
</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{itemize*}
</xsl:text>
  </xsl:template>

  <xsl:template match="entry/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="thead">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tfoot" mode="indirect">
    <xsl:choose>
      <!-- if this is a genuine "totals" numerica footer -->
      <xsl:when test="descendant::entry[@role='total']">
        <xsl:for-each select="descendant::entry">
          <xsl:if test="@role='total'">
            <!-- if this is the first, or the first after a break -->
            <xsl:if test="count(preceding-sibling::entry[@role='total'])=0 or
                          preceding-sibling::entry[1][@role!='total']">
              <xsl:text>\cline{</xsl:text>
              <xsl:value-of select="position()"/>
              <xsl:text>-</xsl:text>
            </xsl:if>
            <!-- if this is (also?) the last, or the last before a break -->
            <xsl:if test="count(following-sibling::entry[@role='total'])=0 or
                          following-sibling::entry[1][@role!='total'] or
                          count(following-sibling::entry)=0">
              <xsl:value-of select="position()"/>
              <xsl:text>}</xsl:text>
            </xsl:if>
            <xsl:text>\vrule height1.1em width0pt </xsl:text>
          </xsl:if>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>\\[-1em]\hline\vrule height1.2em width0pt </xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="tbody">
    <xsl:apply-templates/>
    <xsl:if test="../tfoot">
      <xsl:apply-templates select="../tfoot" mode="indirect"/>
    </xsl:if>
  </xsl:template>

  <xsl:template match="row">
    <xsl:apply-templates/>
    <xsl:text>\\</xsl:text>
    <xsl:choose>
      <xsl:when test="parent::thead">
        <xsl:text>[2pt]\hline\\[-1.5\baselineskip]</xsl:text>
        <!-- can't have a strut in case next row has a multispan -->
      </xsl:when>
      <xsl:when test="@role='heading'">
        <xsl:text>[2pt]</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::informaltable/@rowsep">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="ancestor::informaltable/@rowsep"/>
        <xsl:text>]</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::table/@rowsep">
        <xsl:text>[</xsl:text>
        <xsl:value-of select="ancestor::table/@rowsep"/>
        <xsl:text>]</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:text>&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="thead/row/entry | tfoot/row/entry">
    <!-- output column separator if this is the 2nd or more cell -->
    <xsl:if test="count(preceding-sibling::entry)&gt;0">
      <xsl:text>&#x0026;</xsl:text>
    </xsl:if>
    <!-- determine column number -->
    <xsl:variable name="nth">
      <xsl:value-of select="count(preceding-sibling::entry)+1"/>
    </xsl:variable>
    <!-- use alignment [lrcj]-->
    <xsl:choose>
      <xsl:when test="@align='justify' or @colwidth">
        <xsl:text>\multicolumn{1}{&#x003E;{\bfseries</xsl:text>
        <xsl:choose>
          <xsl:when test="ancestor::tgroup/colspec
                          [position()=$nth][@align='right'] or
                          @align='right'">
            <xsl:text>\pbs{\raggedleft}</xsl:text>
          </xsl:when>
          <xsl:when test="ancestor::tgroup/colspec
                          [position()=$nth][@align='left'] or
                          @align='left'">
            <xsl:text>\pbs{\raggedright}</xsl:text>
          </xsl:when>
          <xsl:when test="ancestor::tgroup/colspec
                          [position()=$nth][@align='center'] or
                          @align='center'">
            <xsl:text>\pbs{\centering}</xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:text>}</xsl:text>
        <xsl:choose>
          <xsl:when test="ancestor::thead">
            <xsl:text>b</xsl:text>
          </xsl:when>
          <xsl:when test="ancestor::tfoot">
            <xsl:text>p</xsl:text>
          </xsl:when>
        </xsl:choose>
        <xsl:text>{</xsl:text>
        <xsl:choose>
          <xsl:when test="@colwidth">
            <xsl:value-of select="@colwidth"/>
          </xsl:when>
          <xsl:when test="ancestor::tgroup/colspec
                          [position()=$nth]/@colwidth">
            <xsl:value-of select="ancestor::tgroup/colspec
                                  [position()=$nth]/@colwidth"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>1in</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>}}{</xsl:text>
        <xsl:if test="ancestor::thead">
          <xsl:text>\normalfont\bfseries\upshape </xsl:text>
        </xsl:if>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- normal header/footer cells just get bolded -->
      <xsl:otherwise>
        <xsl:if test="@condition='nomath'">
          <xsl:text>\mbox{</xsl:text>
        </xsl:if>
        <xsl:text>\textbf{</xsl:text>
        <xsl:if test="ancestor::thead">
          <xsl:text>\sffamily\upshape </xsl:text>
        </xsl:if>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
        <xsl:if test="@condition='nomath'">
          <xsl:text>}</xsl:text>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="tbody/row/entry">
    <xsl:variable name="colno">
      <xsl:value-of select="count(preceding-sibling::entry)+1"/>
    </xsl:variable>
    <xsl:if test="count(preceding-sibling::entry)&gt;0">
      <xsl:text>&#x0026;</xsl:text>
    </xsl:if>
    <!-- determine column number -->
    <xsl:variable name="nth">
      <xsl:value-of select="count(preceding-sibling::entry)+1"/>
    </xsl:variable>
    <!-- use alignment [lrcj]-->
    <xsl:choose>
      <xsl:when test="@spanname">
        <xsl:text>\multicolumn{</xsl:text>
        <xsl:value-of select="@spanname"/>
        <xsl:text>}{</xsl:text>
        <xsl:choose>
          <xsl:when test="@align='justify' or @colwidth">
            <xsl:text>p{</xsl:text>
            <xsl:value-of select="@colwidth"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:choose>
              <xsl:when test="@align">
                <xsl:value-of select="substring(@align,1,1)"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:text>l</xsl:text>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text>}{</xsl:text>
        <xsl:if test="parent::row[@role='heading']">
          <xsl:text>\vrule height1.5em width0pt\bfseries\itshape </xsl:text>
        </xsl:if>
        <xsl:if test="@xreflabel">
          <xsl:text>\llap{</xsl:text>
          <xsl:value-of select="@xreflabel"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
        <!--
        <xsl:if test="@remap and 
                      ancestor::tgroup/colspec[position()=$colno]/@width">
          <xsl:text>\hbox to </xsl:text>
          <xsl:value-of select="ancestor::tgroup/
                                colspec[position()=$colno]/@width"/>
          <xsl:text>{\normalfont\color{gray}\tiny\centering </xsl:text>
          <xsl:value-of select="@remap"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
-->
        <xsl:apply-templates/>
        <!--
        <xsl:if test="@remap and 
                      not(ancestor::tgroup/colspec[position()=$colno]/@width)">
          <xsl:text>\linebreak\normalfont\tiny </xsl:text>
          <xsl:value-of select="@remap"/>
        </xsl:if>
-->
        <xsl:if test="@charoff">
          <xsl:text>\rlap{</xsl:text>
          <xsl:value-of select="@charoff"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <!-- otherwise it's not spanned -->
      <xsl:otherwise>
        <xsl:if test="parent::row[@role='heading']">
          <xsl:text>\vrule height1.5em width0pt\bfseries\itshape </xsl:text>
        </xsl:if>
        <xsl:if test="@xreflabel">
          <xsl:text>\llap{</xsl:text>
          <xsl:value-of select="@xreflabel"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
        <xsl:if test="@role">
          <xsl:value-of select="@role"/>
        </xsl:if>
        <xsl:apply-templates/>
        <!--
        <xsl:if test="@remap">
          <xsl:text>\linebreak\normalfont\tiny </xsl:text>
          <xsl:value-of select="@remap"/>
        </xsl:if>
-->
        <xsl:if test="@charoff">
          <xsl:text>\rlap{</xsl:text>
          <xsl:value-of select="@charoff"/>
          <xsl:text>}</xsl:text>
        </xsl:if>
        <xsl:if test="ancestor::tgroup/colspec[position()=$nth]/@align='justify'">
          <xsl:text></xsl:text>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="inlineequation">
    <xsl:text>\(</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>\)</xsl:text>
  </xsl:template>

  <xsl:template match="m:mtext | m:mi">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:msup">
    <xsl:text>^{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="m:msub">
    <xsl:text>_{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="m:csymbol">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:mo | m:mrow">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:mfrac">
    <xsl:text>\frac</xsl:text>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="m:mover | m:munder">
    <xsl:text>{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="m:mn">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="superscript">
    <xsl:text>\textsuperscript{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="command">
    <xsl:if test="@userlevel='math'">
      <xsl:text>\texttt{\$}</xsl:text>
    </xsl:if>
    <xsl:text>\command{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="@userlevel='math'">
      <xsl:text>\texttt{\$}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="errorcode">
    <xsl:text>*\verb+</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>+</xsl:text>
  </xsl:template>

  <xsl:template match="methodname">
    <xsl:text>\package{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="modespec">
    <xsl:text>\env{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="option">
    <xsl:text>\opt</xsl:text>
    <xsl:if test="@xreflabel">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="@xreflabel"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:text>{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="keycap">
    <!-- bind sequences together -->
    <xsl:if test="parent::keycombo and 
                  count(preceding-sibling::keycap)&gt;0">
      <xsl:text>--</xsl:text>
    </xsl:if>
    <!-- separate from preceding sequence -->
    <xsl:if test="preceding-sibling::keycombo">
      <xsl:text>\thinspace{}</xsl:text>
    </xsl:if>
    <!-- use special version if needed for font control by using
         the value of remap as a part of the command name -->
    <xsl:text>\</xsl:text>
    <xsl:if test="@remap">
      <xsl:value-of select="@remap"/>
    </xsl:if>
    <xsl:text>key{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="keycombo">
    <xsl:apply-templates/>
    <xsl:text>~</xsl:text>
  </xsl:template>

  <xsl:template match="userinput">
    <xsl:text>\textsl{</xsl:text>
    <xsl:if test="parent::programlisting or parent::filename">
      <xsl:text>\uline{</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:if test="parent::programlisting or parent::filename">
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="exceptionname">
    <xsl:text>\mbox{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="equation">
    <xsl:text>\[</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\]</xsl:text>
  </xsl:template>

  <xsl:template match="link">
    <xsl:apply-templates/>
    <xsl:text> (\S\thinspace\ref{</xsl:text>
    <xsl:value-of select="@linkend"/>
    <xsl:text>})</xsl:text>
  </xsl:template>

  <xsl:template match="ulink">
    <xsl:choose>
      <!-- if there's no content, use the URL -->
      <xsl:when test=".=''">
        <xsl:choose>
          <xsl:when test="ancestor::biblioentry">
            <xsl:text>\texttt{</xsl:text>
            <xsl:value-of select="@url"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:text>\url+</xsl:text>
            <xsl:value-of select="@url"/>
            <xsl:text>+</xsl:text>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <!-- if there *is* content, display it and footnote the URL -->
      <xsl:otherwise>
        <xsl:apply-templates/>
        <xsl:text>\footnote{\url+</xsl:text>
        <xsl:if test="@type">
          <xsl:value-of select="@type"/>
        </xsl:if>
        <xsl:value-of select="@url"/>
        <xsl:text>+}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="figure">
    <xsl:text>\begin{figure}</xsl:text>
    <xsl:if test="@floatstyle">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="@floatstyle"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:text>\small&#x000A;</xsl:text>
    <xsl:if test="not(title)">
      <xsl:if test="@id">
        <xsl:text>\label{</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>}&#x000A;</xsl:text>
      </xsl:if>
    </xsl:if>
      <xsl:apply-templates/>
      <xsl:text>\end{figure}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="figure/title">
    <xsl:text>\caption{\small </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}
</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="graphic">
    <xsl:if test="not(parent::entry)">
      <!-- ALIGNMENT -->
      <xsl:choose>
        <xsl:when test="@align">
          <xsl:text>\begin{</xsl:text>
          <xsl:if test="@align='left' or @align='right'">
            <xsl:text>flush</xsl:text>
          </xsl:if>
          <xsl:value-of select="@align"/>
          <xsl:text>}&#x000A;</xsl:text>
          <!-- why did it include \leavevmode\null\hspace*{-7pc}? -->
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="not(name(preceding-sibling::*[1])='graphic')">
              <xsl:text>\begin{center}&#x000A;</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>\quad</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <!-- ID -->
      <xsl:if test="@id">
        <xsl:text>\label{</xsl:text>
        <xsl:value-of select="@id"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <!-- FRAMING -->
      <xsl:if test="@contentwidth">
        <xsl:text>\setlength{\fboxsep}{</xsl:text>
        <xsl:value-of select="@contentwidth"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:if test="@remap='frame'">
        <xsl:text>\fbox{</xsl:text>
      </xsl:if>
    </xsl:if>
    <!-- GRAPHIC -->
    <xsl:text>\includegraphics[</xsl:text>
    <xsl:choose>
      <!-- WIDTH -->
      <xsl:when test="@width">
        <xsl:text>width=</xsl:text>
        <xsl:choose>
          <xsl:when test="contains(@width,'%')">
            <xsl:value-of 
              select="number(translate(@width,'%','')) div 100"/>
            <xsl:text>\textwidth</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@width"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="@scale">
        <xsl:text>scale=</xsl:text>
        <xsl:value-of select="@scale"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>width=\textwidth</xsl:text>        
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="@scalefit">
      <xsl:text>,viewport=</xsl:text>
      <xsl:value-of select="@scalefit"/>
      <xsl:text>,clip</xsl:text>
    </xsl:if>
    <xsl:text>]{</xsl:text>
    <xsl:value-of select="@fileref"/>
    <xsl:text>}</xsl:text>
    <xsl:if test="not(parent::entry)">
      <xsl:if test="@remap='frame'">
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:choose>
        <xsl:when test="@align">
          <xsl:text>&#x000A;\end{</xsl:text>
          <xsl:if test="@align='left' or @align='right'">
            <xsl:text>flush</xsl:text>
          </xsl:if>
          <xsl:value-of select="@align"/>
          <xsl:text>}&#x000A;</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not(name(following-sibling::*[1])='graphic')">
            <xsl:text>&#x000A;\end{center}&#x000A;</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template match="mediaobject">
    <!-- bit more space when it's the first one of a group -->
    <xsl:if test="count(preceding-sibling::mediaobject)=0">
      <xsl:text>\par\smallskip</xsl:text>
    </xsl:if>
    <!-- rule, strut, small text -->
    <xsl:text>\hrule height.2pt\par\noindent{\sffamily\scriptsize\lite\emstrut </xsl:text>
    <xsl:value-of select="@xreflabel"/>
    <xsl:text></xsl:text>
    <!-- treat lang attribute as a crossref to a caption footnote -->
    <xsl:if test="@lang">
      <!-- if there is a previous entry for the same lang, just note it -->
      <xsl:if test="preceding-sibling::mediaobject[@lang=current()/@lang]">
        <xsl:text>\footnotemark[\ref{</xsl:text>
        <xsl:value-of select="@lang"/>
        <xsl:text>}]</xsl:text>
      </xsl:if>
    </xsl:if>
    <!-- treat caption comments as footnotes -->
    <xsl:if test="caption">
      <xsl:if test="preceding-sibling::mediaobject[@lang=current()/@lang]">
        <xsl:text>\raisebox{1ex}{\scriptsize,}</xsl:text>
      </xsl:if>
      <xsl:text>\footnote{</xsl:text>
      <xsl:apply-templates select="caption" mode="fn"/>
      <xsl:if test="@lang and 
                    not(preceding-sibling::mediaobject[@lang=current()/@lang])">
        <xsl:text>\label{</xsl:text>
        <xsl:value-of select="@lang"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:if test="count(following-sibling::mediaobject)=0">
      <xsl:text>\hrule height.2pt </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="textobject">
    <xsl:if test="@id">
      <xsl:text>\quad{\fontseries{m}\selectfont(\package{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>})}</xsl:text>
    </xsl:if>
    <xsl:text>\hfill\texttt{</xsl:text>
    <xsl:if test="@arch">
      <xsl:value-of select="@arch"/>
      <xsl:text>\enspace </xsl:text>
    </xsl:if>
    <xsl:value-of select="@xreflabel"/>
    <xsl:text>}}</xsl:text><!-- closing } for size change in mediaobject -->
    <xsl:text>\\{\fontencoding{</xsl:text>
    <xsl:choose>
      <xsl:when test="@arch">
        <xsl:value-of select="@arch"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>OT1</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text>}\fontfamily{</xsl:text>
    <xsl:value-of select="@xreflabel"/>
    <xsl:text>}\selectfont</xsl:text>
    <xsl:if test="@role">
      <xsl:value-of select="@role"/>
    </xsl:if>
    <xsl:text>&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}\strut&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="caption"/>
  <xsl:template match="caption" mode="fn">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="phrase">
    <xsl:if test="@wordsize">
      <xsl:text>\fontsize{</xsl:text>
      <xsl:value-of select="@wordsize"/>
      <xsl:text>}{0}\selectfont </xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="guimenu[not(following-sibling::guisubmenu) and 
                       not(following-sibling::guimenuitem)]">
    <xsl:text>\menu{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="guimenu[following-sibling::guisubmenu or 
                       following-sibling::guimenuitem]">
    <xsl:text>\menuitem{</xsl:text>
      <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="guisubmenu">
    <xsl:text>{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="guimenuitem">
    <xsl:choose>
      <xsl:when test="preceding-sibling::guisubmenu">
        <xsl:text>[</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>]</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>{</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="variablelist">
    <xsl:if test="title">
      <xsl:text>\subsubsection*{</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
    <xsl:text>\begin{description}
</xsl:text>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}
</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\end{description}
</xsl:text>
  </xsl:template>

  <xsl:template match="variablelist/title"/>

  <xsl:template match="varlistentry">
      <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="term">
    <xsl:text>\item[\sffamily </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>]</xsl:text>
    <xsl:if test="../@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="../@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="varlistentry/listitem">
      <xsl:apply-templates/>
   </xsl:template>

  <xsl:template match="varlistentry/listitem/p[1]">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="varname">
    <xsl:choose>
      <xsl:when test="@role='counter'">
        <xsl:text>\counter{</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:when test="@role='dimension'">
        <xsl:text>\length{</xsl:text>
        <xsl:apply-templates/>
        <xsl:text>}</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>{\slshape\verb`</xsl:text>
        <xsl:value-of select="."/>
        <xsl:text>`}</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="guiicon">
    <xsl:text>\guiicon{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="filename">
    <xsl:if test="ancestor::biblioentry">
      <xsl:text>\protect</xsl:text>
    </xsl:if>
    <xsl:text>\url+</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>+</xsl:text>
  </xsl:template>

  <xsl:template match="filename[userinput]">
    <xsl:text>\texttt{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="function">
    <xsl:text>\textbf{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="orderedlist">
    <xsl:text>\begin{enumerate}</xsl:text>
    <xsl:if test="@numeration">
      <xsl:text>\renewcommand{\theenumi}{</xsl:text>
      <xsl:choose>
        <xsl:when test="@numeration='upperalpha'">
          <xsl:text>\Alph</xsl:text>
        </xsl:when>
      </xsl:choose>
      <xsl:text>{enumi}}</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\end{enumerate}
</xsl:text>
  </xsl:template>

  <xsl:template match="listitem/simpara">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="para/orderedlist | para/itemizedlist">
    <xsl:text>\begin{inparaenum}[\itshape a\upshape)]</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{inparaenum}</xsl:text>
  </xsl:template>

  <xsl:template match="para/orderedlist/listitem | para/itemizedlist/listitem">
    <xsl:text> </xsl:text>
    <xsl:if test="position()=last()">
      <xsl:choose>
        <xsl:when test="@boolean">
          <xsl:value-of select="../@boolean"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="parent::orderedlist">
            <xsl:text>and</xsl:text>
          </xsl:if>
          <xsl:if test="parent::itemizedlist">
            <xsl:text>or</xsl:text>
          </xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:text>\item </xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="position()!=last()">
      <xsl:text>; </xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="para/orderedlist/listitem/para[1] |
                       para/itemizedlist/listitem/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="formalpara">
    <xsl:text>\begin{description}</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{description}</xsl:text>
  </xsl:template>

  <xsl:template match="formalpara/title">
    <xsl:text>\item[\sffamily </xsl:text>
    <xsl:apply-templates/>
    <xsl:text>]</xsl:text>
  </xsl:template>

  <xsl:template match="formalpara/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="table">
    <xsl:text>\begin{table}</xsl:text>
    <xsl:if test="@condition">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="@condition"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:choose>
      <xsl:when test="@orient='land'">
        <xsl:text>\begin{Sbox}\begin{minipage}{\textheight}\small </xsl:text>
        <xsl:apply-templates/>
        <xsl:text>\end{minipage}\end{Sbox}\rotatebox{90}{\TheSbox}</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>\small </xsl:text>
        <xsl:apply-templates/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="textobject">
      <xsl:text>\footnotesize </xsl:text>
      <xsl:apply-templates select="textobject/*"/>
    </xsl:if>
    <xsl:text>\end{table}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="table/textobject"/>

  <xsl:template match="table/title"/>
  <xsl:template match="tfoot"/>

  <xsl:template match="literallayout">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="simplesect">
    <xsl:text>\begin{</xsl:text>
    <xsl:value-of select="@remap"/>
    <xsl:text>}{</xsl:text>
    <xsl:value-of select="@xreflabel"/>
    <xsl:text>}
</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{</xsl:text>
    <xsl:value-of select="@remap"/>
    <xsl:text>}
</xsl:text>
  </xsl:template>

  <xsl:template match="simplesect/title"/>

  <xsl:template match="parameter">
    <xsl:text>\(</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\)</xsl:text>
  </xsl:template>

  <xsl:template match="member">
    <xsl:text>\item </xsl:text>
    <xsl:if test="@xreflabel">
      <xsl:text>[\sffamily </xsl:text>
      <xsl:if test="@xreflabel">
        <xsl:value-of select="@xreflabel"/>
      </xsl:if>
      <xsl:text>] </xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>
</xsl:text>
  </xsl:template>

  <xsl:template match="procedure">
    <xsl:variable name="depth">
      <xsl:choose>
        <xsl:when test="parent::procedure">
          <xsl:text>ii</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>i</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:if test="title">
      <xsl:text>\par\smallskip\noindent\textbf{\itshape </xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:text>\begin{enumerate}&#x000A;</xsl:text>
    <xsl:if test="@condition='cont'">
      <xsl:text>\addtocounter{enum</xsl:text>
      <xsl:value-of select="$depth"/>
      <xsl:text>}{\thehold}</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\end{enumerate}&#x000A;</xsl:text>
    <xsl:if test="@condition='cont'">
      <xsl:text>\setcounter{hold}{\theenum</xsl:text>
      <xsl:value-of select="$depth"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="procedure/title"/>

  <xsl:template match="step">
    <xsl:text>\item </xsl:text>
    <xsl:if test="title">
      <xsl:text>\textbf{</xsl:text>
      <xsl:apply-templates select="title" mode="indirect"/>
      <xsl:text>}\\</xsl:text>
    </xsl:if>
    <xsl:if test="@id">
      <xsl:text>\label{</xsl:text>
      <xsl:value-of select="@id"/>
      <xsl:text>}%</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="step/title"/>
  <xsl:template match="step/title" mode="indirect">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="abbrev">
    <xsl:text>\uline{\textbf{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}}</xsl:text>
  </xsl:template>

  <xsl:template match="note[@role='marginal'] | para/note">
    <xsl:text>\marginal{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="note[@role='marginal']/para">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="blockquote">
    <xsl:text>\begin{quotation}\small\begingroup </xsl:text>
    <xsl:if test="@condition">
      <xsl:choose>
        <xsl:when test="@condition='news'">
          <xsl:text>\ttfamily\raggedright\setlength{\spaceskip}{.375em}\noindent </xsl:text>
        </xsl:when>
        <xsl:when test="@condition='mail'">
          <xsl:text>\sffamily\lite\raggedright\noindent </xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="@condition"/>
          <xsl:text> </xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\par\endgroup\smallskip\footnotesize\noindent </xsl:text>
    <xsl:if test="@citedoc">
      <xsl:text>[</xsl:text>
      <xsl:text>\citeauthortitleyear{</xsl:text>
      <xsl:value-of select="@citedoc"/>
      <xsl:text>}]</xsl:text>
    </xsl:if>
    <xsl:if test="@citedetail">
      <xsl:text>, </xsl:text>
      <xsl:value-of select="@citedetail"/>
    </xsl:if>
    <xsl:text>\end{quotation}&#x000A;</xsl:text>
  </xsl:template>

  <!-- bib -->

  <xsl:template match="bibliography">
    <xsl:if test="title">
      <xsl:text>\renewcommand{\bibname}{</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:text>\bibliography{</xsl:text>
    <xsl:value-of select="@role"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\bibliographystyle{</xsl:text>
    <xsl:value-of select="@remap"/>
    <xsl:text>}&#x000A;</xsl:text>
    <xsl:text>\begin{VerbatimOut}{</xsl:text>
    <xsl:value-of select="@role"/>
    <xsl:text>.bib}&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>\end{VerbatimOut}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="bibliography/title"/>

  <xsl:template match="biblioentry">
    <xsl:text>@</xsl:text>
    <xsl:value-of select="@type"/>
    <xsl:text>{</xsl:text>
    <xsl:value-of select="@id"/>
    <xsl:text>,&#x000A;</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>  comment = {Written by XSLT}&#x000A;</xsl:text>
    <xsl:text>}&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="biblioentry/authorgroup">
    <xsl:text>  </xsl:text>
    <xsl:value-of select="name(child::*[1])"/>
    <xsl:text> = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="author[ancestor::biblioentry] | 
                       editor[ancestor::biblioentry]">
    <xsl:choose>
    <xsl:when test="parent::authorgroup">
      <xsl:if test="count(preceding-sibling::author|
                    preceding-sibling::editor) > 0">
        <xsl:text> and </xsl:text>
      </xsl:if>
    </xsl:when>
    <xsl:otherwise>
      <xsl:if test="@remap">
        <xsl:text>  jura</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text> = {</xsl:text>
        <xsl:value-of select="@remap"/>
        <xsl:text>},&#x000A;</xsl:text>
        </xsl:if>
        <xsl:text>  </xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text> = {</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="othername">
      <xsl:text>{</xsl:text>
      <xsl:apply-templates select="othername"/>
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:value-of select="firstname"/>
    <xsl:if test="firstname and surname">
      <xsl:text> </xsl:text>
    </xsl:if>
    <xsl:if test="surname[@remap='preserve']">
      <xsl:text>{</xsl:text>
    </xsl:if>
    <xsl:value-of select="surname"/>
    <xsl:if test="surname[@remap='preserve']">
      <xsl:text>}</xsl:text>
    </xsl:if>
    <xsl:if test="not(parent::authorgroup)">
      <xsl:text>},&#x000A;</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="surname"/>
  <xsl:template match="othername"/>
  <xsl:template match="firstname"/>

  <xsl:template match="biblioentry[not(articleinfo)]/title | 
                       articleinfo/title">
    <xsl:text>  title = {{</xsl:text>
    <xsl:apply-templates/>
    <xsl:if test="following-sibling::subtitle">
      <xsl:text>: </xsl:text>
      <xsl:apply-templates select="following-sibling::subtitle" mode="extra"/>
    </xsl:if>
    <xsl:text>}},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="biblioentry/subtitle | articleinfo/subtitle" mode="extra">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="biblioentry/subtitle | articleinfo/subtitle"/>

  <xsl:template match="biblioentry[articleinfo]/title">
    <xsl:choose>
      <xsl:when test="ancestor::biblioentry/@type='article'">
        <xsl:text>  journal = {</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::biblioentry/@type='inbook'">
        <xsl:text>  booktitle = {</xsl:text>
      </xsl:when>
      <xsl:when test="ancestor::biblioentry/@type='incollection'">
        <xsl:text>  booktitle = {</xsl:text>
      </xsl:when>
    </xsl:choose>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="titleabbrev">
    <xsl:text>  juratitle = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="publisher">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="publishername">
    <xsl:text>  publisher = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="pagenums | artpagenums">
    <xsl:text>  pages = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="address | isbn | issn">
    <xsl:text>  </xsl:text>
    <xsl:value-of select="name()"/>
    <xsl:text> = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="seriesvolnums">
    <xsl:text>  series = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="date">
    <xsl:text>  year = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="releaseinfo">
    <xsl:text>  url = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="biblioentry/orgname">
    <xsl:text>  organisation = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="volumenum">
    <xsl:text>  volume = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="edition">
    <xsl:text>  edition = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="issuenum">
    <xsl:text>  number = {</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>},&#x000A;</xsl:text>
  </xsl:template>

  <!-- index -->

  <xsl:template match="index">
    <xsl:if test="title">
      <xsl:text>\renewcommand{\indexname}{</xsl:text>
      <xsl:value-of select="title"/>
      <xsl:text>}&#x000A;</xsl:text>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:text>\par\parfillskip=0pt plus.5fil&#x000A;</xsl:text>
    <xsl:text>\multicolsep=1.5pc\printindex&#x000A;</xsl:text>
  </xsl:template>

  <xsl:template match="index/title">
    <xsl:text>\clearpage\section*{\indexname}&#x000A;</xsl:text>
  </xsl:template>

  <!-- fancy formatting -->

  <xsl:template match="format">
    <xsl:if test="@condition='LaTeX' or @condition='both'">
      <xsl:if test="@frame='yes'">
        <xsl:text>{\setlength{\fboxsep}{0pt}\fbox{</xsl:text>
      </xsl:if>
      <xsl:text>{</xsl:text>
      <!-- encoding first -->
      <xsl:if test="@fontencoding">
        <xsl:text>\fontencoding{</xsl:text>
        <xsl:value-of select="@fontencoding"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <!-- family specified or default rm|sf|tt -->
      <xsl:if test="@fontfamily or @fontdefault">
        <xsl:choose>
          <xsl:when test="@fontfamily">
            <xsl:text>\fontfamily{</xsl:text>
            <xsl:value-of select="@fontfamily"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:when test="@fontdefault">
            <xsl:text>\</xsl:text>
            <xsl:value-of select="@fontdefault"/>
            <xsl:text>family{}</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
      <!-- size or step specified -->
      <xsl:if test="@fontsize or @fontstep">
        <xsl:choose>
          <xsl:when test="@fontsize">
            <xsl:text>\fontsize{</xsl:text>
            <xsl:value-of select="@fontsize"/>
            <xsl:text>}{</xsl:text>
            <xsl:value-of select="@fontsize"/>
            <xsl:text>}</xsl:text>
          </xsl:when>
          <xsl:when test="@fontstep">
            <xsl:text>\</xsl:text>
            <xsl:value-of select="@fontstep"/>
            <xsl:text>{}</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
      <!-- series -->
      <xsl:if test="@fontseries">
        <xsl:text>\fontseries{</xsl:text>
        <xsl:value-of select="@fontseries"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <!-- shape -->
      <xsl:if test="@fontshape">
        <xsl:text>\fontshape{</xsl:text>
        <xsl:value-of select="@fontshape"/>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:if test="@fontencoding or @fontfamily or @fontdefault or
                    @fontsize or @fontstep or @fontseries or @fontshape">
        <xsl:text>\selectfont{}</xsl:text>
      </xsl:if>
      <!-- colour -->
      <xsl:if test="@colour or @colourcode">
        <xsl:text>\color</xsl:text>
        <xsl:if test="@colourmodel">
          <xsl:text>[</xsl:text>
          <xsl:value-of select="@colourmodel"/>
          <xsl:text>]</xsl:text>
        </xsl:if>
        <xsl:text>{</xsl:text>
        <!-- prefer colorcode if model is not 'named' -->
        <xsl:choose>
          <xsl:when test="@colourcode and @colourmodel != 'named'">
            <xsl:value-of select="@colourcode"/>
          </xsl:when>
          <xsl:when test="@colour">
            <xsl:value-of select="@colour"/>
          </xsl:when>
        </xsl:choose>
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:if test="@lining">
        <xsl:choose>
          <xsl:when test="@lining='under'">
            <xsl:text>\uline{</xsl:text>
          </xsl:when>
          <xsl:when test="@lining='through'">
            <xsl:text>\uline{</xsl:text>
          </xsl:when>
          <xsl:when test="@lining='wavy'">
            <xsl:text>\uline{</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
      <xsl:if test="@struts='horiz' or @struts='both'">
        <xsl:text>\hbox to1em{\hss </xsl:text>
      </xsl:if>
      <!-- now the beef -->
      <xsl:apply-templates/>
      <xsl:if test="@struts='vert' or @struts='both'">
        <xsl:text>\emstrut</xsl:text>
      </xsl:if>
      <xsl:if test="@struts='horiz' or @struts='both'">
        <xsl:text>\hss}</xsl:text>
      </xsl:if>
      <xsl:if test="@lining">
        <xsl:text>}</xsl:text>
      </xsl:if>
      <xsl:if test="@paragraph='yes'">
        <xsl:text>\par</xsl:text>
      </xsl:if>
      <xsl:text>}</xsl:text>
      <xsl:if test="@frame='yes'">
        <xsl:text>}}</xsl:text>
      </xsl:if>
    </xsl:if>
  </xsl:template>

  <xsl:template match="foreignphrase">
    <xsl:if test="@remap">
      <xsl:text>$</xsl:text>
      <xsl:value-of select="@remap"/>
      <xsl:text>$ (</xsl:text>
    </xsl:if>
    <xsl:text>\emph{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
    <xsl:if test="@remap">
      <xsl:text>)</xsl:text>
    </xsl:if>
  </xsl:template>

  <xsl:template match="caution">
    <xsl:text>\parbox</xsl:text>
    <xsl:if test="@role">
      <xsl:text>[</xsl:text>
      <xsl:value-of select="substring(@role,1,1)"/>
      <xsl:text>]</xsl:text>
    </xsl:if>
    <xsl:text>{</xsl:text>
    <xsl:value-of select="@colwidth"/>
    <xsl:text>}{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

  <xsl:template match="processing-instruction('LaTeX')">
    <xsl:value-of select="."/>
  </xsl:template>

  <xsl:template match="TeX">
    <xsl:text>\TeX{}</xsl:text>
  </xsl:template>

  <xsl:template match="LaTeX">
    <xsl:text>\LaTeX{}</xsl:text>
  </xsl:template>

  <xsl:template match="LaTeXe">
    <xsl:text>\LaTeXe{}</xsl:text>
  </xsl:template>

  <xsl:template match="BibTeX">
    <xsl:text>\BibTeX{}</xsl:text>
  </xsl:template>

  <xsl:template match="LyX">
    <xsl:text>\LyX{}</xsl:text>
  </xsl:template>

  <xsl:template match="sgmltag">
    <xsl:text>\texttt{</xsl:text>
    <xsl:apply-templates/>
    <xsl:text>}</xsl:text>
  </xsl:template>

</xsl:stylesheet>
