/*
 * Copyright (C) 2000, Matias Atria
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "mdvi.h"

typedef struct {
	char	*name;		/* name of the property */
	int	format;		/* format = 8, 16, 32 */
	Atom	type;
	int	nitems;
	Uchar	*data;
} PropData;

typedef struct {
	Window	win;
	Pixmap	p;
	int	w, h;
	int	hidden;
	GC	gc;
	Ulong	fg;
	Ulong	bg;
} DrawArea;

typedef struct {
	Window	win;
	Uint	w;
	Uint	h;
	int	active;
} TopWindow;

extern Display	*dpy;
extern Colormap colormap;
extern int	scrno;
extern GC	normal_gc;
extern GC	inv_gc;
extern GC	color_gc;
extern GC	image_gc;
extern int	depth;
extern Visual	*visual;
extern Ulong	black;
extern Ulong	white;
extern XFontStruct *default_font;
extern Uint	root_w;
extern Uint	root_h;

#define MX11_LEFT	0x0001
#define MX11_RIGHT	0x0002
#define MX11_HCENTER	0x0004
#define MX11_ABOVE	0x0100
#define MX11_BELOW	0x0200
#define MX11_VCENTER	0x0400
#define MX11_HJUSTIFY	0x00ff
#define MX11_VJUSTIFY	0xff00

#define FONT_HEIGHT(x) ((x)->max_bounds.ascent + (x)->max_bounds.descent)
#define FONT_ASCENT(x) ((x)->max_bounds.ascent)
#define FONT_DESCENT(x) ((x)->max_bounds.descent)

extern int init_x11 (void);
extern void close_x11 (void);
extern int handle_top_events (TopWindow *, XEvent *);
extern int create_top_window (TopWindow *, const char *, int, int);
extern void resize_top_window (TopWindow *, Uint, Uint);
extern Window create_window (Window, Ulong, int, int, int);
extern Window create_subwindow (Window, Ulong, int, int, int, int, int);
extern void expose_window (Window, Bool);
extern void close_top_window (TopWindow *);
extern void set_max_winsize (Window, int, int);
extern void set_window_events (Window, Ulong);
extern void add_window_events (Window, Ulong);
extern void clear_window_events (Window, Ulong);
extern Pixmap create_pixmap (Window, int, int);
extern int create_draw_area (DrawArea *, Window, int, int, int);
extern void destroy_area (DrawArea *);
extern void refresh_area (DrawArea *, int, int, int, int);
extern void show_area (DrawArea *);
extern void hide_area (DrawArea *);
extern void clear_area (DrawArea *);
extern int  resize_area (DrawArea *, Uint, Uint);
extern void set_clip_area (DrawArea *, int, int, int, int);
extern void resize_top (TopWindow *, Uint, Uint);
extern int  get_win_size (Window, Uint *, Uint *);
extern void draw_line (Drawable, int, int, int, int);
extern void draw_box (Drawable, int, int, int, int, int);
extern void draw_bitmap (Drawable, BITMAP *, int, int);
extern void draw_text (DrawArea *, GC, int, int, const char *, int);
extern void put_image (Drawable, void *, int, int, int, int);
extern int  window_closed (XClientMessageEvent *, Window);
extern void detach_window (TopWindow *, Window, int, int);
extern void attach_window (Window, Window);
extern GC   create_gc (int, Window, Ulong, Ulong);

extern void beep_sound(void);
extern void set_area_foreground(DrawArea *, Ulong);
extern void set_area_background(DrawArea *, Ulong);
extern Ulong get_color_byname (const char *);

extern int get_window_property (Display *, Window, Atom, PropData *);
extern void free_propdata (PropData *);
