/*
* perform mail alias
*/

#include <stdio.h>
#include <ctype.h>
#include "mail.h"

static char globalias[] = "/etc/aliaslist";
static char alname[256];
static char *allist[128];

extern char *home;
extern int DestSub;

char **
alias(name, report)
register char *name;
int   report;
{
   register char **pp;
   char **alscan();
   static char sbuf[256], alfile[256];
   static int opens = 0;
   static FILE *alfp;
   FILE *fp;

   if (opens == 0)
   {
      opens++;
      if (home)
      {
         strcpy(alfile, home);
         strcat(alfile, "/.alias");
         /*
         *   This stays open for duration of execution.
         */
         alfp = fopen(alfile,"r");
      }
   }
   if (alfp)
   {
      fseek(alfp, 0L, 0);
      pp = alscan(alfp, name, report);
      if (!equal(pp[0],name))
         return(pp);
   }
   if ((fp=fopen(globalias,"r")) != NULL)
   {
      pp = alscan(fp, name, report);
      fclose(fp);
   }
   else 
   {
      strcpy(sbuf, name);
      allist[0] = sbuf;
      allist[1] = 0;
      pp = &allist[0];
   }
   return(pp);
}

char **
alscan(fp, name, report)
register FILE *fp;
register char *name;
int   report;
{
   static char buf[512];
   register char *n, *nn, **pal;
   register int i = 0;
   char *strtok();

   while (fgets(buf, sizeof(buf), fp) != NULL)
   {
      buf[strlen(buf)-1] = 0;      /* newline */
      n = strtok(buf, "\t");
      nn = strtok(0, "\t");
      if (!*n || !*nn)
         continue;
      if (equal(n, name))
      {
         strcpy(alname,nn);
         allist[i++] = nn;
         allist[i] = 0;
         DestSub++;
         if (report)
         {
            /* for (pal = &allist[0]; *pal; pal++)
            fprintf(stderr,"%s\n", *pal); */
         }
         return(&allist[0]);
      }
   }
   strcpy(buf, name);
   allist[0] = buf;
   allist[1] = 0;
   return(&allist[0]);
}
char *
unalias(name, report) /* unalias out of /etc/aliaslist or .alias */
register char *name;
int   report;
{
   register char *pp;
   char *unalscan();
   static char sbuf[256], alfile[256];
   static int opens = 0;
   static FILE *alfp;
   FILE *fp;

   if (opens == 0)
   {
      opens++;
      if (home)
      {
         strcpy(alfile, home);
         strcat(alfile, "/.alias");
         /*
         *   This stays open for duration of execution.
         */
         alfp = fopen(alfile,"r");
      }
   }
   if (alfp)
   {
      fseek(alfp, 0L, 0);
      pp = unalscan(alfp, name, report);
      if (!equal(pp,name))
         return(pp);
   }
   if ((fp=fopen(globalias,"r")) != NULL)
   {
      pp = unalscan(fp, name, report);
      fclose(fp);
   }
   else 
   {
      strcpy(sbuf, name);
      pp = sbuf;
   }
   return(pp);
}

char *
unalscan(fp, name, report)
register FILE *fp;
register char *name;
int   report;
{
   static char buf[512];
   register char *n, *nn, **pal;
   register int i = 0;
   char *strtok();

   while (fgets(buf, sizeof(buf), fp) != NULL)
   {
      buf[strlen(buf)-1] = 0;      /* newline */
      n = strtok(buf, "\t");
      if (!*n) continue;
      while(NULL != (nn = strtok(0, " ")))
      {
         if (equal(nn, name))
         {
            strcpy(alname,n);
            allist[i++] = n;
            allist[i] = 0;
            DestSub++;
            if (report)
            {
               /* for (pal = &allist[0]; *pal; pal++)
               fprintf(stderr,"%s\n", *pal); */
            }
            return(alname);
         }
      }
   }
   strcpy(buf, name);
   return(name);
}
