case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting src/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
# $Id: Makefile.SH,v 4.1 90/04/28 22:42:16 syd Exp $
#
#  Makefile for the ELM mail program.
#
#	Copyright (c) 1986, 1987 Dave Taylor
#	Copyright (c) 1988, 1989, 1990 USENET Community Trust
#
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Syd Weinstein - elm@DSI.COM
#			dsinc!elm
#
# $Log:	Makefile.SH,v $
# Revision 4.1  90/04/28  22:42:16  syd
# checkin of Elm 2.3 as of Release PL0
# 
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHGRP		=	$chgrp
CHMOD		=	$chmod
CP		=	$cp
DEST		=	$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $xenlf
LIB		=	$lib
LIB2		= 	$libs
LIBS		=	$cryptlib $termlib $dbm
LINT		=	$lint
MAILGRP		=	$mailgrp
MAILERMODE	=	$mailermode
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'

#	Variables you may want to manually edit
#		If you want debug logging then you'll
#		want to uncomment the following.
#DEBUG		=	-DDEBUG

#		If you're on an ACSnet system (Australia) then
#		you'll want to uncomment the following.
# DACSNET	=	-DACSNET

#	Other general variables
BIN		=	../bin
CFLAGS		=	$(CCFLAGS) $(OPTIMIZE) -I$(INCLDIR) $(DEBUG) $(DACSNET) 
INCLDIR		=	../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

# 	Lists
ELM_SRC		=	addr_util.c	\
			alias.c		\
			aliasdb.c	\
			aliaslib.c	\
			args.c		\
			bouncebk.c	\
			builtin.c	\
			calendar.c	\
			conn_to.c	\
			curses.c	\
			date.c		\
			delete.c	\
			domains.c	\
			edit.c		\
			editmsg.c	\
			elm.c		\
			encode.c	\
			errno.c		\
			exitprog.c	\
			expires.c	\
			file.c		\
			file_util.c	\
			fileio.c	\
			forms.c		\
			hdrconfg.c	\
			help.c		\
			init.c		\
			in_utils.c	\
			leavembox.c	\
			limit.c		\
			mailmsg1.c	\
			mailmsg2.c	\
			mailtime.c	\
			mkhdrs.c	\
			newmbox.c	\
			opt_utils.c	\
			options.c	\
			out_utils.c	\
			pattern.c	\
			pmalloc.c	\
			quit.c		\
			read_rc.c	\
			remail.c	\
			reply.c		\
			returnadd.c	\
			save_opts.c	\
			savecopy.c	\
			screen.c	\
			showmsg.c	\
			showmsg_c.c	\
			signals.c	\
			softkeys.c	\
			sort.c		\
			string2.c	\
			strings.c	\
			syscall.c	\
			utils.c		\
			validname.c

ELM_OBJ		=	addr_util.o	\
			alias.o		\
			aliasdb.o	\
			aliaslib.o	\
			args.o		\
			bouncebk.o	\
			builtin.o	\
			calendar.o	\
			conn_to.o	\
			curses.o	\
			date.o		\
			delete.o	\
			domains.o	\
			edit.o		\
			editmsg.o	\
			elm.o		\
			encode.o	\
			errno.o		\
			exitprog.o	\
			expires.o	\
			file.o		\
			file_util.o	\
			fileio.o	\
			forms.o		\
			hdrconfg.o	\
			help.o		\
			init.o		\
			in_utils.o	\
			leavembox.o	\
			limit.o		\
			mailmsg1.o	\
			mailmsg2.o	\
			mailtime.o	\
			mkhdrs.o	\
			newmbox.o	\
			opt_utils.o	\
			options.o	\
			out_utils.o	\
			pattern.o	\
			pmalloc.o	\
			quit.o		\
			read_rc.o	\
			remail.o	\
			reply.o		\
			returnadd.o	\
			save_opts.o	\
			savecopy.o	\
			screen.o	\
			showmsg.o	\
			showmsg_c.o	\
			signals.o	\
			softkeys.o	\
			sort.o		\
			string2.o	\
			strings.o	\
			syscall.o	\
			utils.o		\
			validname.o

# Standard targets
all:		$(BIN)/elm

install:	$(DEST)/elm

uninstall:	
		$(RM) $(DEST)/elm

#	This is the only target that gets installed even if not out-of-date
#	with respect the files from which it is installed.
rmt-install:	rmt-defined
		-$(MV) $(DEST)/elm $(DEST)/elm.old
		-$(RM) $(DEST)/elm.old
		$(CP) $(REMOTE)$(DEST)/elm $(DEST)/elm
		$(CHGRP) $(MAILGRP) $(DEST)/elm
		$(CHMOD) $(MAILERMODE) $(DEST)/elm

rmt-defined:
	@(if [ "$(REMOTE)" = "" ];\
	  then\
	    $(ECHO) "You need to define 'REMOTE' as the remote file system";\
	    $(ECHO) "for this particular command. The easiest way to do this";\
	    $(ECHO) "to type:";\
	    $(ECHO) "        make REMOTE=<remote file system> rmt-install";\
	    exit 1;\
	fi);

lint:		
		$(LINT) $(LINTFLAGS) $(ELM_SRC) > LINT.OUT

clean:		
		$(RM) $(ELM_OBJ) $(BIN)/elm

# Dependencies and rules
#	Dependencies of header files upon other header files they include
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h $(INCLDIR)/headers.h

$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elm.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
addr_util.o:	$(INCLDIR)/headers.h
alias.o:	$(INCLDIR)/headers.h
aliasdb.o:	$(INCLDIR)/headers.h
aliaslib.o:	$(INCLDIR)/headers.h
args.o:		$(INCLDIR)/headers.h $(INCLDIR)/patchlevel.h
bouncebk.o:	$(INCLDIR)/headers.h
builtin.o:	$(INCLDIR)/headers.h
calendar.o:	$(INCLDIR)/headers.h
conn_to.o:	$(INCLDIR)/headers.h
curses.o:	$(INCLDIR)/headers.h
date.o:		$(INCLDIR)/headers.h
delete.o:	$(INCLDIR)/headers.h
domains.o:	$(INCLDIR)/headers.h
edit.o:		$(INCLDIR)/headers.h
editmsg.o:	$(INCLDIR)/headers.h
elm.o:		$(INCLDIR)/elm.h
encode.o:	$(INCLDIR)/headers.h
errno.o:	$(INCLDIR)/headers.h
exitprog.o:	$(INCLDIR)/headers.h
expires.o:	$(INCLDIR)/headers.h
file.o:		$(INCLDIR)/headers.h
file_util.o:	$(INCLDIR)/headers.h
fileio.o:	$(INCLDIR)/headers.h
forms.o:	$(INCLDIR)/headers.h
hdrconfg.o:	$(INCLDIR)/headers.h
help.o:		$(INCLDIR)/headers.h
in_utils.o:	$(INCLDIR)/headers.h
init.o:		$(INCLDIR)/headers.h $(INCLDIR)/patchlevel.h
leavembox.o:	$(INCLDIR)/headers.h
limit.o:	$(INCLDIR)/headers.h
mailmsg1.o:	$(INCLDIR)/headers.h
mailmsg2.o:	$(INCLDIR)/headers.h
mailtime.o:	$(INCLDIR)/headers.h
mkhdrs.o:	$(INCLDIR)/headers.h
newmbox.o:	$(INCLDIR)/headers.h
opt_utils.o:	$(INCLDIR)/headers.h
options.o:	$(INCLDIR)/headers.h
out_utils.o:	$(INCLDIR)/headers.h
pattern.o:	$(INCLDIR)/headers.h
pmalloc.o:	$(INCLDIR)/defs.h
quit.o:		$(INCLDIR)/headers.h
read_rc.o:	$(INCLDIR)/headers.h
remail.o:	$(INCLDIR)/headers.h
reply.o:	$(INCLDIR)/headers.h
returnadd.o:	$(INCLDIR)/headers.h
save_opts.o:	$(INCLDIR)/save_opts.h $(INCLDIR)/headers.h
savecopy.o:	$(INCLDIR)/headers.h
screen.o:	$(INCLDIR)/headers.h
showmsg.o:	$(INCLDIR)/headers.h
showmsg_c.o:	$(INCLDIR)/headers.h
signals.o:	$(INCLDIR)/headers.h
softkeys.o:	$(INCLDIR)/headers.h
sort.o:		$(INCLDIR)/headers.h
string2.o:	$(INCLDIR)/headers.h
strings.o:	$(INCLDIR)/headers.h
syscall.o:	$(INCLDIR)/headers.h
utils.o:	$(INCLDIR)/headers.h
validname.o:	$(INCLDIR)/defs.h

#	Dependencies and rules for compiling C programs
$(BIN)/elm:	$& $(ELM_OBJ)
		$(CC) $(LFLAGS) -o $@ $(ELM_OBJ) $(LIBS) $(LIB2)

#	Dependencies and rules for installing C programs
$(DEST)/elm:	$(BIN)/elm
		-$(MV) $@ $@.old
		-$(RM) $@.old
		$(CP) $(BIN)/elm $@
		$(CHGRP) $(MAILGRP) $@
		$(CHMOD) $(MAILERMODE) $@

!NO!SUBS!
