/**********************************************************************/
/*                                                                    */
/*	CRISP - Programmable editor                                   */
/*	===========================                                   */
/*                                                                    */
/*  File:          scrblank.cr                                        */
/*  Author:        P. D. Fox                                          */
/*  Created:       5 May 1991                      		      */
/*                                                                    */
/*  Copyright (c) 1990, 1991 Paul Fox                                 */
/*                All Rights Reserved.                                */
/*                                                                    */
/*                                                                    */
/*--------------------------------------------------------------------*/
/*  Description:  Screen blank utility                                */
/*                                                                    */
/**********************************************************************/

/* SCCS ID: %Z% %M% %R%.%L% */
# include	"crisp.h"

/**********************************************************************/
/*   Number of minutes before screen blanker should take effect.      */
/**********************************************************************/
# define	BLANK_TIMEOUT	10

/**********************************************************************/
/*   Time  (in  msec)  between  displaying  pattern  in screen blank  */
/*   window.							      */
/**********************************************************************/
# define	TIMEOUT	20000

# define	BLACK		0
# define	DARK_GREY	8

/**********************************************************************/
/*   Current setting of blankout time.				      */
/**********************************************************************/
int	blankout_time;

void
scrblank(string arg)
{	int	i;

	if (first_time()) {
		register_macro(REG_IDLE, "screen_blank");
		}
	i = atoi(arg);
	blankout_time = i ? i : BLANK_TIMEOUT;
}
void
screen_blank()
{
	/***********************************************/
	/*   Make  sure  we've been idle for the time  */
	/*   specified   before   going   ahead   and  */
	/*   blanking screen.			       */
	/***********************************************/
	if (inq_idle_time() && inq_idle_time() < blankout_time * 60)
		return;
	scr__blank();
}
/**********************************************************************/
/*   Actual  function  to  blank  the  screen.  Made  it  a separate  */
/*   function so I can test it without having to wait for timeout.    */
/**********************************************************************/
void
scr__blank()
{
	int	curwin, curbuf;
	int	buf;
	int	win, key;
	int	lines, cols;
	int	echo_status;
	int	background, normal, selected, messages, errors, hi_fg, hi_bg;
	int	i;
	int	color_screen;
	string	esc;
	
	/***********************************************/
	/*   Save  colors  so  we can go for a darker  */
	/*   one.				       */
	/***********************************************/
	get_color(background, normal, selected, messages, errors, hi_bg, hi_fg);
		
	curwin = inq_window();
	curbuf = inq_buffer();
	/***********************************************/
	/*   Save  status  of  echo  line  flags  and  */
	/*   clear  them  from the screen at the same  */
	/*   time.				       */
	/***********************************************/
	echo_status = echo_line(0);
	
	/***********************************************/
	/*   Create   a  window  which  overlaps  the  */
	/*   whole screen, so we can play inside it.   */
	/***********************************************/
	color_screen = inq_screen_size(lines, cols);
	buf = create_buffer("Blanker", NULL, TRUE);
	win = create_window(0, lines - 1, cols - 1, 0, NULL);
	set_window(win);
	attach_buffer(buf);
	set_buffer_flags(NULL, BF_ANSI);
	/***********************************************/
	/*   Wait  for  key  strokes,  and  every now  */
	/*   and again do something interesting.       */
	/***********************************************/
	color(BLACK, BLACK, BLACK, BLACK, BLACK, 0);
	while (1) {
		clear_buffer();
		i++;
		/***********************************************/
		/*   On   a   mono   screen   its  not  worth  */
		/*   changing  color  since  it has no effect  */
		/*   and  we  can  end  up with reverse video  */
		/*   to the end of the line.		       */
		/***********************************************/
		if (color_screen)
			esc = "\x1b[" + ((i & 7)+30) + "m";
		insert("\n", rand(lines - 2));
		insert(" ", rand(cols - 20));
		insert(esc + "Crisp Screen blanker");
		if ((key = read_char(TIMEOUT)) != -1)
			break;
		}
	delete_window(win);
	delete_buffer(buf);
	set_window(curwin);
	set_buffer(curbuf);
	attach_buffer(curbuf);
	echo_line(echo_status);
	color(background, normal, selected, messages, errors, hi_bg, hi_fg);
	
}
