#ifdef __GNUG__
#pragma interface
#endif

/*
 * Copyright (c) 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * InputHandler - glyph that handles input
 */

#include <InterViews/alloctbl.h>
#include <InterViews/canvas.h>
#include <InterViews/display.h>
#include <InterViews/event.h>
#include <InterViews/handler.h>
#include <InterViews/hit.h>
#include <InterViews/input.h>
#include <InterViews/style.h>
#include <InterViews/transformer.h>
#include <InterViews/window.h>
#include <OS/list.h>

declarePtrList(InputHandlerList,InputHandler)

extern class InputHandlerImpl : public Handler {
private:
    friend class InputHandler;

    InputHandlerImpl(InputHandler*, Style*);
    virtual ~InputHandlerImpl();

    InputHandler* input_;
    Style* style_;
    InputHandlerList children_;
    GlyphIndex focus_item_;
    InputHandler* focus_handler_;
    InputHandler* parent_;
    AllocationTable* allocations_;
    boolean pressed_ : 1;
    boolean recorded_time_ : 1;
    EventButton button_;
    unsigned long click_time_;

    virtual boolean event(Event&);

    AllocationInfo& info(Canvas*, const Allocation&);
    AllocationInfo* most_recent_info();
    void reset();
    void down(Event&);
    void motion(Event&);
    void up(Event&);
    boolean inside(const Event&, const AllocationInfo&);

    static unsigned long threshold_;
};

unsigned long InputHandlerImpl::threshold_=0;
