(*
 * Copyright 1990,91 by Thomas Roell, Dinkelscherben, Germany.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Thomas Roell not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Thomas Roell makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * THOMAS ROELL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THOMAS ROELL BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Thomas Roell, roell@informatik.tu-muenchen.de
 *
 * $Header: /proj/X11/mit/server/ddx/at386/etc/RCS/clock.pas,v 1.3 90/11/08 17:54:22 root Exp $
 *)


USES dos;

VAR
reg: registers;
no,i: integer;
norm: longint;
clock: array [0..7] of real;

function test(c:byte): longint;
 var i: longint;
     j: integer;
 begin
   port[$03C2] := c;
   i := 0;
   while (port[$03DA] and $08) = $00 do;
   for j:=0 to 10 do
    begin
     while (port[$03DA] and $08) = $08 do;
     while ((port[$03DA] and $08) = $00) and (i<1000000) do inc(i);
    end;
  test := i;
 end;

BEGIN
 reg.ax := $0012;
 intr($10,reg);

 port[$03C4] := $01;
 port[$03C5] := port[$03C5] or $20;
 port[$03D4] := $11;
 port[$03D5] := port[$03D5] and $7F;

 norm := test($23);
 clock[0] := 25.175;
 clock[1] := (clock[0] / test($27)) * norm;
 clock[2] := (clock[0] / test($2B)) * norm;
 clock[3] := (clock[0] / test($2F)) * norm;
 no := 4;

 if paramcount = 1 then
  begin
   if paramstr(1) = 'ET3000' then
    begin
     port[$03bf] := $03;
     port[$03d8] := $a0;
     port[$03d4] := $24;
     port[$03d5] := $02;
     clock[4] := (clock[0] / test($23)) * norm;
     clock[5] := (clock[0] / test($27)) * norm;
     clock[6] := (clock[0] / test($2B)) * norm;
     clock[7] := (clock[0] / test($2F)) * norm;
     no := 8;
    end
   else if paramstr(1) = 'ET4000' then
    begin
     port[$03bf] := $03;
     port[$03d8] := $a0;
     port[$03d4] := $34;
     port[$03d5] := $02;
     clock[4] := (clock[0] / test($23)) * norm;
     clock[5] := (clock[0] / test($27)) * norm;
     clock[6] := (clock[0] / test($2B)) * norm;
     clock[7] := (clock[0] / test($2F)) * norm;
     no := 8;
    end;
  end;

 reg.ax := $0003;
 intr($10,reg);
 writeln('CLOCK: A simple program to determine your VGA''s quartz oscillators');
 writeln;
 writeln('usage: clock [ET3000|ET4000]');
 writeln;
 writeln;
 write(' detected clocks: ');
 for i:=0 to no-1 do
   write(clock[i]:2:1,'  ');
 writeln;
END.
