#!/usr/bin/env python

import wx
import os
import sys
import images

from wx.lib.embeddedimage import PyEmbeddedImage

try:
    dirName = os.path.dirname(os.path.abspath(__file__))
except:
    dirName = os.path.dirname(os.path.abspath(sys.argv[0]))

sys.path.append(os.path.split(dirName)[0])

try:
    from agw import ultimatelistctrl as ULC
except ImportError: # if it's not there locally, try the wxPython lib.
    from wx.lib.agw import ultimatelistctrl as ULC


catalog = {}
index = []

access = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABJTSURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACKARHwAAATTiAwAggEZ8AAAEEAsuCUamPj6G/3/bGRj+BAO5XAwM/xmRZNFV"
    b"U5fPCCUYkaQYGVGVEuSDfMf8jYHj+y6GL+ubGb6deAgU+Yle6wEEEAvusPnbwcTMkunvr8Gg"
    b"pMzP8P/ff0yL/qNZ+J+APDKDEc3H+MKEkZGIcEM1g5GJkeHeo088G7c/iPnH5SgGDIACoPA9"
    b"UCAg6wIIINwB8P9vmL+/OsO6tb5DOokHJe9iWL/2ix2QaQLEH4D4ObI8QADhSQH/OVRUBMGs"
    b"L99+MVy+854BnHyAofzv73+GH7/+MIC5jJCIHggATmRQN3CwsTAwMUMcwwgU0FUWZODhZmNQ"
    b"UeIHOpgJ5E8lIOZHDwCAAMIXAP///PkHZl26847BMW0LA4j/D+hxLh4OBg97FQY1BSGGv/8G"
    b"NoaZgcX4rQfvGHYcvMPw7csPBiZgQLCwMDHsn+XDYKUnwfDn739oXgSVYwwY/gUIIBZ8hv+H"
    b"xi0olH8BPc7w4w+DubkSQ2qEMYOBpjgDKwv+2GeEm0PbVPAb6DQvB3WG2SvOMpw8eY/hFwcL"
    b"A6ysg6VaBtQiFQ4AAoiFsPOBKejfP2ByYmeIjbVhCPPWYQAGMsOHr9DkhxJgkOTIzMzAwASM"
    b"mR8/QQUxEAPV//kDMgd7WUYJgNmpoSrO0FHpxbBq6xWGxetOg92MRSkGAAggFmIs+fPnL4OM"
    b"lCCDl7MOA7A4YPj0DUeQAR0CTH0Md+59YHj0+CUDFwuwrPjzn4Gdi4tBW12agY+bBRxbtABf"
    b"f0ICGuTG/SfugN2Mu9pFAIAAIioAQIXK56+/GN58/M3AzcUKLASxJxhQzB8585hBgusLQ5qX"
    b"JIO4IAfDL2C5cQlYgG46cZ1BRU2JQVKEm+H3X+qmAnirDmju12+/wW5lZGQkxv8MAAFEZAAw"
    b"MHwGFjCfv/1jYAYlZywBACoPLt18w6Ao9IMhI1ATRc7JlItBQ4GfoW35IwY2djUGNlZmBlr0"
    b"wkER8AXoxs9ffzAwMhKVABgAAgh/GcCIXND8Y3j76ScDGwc7w18sAfD553+GL5/eM8QGy2M1"
    b"TUqUh8FZn5fh6P0PDKqKwljNoEYAvP30C+xWRLvrP94AAAggFkIFDLwgBHLeffzFIABsGvz5"
    b"jd5sBloMzB6yImwM3JxsOM3TV+Fn2HLhA8O338AA+E2Ddj0rJAD+MzAB/cwI9QMj3iQAEEBE"
    b"ZQGQDxmB+MOXXwzfgQ7/heZ4YKsTXDgKsuHvWzEBFf76xwQusGiRAkBB/+HzL7BbwY4iIgsA"
    b"BBDRZQAoED59/c3w/RdmAEBCn5Xh3mtgQxsoyc7GitWcaw+/MTCy8TB8+4moEqkJQG0ekBsZ"
    b"QCmAkYGoVghAABGVBcDJCRgAn0EBAEoBvzAVgpqh7/7wM6w+9JYhxkUCw6x3wPJj3elfDJx8"
    b"IgzAMoomAJSoPgNrAUjsMyL8gCcFAAQQUQ0hUHCCktVXYEsQlHx/Y8u/QDFeAT6GNef/AOv+"
    b"VwyxziIM7KxMwJj+z3Dh7heGmbs+MXxiFGUQYIBkAUYa1IO/gb4FuZGRkZloCwACiEAA/EfU"
    b"8cB67vtPSAD8+YOt5wCxk4tfiGH5iZcM7sa/GGRFORjuPf/BULH8CwO3oCQDNwcTA7A2pYnn"
    b"wZ4BZqvvwABgAbWIiGxpAAQQcYUg0DAWYBH749dfsAfwFmDgwGKFWw9u9ADzPaht/PUncU1b"
    b"cjsPTH9A5dM/cHnEiJyJ8ZTNAAHEQkSHE1rIAZuxvyEBgK9s+QdODczgEh/SRP3P8OrjXwYW"
    b"YOohNP4G6j/wcrFAUgg5gcAICoC/wMYaCzQBEDYEIIDwZoH/SE1hZmZWcAfj7x9oiOIKAFCB"
    b"CMqD0DiQAbYN0h1+AwPlK8Gk//bTX4bdNzkYWDi4SA8ARkgpCHIjM6hBgJIGcFsMEEAshBMk"
    b"xAgmFhZ4oweE//9jwN6cBQ2YAEPo+2+IpRKCLAwZ7vxE+eH9598Me2/9hAQiKX5nhLoJlpJY"
    b"WFCTKZ6ABwggFiJzJThU/wKj/8PrlwzsnFwMrOycQDFmcOqAjQqBAuTnr//Awug/OO/De5PA"
    b"wDp37xd4cAJfKnj2Dpi8gKmHkVCbBEqD7AP19/8ALfv96wfDz+9fgR21P+DyCrUWw20eQAAR"
    b"FwDgnh4Lwx+gZa+fPQBnB1BBx8bBCcHAwGBiYWP4A2yLGcj8Y0hxYGXQkEY0hv4CPd63/TfD"
    b"ow+sDKz4opYRKA8qwBix1zIg4g+wBP4DbIj8+f2T4fdPoKd/fGf4BcR/ge3zv8Dq6T94MBhW"
    b"BvxDG5nFBAABRHQtwAzsaYDa2CCaiRnii9+/foId8uXjJwZmdi6GDE9RhjxPTnCqePP5P4MI"
    b"L8Ri0ACKrAgrw4MPLMBUw4inHvwPHn3+C+xv/wfmMVB+BsUoKOWBPPcX2AD5A/QoSOwfMCD+"
    b"gdVBIogJ7GlGcFeVkfEf/lF4JAAQQEQUgtAyAGgBMzQAGIEBwMQEKumZwJ0NJjYOhvJQcYZ4"
    b"WzaG+2/+M1QC630nbTaGNCc2eCEqzgdM4q8+MvBxQhpV4PYlI3IM/wd7mgGarEGxx8kC6tUB"
    b"A+E/JGBAKQBkLzjbgewHqv8PCgRwQP0Di//7D4wsxr/QztB/goUgQAARlQVAhoFiHVy9MUMw"
    b"I9Qhv/+zMqR5QDx/5SkDQ/HiLwy3nnxnUJZA7Q946LMCqzg+cGogpuL9Bqw+1578AWzb/wJn"
    b"G1BqAAcSiP73DxzL4FQC8jQjqNj9Cy45mcG1ECPqhAmeFAAQQPidw/gfHoqgFPD/PxOYBgcC"
    b"MPZ//WVkMNYQYsh1Y2N48YmBoXLFd4Znb34wCPEwM9x68Z8BWPUzsENt0JFhBGJmkmo2IR5u"
    b"hp4toNj+w8AMSm3AVPCPCRoAoFj/D/T0X1BKAmYHcPUDyqqgFPAPtRbDEwAAAcSEPy4Y4YEI"
    b"iXkWcBYAYVBpzQ4sAFNduMGenLz7D8ODF98ZeLiAhSOwN/js/X+GS08oa9qGmDEymKpyAAtf"
    b"FnAhDKreQDSoocPEwoxgQyOFmRmWQplQm/J4AEAAETEs/h+Sz5lYwIUgyDJGYGz8Bfbr9RR5"
    b"GBzUGRkuA5P+gSs/Gbg4mMEOAmUNUOpYfvIfw68/TJgtO0aM7ia4lAe521AOkWpAST/elpnh"
    b"2lN2cMEHKob/M4JiHprfwTH9FzroA+IDIwpYBjAhWfAfue7EAgACiIWYziCkEGSGBgAzOAD+"
    b"A51jo8kB7nnuvvqX4Ruw/ufhYIUUTkB5LqDrzz5gZLj4GNI7ZWRErcMZsbQgQYLNAQwMZgoI"
    b"cXNFIFZjYThynZGBnfkfOAuARmX/M0KbfgwQgxlBI7WgYgCYLUhpRAEEEBNxhSADpPRlYoEU"
    b"fkDMycnGoA3N01ef/AMPdDJBkyk4qwCTKBuwygPFKjIGzxNgwaDCETRkfvUZ5mhTkBED0D7Q"
    b"ZAMsC0KzBDRLQsokZqgYhI+S7PCUAQABREQKgNWzwCqQgRneHuDlZmUQA1ZtX34Bm7DfGMFd"
    b"UHDLEBj7zNARKdBUHRO06YycCrClgP/QZsvLzxD+zZcMDArCkOwAShGGQHzmLihAQfU9qPT/"
    b"Czb//19GcE2A6FAxk5QCAAKIqHYApAwAepwRErrA7gYDBxsTMMkzMPz4DekggBo4oBKYCSm2"
    b"mWABgEzDpv2xTKqCygFYE/raCwaG58CaxUEVYpaXLgPD5ceQPgisHQEy5B8Dat+cCbkfAao2"
    b"CbQEAQKIiagU8J8BnvcheRwSGKBqDpjtgckfFOuM4KTMipy0WSDzBSAMS+asSJgNCYPVADEX"
    b"B8RWkNmbLkFoELBUYmBQkQB2d4F80ITsX2Bh9+c/pDaCZQFwFoS6D9F+ZsTbswIIIMJZAL4u"
    b"AuRJRBX4A9jb+/AN6CgRBgYxYGfv9UfItBhsXhBEI6cCWBaADdcxMWLGPqjTJAXtOILGNu++"
    b"YWA4fh+SCoC1K4OvPgODPDBb8HMygO2+/ZKR4ckbFoafPyFNFiZwYf0fmnYZUXqzuABAABE1"
    b"JgjOs6BQZoSU8KBU8OsvE8ODtwwMJsBqS0+WgeH6U4inWWAeRwoAMM2EyP9MjKg9O8gELNCT"
    b"QDUa0PHU58AAZQPKH7jNwGAFjH02oHmeWhAMAz+BqX/dRQaGhQeZGb59B5kHLJ3+MUMD4B9R"
    b"fQGAAMKbBf7DkxFaFoAGxgVoQ8cWGENCvNDJUWjSh2UDVhbU0h6W1JGzAijbgKJPXpSBQQsY"
    b"AM+BBeErIOYGZoeH74DlwSvsTjwHtP/ILVD/B9JZg2QDJpQsQKgdABBAhFMALACgIyHgahBo"
    b"GRvQ0GvAWL8NTAXqQIfbajAw7LkCLQCZIdkBpUCEZQMmRC0Acxco9kGNHmd1YKkP1HvqEQN4"
    b"+J2DDVLIXgR61EAS4bIPwCS/9jwDw1Zg7H/5CglYkGF//4AiCZgFEIsDCNYCAAFEoBBE9AVA"
    b"sQ8LYVCBB4q5z0DLt16GKA83ZmBQlYZMTsADAZYakDG0oITFPIgPWn8Gquos5RkY3gKT8hlg"
    b"ac/OiigoHwBTwR+oX64CU0PPHgaGzcAA+AcsEDnZoeUNtKqGZFEmjJYmLgAQQISrTGgowhpA"
    b"kFoA4kmQI48C8+hRYIyJcjEwZNgCk7E4bFwQLekjexyKQQ4HNV91gWVIiC7EndtuMoAHXkG1"
    b"CyyrgKrGF18gcpP3A1Pdc6DHwbUPUiML2u6A1VLEDooCBBCBWoAR6n9GyHw7qJEDtQhkKdhx"
    b"wCS69AQDgwg3MCsAS+g8B2DBBKy+rj+HBAQLI6IFCG4QwcYNgXLswNgzB6YaNxWgh4Bm7b4H"
    b"zO/PIZ4H90ChAzqg2mHJWQaGey8gE7NcbBAxUBMAMiwGNI8FMiwOHitgYIIO0RFOAgABxIJ/"
    b"pBGpGoQW47CWHayEByXRN8ASe9YRBoZEK2C3F1geZAHpM8Am7dnHkMIMlI//Q/M/KNBADShZ"
    b"AWDrTgqYbQQh2WYPsLo7dh9S2gPbWeC6/h/UCaC6/8lraLnCClmf8B82As0EbhiCI+UfNLBR"
    b"1nQSAAABRLA3CBtTARWC/6EDoPD6HboqBDQp/PoDA8McYCC46zAw2ClBYhaEXwLLiTffIQ0a"
    b"kF4eYOyJAVMLP3QW/RlQ/ggwC91+BSkIQUkEFCCMf1EqMsjY4j/oWqP/0BbfP4hb/jEhepNM"
    b"jNDeC3RkidDcIEAAsRAbUpBhKNTSHJTVYIEAyt/fgHl3C7BkvgpMqsbA9oEasJEkAfSsODeq"
    b"Wd+AnrsDbObeBjZ07gBrke/AUp2DBZLawJ7/Bx3mh3X4kJo04PbFf0iT+B90eB65n8EEHj0i"
    b"tDQXAQACiIVQ8QjOR/8hS09hLThGRjRLoRaDS3kg/QTosZfAFHGMB1g2ADtMApyQfAvywA9g"
    b"DH4BevjrL0hSBiVd8JqK/5CYBXueEbUlDotxmMf/Q2OdGRoI4Ej5h9rfgLudwIgQQAAR1RL8"
    b"z4C0fhmtY4PezEXu8v4AevL5e2A58AlREyBXkWzMiBbr//+IpM+INi3DDJWHxTo8kGBsJkRZ"
    b"wMiIrRWMOwQAAoiFUEsQPFILTA7/4OOsWCoXtAVJMMdhawmCMHIzGbkpDMv0/2G9OuSBFJSV"
    b"45h++o+G4SPNBMoAgAAiYmoMOjwFrcZYYRjmIfSBDvRBD6h6WKMIppaZGTMAwIUcNAXA1zb9"
    b"h9QKkFABUszQpgkTJh+WNf5BDfj/n/AsOUAA4csCjCxA1/4BmiYr8Juh2vUdymAGrLGFMdDB"
    b"iNrUZUKKQSa0ITHUeQHE9Bos38P4GBhNHK72H0Jehv83MEuxACOAkQG6aBBrUAAEEO4AYGH8"
    b"de/RV+4fwC6XuCAzg6TQX+ThAVwNRjzi/wmuA2DEkVwZsQgw4m+/AQOFGbye4d6zb6AS8i+u"
    b"3AsQQLgDgP3b1p0HnsdE5Z5kUJTjhq66xuEiRkbsLsa7SYIB94YHnOoYiTaXBVi93H/2nWHn"
    b"cdDKrcugJfKgBb4Ya1sAAogR18ZJRm5LNQYuhykMf0SsGf4xs6EELyMWT6IUUGRsb2FgxK4O"
    b"Qw2+QENyG7hcAPYifl1/wfBk8SGGP592A0X2AP2Lsl8AIIBwBwAjI7ClDt5kAOznMSgDMScD"
    b"bZb40hKAPAdshzLcBWJgb4LhHtC/KAt1AAIIXwCAMwJohgqI+UAVwRANANCwLbAlwvCOAcum"
    b"KYAAYhzpe4cBAmjE7xsECKARHwAAATTiAwAgwAAZF+SF3aAwLwAAAABJRU5ErkJggg==")
index.append('access')
catalog['access'] = access

#----------------------------------------------------------------------
acroread = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABwQSURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACCAWZA4jI+OgdehHHU6VPxxc/v9YWNXffP5yPu7+91Wnv/39CJT6Q455sKwP"
    b"EECMyGXAYA2ATyZCDew6JmVMqtqcjNLyDP9uX2M4tGb5PJebn5uB0k+B+De5AQAQQIM+C3zW"
    b"583jUFSrZxIS5vx39hDD/wsnGBh/fWeQFRLw5mFiNAUqEaDEfIAAYqGXR04wMLD9YGDgB0aV"
    b"2F8GBsFfDAzsoPQGZH//ysDw/gUDw6v3wMhugSRpcPS81uMVYmJmLv7//DHDjwe3/7z6+v2H"
    b"zLPHPAxMTAzcP37y8TAzqH/5x3ABqPQNTA+pACCAaBYAhxkYeIEetvrHwGDHysBg8JeRQZWb"
    b"mUGCjZmBnYWZgRmY2xghSZHh358/DH81/jB8+/GP4Yk9A8OtbwwMF24xMGx7+fGPmpoos9y/"
    b"r58Zvvz59+fsd4a3MmzfeUD6gHoYfv1nALHZKXEnQABRNQAOMjAw/2RgcAAyoxmZGDzEuRgk"
    b"+YFO5OZkYOAEYlagbUxMsDwIp5mAmOXvHwb2nz8ZBH/8YND98Z0hWP4TQy3X93/fwMEEDK0/"
    b"DEzAUPv3G2bA+3//fn379/8PuTEPAwABRJUA2Af0G9Dj4cBknS/MyWAiLszAIATMmZyguGGG"
    b"OhHkVGBy+A+j/0MwqNz9B3IIkGbhAgYWN5APFBcRZWAD6mX7/w9iByfjfxY1VkZBmJ3Pf/0F"
    b"pZhv5BSAyAAggCgOgK0MDM5Aj7dL8DKYyopBPM7IDPEk2GlfIUXtP05mhr+cXAz/+IQY/vHw"
    b"M/xjZgWHAOPPHwyMH98xMH4G1mjfgOzv/xn+AwODCegyRhZE9AILPBYlNiZhcIoACl778e8t"
    b"qIwE4p+UpAKAACI7ANYBCzKgF1oF2BnSlKUYmMWAsc7IBI3pLxCTf0tJM/zQsWL4qWbE8Fte"
    b"neG3hDzDfw5uhv/MzJCoB4F//xgY/wJT9sf3DCxP7jGw3L3CwHrpFAPzlTMMLN+/A9MWtL5m"
    b"YmRgAWKQV0HW/Pv0hxFq0y9KIhAggMhqB2xgYDACen6hggiDjqoM0I1sUI8DS73/PGwM302d"
    b"GT47BDP81LFk+MsvDPQwMDT+/AKXXIzgdI+lXmYCBgoLKzDWWRgYf3xjYHr9nIFn1QwGnm0r"
    b"IPqhbgNR33//Y7h+4wvD9V//T0wAZrtLDAyXILaT3g4ACCCSAwDo+QBgap6vLcMgIC0GFQRG"
    b"FAMrM8M3e2+Gj4GZDL9UDYFJHOghYGnGBIwyZmDBxcrKysAC9BwzUBxmD8huEP4HTAV///4F"
    b"hs8fMAblnv9cvAzsl08yCJdGAuvKv/DSkxWYCq5//slw5+13Bg1gCXD/G8PtWQwM2esZGI5D"
    b"M9x/UgIAIIBIygJrGBiSuFkZphkpMrCD8jqoEgd5/re6BsP7pFqG72ZuDP+BJRioocL2j5mB"
    b"k4ebgYODA+x55MBF9jgyH4RBAfHr1y+GX/+AASEmxfAPGBBMn97B22z/gPLPPv1kEACGr5AQ"
    b"sIxlZlDN/sywCJgic1cxMOwGNRxJKRMAAojoluBqYNXGz8ow01QF6HlBaM4DFj9f/SMZXnVt"
    b"ZPhu6Qks0EAe/80gKCDAIC4uziAApNnZ2cGeR45pGA0TA2FYAIAAGxsbAxcw4DjFpRj+K6gC"
    b"sw6koAfVl5+BZchbIUkGMaDdjMDw4+VlYJDnZZBIZWCY4sXA4ApUxs+ANZNhBwABRFQAAEPW"
    b"lYeFYaaJCgMLPx80twGL+o9Z9QzvCqcw/AWW6szA9hwvDw+DmJgY0FHAWAMmWWSPIXsQPeax"
    b"sv/9ZWDkBdYWGvoMjL8hAcAMLEceymowMFV1MvC5uzH8/QJKEQwMXMCqU56bQTyTgaFHl4HB"
    b"DFRpEBsAAAHERITnldgYGWYbyDNwC8A8D0x37wu7GT5FFgHT/w9wZS0sLMwgKCgIzuOwWEVP"
    b"3oQ8j6IWFHhA/EvbhOEvOyew8ASmGqDwSzEFBmEtPQamvnkMf4ODGf4BA+E/MBCANSyDMgeD"
    b"fCmwZgIaqQLEHMQEAEAAMRGo6piAzp2sIckgLyGMqHA+5HYwfPVNYWAENlE5gPlbWEQE2NLj"
    b"REnOxHieIAZlFQ4ehr+gGgJaZfJ8es8gwM7GwMQJrE5bJjH89/Jg+PcZLAVubRqwMJjUMzAU"
    b"A1XLElPGAQQQ3gAAZrMsKV4GLzVJaIEHFPgSXcDwNSAd2GD5wsAJzKdCwJIIVLrD8jSpnseW"
    b"TcAYXJIB4eEd4OwFamQwAlOXwKObDN/fvgaXC0xA+5k7JjMwmBoy/P8KqSJBgeDKyBDkzsDg"
    b"CTRCmFB5ABBAOANgGTBbsTMxVOnIQFt2wNL+p7Uzw5f4SmApD0z2QE/z8/PD8zpy1UJKzGMV"
    b"BwUKMNb/PnvCwHhoFwMz0KMgb/wH2in4+hnDl9s3GH6Da5tfDIwi4gwsrf0M/4UFGP4Csyco"
    b"sQiyMXCGMzCkAY1WA7Wi8QUAQADhDABgu6ZYUYRBUpAXEvP/RIUZPme1Mvxn42BgAeZHUAkP"
    b"y+9U9TwMA2uP30DPs714APb4b1ABAAxsnt/AmLh4muHTj59gsxm/AxtNxmYMLAWlDP9/Qfoa"
    b"oE6XIRODVjQDQzDQCgl8/gQIIKwSi4CFCLDUj1ERR7Tpv4XnMvxV1WdgAlZ1PMBSHpTskT1B"
    b"Vc8D0/LfL18Y/u9Yy8AJ7D9//fGX4d3X3+DUzMnKxMB97TzDx9evGP5Aq1QmYIOLLS6ZgcnK"
    b"nOHvN0gjgA3YoATmAV8gE1iPMnDjCgCAAMIaAMDsnqgALNR5OCGx/1dVneG7bwKwBvjGwA6s"
    b"o0EFHj7PUOR5UPJn52D4ceY4sCV4moEFaN9zZh6GR7wSwNgF5nsgX/TJXYb3t2+Ci6UfwP7z"
    b"f1ATm4ePgT2vGFzsgapGUHmgwcig4MPA4AZUJobLrwABxIQl7/OwMzJEyAtB21OgIRvfRIb/"
    b"QhLAKuEvsM7lpp3noYUfqLX3e8MyBr7/3xl+fv/FcFvDlOGFkS3D9++/geURE4Pw788Mv08f"
    b"Y/j29x+85cgISgWOzgwsNnYM/6G9AjYmBiYHyPiEPK6yACCAMAIAmIIcxXgYlIS4IdXePykJ"
    b"hl8OgeBWHjuw+oElfVp4HlwjAHtW369cYmA7tpuBg5uT4fEfVobXeqYMvPYuDO+YuMAphA/o"
    b"M87zJxjev3oFrByYgAHzHdgWADacuHkY2CMiwbkWlApAQA+YBUSBiQHaQsQAAAGEEQBAzd6S"
    b"/FAZYPL/ZeHG8E9SDhz77OwcVMvz6E1gOBvooR9rlzAI/nzP8Ovnb4YbEmoM7GpaDDImZgwf"
    b"ZTWB7a6fDCwcbAyST24zvL16meEvaLQImAVAqYDp108Gdmc3BmZZKcjACxCIAFvL9gwM5hAm"
    b"ZrsAIIBQAmAxsAAFJn8rMV5I0v8P7Ob+NnMBZyhQdYde6lPieWwBAepXf79xjYF930ZgcxoY"
    b"+9+ZGJ6Z2DJIAVMhr6gIwy8ze4YPwMIQFOsS/78x/D6yn+Hrb4hPYWUBk4QEAyswG/yFDrsx"
    b"QlKBFrQ2wGgdAgQQSgAAU7wcDyuDKj87pB78L8DP8FfbjIHp9y+UHh21PI+RBYAB/G3VIgah"
    b"r8AS/hewzy+syMBqaMIgCWxs/fv5k4HNzpHhFQs/OBsIcLEyCF44zvDm8SNwAwkUAKCyA9Rm"
    b"YLeyhhRf/yCVmAIDgyQ0ADBqA4AAQgkAYA2rx88JbN0yQ6q+vwpaDP8FxcDtTFDsE9OxIcvz"
    b"IDOAsf/jxnUGjt1rGfiBsf/o63+Gp+aODNJycgxcwFrnD9CDXKpqDB81TRi+f/nOwAwsjxTe"
    b"PWb4cPQQw29gxPyDFYbAjhOrHjDOgRH2BzoqB/S9ALADK4UtAAACiAkt/6vyskMaj6A89Fde"
    b"HVh2cjOARqJAWYBWMQ9s0zH8A5r/c9lsBrHvb4Ae+ctwVUSZgdXUnEFKWAg+DsDExsrA7OLD"
    b"8PIbxL2SwATNeXAXw/t3H8AxDg4AoDpWRUVg6hUAB8AvSNeQQwaSCrjR/QwQQCgcoCHKnKxQ"
    b"NmjkVkyGgRFY7zKBBvGhfXqqex6EgXb8uHCWgWvvOmAjCxj7P5gYntq4MEjLyzPwAKtdUCEH"
    b"HiwBlvY8dvYMr6RUwIUhOxcHg+KDywxvz5xk+AtMoSB1oIzPzAXsGsrIgD0PaT4xMElDsgAP"
    b"ekEIEEAoAQBM+YqsTJCQ+A/KBvzCwG4oA0rep7iex9rpAbb8Vs5nEPn9CVjy/wGW/KrQvC+I"
    b"OoIE9CAbsNv9x8ad4f2nn+DCUI7lJwPz3q0MX4ABAmoTgCcagAHKCCw3fjPAp5kYuSCxz4Ue"
    b"AAABhJ4cBFmgAQDi/Af2wxmwNHfR+/PoY23YAgVnpweY939du8TAfWI3Axew6fniByPDcyNr"
    b"BnFJSQZuYEyi9DJBgQCs6jgcXRhecwgCs8UfBk4udgbpW+eBLcNb4MFTsDpQWwWUcqAp4C+k"
    b"FcQJnUViRnYvQAChB4AAKL+DJy5ANGgggpEBJfmTG9tYswGo8AK15RdPZRD6+Y7h548/DNdk"
    b"tRmYTC0ZZMVE4akNpcoE1gYcGhoMX609GL58/AYeRVb59ZaBacd6hm8gs4B8EP4PLAR/I+Zj"
    b"wNkAGvsofgYIIBQOUMP739CZGNAoC6j1BxqPx1X9UeJ5sGc4OBn+Hd3HwHd0KwMHJzvDY2Ak"
    b"PbT3ZJCVk2XgBcYgPPZBdoEiAeQxFlYgBpZLMckML/glwdmCh5udQensPoZPwBYkI6g/DKwJ"
    b"fgED6gekZQtLCdBwQB0fAAggFrQAePH7L6I/zPDtC7gGoIXnwcn17WsGzoUTGHiZ/gJ7fAwM"
    b"lwxcGLj0jRlkJIAeA2aN/2yM4MbN3y+fGf4A8d+3bxj+ATHDx/cMTN++MnzlEmT49vYtAzcw"
    b"AOR+f2VgndHC8P3ULmANyMIg/ecVg4C6GMM30GzTmy8Mf/8A67Xf4Im2f8h+BgggFrR2wL3v"
    b"0CYkqBpkfP0CI/9SxfMgVwBjlGNyIwPfjdMMjMDGyzVRZYbnzn4MBsCkz/IBmB0u3Wf49/wJ"
    b"A8PzZ+ARIW5gZLD/+83AzsLIwAZslrP8/snAyg/s7XxmAZvJxs7KIP/+IcO/898ZWAWEGfh1"
    b"gb1gJzvw+OWfN68Z2k4dNeG7eE973pvfp6FTamDPAAQQC9ogyMOvvyAtKHAh+PQ+sGHxBzwQ"
    b"8Z/E8TwMz//7D5nwADWnuYCdlh1rGPj2rWNg4eRg+PSbkeGjmDSD4cUjDDJn9zCwfXrHwArM"
    b"g+zA5McKSoFAz/789ZvhBzB5fv/6leHVrz/ApA3sBAHLqL9Cygy6L+8wCIHmHoGF4vdnTxke"
    b"AAvSf9dvM8gIcjFwi4kz/JeQZVA0NBUq+Pgxbd6bF0ehEyigQGAACMCY2aQgDANR+FX7Y1VS"
    b"tdq9Ow/hJTyZd+gVeghPIFS7qMtgxSIEJBpSX0AX3bkPhPlm5jGP1wPAKSzvGh3/8VwwierI"
    b"NeBbdsj7hhb/QOgV77rNvbUu3noqoGkQXU4Q+Z5iTRgiRehH2LY1RreKo8oiKNTKWEg7xDUW"
    b"aCczqCSDnq/wTjN4IoE/jhEQZEAHuCxyiEOBAXVjSmKSp3txfsDoBru1xGZRwoQxOv1yLsf5"
    b"gvoH4COAUAIAmLsuAQPgE7Aw5ucEVRZP7jMwPbkH1GLI8O/7N+K7tMieBuZX5odXGDhuXWJg"
    b"f/6QgQ2YnJl+fGX4/+kteMrs//fPDL8YfzC8ZWJjeMErwvBSVIzhg7AkwzcpeYZ/QM+y8fMz"
    b"cAkKAWOYk4EdmLc5gaU7GxCD9ILXWICavGklDG9ePWIQunmegZGHl0Hl60uGGDkWhuNPgVmF"
    b"kRlSgALdv+HNr2fQcQG4vwECCCUAZjMwvFQHtkJffWOwUuIDZoUPwP7wqQMMjNqG4KYwzkYQ"
    b"qEQHV2tMwJKdC2wZ082LDBxXTjOwv3zCwA5MOSzAZux/JmAqAibnf/dvMbB8fMvwWEyB4bKG"
    b"OTD5yzL8FJViYOEXZOASEmYQ5uZikAONPAExCzMTYjUFRvsDGNjAdgFouv1X3USGf+2FDAwX"
    b"zzD8BaYMIWC31kuFC1zn/f7zn+HAl7+vWl/8PAPkPoLFPggABBB6/xg02XLk+RcGKwVeSCnx"
    b"f98WBpbYHHBhAgoElGwA8zhoZJgN2DAHluqsB7cwcFy/wMDx7w8DCzB5gkYov79/y/AA2IH5"
    b"/eEtg9LNMwyswCT6SlSGYbtLLAM3MHAVJcUYuNjYwSPNjAyIVAabRoMFOs5xPWCgCumbAGuB"
    b"dQzvK9MZWI/uZeBiZANnW1CZvubTn0cFj38c+fWfARQAV6Hzh2AAEEDoAfD/HQPD1sdfGAr1"
    b"gZ0qoJsY/p05zPD/yjkGJgNzBhZg/vwNrGPBDgIld1AnBliXMwA9xrZjNQPn1TMM7EBPMwHb"
    b"6L9evWC49+A+w31WHoZnSjoMrKr8DFabZjOwAQuqz7yCDLvswhh41HUYtGQkwVNpoHY82MNo"
    b"5Qghz4Pk+fj4GLiAKYVNUpbhtowRw8U72xn4RBgYRIBh+e7zn3fJv/4dAppyFLJ0CZwC4KtK"
    b"AAIIY4RkEgPDmY7fDBeefmUwVQZmgz8ffjP8XTUPHADMwBgCDYn9BA0+gLrHwDzOemg7A+eB"
    b"TcBGIzC5AT3y5dEDhpvffjHckVFn+Glnx8CnosGgCowHtanVDEIPrzF85+Rl2GkdxPBX35xB"
    b"V1GegQvY3AX14nANlhCc2QGmPlFRUfDg6efnzxkeLV4MFn/25hcDaNnCfgaGp0BTbgKZJ4H4"
    b"DnRFCRwABBC2qaPvbxkYlt/5wGAqzw0ZQ/mzcRkDS3QGAxMwubKB5utAc/hAzLFoIgPnzQsM"
    b"rBLSDN8fP2C4AjT6lropsNA0YJCWlmYQk5Rm4Hn/kkGkt5SB8/wRhl+cPAy7LPwYPpg6MhhC"
    b"PQ/r6ZHjeVCKERERgUzQAPk358xh+PDoEbiEk4KUdj93MDBcZ4AEwCN0z4MAQABhGyr+D0wr"
    b"K+99Y7j/DFgDggryf8CW1K9JrZAeIzCkOXj5GNhXzWLgOrkPWDSwMDy6fJFho5Quw43AVAZ5"
    b"d18GM2MTBkUVVQbBm+cYhGsSGThO7GP4xcXLsMMygOGFlQeDrrISPNmT63mQGtDwvCSw0wQa"
    b"rHl/6xbD1SlT4D0dfsiqtcfPILH+ALqcBgMABBDWsfJjDAyvgG2wuVfeAzPLP0hQ/tq0luH3"
    b"uiXgfgH7u1cMnDtWAQuM1wz/gJ57zivMwO3kzWBmZsEgryDPwPnxNQPP9GYGoaoEBm5g9fcF"
    b"2DLbbB/O8NLGm0FPRYlBkJ8PpZdHqudB6kCelpOTg8xRAMVO19QwfAGNEkPrOWBR/XMNZOnM"
    b"LVCFjmstEUAA4VwiA8z+ouUMDHtchRn0NIDB+RPYq2AUBxZYGw4xMANTwF8fHWBZ+hHYXmcH"
    b"D5r+1DJm+K+mB+xOvWJgu3CCgR3YimQCNnQeSiozHLAKYPinZ8agoyAHLrBgpTu5ngcBeXl5"
    b"BhFg3ge5+PLkyQyH8/LAsc8ITf7rGBiuzQev6GHYBMQX0dcQwcwBCCB8a4RY4hkYgmyZGRa5"
    b"iDOw87ECUwOw8mCxtmbgW7GD4f/W5Qy/2osZ2IGNGkbQ4ibQKg5gcmECddvZmRne8YkyXNQw"
    b"Y7hp7MwgpqTKoCItCezxcaJUbegNKGI8D3KjrKwseCEGCDzZvZthZ0AAw+9vkHEy0BAKsCZ7"
    b"V8DAsBkY5Tsg5SDDK/RlMzB/AwQQvvnzPwsZGLYL/2VYKPiOIc0G2D1nBBaKPw8eZfiUHcsg"
    b"MHcNw1cFTYYni6YycNy7xsDy+SPDX2B58IlfmOGphCLDE1UjBlZFFQZtCQkGEUEBcGkNy/PY"
    b"5gOIyfOgkWlQsgdNyYPAy5MnGfbFxTH8+vYNXAiCxrxB8TSdgeE80POXGSD4Hb41QwABRGiV"
    b"GBPQQKlKBoZV1twMloYCkI7SX2BK4AgNZBCctpjhE7CN/fLObYbXTx4zvH4H7MUxsTBwCQgy"
    b"iPDyMAjwcIOrTfQ1QaR4HqYOlHVAngfVHGDPHzvGsCssjOHz06fgpM8CHfeey8BwYT0Dwy4g"
    b"czsQn0Vu9WFLAQABRMwyOVZgzjYIA1aN1rwMytq8kIXKf4CBwOZozSAyYzEDs5wiZEEFUOI9"
    b"MBC+fPqEks9xFXb4PA+TBxVyoOQOqu5ABR8I3Fu9muFgejrDj/fvwTEPEgWNHwF9fWcaZKXY"
    b"HgZIw+cVrtiH2Q0QQMSuE+S0YmCw8wV2F8x5GGQ1uCDrecFlgpI0g1DXJAYunyBErxLYUHoP"
    b"dNwnYECAWo64epHojoGJg7ILKKZBSR209giU9MEDNsCu8LnGRobzvb3gZjjM88KQmuthD8Tj"
    b"hyA1IHgjxR9ChSlAABEbACAJHmATx8GPgWGKKQeDnCY3ZHDt9zfIcBVPTAyDYEUDMN8rIQoR"
    b"YIr4/Pkzw5cvXxi+AfPpz58/UVIGI3z1JyM4dkFrCrmBXVpQcufh4YF3wEDg0fbtDKcrKxle"
    b"XLwI78qxQgs9YCl3fzKksIM1dx8QWkQN8zdAAJGyUhQkyavGwGAeysDQa8jKoKvFBVrEDB6C"
    b"A/eimCQFGPgSUhj4k9MY2JRVMSz8AxqrA2LwalDQ6g7onCOonACtJ4QlcbgeYGA93b+f4cqE"
    b"CQwPtm0D9xNYoGkaVOABc+M/YHV3cymwAwdJBOAAeEjM+mGYvwECiNSlsuCUALRcI46Boc6c"
    b"kcFTjYOBWQrqqt+g6XQgZhLiZuB29WDg9Q9i4LZ3YGABttYYiFyH/B8YQB9u3GB4smMHw11g"
    b"Xn955gzDH6jHoXMX4AH+7wwM3+YB63egj0FDXKBlsqfwNXhwBQBAAJGzWBrW2JJzZmCItGdg"
    b"SNNiZpCQB6ZHfkZI1/0vMEX8gQ6uMgnyMXDoGTCw6+kDe4Sq4MBgAiZxRtCYP7ATBJrt+Qks"
    b"L74C2/Agj78+d47hHbBZ+xUYEIxITVUQzQax+D+wT/sU2Mg59QbS0jsFre5eMJCwgwzmb4AA"
    b"omTXGMg9YsAWo743A0OyMQODiwIzA68kE7gVycAMWesIrjZhExR/oJMUIPoPMOn/BmULIP4F"
    b"babB5P+itdXZoBiYtt8Bk/zV05CWHcjT54H4LhB/RNNGdAAABBCl2+aYIFmRQRZYB5vYMTCE"
    b"6DIwWCgwMoCnNEEdEo7/8HVH4ECAzdfBAuQPFj4sqUOnKf/eZmB4sxfYpgem86v/IZ2by9A2"
    b"/gtyN0zA/A0QQNTaNwgrkKWBPQN1EwYGR00GBlMFBgYFcWA48EIaVPCe2j+kmEZm/0fMT/wG"
    b"9uI+3mBgeA7sxN+7D8TQkv02NMZfQHt3/8h1MMzfAAFE7Y2TbJB+FHhVlgyQA2y7MWgCA0IN"
    b"KACsIxj4gIHBxQrZY8HyF7KU5x8wCn9/hoxDfAJW3u+Avnz2GuLJV9D6/DFomxBk3BY8pP2X"
    b"UofC/A0QQLTaOcoMLSh5oTlBCIoFoIU4JzTVMCHWooFzx3do0/U9tA3/Djp+94XSvUG4AgAg"
    b"gOixdZYRmjLYodU3GzSAmJHm6ZADAboTAVwu/qWmp7EFAECAAQBSttDTdkLaMAAAAABJRU5E"
    b"rkJggg==")
index.append('acroread')
catalog['acroread'] = acroread

#----------------------------------------------------------------------
agent = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABbgSURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACKARHwAAATTiAwAggEZ8AAAE0IgPAIAAGvEBABBALDAGIyMj/W0XmcnC8P93"
    b"AAPDHyWG75sXMnzb+x4o+oueTgAIIEZYQ4juASA82YbhL1MHw18GawYWYEJk/HaD4e+lFoaP"
    b"C7cAZT8D8T96OAMggOgfAEKTZYBkPcMPhgQ+KT4WKy91BlYeToYD6y4zfH7x4Q8Dy8v1DN92"
    b"NTJ8O3kHqO4nrZ0DEED0CwCh6WwMDH8zGH7+r2bmZBMzcVdlcAvTZRCVFWB4/+U/w4vHHxgO"
    b"rr3EcO3oPWDcf3vO8P92B8ObqUuAOj8C8V9aOQsggOgTAEKTXRh+M3Qw/Gc0VjCSZnCPMmBQ"
    b"NZBi+P//H8PXr38Y3n/9z8DCyszABHTCzTOPGQ6vu8Tw/un7/wxMb/YyfDtcy/BpxyWgKd+B"
    b"mOodF4AAom0ACExSBDq5leEXYxifLD+zQ4gug4mzCgMrOwvD759/GP4BrX7/5S/Drz8g+yGY"
    b"jYOF4fP77wynd1xnuHzoLsO/X98/MPy/O4nhzcIZDH/evAaa+oeaTgQIINoEAP8kUD5PB5bn"
    b"WSw87EJG7moMNgFaDILivAy/fgA9DvQ5KLY/ff/H8AWImdDsZgYWikzMTAyPb7xkOL71KsOb"
    b"e28ZGJi+3WP4fbud4cWkNdBCkirZAiCAqBsAAtOA+fxPJtDj1QxMTKLywORuF6bHIK8lxvD3"
    b"z3+Gv7//Qu0Clm6//wOT/j/ciRqohoWNheHX998MV4/cZbh2/AHDjw9ADYyvdjB82lfP8H73"
    b"VaCqH5RmC4AAol4A8E9yYfjzv5PhP5ORtJ4kg6GbKoOaiSw4b/8GpnHYsAMo5n///c/w7utf"
    b"hr//QP7Eby8jUAPIjM/vvzFcOXSH4c7Zx8Cmw9e3DH9u9zE87p0FVPKBkmwBEECUBwD/RCVg"
    b"jd0Cyuc8MvzMpr6aDNp2SvB8/v8fIoJAVvwCpoQP3/4x/AGKE/I8erYABcaz268ZLh24xfDx"
    b"KahyeHuc4fOxaoZXa06SW0gCBBD5AcA3lQsY8PnA5F7GzM0uoOmgzGDoqc7AJ8oN9PhfYD7/"
    b"h9He/vYblO//MkDChPQAB+mAZItfDLdOP2S4B0wNf398/cLw5/5shsfTehl+v3sFVPKbFDMB"
    b"Aoi8AOCd6Aus0tqBCU9bClidGfppMUiqijD8+wOM2T9/GZC9BzIWKMzw5cd/YAAgpQaQCpii"
    b"/zCKuAhkYmJiYGZlYngHTAU3gO2G949BLeiPVxk+n65heDJ/L5DzhdjUABBApAUAT58EMB0W"
    b"A5N7IRMHK7M6sEozDtABJ09QckdO6ozQtuwPYHx8/vmfARQujEwwjzOCPQuqDUCQGSgBth/o"
    b"Foh7iAsIFlYWhj/A8uXa4TsML26+BGr79ZXhx41pDI/nTWb4+fI5MWUDQAARHwC8/dYMf5jW"
    b"AGNeQlRLnEHXW5NBTFUUGOvAJA0s1GCeBhkHzOYMwFzA8B1o/e8/kHgFBwiw4fP77x+GX0DM"
    b"+OMzA9vXNwxMv38w/OIWZvjNLcLAxsIGxKwY1SIjLEVhGcAFlQsg/PLua4YH5x8z/AAWlsBy"
    b"8SrDx1NVDI/m7yeUGgACiLgA4J0CDOq/+zmFeWw0vTUYZAykwXnxD7R0B5kAiuHfwBj99Y+R"
    b"4fvnDwy/P78FVgjM0FQOJP/9ZmD78oZB+O19BsnXdxikXj9gUHh3j0Hw7yeGF4KKDI+kNRju"
    b"SugwPBZSZfjBJYRSRjABA46Zg4eBmVcUuycYQYUkM8PPrz8ZXgILyRe3XjL8+fL2KcPtxjiG"
    b"74/PAJV8wuU1gABiISqt/f+XALTGRs1dnUHWXIHh19dfDL9+QfopH4HUz3+QyAEHJjB/fvvx"
    b"jUHx7DoG1et7GP4A8z0LExcD19+fDNI/nzCIcn5hEBP9zyCmDWw2GDAwsAoDA+/yW4ZfF88w"
    b"fDvFyPDxnzDDSy5pBmZgQ4iN+T8DD8cvhsuCGgyTlFMYODiEgKmDCXuE/gY2EYCBIKkvzcDK"
    b"y85w//gfaQZxr2yGBzMbgLI3cBWOAAFEOAB4e0WApViFkJo4g7CWBLiZCvIoKH6AKR+cv/8j"
    b"FXuMoCwA9PDv/8wMim9vM+iGWzOwM55g4OT/zSCiB+wW6AKLEgVgjPECFXNB7fgF9BKwbff7"
    b"7n+G3+ffMDDefcPAAjQHWP0zMAIruLvf5Rm+sPIzsIAKlf/4G4CMwMYWjwQ/A484H8OXX4bO"
    b"DJzSmxm+P30BlHqNTT1AABEOgP8shYxsrMoyNkrAvA1szf1CtOaANRrDzz+w2vw/PMP+/8/E"
    b"8FxEjeEbBx+DcUUKg5Am0O6fNyDyP6FxAUqU72CVPFAbK7AfoA7EetCiixEaMMkMDKd/qTH8"
    b"BgbqH1B58p/wMAETsFDmVxRh+PLmCz+DpG8ow70ZF6G9SozBFoAAYiHQyNEClvjZwgaSDJwy"
    b"AgzfQBU53J//GT4BPQ/K86ilB7B0/8/C8JFHguHlP26Gl6cvMwhpqAHD/waiyoOl4H+cECf8"
    b"/QxxGiO00QCigY1qhgdAVz9lZbigogb0FDswsP9iLQgxALCJySbIzcAlxgusek1tGLh3GDN8"
    b"ffAUmgpQDAAIIPxjgv8Yapj5OPiFjWQYfgCruZ/A2P8JTGK/gPjLr/8MX4H4N7CS/4WC/wJT"
    b"ChPDDx4xhmdcUgyvz1wDGiTNAK8KmCAxzsAKSg3AvPBFDxwGYDEmBtRAAmp99FuU4RGnNLAY"
    b"YgTb+wvDPiwYWB78AuZPLhlgYcopxMcg5RMKNE0WGqwoACCAWPC07d0Y/jCGC+pJMTDycTB8"
    b"//YbOZIZPgM9+es/jsYsqLPDwsvwSlyd4cWFY8AmoA7Qc0AfsvxF1Gkg/B3owO8iDAwiwNBg"
    b"gaauf9B+HihF3GRguMCkyPCeVYCBA9SZ+k/CKBkwIBh5OBjYhXmAEWdiycCrasrw+fYToMwr"
    b"5FQAEEAsOHp1rMCuWwOrKC8Tl7o4ww+g52FtelAh9xMYVV8Y8DRYGEHZAFgOAAPg2aVNDN8/"
    b"MDJwMvEBlQNbbO+Asf6bA2LQJ15wcmV4oQFMAT8h5gk/BgbCD0gX5w4Dw3keZYavTLwMTODk"
    b"T9owIbgjJc7P8OvDN97/0j5hDDf6z0I7T/ChNoAAwh4A//8mAusUS25tKYbfzMwM/77/hef7"
    b"P8DS7yu4JYffMf+A1dVLAQWG199YGN5efsAgYyQIFAUGABew9HsEzBLA8omBGRjrjMAS74UM"
    b"MEsAo1wWGOXsPyHFFTC3fnjCyHBWUAmcN34Tm//RAQcbA6MAF7AHaWjGwK9hzvDxBigVvIDF"
    b"HkAAYQaAwARg552hnEWKn4FRWoDh+9dfYItBKfYPqI4HJuX/8LSKLwCAkQssuT8y8TD8eA30"
    b"DbDFB86B/MCiX/MEA8NVYLb4xA9JCSxfGRg0gAU1zzeIsX8gtcT3X6wMz5gFwFni19+/5HX9"
    b"Qf1vQR5gngWWijJ+YcAAOA2JCfBYAgNAAGEGwH+maGB+VWJVFAZ3Wf8DCx5wMxYY69+BGLmX"
    b"hz/9AfPg758MXIw/Gdj5gA7/DfQcJ6wgBPJ/AM35CxRjBtI/mBGFJDMibbIyAev0P8DAAdr5"
    b"j+E/eQEAyrrswDKGix0Y+Nr6DJyS+gzfnz+EpgIGgABiwoj9/4w5TMDqg1GEl+Hv99/AFuxf"
    b"cBP3OzDm/8Ha4wQxRB3Tn58M3P+/A1tmoCj8iSj933MDAwSYsvSBSd4EWNRzAyPkJS+kNkCK"
    b"Ela2vwwCf4BNeVjs/ycTg/TyA0OfU5iPQc7fDyggBasRAAIINQUwMpcwsLIqsSiJMPwF5TlQ"
    b"yAN7XL9ZmCGG/CM2BiA9PjZgh4cdWPJz8AJTG7ADxABrxTIDzTa5D3QUtF1iCmS/AToQ2K5g"
    b"YP0PUQdUwg4UEvj1GaKXkYXkQhCpOgd6HpQKgH4Ws7BheLJFn+HrE3CNABBAiBQgNMWA4R9T"
    b"BpMkH8M/HnZw8v8FTDq/Qe1RUCiCkj6JmPPHJwYWYBJn5/wGcQUXNMglgXzBX4gUzQn0rRww"
    b"ptmBAsAKgoEdEgBsQFoQ1Ej6+5cs+1Ex0GxgtQhsHfEzKASFQhonDGwAAYRIAf/+BjGwsAOr"
    b"CwGGP1yskLYuWJycUIfo5fzxhYGD6x8DK/t3Boan/yDCPKD+BTQBskJTBKzeB3VcgVme4SWk"
    b"IGQCBoDA76+QqhJUVvyncLaMFTTSCoxQPiVgCcygDMSPAAIIEQD/n2xn+KdQ/P/9Ny4GYCoA"
    b"D+OQPdLIBI5xTmAW4OL6y/APVAYoigFrX6Av3wKrvntA+h/Qh6z/IB4HNwGAetiAjmMHlX5A"
    b"rAEMHbF3DEL3gdXBn18QMXieJjNOQIMUoMB8dRJUAAqA0hpAACEC4GP3RQbBxm0Mj9lCGKSA"
    b"AQDMBsTneeT89g8yOPDzOwPnz3cMn+79YVjn8IBBQo+ZQVCdnYFfmRUYAbwMPNKMwATwl+H/"
    b"pz8Mf78AsxuwsfTvGbC6ffabgeXFVwamZ8D2PLBNxPMPWEC+eQZMNaKQ7iEL0MnMzOQFArBQ"
    b"Z/jx6ivD4+03oF2xHwABhFwIfmf4c2Mywy8hT4aH77gZtMSJCwBYjICHgoCx+usXlP2T4ZaQ"
    b"DsMMtlQG0U8vGST3v2SQ2fqKQZ7pDYME1wcGIb6/DGKykJ7hj7eMwEhmAfYvuBmeM4kzPOUQ"
    b"YXjCLsLwmFOM4RKHNHiMgeEPUCGwWgWzWVkhmIkJdVQEX+z//geJ/ecHHwFD+x5Q5D5oggUg"
    b"gFhQunGfl59hEFZbz/CSK4ZBCphvefGkAvhAPxOCD4oZTk6oAm6Gb7wmDDf/GjPc/AcaLgKa"
    b"9xOYyX9/YRD9+ZpB8cdTBulnr4A1DDuwBhRjeMQuwfCKVYjhPzOwkABhFg6IeSyMSDH+H3fg"
    b"EwoEUDf+5/sfwNi/AuTdAmJQ7/A3QAChN4S+M/y+MpmBWcSH4clHAQZ1EewBAErmoKTIwYEa"
    b"C+ChL9CAACO4scMKrNL42f4zSPL8YxDj4mEQ5hRh4GX7x8ABrBpZmf4Ai5l/4IaaBrBg+vef"
    b"GdjdZWb4+puR4eNPJoa33xkZXn4F9ie+APsdQLF/f6DmglqOTP8w3fPzJyQFYgsIkB9Aozcv"
    b"jz1h+Pb8NqSXAW5wMwAEEHoAADv5ay8zsOusZnjLlcrwARhrfGipAGQZKJYFBJBiH9KXZWX9"
    b"w6DI9Z1Bi/8bgxzPTwZZ7p8Momw/gYXvX2DtB8zvwGzxC5hFQN1qULf131+oR4AeZGUB6Wdm"
    b"4OBhA9KsQCNZgRUBI8OPvywMz7+zMzz9zsZw5xMHw7WPwGzygxuoFzSK8hfRJOcBppovwBT2"
    b"6RNiphXeMwRhYI/u0RZQ3xwUAE9ggyMAAdgwlxSEYSAM/6QPqaGIItYHLly79gSewMN5KRd2"
    b"3VUXUg2CCJW0CWh18tCVN8hkvmH++f4dQwr6uEc02UE8xuChJ89ngQEVPp05LG1HQmRRjU1y"
    b"wjqqMOxuFvW2anGWGoVUaBoNpbR1B4YSRqky+GFNJ7XV4sxpcqsVzYcE6CcxbZEeUh5jQUFm"
    b"RcRtM47qNUKu5sj1EtJIlffTvS+l/copZQrhaGCemo4adT1cUJeFx//+naePAMIWAMBUsPkG"
    b"A5fFNoaPXHHAkgloKCukDhYRZmBQAlaf/5ghefrXVwaF7zcYXL4dY+B48Zrh0YevDHeBWQDY"
    b"C2BgBnqSi4sLjCX4BYGJBtg3Z+cA8jmBkcUNdCc3eIIDPMkBDAyQx79//wHEkMD6Cawyv337"
    b"BozUbwxvP35lePryE9BPoKm23wzCwGatl4QQg+IvPoYtf4wZ3nMAS1NWLtC0ETDF8kFS5qOH"
    b"oN4YJABAfnp++C6QvgeN/R8wzwIEEK4BkV8Mv+/MYmATC2K4/5GHAdQwYgMa9ouDgZHrPYMO"
    b"6ykG6a93GMSYPjOIcgAbOmysDKz8cgwyyiCPcYI9DUrGzMwswKKCGYxBfJgYaAge5HGQOMjz"
    b"oBTBAixTWFlZwGrAo1rA1h9olgnkaQj+Cwyc7wwfP35iYAM2EVlYWBnEnz1ikLm/l+HZN2BZ"
    b"8ZeL4Ra3EcODnyrAvA7MBn/ZoeUFMADe33zP8OIoKPnfhVZ/8DwNEEC4AuA/w9v55xhYBLoZ"
    b"/ghFMfzgkGBk4eP+/+Yby/+bLxjsg/4wODjIMzx//RFYPACTK9BBoGQLKgcg9H+wByDl0X94"
    b"Qf0XmOeZmf9APc8C7lkyA1t4TEyQuUSQnt+/IfIQPYg5C9AwOQcHOzBwxRn4+fnAZcn//78Z"
    b"OHm4GMyAESAiwM3QvfMbw4MrVxm4mN////vt5cefn168Yfj+4j3DS/B6oyvQqu8bskcBAgjf"
    b"oOgPhpf9M4D0MQZGNk1GNnEFQUF+ZWZOWZWjZ7S0VeWUGURFxYHZ7SXDH2DMgDwEwqAuH8jB"
    b"II+DPADK14yM/8CegvAR7P/wqTAGFDailvuPweYEFsCggHz79h3D169fGdg5gA1XKUmGIycv"
    b"MDw6f5pB493d10/vnD/3/cu3uwz//z6FDoG9gib/5+gDGQABRGhmiAXaeucHV+zAHAbEooaG"
    b"+sVS0or27m7ODBIS4gyvX78GxwgkiTNjYFDAYBPHpxY5UEApA4RB4jzA0v7Dhw/AAHgLLkcE"
    b"gLXR4SPHGLZs2crw5tXzp1euXj0ADOTzQO0Xofn9EzTWv0NLfpRQBgggUiZHGaHdF05gDMoY"
    b"GplMFBMTd7ayNGfQ0tIExsYXYA30GWwOsodxeR5ZHFYQgsRg2QNkDnIAgFIOL7CUBwX0x48f"
    b"gdmAH5hdfjNs3baD4ejRYwxv3rx+evXKpb1AdSeAbjwKjfGvhEZRAAKI3PUBoA6rgoGhUauI"
    b"iGigqooKk6mpMYOgoCCw1P4CLqzA8x3MzPBUAfMYNs/D+DA2tgDg4ADVIuxgT4PUXb9+g2Hb"
    b"9h0MDx4+/P/i2dM7N2/eOAxUC1oocQRa2BG1xhAggChZIQIKBDkVFdUEaWmZdAFBQWENDXVw"
    b"ahAQ4Ac3cn78+A4u1CCFGCLmkWMaOfaRUwhIHFKWMIKTPSj2QTF/+/ZthkOHjzBcBRZ2n798"
    b"/nLn9u1LL148B02Agsb6QAHwiJQFlgABROkSGVCWEAfmRTM1NfV0YWFhWz4+Pk5ZWVkGEJaW"
    b"lgI7HFzPA5PwH2BMgucVkQIEOQAgVSErOLZBGKQOFONv3rxluHnzJsPFS5cYHjx4ACr8fgI9"
    b"fQ/o+XNAeVD1Bsrzl6EjCSStEAEIIGoskmKGDnEoCAgIWiooKAQDA8IYWFrzAxs/jCIiIsCG"
    b"oySDKJAGZRFgAIGTMnJsw9oFIPwT2KYHxfQbYCH3/NkzUBJneP3qFaSR9OP7l1cvXz26f//+"
    b"le/fv92GzB0xgFaLPSR36RxAAFFzmRxojAc0sS/HxsamKSoqaiYuLm7Ex8+vwMnBIQz0NCso"
    b"dkGxDGrIgOp0GP8PsKv7C5hVfvz4wfAbWMiBYh0UEEAaWMN+//T+/fuXb968efLy5ct7wPLg"
    b"CTSPgwLgMbRZS/YKc4AAovZCSdi0JqjaBK1mEAeaKw3MBsrAVKEJzMtSwJQhCAwgHmDMswNj"
    b"nAWImf9BANBvf38BPQ708/fPnz59eges6p4Dm8MvgW58BR3GfgalXyPN9lK0ThAggGi5VBbU"
    b"nOOAtiP4oENQQlAaJMYJLUhZoGqRZwW/QUcIP0Cbru+h9flXaDueaounAQKIXqvFYVMesDFf"
    b"2JAoM9KEOPLU6G8GxGghzMM02eEJEECMI33nKEAAjfg9QwABNOIDACCARnwAAATQiA8AgAAa"
    b"8QEAEGAAN3pyzfJrAA8AAAAASUVORK5CYII=")
index.append('agent')
catalog['agent'] = agent

#----------------------------------------------------------------------
aktion = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAxhSURBVHjaYvz//z/DSAYAAcQ4"
    b"0gMAIIBGfAAABBADKACQ8TAAYkAcBMSzgfgBEOfh8zNAAA2HAOAAYlMgLgTi9UD8kI2N7Z+J"
    b"icl/fX19kIduArE4rgAACKChGgCqQJwAxIuA+A7ITyIiYv/NzS3/z5o16/+NGzf+g8COHTtA"
    b"HvoLxIG4AgAggFiGULIGxbITENsBsY6IiAiHhIQkg6KiMoO8vAKDkJAQw9+/fxmsrW0Y1NXV"
    b"gez/DCoqGgx8fHxMnz59MoWmDgwAEEAYhSAjI+Ng8DAPEOsBsT0QOwCxMS8vr7CmpiaDnZ0d"
    b"g5OTEwMwiTNcuXKNYfv2HUDP/mH49u0rw9evXxhkZGQYCgvLwAHw/z8jQ1CQD8OJE0f3Ac3w"
    b"A+KvsBQAAwABNFhSADMQawCxDRA7A7E5ExOTnJiYOIOCghKDnJwcQ3h4GNAzASiaVFRUGD58"
    b"eAv0/Dewp/78+cNw+fJlhoMHDzMYG1sycHBwMtjYOIACQAeoXAmIL6NbDBBAAxkA0kBsBsQu"
    b"QGwLxJoSEhIsFhYWDKqqagzfv/9iEBYWZmBiYmT4/PkTw9WrVxhcXV2BfBaGnz9/Mvz+/ZeB"
    b"k5MPGAjqDPv372ZgZWVj+PfvH1DfN4adO7cyiIlJM9y9e5vhxo1rsCykjS0AAAKInlmAD4gN"
    b"gNgRig2AMcSvpqbG4Ovrw2Bvbw+MNWNwXgY5qa6ujuHFixdAT/0F5+2vX78yREbGAfO4PcOn"
    b"T5+BYv8Y2Ng4GJ49e8LQ3l7D8PHjR7CaDx8+AOU/gc14//7dP6A9z4H4IhDPAOIdQPwb2c8A"
    b"AUTLFMAGxFrQZA0qvMyAyVoaVHApK6uACy9xcXEGSUkJYJ7Ng5bODMAY/MnAzMzKoKSkDIz1"
    b"y+CYBSXtHz++M2zbtplBU9MQ6HF2oGc/M9y5c5fh4sVzDDdv3mJ48uQRMGX8AhnzDojvAvEl"
    b"aIzfAuKnQPweWiOgAIAAonYKUARiS2g+tgJidVlZWUZQsnZ2dmYwNzcH5s+jDG/evAF66he4"
    b"0ALGEjBvhzC4u3uDYw6UtEGF17NnTxm6u5vg+fv379/ArPAZmFJcgXreg/I1MABuAT0NDBlI"
    b"g+cqNKavg9oCQPwGiD8C8Tcg/oleDcIAQABRmgKEgdgIGsOgEluPGwikpWXBsZybmwUshGwY"
    b"gCU4XMOTJ8+Ajj8CjEU2cPL+8eMnsCTfBqy69BhYWNjAqYCZmYVBQkIWmArUGbZsWQ9MFd/B"
    b"SRuUxE+fPv0XGqM3oB4GefweEL8A4g/Qkh4UKEQ1agACiNQA4IAWJnZQT5sCPSKura0NTM5S"
    b"QCzBICUlCSycOBm+fPkM9BAr2PPfvv1g+PXrD9hz6urawNKZAxyLoJgAFVx37txmOHbsCIOV"
    b"lSMwOV8DJ+vTp08wnD9/muH582cge18D8W1okr4MZT+FJvcvUA//IScGAQKImCyghpSsQbSK"
    b"kpISg6WlJThZW1lZgRsely9fZZg7dy64TgblV1BJzc3Nw1BaWgn0MDc4pn///gNkczGsX7+C"
    b"YePG1UC7mMBJHBQYjIzMwJhnZrh16wYoz3+BxupVaF4GxfYjaLL+BE3Wvyjp/8AAQACx4Cit"
    b"QQWXKzRZa/Hy8rHLycmDkzWoEPPwcGcIDPSDa/jz5x8w5kG12j+G169fgQMRVHCB2Dt37mLw"
    b"8goCxjQT0GJmYIy+AMr9Z7h37z48Wf8FhRrEg9ehHgZ5/D4Qv0RK1j+JTdakAIAAwhYAy4FJ"
    b"1EtXV5fB0dGRQUNDExgrdxm4uDjBBdGnTx+BBdl+cEtMUFAYnD9BBRcouWtrGzBcu7YMmr//"
    b"gUvl3bu3MfDzizBcv36Z4eTJ4wyXLp1nePkSVDOB8+wtpGQNatM/g5bWsGT9l9aNEYAAwpYF"
    b"tgI95wUsbOBira1twEC4BW6UgOpkUP52c/Ni8PMLBZfMoFIbVDWBGiz19aXgKunLly/gGAbV"
    b"zz9+/GCAlsh3kTwM6qU9BuK3QPwZmqx/02sIAAYAAghbClh98+ZNrwcPHoGTNSh5a2vrAQul"
    b"U8A6mRWctH/9+sWwd+9uYCqwBXY2BIAx+gwYw1cZzp49BVYHKriAlvyEJmvk6glUXb2CBsZX"
    b"9OppIABAAGFLAXJA6uzs2QtEAgJCgDH4CVxQ9fS0AD32BKQCHKOggktVVRPcKrt48Sywbn/9"
    b"H5qEbyJVT3ehYh+gyfoHuKAYBINAMAAQQNhSACjWLu3du9fJ2zsYXHixsnICCz8ZcN4HBQYo"
    b"2QMD4deVK1deQvMucqvrCVKyHvQDDAABhKsdcPDUqeNOixfPBxZcxxguXDgDLLXvovvnI7SU"
    b"/gvtaSlA8/BPpMKLEQkPNGAC4gNAPAtZECCAcLUD3IHt9h1OTo7Ago8ZWJh9ZmBn5wCymcCB"
    b"ACoLhIT4gKkDoRdUx79//xFct8OSGTs7G7Cm4CVT3W+gus/wdglMnYAAL0oS/vXrN9B9n1DM"
    b"4+BgA9Y8CHUgd9+7d4/hzJkzoGxoBhS/DtMPEEC4UsAPUGtu+fIVDCIiIgwHDhwDWvIR3FD5"
    b"//8fOAA8PZ0xNO3ffxRcZoDUgapBUHXo6emEoW7fviPgsoOQur17DwOz2xe4OnZ2dmAbxBFD"
    b"3Z49h8G1DkwdBwc7sG+Bqm758uUMUVFRf6ApFR4AAAH4LpcUAGEYCka0tCntfRSph+9n1+u4"
    b"cWUSRA2CXQ/9PprJ9BMXmnSXC0A0kHOXDfBgy/PeUGOy3a/GJRJxglK6pIWTwlwIBlJKinNu"
    b"hFo1F6OlvmH9cK291z2o6jiyz0Vx1g7C8cEfDslWZ+GYYRO9PmDlFqcAfJgxDoAgDEWJkpjo"
    b"IYCVoFfXVU6krAw6YGL/VyeNzG9p04b3+5sFEE1hbdY6npxSWtjlUg4RnKhCGKTolm6gda2M"
    b"cUx4Ka3CVeRijPxG4f/I8OBw5YFLvLmexV6cJpfzKNx2c0W4WXkfODUPh2id8yTmub84CFrX"
    b"NVyVr3cKICa841TMbODQExcXAXvi2bNnQEvegKvAq1evAkP9GDAlsAGzBDswD7IA+/ZiQEt1"
    b"wV1ZmDpgTQHs6BwHqmOHq5OSEgf263VQ1F2+fInh+PETSOqYGaSlJYAtUW0kdR+ALcmLwN7k"
    b"SRR1MjKSwP6IJoq6ixcvAAvwU2DPQ/yCPa4BAtBd9ioMwzAQFpR46e7330teJM5acDHGwVkS"
    b"F5O9U3WXIX/Eo30gI45PujsHPAChtn2JtZYXCCnO9WwIoI73aZolxshYC96ADeOYL7pSioQQ"
    b"DrqcB0RbQnaF3k8//9U6HzoKOmMaSSlJ1zk6b9NV8d4zeK06wym112FZq3XR1fytzXoybepp"
    b"zhPpL4Bw1QKggY3dQCwJ1cAZFRXDICoqCk5esBoO5ACQB2EdSEhfnhk8ioOoMrGrAyVdUPKk"
    b"tTqQf65fvwYsyPeDJM4BcTHQzwdh/gUIIHzdYVHoGJ4VMAQbzpy5AB6mAhVYQwmACs1ly1Yy"
    b"REdHgPoaWUB8GOjnezB5gADCVwi+hqYCcAiBQvPPn9/gpDWUwJ8/HMjths/QcQY4AAggYkaE"
    b"/oMSBSg/gkpwSN4eOgCYM8DuxlXoAwQQEzEdJoZhDAACiIlhhAOAABrxAQAQQCM+AAACaMQH"
    b"AEAAkTAv8B+Mh+YqEtxuBgggkiZGgD1N8Lw74xCqFyCrYHDLAwQQC/EGDc11RBDn4nYzQACx"
    b"kGbYP4bhtqwOIIBITAEM4AGGoZQFQNkWX5wBBBALqXlpKGYBfE4GCCASs8B/cDYYKq1jRP7H"
    b"HQIAAURiCoBMZ8NGYId67IMAQACR1A6AlQNDYL4DJdLwBQJAALGQEpKgAnAoFYIQN+NPBQAB"
    b"NKxbgsSUAQABREZDaGgVghD34g4AgABiITU5gfBQygKECkKAACKjFhhKZcB/cIThAwABRHIZ"
    b"MFRqAFQ34wYAAcRCepIaSoUgYbcCBBDJWWCoBQAhNwMEEMkpYCgWgvgAQACxEJuXYM1gSFOY"
    b"cUhlAejEKBO2+hsggIgKAJCHQROMIiJCQJpryKQAkLv5+NgZzp49A+KCpsa+QgMCXjcABBAx"
    b"AcAEmg6bN28OA2iJLMjQoVAOgNwJmqi9cOE8w6xZ00FCoGm+Z+jVAkAAEbNWWAKIlwGxLhCz"
    b"Q5PRUCkJQW4FrS0GzQYvZoDMDr9E9jNAABG7XwCUUswZIMvjmYdYYwC05Ba0mu0FFKOkYIAA"
    b"GvFbZwECaMQHAEAAjfgAAAgwAE0uRsG/iwn9AAAAAElFTkSuQmCC")
index.append('aktion')
catalog['aktion'] = aktion

#----------------------------------------------------------------------
amarok = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABj6SURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACKARHwAAATTiAwAggFhgDEZGxoF3jeEUToZ/f6OArvFjYPrPzvD7yzaGO5NX"
    b"MPx48Q4o+4cWVgIEECOsFhjwANDvUWf4yzqfgZXZkpmZkeHvL6C7WNgYGL7evMhwZ1ouw9/v"
    b"54CqvgExVastgAAaHAGg16XD8J9lk6oMi6KTFhODqCAHw7WnTAybT31j+P2fk4Hh3cEbDA8W"
    b"JwP9fhGo+is1rQYIoIEvA3RaZBj+/F+nJvFLMcrsB4OG1H8GOREmhih7HoYMbyEGpr9A/wrb"
    b"ajDwaZQBVcsDMRs1rQcIoIENAN02TobfDIslRNhU3bV/MzAx/GP4+ZuB4Rcwt3/98Y/Bw4SP"
    b"wd2Mj4Hhx3cGBklfVwZGJkegLiFQgsVqnrExM6lOAAiggQ2AH9+niYrxOcQ7CTFwsvxi+PMP"
    b"4a9/wJz5B0hEOIox8PICORyyXAxc8oF4U8H//yoMpjoxDFzsPMgFPD4AEEADFwBqVTUcnOwJ"
    b"NUmmDBx/ngFj/h+Gkl+//zPIS3AyOBoKQpKFoIkeUFgTiPmxmvny+UNgIOgz6MtvZpARAKnl"
    b"wplaoAAggAYmANTKoxj+/m9sK/ZgUBf/y/DwyXMGJiZmBlCBjN41+QcMF1dTUQYmVmAA8GoK"
    b"MzCymgGFRYAYM7k/ff6T4dqdXqCfRRmUhNcySPPYAUV58QUCQADRPwDUSqwYfv2dXphqz5QS"
    b"YMRw/ORpcL3GzMzMwMnJxgCqApE7aL9+/2XQVuRjUJTiAEUoEwOHuC4DF4cmg5GWP1CAHS0g"
    b"/jN8+/me4cW7UgZmJjkGNcHpDELsoADjwRUIAAFE3wBQK1Bk+PFrqZONNl9bvivD4yfPGO7f"
    b"v8/Aw83BICnJyyArK8wgLy/OwM7OCgyEf/CygJ+blcFMSxDSFOKQkWP49oOL4f8/WwZLtUUM"
    b"gpwK0ICAgZ8M918fYfj6czEDG7MCgw5/J1BMFaQTm5MAAoh+AaBWyMvw+/cyQV4xhYJwVwYO"
    b"DiaG69dvMvz48Y1BQICdgYWFCZz8ubjYGaSkgEmeiQmeJUDpwVANGAAswBDglgcyGOQYLt1a"
    b"Bkwuugw6YssZeFm1ofkdBr4wvPjYC8xm7xn4WY0YjPgKgWIy2ApGgACiTwCo5DIy/P4xi5Od"
    b"3yLZ15PBzlqS4evXfwx3794DxjbQVSyM8Lz/9+8/Bh4eDmCg8MKzAigbaCkKArMIMBVzSAM9"
    b"yqTA8BdYZbx4W8vAwWLKYCgyGWQLUiz/Z3j08RbD99+rwDxp9iAGMVasVShAANEnAP78bGFh"
    b"Zo8Is3NniIswYODhY2L49Ok7w+PHD4ApgRmj4APxBQV5weUCyC/AMAG2DjkZ5MU5QTUgMwML"
    b"lww4xu+8OsLw7fcGBl4WKwZTAVBDSRYpln8xvP8xG5iHvjGwMnIxaHAkAcWU0LMCQADRPgAU"
    b"koEWM1Z5mTozRPhbMggKQ5L6mzfvGD5+fM3AzIytOv8PDBh2cKEIyQb/geUeC4OqHLBR9Beo"
    b"gJVfHFoV/mZ497UX6MmfDFJsIQzSbJ7QGoIRHHLX3l1l+PnvMNhQcWZDBkkWByBLGDkVAAQQ"
    b"bQNAPt4JmKYn2+rYMMQFOjNw8bBCLAXa+uzZU4bv3z8zYOuCgDwMKgO4ubkQAcLGwqAgCSzM"
    b"QY0lFj4+aACwMFx/e47hx989DEyM7MBYToYWeJzwAvHnn9VgFjMjG4MKix+0IQVPBQABRLsA"
    b"kItRY/jze5GesjFXQoAvA58AJ8Pnz6BC7j+4bn/+/BmwAPwCDABmHI26/8AUwAEtDIERD6wO"
    b"5IA1BbgNyMLLDQ0AUOn/neHHn4UM/xn/Mwiz6DDIs7oDxcTgqeD1z53AwvAtUB6UCnQYOBm1"
    b"gOICMHsAAog2ASAbJgTM98sVpTSlE/3DGMQl+Bk+fIDkbU5g3Pz8CQqAp/CqDlcAgKpDFhZm"
    b"eOEoJcrDwMwKNISZix3qCUj1d+/zXmCH6iHQy0wMSixeoIwHTwU3Pr8AdilPg9mcjLwMSswO"
    b"0AAClxUAAUT9AJCNYGH482euqJCcUbxPDIO8nBg45n/8ADV2/gJj9D+Q/Zvh5ctnDIR64KDY"
    b"Z2NjhRaE/xkkhHkY2EDOZuYGpQNBaFJmYnj54yOwcbUPXF+KMakz8DHqIZX4f4CBcxhuqARY"
    b"ThoWQAABRP0A+POti4dbKCDGI45BU12B4es3oBCw+n758jOw0HvJwMrKCAyAHwyvXr2AlvJ4"
    b"BiuAIQQKAFCW+QckBPg4GHiA7QdgALAAJXmhAQAy5C/D7797wZrYgCW+ArMdciwD5Y6D2lTg"
    b"8BBmkmVgBbYjGBhA5QgDQABRNwAkfbJYWTgLQ53jGYz19Bi+/4B4/uPHHww3btwF538mJkaG"
    b"L1++AsXegWOYEGBlZQGnFFD2YQU2loT4gZH/HyjIwMgNzQKQdPTlzzGgFz+DuWKMoA6TFLxx"
    b"9ObXFUg5ABbhhcqDyhAmgACiXgBIeHoCs2Cfj00Ug62pDbjz9hdYZX379ovh5s27wID4Cazb"
    b"IVn23bsPwFTwFegxJnAs4x6N+g8sA1ggBSEoOoHlAT8PGzTiGDmg3WJIMrr17RnQk3fBbCFG"
    b"SWDcy0I7QsDk9/s9MI3cg5Z6TMAAUINWh6wAAUSdABB312H4+2eho0kAu7udDyitgT3/8+cf"
    b"htu37wFbfV+BBRoLsF/PAhb/8OE9w69fv4Et47/AgPgJGZ1lYcFSEEI6SeDwAXJYmZkY+ID9"
    b"AnCJzsgCysOs8FT88e9vYHvgOjikuIHJW4hRBd4TfPX7D7DvcB9uMD+DBLSM4AQIIMoDQMxJ"
    b"iuHPjxVGWi6iAS6RDKxskGrrz5+/DHfu3AUWgJ/AMQjq5XFxsYDzMygL/PvHBmwMfWU4d+4q"
    b"w549B4G1wktogYc2bM3CCPYDpMcIbBsAG0QM//4Ckw0zOzQAGOHJ5T/DbWgsMwObQ0rQmoIV"
    b"2qt6ADeUB1yAgmsRgABiIdnDInbsDP//ygN9YAJ0iAnDz2/uqqr2WpE+GQw8vBxgDzICq+RH"
    b"jx5BY54dWv0xgzGoTADFvqCgGBALA9l/Ga5du8CwfPkqhrS0RAY9PT2M7gqo3ACZAaLZgS1h"
    b"oP2wIX0WlO7w339P4GxeBlGkqvIXMHCew+U4GLihhSA7QAARDgBBEyGg7XrAtGsMdIIJMCgN"
    b"2Nl5FIUEpNnFBGUZpMTkGTwcfRj4wY0zUIz9Z3jw4DnQ89+BLTlucP4GBQrI86B2/x9w2QCq"
    b"4zkZ+PgEGKytLRl8fDwY2tsbGVasWM2gpqYGVMsJj1RQ8of1CUApiQMUAP+AAcDIBPM8cgHy"
    b"HDpszgj0Ij80C7BBjXoDV8UOLj9ABSQrQAChBoCAARPQtWoM//6YAZOMMQMruyELK4eWAK+E"
    b"oJiwApO4iAKDhKgisD6WY+DjFQR6kI9BWoqbQUSUCZicgTYBrXr48B0w2X8HJndOeCkPCgAu"
    b"LmZwExjE/vnzB7hhY2ZmyODubs0gLMwHDLhfDElJiQxnz55j8PLyhJcBkOoQwmYCVYusTJAA"
    b"gOR9ZpSa7B+4pP8LThlsDHBPQgPzPTxwWMGBApJnBQggRADw6wLrzf+r+PjEzcVFFDnEgR6V"
    b"FFVhkBRTYhAUEGfg4eIDeoKLgQXoADZgXc7KBoptYI4Adj1+/waWO9zANPb8E7CA+waOQVBy"
    b"hdXloIIPlP/BTdq/kFYdBweoyysE7BO8BvYJfjK4urowqKurM5w4cQIYKG7A6o+VAWPWChwQ"
    b"/yBVOrgkxBjl+cTAAA0AFrAn2eFtAWDzAx4AzOBAA9cgAAGECIBf38LNTMPtfV0LwD0xLk5e"
    b"cAEESn1gzALxMCgWQc3Uv0Cf/Pz5F1jNsTA8efIVGOu/wfkZ5DGYg2E0SD8rKzPY8//+gfT9"
    b"Aifrd+8+AWsGSI0gLS3BYG5uzrBp0zqgmV+RsgF61fAPVgYwYAQAwpOQghDiSWgyBLYRIKmD"
    b"CWlakBEggFiQNFspyeszSEmIgpWAPApyPwT/Bzv8+/d/4Krt+/c/0MIO5DEmoOf/Aj3HCI41"
    b"dM9DkjIjuASHdW0h2QLYT3n9BpgK+MBsHh5eBgkJKWAD6SPQ/B8o5iCbBXILMIvCkgLqSAIL"
    b"4z8G1NEFJnggMWGdUmMECECGFe0ACIJA1HqLpo/9/yf25JoWB25hPTs2OY7jYHHG++CtKLUR"
    b"gmrWeqlggbJ6mhonqij6Y1WNImpJmLGSH+Pzh00EMQZ7f9FGiwAA5l1aKOvqm3NRc3TK8uBd"
    b"ooFgoIEtFPqgwiepqJS3wEZtektikcP9896PAEI4+/9fJhZQPcsNCYCvX/8AA+Af2KGgIWuQ"
    b"IGqDjRE8jvf7NyNGIwZbAICUgNrzIE+AAhIkDvLM8+evwV1iMTFhcPcXpPU3qFBB6hWC9IGy"
    b"DEgvKPsA/Q40BJQMwJ78h9Rw5AP3CBkgXSCo/H+oQYg5gr9wPf8BAgjh8n9/vjMCQxZcmwGV"
    b"vX3LBI5hSBZghDsa4TEGcGyBqjXkTg1utYzgbAQJODawpyDd3L9AM/6APffhw0cwn4eHhwFz"
    b"7RJQ/39YAPwGRdgvFA9CLBKA++knw0/wiBEsgJgY+aEFJ6hV8Bs63f4fIIBYkMbtHnz/8QnY"
    b"OAGqBfrn0SMmcDkAK83RYxjZk7h6dTB1IL+A/AsqBEHdYVDAQcT/gWlQjIOaxU+ePAGnAl5e"
    b"XgZsi7f+AbPit2/fgc7+9R8aAH9QUgAjsA8Ai+Wv4Fnkn/B1Bf8ZheFh9ev/T3AwAJ0EEECI"
    b"jPbn+4NPn14zCAJbyNLA3jI7OxNKZwWEQfkSmQ0pFxgw1KCrg+RnJmCShzSCmJkh4/6w2AeN"
    b"D3z48Inh4sULDIqKiuAGFCiFwBIRKHWA4uE3UP2nL19AKeAv1HO/UQKAgVEOqUL8CF1P8Bta"
    b"PkjB5b6Bxb+D5AACCBEA//88fPP2CbCpycAgKgqqtxnBpTey5zBLd0jtgK4G23oDUECBRoL+"
    b"/PkHLjTBgxx/f4Pxb2Bf5eHDxwyXLp1jsLS0BDao2KApgBEayJAq5w/Q3x8/gQLgO6ga+AaN"
    b"RaQUwKAMzeN/GF4zvAKyPkPVgPTLI80afIYFDkAAMSHVAjcfPbr+5+17SPMTXBji6KKC+x3g"
    b"tsAfcDcXnzqEWlAVCinQWFkhY5J//vwGY5D8/v07wENg1tZWQHU/UcwB6QUF6G9gann/Hhix"
    b"/3/8hnoAEQBhIsAYYNAEZ4BvQA9+/A8KgPfglBImDIodRbiR7xneQRtNPwECCKmu+Xf32fPr"
    b"rx49/ADpMPH8B+dLUAyDPArBv8FJFuRoSOz9Ag9sgtiQEh6k/g8Yg5I3TB+ID4rlHz/+Q8f6"
    b"uIDZgAUsB8pmd+5cYTh6dAdDSEgwg5CQMFgvYnL0H7y8+QLM/5+BPUmGf6CSEJzEf8AD4BeD"
    b"GDCfaIAD/Q2wSfwX3Pb/AM4C/4E9AybwGABI9T+Gl/9fQPX/BAggRCH499unn19fXDtz9oKU"
    b"j48jAz//X7AHf/36jxHzkPLpP9hjX79+gHqIDWmQE9HggdD/wbXF16//gR4ElQmswJh8Aw6E"
    b"Bw/uMNy4cZ7BycmBwdbWFhz7sGYwKCWCsgxkXICJ4eWr95DU8Q801gSOwR/QmgA0XG4OjH1I"
    b"j+zpv2dAEpYFgJYzajKw/RcBp44vwMLx3X9Qp+ktqBwACCDkChwYNp9OnTh5wOXbN0dgvQzK"
    b"f9/AyRbV8wg2KMZBAcDBwQssvbnhVRtCDQM8UH79ArZFP4N6g+xA9TzAztMzoN6PQH3sDB4e"
    b"zgwmJibgmEct/RnBqQQkxgKsaV68fMPw5wcwBfz/+Q3qOUQKYGB0hlR//78yPAQPfjyDqgEG"
    b"EaM1pIEENPvVP6Ah4MABZYNfAAGE3oLZc/bczorLlwuZzM0FgDHxDdhe/wVu9UE89x/eMIH1"
    b"K75//8Tw6dMroBpJqGNhKeAfSmD9+QOq51mBAQHspbBxMsjIyALNEWCQlZVnEBcXg7YFMIfJ"
    b"QVkHHAAszAxPngHd/Q2UBX5/QQqA/wwBUqCRUzdwDD//94jhx3/QuMBTaDkBcqYdYg3Bv8fQ"
    b"bjMoe/wHCCC08YB/Z968vHhr7dqdGubm4QxycowM9+69ByZxRjQPQVp0kFbbT2D7/RWwzBAE"
    b"F4iQZvN/cMQgpxjQCNGbN2zAFMUFzAJswGavODBwP4M9DfIkroIUJgfS/+gpMOv+/QE0+M8H"
    b"cGKGVIVARzDaAbu4GiBrGG78ugkUeQDNAn8YvCWEGJj+WUOqv/+fGR7/uwMNHHDqAAggFrSe"
    b"FjB4f65evmJKrY+PJTCWOIEF1zsg/gsNgH+Qwg5U+oMLPlA9/gucdP/9A/XVORjYOdjh6mCB"
    b"AAosiEcZgcke2N9gBbX7JYABchPvWAys6csGLBO+AbP9vfvAyGMEFgL//72HlgG/oPk/CRz7"
    b"r37fYnj1FzT4eQdaA4Ci3wkoJ8YA6kQ9/vsU2Ah6BA0AUDuAASCA0EeEgPUN07wnj09GR8eE"
    b"KokIizN8+fIN2AD5DS3NISX7P6RW3L//4AD5z87Ox6isaM8gJ6sHLED5wY0fkHpYloEEyl+G"
    b"ly/FgMmeFxgA0tA+Bm4Ain1QKxHUPQe54+6Dx6Aq8Ds0dj+BY9hdUZmB8U8g0PBvDBe+nweK"
    b"gcYF78M8CGwBhkPKgf+/GG79ug6VewVrIQIEEJah2L/AwuNfzpPHpxqePAa3nhihBQ2sc/EH"
    b"CwbFBP/bd7c1nr+0YFeStwA2qSWgkxogz0NS0I8fv4DNXREGKSkpcACwsnLinB4DBSBoxBiU"
    b"pUBzA7fv3WN49xZUcP8AefwFNACA9TJjObBnz8lw78c2hg9/QLF/GYhfg/OPu5wCA9NfD0je"
    b"B8p9ACf/O9D8DwYAAYRtTBDU2zgCpHOA2Bw6gfAP2qT8jRQQsLY4TIzh7893hg/u7Y56+/a2"
    b"vLycBYOYsCKwe80Ob/eDqrBbt1gZdHW1gO19CWDM8uMMAJCeb99+QCdEWBmuXLvN8O8L0N3/"
    b"foFK7zfgAHDQMGRg/J3K8PH3EYbLny5APX8HKfaTgdHHw/AbWDNc/n4JKALKc4/gZQcQAAQQ"
    b"rkFRUAFzFZpXYG1CWNcThtH5IHAK2E4/9PnDnexrX1+6vhHVZJcU1wamBG54Frh9+zMw79sB"
    b"xfiBgSADFHuMtRMFKvRAA6ugUeVfv38xXLxyDVQAAgP9zytwDAvyAqsHhjkMP/+cYDj5age0"
    b"2jsPrd//MzgqigCpVLCBd76dZfj8F5Q1rkADD17XAgQQC552LKzDwAifasa+UBlZ7D2kfv3/"
    b"+N/vTydfPD+b/OnzUwVxUU0GXh5xYFXGAfTUL2DL7w6Dvr4NsOutAKwJHmFJ/ozANsNXYJX5"
    b"BzwO+ebtB4YLl4ABwPQTWG0wPAEq+MigppjP8OP7dYazj3cy/AH3s0Gefwzv/TEwFwPLBnGG"
    b"978uMVz/CkodF6D5H6XtDhBAhCZG/qPF9n8sGLUQhVQvoNCeB6yuMr59frrlwaOjP588PQNs"
    b"LzwBeuoLw82bN8DZgZcXNL3AARnmQop9UL4HjReCjGcH9s7OX7zC8Ob5M1AD6A24ihMUBCaP"
    b"H6cYTt6eAPQ8qE4/A036EM/ZqWsBDSpj+PX3DsPpdweBIsDQY7gIbfyguBkggEifGCEO/IIW"
    b"VMDA+P/k/59vJ9+9u5385etrBX4+KYbLl78wGBpaAQNADuhOYfDQGyjWId1nRmAWgYwL8vHy"
    b"gKvCg0eOAUuaz6Dk/xScLd++vQXE36Dl0yNosod43loHWPL+XQzMQ7cZzr/cyPATVKgDsyZK"
    b"6kAAgACi5RIZtNTwN+PXj3ebX7+99eP+g2MMBw+uApbuPMBAUAf2C74BPfwb3J549eoDw+vX"
    b"H8AdAVCf4OHDRwzHjwPdz/jnPTQJP4XWAJ+g7Jdwz5sasjL8YWoCNlLeAbPGZIbPv0C1wglo"
    b"6viBzZEAAcTCQHuAkhqAVcWx339/ph48tFBJRsaAQUnJApgCbjO8ePERWOpD5gtAQ2JMoPkL"
    b"YDW6dccuhq/vXwCz4G9QDN6CFnaIgQ5k8BfY5f39+ybDhVvboJOfj6Ce/4LLcQABRO8NE6Bu"
    b"HmjODrROJ5uZhcPD3DyJQ1/PBJgSnoAHQnh4uMFYRFiI4fnL5ww1dQ0MXz+9Acby3z1APWuB"
    b"+Ah6SY6YqBVjByYhPujUN6zB9IMBzy4TgAAaiB0jjNC1u6D5e9CqrVRRMQ0lTw83Bg0NFXCn"
    b"R0hIEFww9vb3MVy7cg40CAgq5LYA8Q5oXf4Tj9mwNQO/GIjYZwQQQAO5ZYYVuqYPtMy1ipeX"
    b"39HTK5BBV0cPWB58Zdi4eR3D1cvnQR4FNV8PAfFWID6LrSSnBAAEEMpszQAARugMri64oAQW"
    b"aJycXL+YmFl/QJMvaG3PNCAOgq7vY6W2AwACaLDsGmOHrtwCdVstoAXYZ2i39iK0Hn8OTfpU"
    b"jS2AABo82+Ygk5WgBQ3iSAsZP0JTwkdonqZ6UgUIoMEUALAswQybuUXqff6jlYUAAcQ40rfP"
    b"AwQYAE5pjFBtR4nAAAAAAElFTkSuQmCC")
index.append('amarok')
catalog['amarok'] = amarok

#----------------------------------------------------------------------
amor = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABPmSURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACKARHwAAATTiAwAggEZ8AAAE0IgPAIAAGvEBABBALMgcRkZGujsgzcSE88e/"
    b"f5Z//v0z/8fAYMTw7584EP8Etk/u/fv799Ln798P7nj48DZQ6S8gpmqjBdQGAgggRuSGED0D"
    b"IMnISPwXI2Mmy+/fcSKfPyvKs7AwiLGxMXBxcTH8Acp/+f6d4dnPnwyP//z58Y6N7ejbr18n"
    b"7nzyZD9Q6hsQ/6NWAAAE0IAEQLyxcRQwlrs1X7+WchQVZdB2cWHgtrJiYFBUZGAABgTD798M"
    b"DJ8+Mfy/cYPh+bFjDMfOnmU4+uvXn0e/fi3e9vhxw4+/f19AUwTFAQAQQHQPgDhT0w6BL1/K"
    b"Q96/Z7COj2dgSktjYJCQYGAAxjjDly8MDD9+AL0G9NvfvyAHQfDWrQwPZ8xgWAwMnIt//+5Z"
    b"8/BhFtCoR0D8k9IAAAggugYAyPNSHz6UZwA9KN/Xx8Dg7c3A8OEDA8PXrxBPgzAw2YNpkFuA"
    b"gfJ21SqG35s3M0gAU8VbVlaGmcAscvzbt7Vbnj+vBBr5AIh/UxIAAAHEQq88H29klCT47Vt5"
    b"JtDDcvPmMTA4OTEwvHgBiXFQkkf2PMhxnz8zvOrpYXh/8CC4TPjNwcEgKyjIEAGUf8PB4afD"
    b"y3v6yufPi4FSzykpHAECiGYBkGhoKP6HkdHo7///sv8YGdX/Awu88IcPGeQqgRFna8vA8OwZ"
    b"wsPIsQ/yDTD/vwWmkC9HjzKAHAhKl++BAcX+7RuDEjAQLP79Y73HyRkODIDjQKmPQPyVXHcC"
    b"BBBVAyDN2JgZ6AU/YIwlsf36ZSv19Su/GDAZs/37xyAO9JSZjg4DQ3g4A8PLl8Cy/Bsi5mGe"
    b"B6oDlQPvOzoYvp0/D/b8X2j0gthvgXJifHwMJsCscJiVVZ2fhUX/458/9ygJAIAAoloAJBsb"
    b"639nZJwo/v69vSXQoUYCAgzSGhoMrEJCkALt7VsGhuBgUMYDl/AoMQ8LCCYmhq/LlzP8QPL8"
    b"P2hrjRlU7APN+QAMKDlgOSD1+zenNCurITAADgGlQLXCH6AbWH/+/Sv789cvuX9A8OP378en"
    b"nj178vr79z+4sglAAFElABKMjKL///o1zf3tWz5fExMGvshIBgYzMwYGTk6IAlDswvDr16ie"
    b"hsU+MzPDH2B19wNY4jNDXQvz/H9oNgABoKcYBIBqhYFCvExM0kAhYXtlZTFZdvZYwc+fo1X4"
    b"+NSEpaRYgdmO4dWLFz8VGBguPvrzZ+7mhw/XANV+hoYrHAAEEMUBAKzTEzi+fp0dy8zMYtXe"
    b"zsAQGAiRAMUyqHSHVWt//iA8C/I8jIbJAbPKD2CJDxJjgrqSEcnjMPAPlIKAKYUDFDBMTOwW"
    b"srJuZn//LvGWkpI0AwY8JyjggQ0qcLX6/j3np6NHLXatXm3B8/+/35Znzwo///nzBLn6BAgg"
    b"igIg0cjIluX796mJ/PwsZhMnMjDo6zMwvHkDsRwWyzCPIsc4egoAxtafAwcY/t6+jRLj2Cpl"
    b"ZlBDCZgCPv/9+19SUFDFk4XFIsbXl527sJCBgZ8fktVA7QlgoP4D2gFqTAUDaxtgK9P3p5gY"
    b"47pnz4qh1Se4ugEIILIDIM3IiO/Hnz8T/FhYuMy6uhgYgPmd4elThKeRPQvzMMzTyAEDzNf/"
    b"371j+LV7NwOhVghIngOYrb4BA+zFv3+Mzj9+SKdkZDAwFxeDYpuBAVjLgAMf5HlgQfuyqYnh"
    b"/aVLDK+BKcZaTIzhLgeHxy1e3lPA2mM+0KhnoAQFEEBk9wZ//f/frfjli5F7QgIDg7Y2pE4H"
    b"JXkQBpXwMBrkIBCNjEFyMHFggPwF1vX/QDEHa6Cg0TA2CzDm+YGF612gHs6PHxlCVFUZmKOj"
    b"IVXqq1fACvEjJOsBA/RDby/DT6Dn2UHpHVi7vAfaZcPExKLExuYFFFIChSXIXIAAIisFpOnp"
    b"yf/++TPcTl6egdPdHVKwQT2DtYCDxT56CgDm5//AmPp94gTck/+RCkB0mg+UxIE1wMX79xl0"
    b"gPZKZmVBAhLkaVBZA2IDzfyxdi3Dr+PHwTUJrAr9AJSXBKYEKWZmOSBXHohvgDpWAAFEVgAA"
    b"GzduQt+/8+tbWEAKHGCIYzRoYB5GDwAQH1YgguouYGPnLzBFoHsYW2AIAZPxO6AZT4GedATF"
    b"vLg4JOWBzAQFADA7/bt3j+Hn+vXgsgSGQVnnL1AOVH5wMYATBbASYQBXUQABRFYA/Pr3z1gf"
    b"ZIqCAqK0Ry/ZsfGRAwHoiX/ApPvr4kWwB/8h1fvogQES5+DmZuAEtgKPPHnCIKqlxSAN7EUy"
    b"ANlgu2FVLDBgf2/axPAfWAgyomUfVmDj6ScwC338/RsU8qzQpgUDQACRFQBM//5JSoOqI2D7"
    b"HBwAyK069OoNOVuA+DB5YL78dfIkwx+g3H8kz//FEhggtgAw9v8Ak/A1YB/B3toaVs1BaGgr"
    b"8t+1awx/zpxB7fBAzeDn5WV4BnQzsEv9DtScgLUHAAKIrABg/PePhRUUAMgFHHIsg1p+oMIN"
    b"GDu/gEnzH5DNBBRjBWIWUHMXiP/cvcvw4+ZNuCf/oXkYFgCgJhwzMPaEgMn9CrAj9R+YCjTU"
    b"1CCFHqi6g1W5QPx7/36Gf6BaBcnjsMYUl4gIw4UvX/7e/PnzPqhVDR1YYQAIILICANjK/PoV"
    b"5ElQ6QtKirAUAIpVoKMuA5PmhcePGV48f87wDejo30DHsQFjjwtYhYkCPaAPLMyUgc1dUCD+"
    b"xuP5v9C+rhDQ8aDC7/ydOwxaNjaQ4htU7oA8Dy34/l6/zvAbGKB/sQQgN7D/8AVo98GnT98C"
    b"W4V3gEJPYP0HgAAiNwXcvgK01AWY5FhAsQFt7R0Dxuo2oMdABZEW0EIXYNtAzNiYgY2Hh+Ev"
    b"MIDeA0v8e0BH7nrwgOEXsEByAAaEHrDqgjn0H5ZsAALCkpIMr4AefQXMQu6gKhdUZQKzAthe"
    b"aAH449gxcMsGZhYMg7OPhATDOWAknf327QF0IAXYYGH4DjIbIIDICoDvP38eeMzOXn7r0iVm"
    b"LQMDhq/s7AzzgVXZ/VOnGPyAtYJlSgoDm78/ZKQH1HIDJXugI+WAjtYHOj4AGEin1qxh2AhM"
    b"IY+A6l2A1Si2QADFPhcwkDiAKeAgMOAk5eQYxICBCY99UAAAAwXUefoGNOsfWgCA9DMD3cYI"
    b"7JAdvnXr6/W/f0FV3z1oFgA3MwACiKwAWPXkydEkefmzJ37+NJPbuZNhEjCJsQEDoB7UEQJ2"
    b"ZRk0NSGNEtgQF1LBB6o2fwHztDmQrQwsQGcCPbgHyHYEBgx6AQjyhJC0NKjRxXAb6GlnUDsf"
    b"FPMgs2GeB2aL98CCD7nG+AvVC2rwSwJTz2Ng6jz++fPTb///34c2g7/A/AIQQOQ2hX/c/fy5"
    b"ko+be+X19+9FFIH5L8POjoFpxgxIjIOaxLDmMIwGlRlA/HbOHIZXK1YwcACbs4rCwgwpQI9M"
    b"BQaCFDCJKgBj9Q+SJ1iAsQfs2TFcAhZ4zMAyQAVYE4BjH1rt/gEG2ptz5xh+g8b20MoQcP8X"
    b"aAc3MBXuevz4z/k/f25CY/8lVBoMAAKI3Kbwv4Pv3p0EZoMd/4EOiQZWMUwtLZBxPFD+hCVP"
    b"WCEFHen5tHIlwztgf58J6OAvwFh/CvQ0sCnDYAHkXwCmot9IHgCxeYABBOpSXwc2dkCeZwVV"
    b"o6BqF2jmf2AqeHXhAsNXaKD9RsMgG9mBAfsTGIin3r79AKwCQYXffegIEhwABBDRKSDV2JgP"
    b"aKgb0HB7lr9/1Zn//xcEelcpFFjg8QM7HeDaANQThDV0YDEP4gMD5tuWLQwf5s4Ftz4YoS2R"
    b"98CYFALmaStgljgHdOhLIC0IillobIrIyDB8Agbkc6BnDYCBzHD1KiQbAWuUD8BU9gUY2MAu"
    b"McMfULWKVoaACkQ5oP57wFrowo8fj6EF33NoGwAOAAKIYACkGRvz/GBkzPn782e2yvv3MlpA"
    b"B0oDW1TA/jUDK9ADyqBeoKcnZn8AFgBAtT+A5cSHSZPgIzsMSAMdb4DlhCzQc7JA9kNgIPAA"
    b"zQcVz7zAFMEPzL8ngV3ke79/f5ny/v1Ph58/hWRYWRl5gdlMABhwUkZGoEYZpO4Hpo5fQPu+"
    b"AVPEZ6C7QG0OLmDyP3bmzI+LDAzXoXn/HfrIEEAAsRAY6TH+8ffvXK03b/S9gMlJy9eXgdnQ"
    b"kIEBWDCB8zqoMAI6FOxRWJMUuU8Aau4Cq8avixczMKG1zJigln8F6QGmEGB9wfAY2EaQAJbY"
    b"74AFnQSwowUa1bkOjOkLf//ePvz27bHtnz+zATs0cvyMjKJCTEz8IszMvDLs7NyS7OwcIpyc"
    b"TMKcnIy8wN6iMLCFKggM1EfAluKRDx+ef4R4/iFy4QcDAAGEMwASTEzcmb9/XxH8/buAZ2Ii"
    b"A3NcHKhIhXgSNtIDKthAeRw0to8e89BS/zuwwPsPdAiugY6//yCzXDygPAsMTDlguwLUXQM1"
    b"s+8A+/d3P378Do3Bk8Bu8PW7kE4MqDPDCzSHF1iYCnCB+klA1wEFRYUZGQVFgGISzMz8//7/"
    b"ZzrJwHABqPY2tP+PMYcAEEAsOGLehPnbt6XxHBwCtsB+NYODA8STsJ4Xtm4vlomNv8B2wR9g"
    b"ex99XI8RDYNTE1D9XWDLchnQDn5giQ/CD4ClP9Dnzz5BSu+rUMwI7cuzAc1k+/7/PzswCjiA"
    b"RS83KFCAqQ4UlrzMf//yARVyA8sFYIeB4RKoR4xtYBQggFiw5HnOH79+TQlkZRW27e9nYADm"
    b"M5QxfGwBgNwBgnV3gSnj19atBEd5WIAFH7CrxvAJqPfaz5/Pt3379lD67VsOYJHHA+pO7Wdg"
    b"OAHtuz9HmiH+gWWwCFS8sMHwXwT7N9Tz37HZDxBAGAHw49+/FM3v3809KyoYGHR1cU9g4EoB"
    b"sNgH9vP/gYaosE1JITVa+ICF2X9gADwGBti9f/8en2Vg2HWageEOVAkopt9DY/4dnhmg/0gN"
    b"wG+k1OcAAYQSAOkGBuy/v35Nc9HXZ2B1dkZMXcE8jW1EF330B1QuAAvH34cOYQxsoGNQtAkC"
    b"6/oXQD33fvz4de/Xr7vQ5HoKWpWzQGP9MzVmg7EBgABCCYDf//6ZSv37p6UDbNWBkzGo2Yme"
    b"vNFHfNCzAygagPn+L7BNgM/zoNjnhA5yHARWobd+/Hj5/t+/h9DS+iWtPIwOAAIIJQD+/Plj"
    b"qczOzsShogJpcoLqdXRP4woA6KAEeIT39GmsAxv/0Ia5BICdnO/A7HLt06f/13//vgv1/CtK"
    b"ZnxJBQABhBIA///+1RABtbiAjRd4dxNbwQfjo092gKIN6Pk/QL3YPP8PqZ0OGp8TFBdnOAdU"
    b"e+Pbtw83f/++Dm2rv6f2Uhh8ACCAWNAmzLmYQfUyKOZBgQCq43FVdViGuP4By4wfly/DJzSR"
    b"e3XoHRVB0CAHsJ1/6fFjhhu/fz/6D4n9R5RMdJIDAAIINQX8+/f2JyjmQbO3wLyJ0rRFTwHI"
    b"g5zQwPgK7Jb+gpYDuEZ4YIt7QL28J8AAvvnp08/LiH76a2qt/yEWAAQQSm8Q2Ka+9gyU7K9c"
    b"gXgWeTIDlBpgEx+wsUBYbw+oFjS+9+3+fXgMI9PI+Be0l8YODOBLwMLvBrDu//Dv311oT+0z"
    b"vVepAQQQSgr48OPHgfusrJ9eHD/OJwFasATq3sLG+9ALPqQB0L/AVuJHYNf0N1p7H9sQ119o"
    b"7H8FZpkbb978v/rvH6yb+oKehR8MAAQQSgrY9vz5XWARvOswKAvs3o1YuwOLdeRRYFh/AEi/"
    b"O3eO4TuQ/otlPO4PliEqQWCf4jqwmrzx/fu72//+3YAGAF0LPxgACCD0luCvp1+/9h3l5nZS"
    b"v3ZNSA8U66DuLqi5it4YAjV4gPSbS5cYPgILP0Yk1/9DSwV/kfroEqBxQmDhd/X5cwZg7MN6"
    b"aY9wNVVpDQACCD0A/u99+/YiJyNj20p29g7Ge/dYdEHtAVFRhv/A3tlvYEEH7tODprOBqeAV"
    b"MN9/AKYWJiztUuRAgCV9UJYSl5NjeAjMMrc+fPh++d8/WNX3ht6FHwwABBC23uD3LW/eLPwp"
    b"IMD3jZOzxOHDBy5bYFIXAiZd0Nj+f9D8G7CK/AkMAGZgf58P2H//BUwVIAyaf/sLGgPAkgr+"
    b"QJu97ED1V4DlxdU/f559hvTTH2Drp9MLAAQQC46OxfvdHz7MePTjx8MXnJy5Z3/80NFgZ2eR"
    b"BQaCADA78AMDQkBAAJgwRBmYgLHKyARJA6AZoO/AwAJjYAD9ANKgEZrvQAwatRGXl2f4AlRz"
    b"68WLv8A+/i1o7L9AHqSkNwAIIFwDIqAU++rmjx+bgfiGEhuboxILi6MgE5M8HxMTnwAjIxcf"
    b"IyMnDzMzkzAbG6MgGxuDIKhwA+ZtASAGNXKEgGKgwAGN3/0HjdkBPc4KrPpOXr/OcP3nz7cP"
    b"EAHwYSAKPxgACCB8Q2J/oXnzK7CX9hSIQQuVpYFeEmFnZBTkZWQUBgaIuDAjoyg/sFnPC2o6"
    b"MTLyCjEycgswMXHys7ExC3FyMoICBDS4IQDs+LADU8K1R48YLiOS/pOBKvxgACCAiF0qywgd"
    b"XOCBzquzQ/vq3AywkRgI5gFKCIDG7IBlvbTg//8iAgwMQsAA4ucDqgOyeYA+frsUWOMC65Gt"
    b"QPVHoSlgQADI7wABRMlaYdgoDCvSSAw7lOZECxheaOBxQ/U8hPb5Hw1k/gf5HSCAaLVYGmOI"
    b"CgkzQjs87xkoXO1NjQAACCDGkb5zFCCARvyeIYAAGvEBABBAIz4AAAJoxAcAQACN+AAACDAA"
    b"0Rvi9O4K3N8AAAAASUVORK5CYII=")
index.append('amor')
catalog['amor'] = amor

#----------------------------------------------------------------------
applixware = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAApnSURBVHjaYvz//z/DSAYAAcTE"
    b"MMIBQACN+AAACKARHwAAAcQAKgOwYTqBVCB+C8QfgLgHiMWAmJWe/gUIoIEMAA4gvigiIvJf"
    b"VVUVZOE7II6EBgIjvQIAIIAGMgv4A7Geq6srQ3h4OAMjI6MgkB8GxNJAzEIvRwAE0EAGQLqy"
    b"sjKDpaUlg4SEBAMwFYDEzIFYEYh56eUIgAAaqABwBGIHCwsLBiYmiBNMTExAlAQQuwCxKL3c"
    b"BhBAAxUAWeLi4owaGhoM3759A2N1dXUGYWFhUN63BWI5IOaih0MAAmggAkAfiL2NjY0ZODk5"
    b"GX79+gXGXFxcDHp6eiB5UF4AJQchWhaGMAAQQAMRAKl8fHycurq6DD9+/GD4+/cvGIMCASTG"
    b"xsbGDlTjBi0M2WjtGIAAoncAgJJ2OMijvLy8DD9//mT48+cPGIPYwCoRVhiCUokGEPPT2kEA"
    b"AUTvAEhiZ2cXASV1mOdBsQ+if//+DWaDAgcIQFWiK7RQpGmVCBBA9AwAUJ6OBxV2goKC8OT/"
    b"/ft3sOdBgQBiy8jIgKtFILAEYnkg5qGlowACiJ4BEAms8hR0dHTgyf7fv38MR44cYXj69ClY"
    b"ASggWFhYGLS0tEBcWSC2A2JhWhaGAAFErwAAFWbJ8vLyDKKiouDYB4EnT54wnD59muHevXvg"
    b"wAAFCkhOSUmJgZubmxmoxAkaEJy0chhAANErAHyB2BAUs6D2NyimQR6+ceMGWPLu3bsMX79+"
    b"BWcJUNkAqhJBrURoQagPLRNokgoAAoheAZAJbPgwSElJgT0ICoSPHz8y3LlzByT3582bN/9B"
    b"qQEEYIWiiooKqJUIagy5A7EkrXqJAAFEjwCwBzV9QYUfMzMzOPZBAXD//n2GL1++gORvAvEn"
    b"EB/meVAgCQkJgQMMCIyBWIlW/QOAAKJHAGTw8/MzgUp3WMkP8iA09kFd4FNAfPnhw4cMnz59"
    b"AmcNWCBBs4EYtGEEopmp7TiAAKJ1AOgAsR+oUGNlZQW39kAefPXqFcPz58/B5SAQ3wbi9cDU"
    b"AM4GII/DCkNQdQhsNYLU2UCrRKr3DwACiNYBkAps73PJycmhNHygpf5PoDyoFAQlhY2ggACl"
    b"AlAgwRpGoCoRVHNAs4AFLapEgACiZQDIgOp+WVlZBg4ODrDHQJ4H5fvHjx+D5F8A8T0gfgjE"
    b"oOSw/cWLFwwfPnyAV4mgQANlHWD/gBXaTZaGjiRRDQAEEC0DIAEYg6KgAIDFKih5P3v2DFTl"
    b"/Yd6/gHU89+BeDVQ3S9QowiWDUD6QD1GUA0CBKA2sja1+wcAAUSrAAA5MgGUh0F1OigmYT2+"
    b"R48egeQ/QpM/KBDeg4bqgPgcEJ8HBRCssIRlBWlpUMQz8CH1D6hWJQIEEK0CIIKRkVEZ5HBY"
    b"sxfkoXfv3jEA63yQ/GMk/A2qB9Q83AxS8/79e3gAgAINVBCC+g/QckABiLmp5VCAAKJFAIB6"
    b"b8nCwsIMPDw88MIPlK9BJT+Q/oUU+6DQ+AfVB0oFG4Hyn0BlAawcAKUA8FgZpIMEahg4UHPI"
    b"DCCAaBEA3kBsCnIwzBOg2AQ1dUEeA4KXSPn/M5peUJV4FFRNgnqGyA0jUAoAFqZM0ACQo1b/"
    b"ACCAaBEAWaDBDlCyhRV+oIAAJX2Qp9AKv19oekH8DaCaApQNkFMBqBUJSlXQ/oE1tapEgACi"
    b"dgCAGizOoB4fuJEPjX2QB0CxilT43Ucq/JABiL8dVEWCAgw2XAZLCaDmMbB/ABoyA02gKFKj"
    b"YQQQQNQMAFDJ3ABMpszApi9K7H/+/Bnc+YEWeqB6/xFS4YcOQCljL6gwBI0WIxeGoPYEyGwg"
    b"UGGADK2LUpoKAAKImgEAihVnUF4F1gDwUR6QB96+fQsr/G5CYx9U+P3FYc4fIF4D9PB/UKMI"
    b"FgAwswQEBGAFrTt0rICihhFAAFErAECxkAZquiLnfdiQFyg2gQCUB+5C8/8nAuYdAOJboHIA"
    b"5nlYYQhqV4DKGGg/A9Q4EqAkFQAEELUCwANUMIE8D5rpQY59UA8PFCBozd5fBMwD1Q7bQIUh"
    b"cjaAZSlQWQAdK6R44BQggKgVAJnA9jo4ecI8Dyu9QckYWvhdhwbCOyyFHzoAZY+1QI//BAUg"
    b"cgCAAhOU0kBNZCAwY6BwLhEggKgRACBHuIMaPbDhLuTkD4pBIHgKLQDxFX7oANw0BhWgsCyF"
    b"nAq4ucGNQdBIkTMlDSOAAKJGAKQCY4QNVEIjxz4IgxwPDJTf0MIPFPuv8RR+6ADcNAble+S+"
    b"ASwVgFIc0F5G6Mgx2XOJAAFEaQCA+ukhIM8jxz7MkdDYhxV+D4ko/NDbBBuA5n4EtSKRAxbW"
    b"s2RnBzUJKJtLBAggSgMgBVjlCYBGe5A9D0v+IDZSy+8pEYUfOgAF3FFQCkBPXSA+yF6g/ezQ"
    b"wpCsuUSAAKIkAEBjdLEgR6DHPogNHfv/jNTxIabwY8DSNF4PGyJDzgawThKoQAQCAyBWJ2es"
    b"ACCAKJl3iwaGvgzIATDHwNMudEADqdVHSuGHng02gwpQYJaSxWh8ABtc0JFm2FziWWhA/yHW"
    b"AoAAIjcAQHVQMsgBoBIZoykHyaMgx/9GKqlNyQwAkBkvgWbKgtoYIDsxkjFQHOgOK+hYAai2"
    b"+UCsBQABRG4ABIKGp0COgcY0aiX+9y+sdWgIxZSC/7BUhS0AoEAW2hm7Bm13EJXdAAKI3ABI"
    b"wxX7yMmTigBsGD77GCBzBs7Q3uRzYrMcQACRUwiCJinsGQYZgAa4JgOJc4kAAUROAGRQOXap"
    b"CbigEUT0XCJAAJGaBYyA2JNAZqVXbGMVB9oPm0sEdbvfEjILIIBIDYA0fP1vqOdfQxswv6HV"
    b"EbWSy3+oe00JjAGAJhFAkyiXobUB3qY3QACREgCgKiaUiOQPGtjcC+39faNBAigCBrQdAXeA"
    b"+gfrGCBzj5/xKQQIIFICIAna3sYX+5+g1RCoQXIKGgDULjBEoR7Elw0Uob1UUCR8wVclAgQQ"
    b"savFRUCtOqDh/3FhqCXngbiKATKFxUyjIoAPGsCE3HIYOnrMgc+/AAFEbC0QBe1y4gMfoH14"
    b"UNv/BQndXlLBVyCeSUQhCZtLFMCnFiCAiAkADlizl0Dyfwwt/G5BW2K0An+h/YMnBNTxQwtD"
    b"vENmAAFETACAFjjpEdFruwkNgBekdEbIBKCaZge+KhcaYaC5RLxrDQECiJgAyCQi9pFHfD/T"
    b"ocEDHjonIpuBxggc8Q2ZAQQQoQAAr+snwkGwEd8XZAx6kAuOAPEVIlq69gx45hIBAoiJiNgn"
    b"VI3BRnzvkznoQS4ATTRuJSIbqEMHTLD2DwACiIlAs9eXiGYvOSO+1AD/oNngKxFjF564hswA"
    b"AghfQygO1JyFjuqyYAk9Rmhz9yo0/5My4kstAGp07QW60RW524wlklWh2QC0IOsnsiRAADHi"
    b"SkLA5MMPHcwwhrYA/+Nonz8D4mPQ+v8nvXvB0Ji1gnaF2bC4kxGaSkB9g5NA/75ClgQIIHwB"
    b"wAb1OD80BeAKgG/QXtdXOuZ/ZMCO5E4mPNkFVDu9Bfr3B7IEQAAxjvTd4wABNOL3DgMEGAAt"
    b"pUQRZvTA4wAAAABJRU5ErkJggg==")
index.append('applixware')
catalog['applixware'] = applixware

#----------------------------------------------------------------------
ark = PyEmbeddedImage(
    b"iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABGdBTUEAAK/INwWK6QAAABl0"
    b"RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAABbASURBVHjaYvz//z/DSAYAAcQ4"
    b"0gMAIIBGfAAABNCIDwCAACIYAIyMjGQZHBMTEwDUWwPEYl+/ft118uTJ5idPnrwASv0cCI/i"
    b"8idAALHQwrLo6Gg/fn7+VQEBAayCgoIMGzduTP7165fGy5cvM37//n0HqOTHYEkBAAEEDhl8"
    b"mIyYl4qPj3++d+/e/z9+/Pj/8+fP/1euXPmfn5//39raeglQiSqtAp4cfwIEEBO1Lfr792+1"
    b"vr6+hIaGBsOrV68YgLHOAEoF2traDLKysoFiYmL2QGVCoNw1GBIAQABRNSaAsa/EwcERp6en"
    b"x/DlyxcGYHIHlyGgkP737x8oILjU1dWjgQFzCaj840CVB8gAIIBYqBz7ScBY5uHl5WV4//49"
    b"WIyJiYnh06dP4NTAxsbGIC0tbczNza0LLBgfAqVfDnQAAAQQ1bJAYmIiJwsLS4SkpCTDt2/f"
    b"GD5//swA9CTY89evX2f4+PEjA7BMYACmEF5lZWVXoBaJgSgL0AFAAFHNAcBS3paPj0+Zh4cH"
    b"nPxBSf7Pnz8Mjx8/Znj48CHD9+/fweIgAEoFly5dkgMyH0CzAkkgPLyG6T/DX9bPn1793759"
    b"7m9QGUeuuwECiJox4MvKysoArOsZQDTI8x8+fABjUMyDAgBUJoDkBAUFZLi4uNSAKeUStgAI"
    b"C+tm+fnzMxew+BD5+/e3PDBzyfz//1cWiKUZGf9Lf//2VZKZmVmIjZX7l7dXyp3ff37uOH9+"
    b"/5rXr5+A8t0fUhwNEEBUaQgBkz8LMMbPAZO3Lkw9sDwAY2DKAHsclCKAWQQcACwsjAynTt1Y"
    b"//u3wFJlZZtfQD1S////k/33768U0IMyLMzM4qxsrFIsLEw8rKzMbJycHEzc3DwM3Lw8DMAC"
    b"hoGLh5eBE5jS/gHL0NevnjDcu3GR4c3Lx1eePbtffe7c/v1A67+gpwpc/gQIIKoEQFxcnApQ"
    b"3RVgnmcHxgy85IdhEB/keRBmZ2cH8v8Cs4Pk3z9/5P5xcjKz8vJxMPDxcwMxFxDzMPDycQM9"
    b"ys3AzQfxMCsnGwMTUC8TyC1A9A/o5D9/GYABC6xGvjMwvHryjuH0wS0M9+4d+fzs2b3mU6f2"
    b"LgQ66y0oHggFAEAAsVAp/8uIiIiwAmsAhmfPnoGTOyjGwRZAPQ5MHQyg8gGk5tWrF8CA+M0c"
    b"FGbPrKqmCPQcM9BjzMAaA9I6+PsPZCawuQj0HNAohp/fIOwfQPrbVyD+DMRf/gH5/xh+//rP"
    b"wMQgyCAvGcfAxizGy8a2se3fvz98Z84cnAY07RVyIGADAAFElQAAJnFwbaKoqAhu8ICSPCj5"
    b"gwIBFPtMTMwMzMxMQPFfDB/ev2O4d/c2g7q6AYOykiID4382hq+fgJ4DNo6/gjwIxKCy8vvX"
    b"vww/fgIT+Q+gR7//ZPj18zcwFv8wMDL9BZoJpFn/M7DyMzJwswL1fv7D8O4VMwMvjwODohwz"
    b"MDuuLHn//vWLu3evrQY66zW+QhIggKgSACBPggq9+/fvwz0NyzqgwPgBjL5v374zyCkYMLDx"
    b"KjMYWqsziImrMFy6xQj0LFDu60+GP7+AHvwH9Nj/v+AswgosJ9jYGRm4uBkYgOUBAys7GwMj"
    b"Czcw3wML2L/s8BTyExhYvHwMDGKK3xhePH3O8P2+GYOwwDMOVdWPxQ8f3r7258/vM0BnfMbl"
    b"doAAomo9DMr/oJgHtv/hhR+I/fv3T4Z/wIQop2rGwC+qw/D780cGFlBF9uU5Az8rE4OYBBsD"
    b"B9CDLGxcwBhmA4YoKwMwwsHJ/xsoG3z7C8w2Pxg+vv/E8PXzJ2CAAWuWb8B2xfcPwBTyHhhA"
    b"kgyyCvYMqiaKDP9+P2P4+dWBQVjoqqKqqnbE9esXngKd9g1XVgAIwGq14yAMxTCPFVL1QLQD"
    b"CxMb3ICd63IUOAQSsMD7pG0gfYVEhZGNwVOGSLZj528EmOKmvhHwDZzR/p/DVmVFMuazAm5R"
    b"wBKCHyO6LuNybeBvHikmkD5RLRmCzqLaP6CX9Mo9D09phNmz1qS2K5FzU1eWq/p+VEsMOyw3"
    b"NcKJMIlrVNVhq2v2ivMvF7wFEFUC4O/ff9+Apfs/LS0tprdv34KbwaBGD6j+hwUCK7CgY/r/"
    b"AZgyXjNcfvCA4dKlxwxv3ggBCzhQbH5i+PPzK7AW/Pzv549Pv36CPPjr87dfPz9/BXr02/fv"
    b"Hz8BA+Lzly/v3gM9/enPn1+fgIpBVd03KytfZwEBDp8fPz4xPH18h0FS0YiBi5eLgfW1OAMn"
    b"J5coUI0MEPPiCgCAAKJKAPz59/8LsGr6B2wJMvDz88PrfeSqBxIQPxj+vDvD8PrhDYa3Vw/+"
    b"5/zy4sOdpz+fPn//+cX7T5/ffP729dOfv7+/Aj0IcuxXaNJFxl+RxEFjCj8FBETUYa36n8AC"
    b"AVjOMrCwsoEyJDA7MQOLSAZ+IObA5XaAAKI4AI4UMbAcfXtJ/cYXUaaHj54wcHGy42w7wALk"
    b"1ZuvDBIi/xgt5W7wWIh9lHr6juHrvXeMNw/fYTpy7fnf+9CGDKin+AtUjmLBf6El+382Ns4v"
    b"IGMhRsPshdFgQTZ8fR6AACIrAPYUsHD8/P3H7N9vBq/vf5jdHDX+awuwcLCcu3gRWBCygAtD"
    b"JiZGqDMYwfU8MJsA8zGoevzDwMH6l8HBzoZBXNyNlfvlXSHRZ9fM9V5fNw82ehb3+QvD+c+/"
    b"GPa/+sKwe9kZhosXHoNj+x+egQ5GCM3IAGViLaJwSQAEENEBsD6DVZD5/28bYJh6/WVgcxaV"
    b"V1EWUtZnElYxZBCQVWUwBSa7I8duM9y4+5rh05c/DN9//GH4DY6nfwwfnz1hEJYQZhARF2AQ"
    b"E+ZkkJEENmc5WIDV2X8GPll1hn/S6sDywZtBlvcn79cnV+ze3Dpv9+HZvSpl4a+3vv5iOPT2"
    b"O8vuY/f+H1199u87fG19cnpEAAFEMAC25HCoAcO2Cth+dxaUUJARVtJlEFbWZeAWkQbmNQ6G"
    b"v8C26I/nDxn+//nNoM3zBVi/f2T4yP6V4Suw8fLzO7AqBNZlL77eYBD8Js7A85GfgfErC8OH"
    b"JywMn0AtRDY2BnZgHc/Lx8UgLiXKwMsmzCCobcMgpWnB8O39C9a3969ov7t7Sfvji0cZSiKM"
    b"T80VmSeUrPm1ANqB+gMpWyDuhDY8SR5mAgggggHw4+cfV0lFjXhdv1IGTm52YEx9Zvj34y3D"
    b"n9f3GX79/gOKYFBhAxr5YOBg/s8gK8XLICnOxfCfiYXh1z9Ght/AdsDX77cYGBSEGRgERYGZ"
    b"8T+4VcgCxGwsIJoR3Dli/P2O4efzdwy/wIUlAwM7BzeDnLY9g6xRBNANLIw390yVufR4vx/Q"
    b"SaeA+CIQf0JkA/KTAEAAEQyAbz8Z2djY/zHwcj8ENsnEgEWKOAOToCIDy39gC+UPMEX+BvZA"
    b"//0ChQKkrAHRjFDHQDsvDPeBnjfXZWCQlAPVmUguhroe2EYAt5QYgeUVqxDQ95LAohxYeP8G"
    b"Vgbf7zCwMl9n4GB6xPDyM5MAUCGwe8xwEzkA4Mb8Jz0MAAKIYAAAsyn3v/9MEMd8ewL0NLD2"
    b"YQLWKuxSDAycQLewAjELMDX+egNUA8R/v4M7NpAAYQTVSQwMXFxAeWDt9fkNNK1CPQ1KPsyc"
    b"wEAFBSzQ08xAdb+Bnbi3J4GV3RVgPfAYqAZoHgs7sIoDVqH/wIayopbq/6EJnwnOIgUABBDB"
    b"APj3j/E/EyvQYWx8UI8BPfIHGBifLzEwvD8BCQwOaQYGblVgoChDXPAb2An7+Rqi7h9Qngeo"
    b"/z8wlfx8D4lpFh5IALJLAPWzQwLuw2Ggp68B2UB9wE4PAwtQHzMwRTABUwSwZvkPbMz9+M2I"
    b"XAWiuZO8ahwggAgGALA3z/mPEagM2BEBd8RhwQwSAzn+D7DK/gyMrXcnIHx2YGDwaQNThyIQ"
    b"g1LOMwYGAWDgMQNdyA5slHHIQQLyJ7CJ/m43MFUBy4e/H6CpBZgaQIENNhvSRQbTQPznLziG"
    b"/2MLAErKAIAAIiIF/OdgZAZ6jJUbKZj/ozY6wA6FBsbX69CUwQYJDB4VYC/IHZhCgDH+BZhq"
    b"3mwB5uu7QG8AszCooQZKQaz8qB4GlyMIz4P4oAGQX38Y/sEaQJjtAdSihVgAEEBEZQFGUKyA"
    b"ki28AIMFwH/MdgbY4WyQwPh2G9gbPwRMCXKQsYmnsyGeBQUoiyCah1nANQlGIDCzQPM3MygA"
    b"/kAbRf+wBgAZWQAggIgJAJ5/DNAsAKzrEcGM1uxkxCIO8tS/n5BU+weYzNmFIOYwMkM9ywLx"
    b"KHqsIwcCsDplALbwQP3//8BKGFe39j9ZrQAGBoAAIhwAIKeycUOyAKinAQtnnGOFjKhskIeZ"
    b"QEn9NySPM3MgxTSURvY4PEAQWQDUxP0LrIl+/gaVjphZABz7//A1mHEDgAAiXA3+Y2BmBBdO"
    b"wCzA8hMp+aN5FFcl9Aca46CIAwcAG+7kji0QQFngH8gdwEbVP8Z/uLIAuU1hgAAi3Bf4x8j1"
    b"H5SnQTHJ8h1H3wIWAExo2YIBknIYWSFJGVifg1MAvjyPHgjAAPj35z8wC/xHrgUwnUlmGQAQ"
    b"QAQDANRhYebgg4wpMH/Dn+QZGTHFWbigSfkvpG4H1RaECj7kQGBhAafxf8DA/fGb4TeuWgBk"
    b"3394/5N4ABBAhMuA/4wc/8FTeFwQzyDbz4gv+UPF/3JBUg8o5mEBQKjgQy4kQVkAWPv8+f0P"
    b"ZNx/XFkAWFiTVQYABBARDSFmdkZmaOsT1GzFGsa4GqH/IYEGzvtM0ABgRSv9sRR8yIEAtPvf"
    b"nz+gApDh11/cVSC5s4MAAUREALD8Z2Zlh9gLTpKc0CoOfXKZEXtg/OOBtAvAnoEGAEYViBYI"
    b"yDUEKAswMwNjmPn/zz/gLPAPZ0OIjAAACCBisgD3v/9oM+osHFhKfygbHjBQTaCeIjMvpPRn"
    b"YIemACKqQJgaYGfqP9NPhp8/fsNC9x/WapDMliBAABFOAYzMTMxsHJjLCuCBgK1VyIgoK0A9"
    b"RWZodcbIDunyElsFgqtPYDuAEdgEBNYE0BSA3hf4T0k9CBBAxJQBrKzsXFClyB5FTwnItQBS"
    b"AICiBZQFQOUIIwekOsRZ8ME8zogUkExAYWZgQ4jx/++///5gpgCwBnzjgXgBQAAREQBM3K/u"
    b"XWdQ0HvMwMEvBB1k/QUdkYKVCViqRVjTGEQxw7q2SAGAreBjQPY4JMD//fnB8Oz6fYa/P74x"
    b"/PzHBhp4+AsrCIODi8RZWP64fP7MwQAesyADAAQQwQB48omhc+3Cldknd+3S1zY24lYwNGWQ"
    b"0zFm4BGVhlSNoFTJwohU7iGVC//RAgAUaOBGEVJyh3ucCeqc/wy/f3xheHH7EcPDC9cZHly+"
    b"x/Dy8SeG9/8UGHWNlWz12AQUOdhZPjAygobW/mv/+iUs//WrOLQtDHXHPwYsrVXsACCACAbA"
    b"jIPPt4GWsghyvTZRP/bAUllkm46qrLCcrpEBr7KxKaOCvgkDv5Q80IPC0FL+IzCSkDvo0A4N"
    b"aGQIND8BK/3BHmaGOuEPw/dPHxmeXrvH8PDiTYY7F58wPHv6n+H5JxmGz0w2DN9YpRl+MfEw"
    b"ApXLMf37K/f9OyRk//5lYfj+XRBIg2qJHwx8fIIMoNz65RVo3OUHsNz4hafhBAEAAUTMsDho"
    b"luby+29/Hp948OfwiQffJLkufVBQP/3ERFl4t56ytJCinqGWgLqRCZO8vhGDiByw68stAukO"
    b"/4B6EFz1sSJZyQLORh9evmJ4cOEGw52ztxnuXn7F8PQlJ8OLrwoMH/97A7E8MG3xApM2MzCo"
    b"/oIyA7ith2h8Qdt+TMA2IrCTKC6qyCCrJMHAygZsNL1nZvjx7x7Dp4+f3kNnkHAOpQMEEKkr"
    b"REAuB2V6UNsYVCBIsjIzyiqJcBgaq8uHaiuKiclI8DAoaWswqBnoAANDmoGJE1jys6mCB3P/"
    b"//vI8OrRC4a7Z4CevviQ4flDYN+CS53hH78hw4f/Ggzf/kow/PrHCU7OjP8gHb////6DUzdy"
    b"jw9e7f2DYA4OLgYxKT4GBV02hn/3BBhu3L4JzLoT/h/Yv3nHy5dPlwN17QT68xU2/wEEECVL"
    b"ZJihgQGaeBRwcnWfZqSv5/DmyUMGxo/PGYTZvjKoyAswqOuoMkhpmDK8enaa4fb52wyf3rEC"
    b"G4eqDIz8Wgxc0iYMrHySwOKBGxibf6Gjw9ClNf8YIcX9P/DALISGehjULgGxQQNUf/6BluD8"
    b"Z+Dj5Wb495if4d6j1wyPPk9juHXr4MOTJ/evAxqxEYhPA83E1pFhAAggkgIgObkCmLaZ7P/9"
    b"+ycFdOLrp0/vH969a9UrP/9oQVaW/9tFRCSMhIRlGHj4xBmuXz0EHhjlZ/jGwPnnPcPHr78Y"
    b"RHQ8GRxcmhlYvzIxgArtf78hnvj/FxGr//4hYvYflA/zMFjsLyRA/kEDBDRI9QdYKX1595fh"
    b"+fdLDK++bWJ4+vjM6yNHdu3+/fvXHtBMHqgs/4/DowABRHQAJCaWRXNycrbKyEjJc3JyMXz6"
    b"9JXh/fsPj9+8ebqPj4/XTlpaVlFYWByonpXh9etXDBcu7Ae2ff4wsAGT588fP4Dd2R8M/MKy"
    b"DJJyRkBXizAwMQoBPfQPGtuwWP8HbTogiyEtbv4HCSUUNmg94r8vDN9/P2b4/Onu70cPbzy8"
    b"ePHY8T9/fp8AOvsgEINWp//E5U+AACIqAJKTywMEBYXWeHjYMwsJCQI9/pnhzZv3DI8ePQWv"
    b"25GRkWUAtpYY3r17z3DnznVgADxgEBHhA0+SgqbJ/4G6s3//MDx+9PTPw4esL5mYOP8wMjL9"
    b"R2nZMkLYjIz/0Vq8/5DYoEIPSiMNEP/9++fv588f3j99eufBhw9vQB6+CsTnGCALMb/hWyUG"
    b"EEAEa4H09Bp2oCdabGxMmSUkxBjevv3I8OXLN4YfP34BPcjOwMnJD176dvfuHYbLl8/8fPjw"
    b"5ntjYwNxXV3QkkHI2iEQfvXqJWjJ7JvTZ3buAhp7m4GMFaJ422uQ1hmo1ActiXkMxG+gYngB"
    b"QAARHhD580dTRERYA7QA+vnzNwzfvv0AL2z6+hW0+vMnw4cPnxgePrz1/+TJQ8/OnTt2/suX"
    b"T7fl5WVSHjx4wAsKGNCSGdCCCdBi6SdPnoAcdwOIQYsZX+DpR5MTAH+hVd43qMeJ6hkABBAR"
    b"o8L/BFlYWJnevfsEnuMHxTwoED5//srw8+cvoPwfYPLiYLh27eKljx/fHwKVuB8/fpR58eJF"
    b"KLDMACc90EKpd+/e/bx37/51aOzfgcbWgAOAACIYAF++fHj8/bvQj5cv33KC1vuBAgAU8yDP"
    b"g/I/EzhPMvz58ePbS+is7bnnz5938vPzu3379o0fVAaAyoIbN27cBvLvQ/PlF4ZBAgACiGAP"
    b"YvXqWQ8/f/6878WLN+D8//EjZPETxPN/wCn4zp2rzz9+fPeMAbL+/+vp06evAbNAza9fv94D"
    b"U8Dfu3fvPrgILJqBcpegefTPYAkAgAAipin858qVU43s7PY6/PzC8uCuPOM/MP7/n4XhxYvn"
    b"H/bsWXsKmqzfQovsH4cPH14uLCz8FBj75sD8/ws6pX0eiN8xULC8ndoAIICIbQdwKStrW5ma"
    b"OlSIikobAQs3zu/fv/26d+/ai0OHtpz5+vXzaWide50BsSMM1FIErdASh05pv4WWzINq2xxA"
    b"ABEbACCCB4iVgVgbiOUgXTtwifsIWu/eY4AsYfuPNjgAw/8GMuZx+RMggEhpCjNCR0P4oZ0h"
    b"Fmhe/sQwSDZAkRMAAAE04rfOAgTQiA8AgAADAECR9KQ+bnM5AAAAAElFTkSuQmCC")
index.append('ark')
catalog['ark'] = ark


class TestFrame(wx.Frame):

    def __init__(self, parent, log):

        wx.Frame.__init__(self, parent, -1,
                          "UltimateListCtrl in wx.LC_ICON mode",
                          size=(600, 400))

        # load some images into an image list
        il = wx.ImageList(64, 64, True)
        imgs = sorted(catalog)

        for img in imgs:
            bmp = catalog[img].GetBitmap()
            il_max = il.Add(bmp)

        # create the list control
        self.list = ULC.UltimateListCtrl(self, -1,
                                         agwStyle=wx.LC_ICON | wx.LC_AUTOARRANGE |
                                         ULC.ULC_HEADER_IN_ALL_VIEWS)

        # assign the image list to it
        self.list.AssignImageList(il, wx.IMAGE_LIST_NORMAL)

        info = ULC.UltimateListItem()
        info._mask = wx.LIST_MASK_TEXT | wx.LIST_MASK_FORMAT
        info._format = 0
        info._text = "Artist\nName"

        self.list.InsertColumnInfo(0, info)

        info = ULC.UltimateListItem()
        info._format = wx.LIST_FORMAT_RIGHT
        info._mask = wx.LIST_MASK_TEXT | wx.LIST_MASK_FORMAT
        info._text = "Title"

        self.list.InsertColumnInfo(1, info)

        info = ULC.UltimateListItem()
        info._mask = wx.LIST_MASK_TEXT | wx.LIST_MASK_FORMAT
        info._format = 0
        info._text = "Genre"

        self.list.InsertColumnInfo(2, info)

        for i in range(3):
            self.list.SetColumnWidth(i, 130)

        # create some items for the list
        for x in range(25):
            img = x % (il_max+1)
            text = "%02d" % x
            self.list.InsertImageStringItem(x, text, img)

        self.SetIcon(images.Mondrian.GetIcon())
        self.Show()

#---------------------------------------------------------------------------

if __name__ == '__main__':
    import sys
    app = wx.App(0)
    frame = TestFrame(None, sys.stdout)
    frame.Show(True)
    app.MainLoop()

