# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Baseline(_serialization.Model):
    """Baseline details.

    :ivar expected_results: Expected results.
    :vartype expected_results: list[list[str]]
    :ivar updated_time: Baseline update time (UTC).
    :vartype updated_time: ~datetime.datetime
    """

    _attribute_map = {
        "expected_results": {"key": "expectedResults", "type": "[[str]]"},
        "updated_time": {"key": "updatedTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        expected_results: Optional[List[List[str]]] = None,
        updated_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword expected_results: Expected results.
        :paramtype expected_results: list[list[str]]
        :keyword updated_time: Baseline update time (UTC).
        :paramtype updated_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.expected_results = expected_results
        self.updated_time = updated_time


class BaselineAdjustedResult(_serialization.Model):
    """The rule result adjusted with baseline.

    :ivar baseline: Baseline details.
    :vartype baseline: ~azure.mgmt.security.v2020_07_01_preview.models.Baseline
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleStatus
    :ivar results_not_in_baseline: Results the are not in baseline.
    :vartype results_not_in_baseline: list[list[str]]
    :ivar results_only_in_baseline: Results the are in baseline.
    :vartype results_only_in_baseline: list[list[str]]
    """

    _attribute_map = {
        "baseline": {"key": "baseline", "type": "Baseline"},
        "status": {"key": "status", "type": "str"},
        "results_not_in_baseline": {"key": "resultsNotInBaseline", "type": "[[str]]"},
        "results_only_in_baseline": {"key": "resultsOnlyInBaseline", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        baseline: Optional["_models.Baseline"] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        results_not_in_baseline: Optional[List[List[str]]] = None,
        results_only_in_baseline: Optional[List[List[str]]] = None,
        **kwargs
    ):
        """
        :keyword baseline: Baseline details.
        :paramtype baseline: ~azure.mgmt.security.v2020_07_01_preview.models.Baseline
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleStatus
        :keyword results_not_in_baseline: Results the are not in baseline.
        :paramtype results_not_in_baseline: list[list[str]]
        :keyword results_only_in_baseline: Results the are in baseline.
        :paramtype results_only_in_baseline: list[list[str]]
        """
        super().__init__(**kwargs)
        self.baseline = baseline
        self.status = status
        self.results_not_in_baseline = results_not_in_baseline
        self.results_only_in_baseline = results_only_in_baseline


class BenchmarkReference(_serialization.Model):
    """The benchmark references.

    :ivar benchmark: The benchmark name.
    :vartype benchmark: str
    :ivar reference: The benchmark reference.
    :vartype reference: str
    """

    _attribute_map = {
        "benchmark": {"key": "benchmark", "type": "str"},
        "reference": {"key": "reference", "type": "str"},
    }

    def __init__(self, *, benchmark: Optional[str] = None, reference: Optional[str] = None, **kwargs):
        """
        :keyword benchmark: The benchmark name.
        :paramtype benchmark: str
        :keyword reference: The benchmark reference.
        :paramtype reference: str
        """
        super().__init__(**kwargs)
        self.benchmark = benchmark
        self.reference = reference


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2020_07_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2020_07_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class QueryCheck(_serialization.Model):
    """The rule query details.

    :ivar query: The rule query.
    :vartype query: str
    :ivar expected_result: Expected result.
    :vartype expected_result: list[list[str]]
    :ivar column_names: Column names of expected result.
    :vartype column_names: list[str]
    """

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "expected_result": {"key": "expectedResult", "type": "[[str]]"},
        "column_names": {"key": "columnNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        query: Optional[str] = None,
        expected_result: Optional[List[List[str]]] = None,
        column_names: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword query: The rule query.
        :paramtype query: str
        :keyword expected_result: Expected result.
        :paramtype expected_result: list[list[str]]
        :keyword column_names: Column names of expected result.
        :paramtype column_names: list[str]
        """
        super().__init__(**kwargs)
        self.query = query
        self.expected_result = expected_result
        self.column_names = column_names


class Remediation(_serialization.Model):
    """Remediation details.

    :ivar description: Remediation description.
    :vartype description: str
    :ivar scripts: Remediation script.
    :vartype scripts: list[str]
    :ivar automated: Is remediation automated.
    :vartype automated: bool
    :ivar portal_link: Optional link to remediate in Azure Portal.
    :vartype portal_link: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scripts": {"key": "scripts", "type": "[str]"},
        "automated": {"key": "automated", "type": "bool"},
        "portal_link": {"key": "portalLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        scripts: Optional[List[str]] = None,
        automated: Optional[bool] = None,
        portal_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Remediation description.
        :paramtype description: str
        :keyword scripts: Remediation script.
        :paramtype scripts: list[str]
        :keyword automated: Is remediation automated.
        :paramtype automated: bool
        :keyword portal_link: Optional link to remediate in Azure Portal.
        :paramtype portal_link: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.scripts = scripts
        self.automated = automated
        self.portal_link = portal_link


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class RuleResults(Resource):
    """Rule results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: Rule results properties.
    :vartype properties: ~azure.mgmt.security.v2020_07_01_preview.models.RuleResultsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "RuleResultsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.RuleResultsProperties"] = None, **kwargs):
        """
        :keyword properties: Rule results properties.
        :paramtype properties: ~azure.mgmt.security.v2020_07_01_preview.models.RuleResultsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class RuleResultsInput(_serialization.Model):
    """Rule results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(self, *, latest_scan: Optional[bool] = None, results: Optional[List[List[str]]] = None, **kwargs):
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class RuleResultsProperties(_serialization.Model):
    """Rule results properties.

    :ivar results: Expected results in the baseline.
    :vartype results: list[list[str]]
    """

    _attribute_map = {
        "results": {"key": "results", "type": "[[str]]"},
    }

    def __init__(self, *, results: Optional[List[List[str]]] = None, **kwargs):
        """
        :keyword results: Expected results in the baseline.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.results = results


class RulesResults(_serialization.Model):
    """A list of rules results.

    :ivar value: List of rule results.
    :vartype value: list[~azure.mgmt.security.v2020_07_01_preview.models.RuleResults]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RuleResults]"},
    }

    def __init__(self, *, value: Optional[List["_models.RuleResults"]] = None, **kwargs):
        """
        :keyword value: List of rule results.
        :paramtype value: list[~azure.mgmt.security.v2020_07_01_preview.models.RuleResults]
        """
        super().__init__(**kwargs)
        self.value = value


class RulesResultsInput(_serialization.Model):
    """Rules results input.

    :ivar latest_scan: Take results from latest scan.
    :vartype latest_scan: bool
    :ivar results: Expected results to be inserted into the baseline.
     Leave this field empty it LatestScan == true.
    :vartype results: dict[str, list[list[str]]]
    """

    _attribute_map = {
        "latest_scan": {"key": "latestScan", "type": "bool"},
        "results": {"key": "results", "type": "{[[str]]}"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[Dict[str, List[List[str]]]] = None, **kwargs
    ):
        """
        :keyword latest_scan: Take results from latest scan.
        :paramtype latest_scan: bool
        :keyword results: Expected results to be inserted into the baseline.
         Leave this field empty it LatestScan == true.
        :paramtype results: dict[str, list[list[str]]]
        """
        super().__init__(**kwargs)
        self.latest_scan = latest_scan
        self.results = results


class Scan(Resource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan record properties.
    :vartype properties: ~azure.mgmt.security.v2020_07_01_preview.models.ScanProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanProperties"] = None, **kwargs):
        """
        :keyword properties: A vulnerability assessment scan record properties.
        :paramtype properties: ~azure.mgmt.security.v2020_07_01_preview.models.ScanProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """A vulnerability assessment scan record properties.

    :ivar trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.security.v2020_07_01_preview.models.ScanTriggerType
    :ivar state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
     "Passed".
    :vartype state: str or ~azure.mgmt.security.v2020_07_01_preview.models.ScanState
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar sql_version: The SQL version.
    :vartype sql_version: str
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Scan results are valid until end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar high_severity_failed_rules_count: The number of failed rules with high severity.
    :vartype high_severity_failed_rules_count: int
    :ivar medium_severity_failed_rules_count: The number of failed rules with medium severity.
    :vartype medium_severity_failed_rules_count: int
    :ivar low_severity_failed_rules_count: The number of failed rules with low severity.
    :vartype low_severity_failed_rules_count: int
    :ivar total_passed_rules_count: The number of total passed rules.
    :vartype total_passed_rules_count: int
    :ivar total_failed_rules_count: The number of total failed rules.
    :vartype total_failed_rules_count: int
    :ivar total_rules_count: The number of total rules assessed.
    :vartype total_rules_count: int
    :ivar is_baseline_applied: Baseline created for this database, and has one or more rules.
    :vartype is_baseline_applied: bool
    """

    _attribute_map = {
        "trigger_type": {"key": "triggerType", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "server": {"key": "server", "type": "str"},
        "database": {"key": "database", "type": "str"},
        "sql_version": {"key": "sqlVersion", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "high_severity_failed_rules_count": {"key": "highSeverityFailedRulesCount", "type": "int"},
        "medium_severity_failed_rules_count": {"key": "mediumSeverityFailedRulesCount", "type": "int"},
        "low_severity_failed_rules_count": {"key": "lowSeverityFailedRulesCount", "type": "int"},
        "total_passed_rules_count": {"key": "totalPassedRulesCount", "type": "int"},
        "total_failed_rules_count": {"key": "totalFailedRulesCount", "type": "int"},
        "total_rules_count": {"key": "totalRulesCount", "type": "int"},
        "is_baseline_applied": {"key": "isBaselineApplied", "type": "bool"},
    }

    def __init__(
        self,
        *,
        trigger_type: Optional[Union[str, "_models.ScanTriggerType"]] = None,
        state: Optional[Union[str, "_models.ScanState"]] = None,
        server: Optional[str] = None,
        database: Optional[str] = None,
        sql_version: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        high_severity_failed_rules_count: Optional[int] = None,
        medium_severity_failed_rules_count: Optional[int] = None,
        low_severity_failed_rules_count: Optional[int] = None,
        total_passed_rules_count: Optional[int] = None,
        total_failed_rules_count: Optional[int] = None,
        total_rules_count: Optional[int] = None,
        is_baseline_applied: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
        :paramtype trigger_type: str or ~azure.mgmt.security.v2020_07_01_preview.models.ScanTriggerType
        :keyword state: The scan status. Known values are: "Failed", "FailedToRun", "InProgress", and
         "Passed".
        :paramtype state: str or ~azure.mgmt.security.v2020_07_01_preview.models.ScanState
        :keyword server: The server name.
        :paramtype server: str
        :keyword database: The database name.
        :paramtype database: str
        :keyword sql_version: The SQL version.
        :paramtype sql_version: str
        :keyword start_time: The scan start time (UTC).
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Scan results are valid until end time (UTC).
        :paramtype end_time: ~datetime.datetime
        :keyword high_severity_failed_rules_count: The number of failed rules with high severity.
        :paramtype high_severity_failed_rules_count: int
        :keyword medium_severity_failed_rules_count: The number of failed rules with medium severity.
        :paramtype medium_severity_failed_rules_count: int
        :keyword low_severity_failed_rules_count: The number of failed rules with low severity.
        :paramtype low_severity_failed_rules_count: int
        :keyword total_passed_rules_count: The number of total passed rules.
        :paramtype total_passed_rules_count: int
        :keyword total_failed_rules_count: The number of total failed rules.
        :paramtype total_failed_rules_count: int
        :keyword total_rules_count: The number of total rules assessed.
        :paramtype total_rules_count: int
        :keyword is_baseline_applied: Baseline created for this database, and has one or more rules.
        :paramtype is_baseline_applied: bool
        """
        super().__init__(**kwargs)
        self.trigger_type = trigger_type
        self.state = state
        self.server = server
        self.database = database
        self.sql_version = sql_version
        self.start_time = start_time
        self.end_time = end_time
        self.high_severity_failed_rules_count = high_severity_failed_rules_count
        self.medium_severity_failed_rules_count = medium_severity_failed_rules_count
        self.low_severity_failed_rules_count = low_severity_failed_rules_count
        self.total_passed_rules_count = total_passed_rules_count
        self.total_failed_rules_count = total_failed_rules_count
        self.total_rules_count = total_rules_count
        self.is_baseline_applied = is_baseline_applied


class ScanResult(Resource):
    """A vulnerability assessment scan result for a single rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: A vulnerability assessment scan result properties for a single rule.
    :vartype properties: ~azure.mgmt.security.v2020_07_01_preview.models.ScanResultProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ScanResultProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ScanResultProperties"] = None, **kwargs):
        """
        :keyword properties: A vulnerability assessment scan result properties for a single rule.
        :paramtype properties: ~azure.mgmt.security.v2020_07_01_preview.models.ScanResultProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ScanResultProperties(_serialization.Model):
    """A vulnerability assessment scan result properties for a single rule.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar status: The rule result status. Known values are: "NonFinding", "Finding", and
     "InternalError".
    :vartype status: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleStatus
    :ivar is_trimmed: Indicated whether the results specified here are trimmed.
    :vartype is_trimmed: bool
    :ivar query_results: The results of the query that was run.
    :vartype query_results: list[list[str]]
    :ivar remediation: Remediation details.
    :vartype remediation: ~azure.mgmt.security.v2020_07_01_preview.models.Remediation
    :ivar baseline_adjusted_result: The rule result adjusted with baseline.
    :vartype baseline_adjusted_result:
     ~azure.mgmt.security.v2020_07_01_preview.models.BaselineAdjustedResult
    :ivar rule_metadata: vulnerability assessment rule metadata details.
    :vartype rule_metadata: ~azure.mgmt.security.v2020_07_01_preview.models.VaRule
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "is_trimmed": {"key": "isTrimmed", "type": "bool"},
        "query_results": {"key": "queryResults", "type": "[[str]]"},
        "remediation": {"key": "remediation", "type": "Remediation"},
        "baseline_adjusted_result": {"key": "baselineAdjustedResult", "type": "BaselineAdjustedResult"},
        "rule_metadata": {"key": "ruleMetadata", "type": "VaRule"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        status: Optional[Union[str, "_models.RuleStatus"]] = None,
        is_trimmed: Optional[bool] = None,
        query_results: Optional[List[List[str]]] = None,
        remediation: Optional["_models.Remediation"] = None,
        baseline_adjusted_result: Optional["_models.BaselineAdjustedResult"] = None,
        rule_metadata: Optional["_models.VaRule"] = None,
        **kwargs
    ):
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword status: The rule result status. Known values are: "NonFinding", "Finding", and
         "InternalError".
        :paramtype status: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleStatus
        :keyword is_trimmed: Indicated whether the results specified here are trimmed.
        :paramtype is_trimmed: bool
        :keyword query_results: The results of the query that was run.
        :paramtype query_results: list[list[str]]
        :keyword remediation: Remediation details.
        :paramtype remediation: ~azure.mgmt.security.v2020_07_01_preview.models.Remediation
        :keyword baseline_adjusted_result: The rule result adjusted with baseline.
        :paramtype baseline_adjusted_result:
         ~azure.mgmt.security.v2020_07_01_preview.models.BaselineAdjustedResult
        :keyword rule_metadata: vulnerability assessment rule metadata details.
        :paramtype rule_metadata: ~azure.mgmt.security.v2020_07_01_preview.models.VaRule
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.status = status
        self.is_trimmed = is_trimmed
        self.query_results = query_results
        self.remediation = remediation
        self.baseline_adjusted_result = baseline_adjusted_result
        self.rule_metadata = rule_metadata


class ScanResults(_serialization.Model):
    """A list of vulnerability assessment scan results.

    :ivar value: List of vulnerability assessment scan results.
    :vartype value: list[~azure.mgmt.security.v2020_07_01_preview.models.ScanResult]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ScanResult]"},
    }

    def __init__(self, *, value: Optional[List["_models.ScanResult"]] = None, **kwargs):
        """
        :keyword value: List of vulnerability assessment scan results.
        :paramtype value: list[~azure.mgmt.security.v2020_07_01_preview.models.ScanResult]
        """
        super().__init__(**kwargs)
        self.value = value


class Scans(_serialization.Model):
    """A list of vulnerability assessment scan records.

    :ivar value: List of vulnerability assessment scan records.
    :vartype value: list[~azure.mgmt.security.v2020_07_01_preview.models.Scan]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Scan]"},
    }

    def __init__(self, *, value: Optional[List["_models.Scan"]] = None, **kwargs):
        """
        :keyword value: List of vulnerability assessment scan records.
        :paramtype value: list[~azure.mgmt.security.v2020_07_01_preview.models.Scan]
        """
        super().__init__(**kwargs)
        self.value = value


class VaRule(_serialization.Model):
    """vulnerability assessment rule metadata details.

    :ivar rule_id: The rule Id.
    :vartype rule_id: str
    :ivar severity: The rule severity. Known values are: "High", "Medium", "Low", "Informational",
     and "Obsolete".
    :vartype severity: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleSeverity
    :ivar category: The rule category.
    :vartype category: str
    :ivar rule_type: The rule type. Known values are: "Binary", "BaselineExpected", "PositiveList",
     and "NegativeList".
    :vartype rule_type: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleType
    :ivar title: The rule title.
    :vartype title: str
    :ivar description: The rule description.
    :vartype description: str
    :ivar rationale: The rule rationale.
    :vartype rationale: str
    :ivar query_check: The rule query details.
    :vartype query_check: ~azure.mgmt.security.v2020_07_01_preview.models.QueryCheck
    :ivar benchmark_references: The benchmark references.
    :vartype benchmark_references:
     list[~azure.mgmt.security.v2020_07_01_preview.models.BenchmarkReference]
    """

    _attribute_map = {
        "rule_id": {"key": "ruleId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "rationale": {"key": "rationale", "type": "str"},
        "query_check": {"key": "queryCheck", "type": "QueryCheck"},
        "benchmark_references": {"key": "benchmarkReferences", "type": "[BenchmarkReference]"},
    }

    def __init__(
        self,
        *,
        rule_id: Optional[str] = None,
        severity: Optional[Union[str, "_models.RuleSeverity"]] = None,
        category: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.RuleType"]] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        rationale: Optional[str] = None,
        query_check: Optional["_models.QueryCheck"] = None,
        benchmark_references: Optional[List["_models.BenchmarkReference"]] = None,
        **kwargs
    ):
        """
        :keyword rule_id: The rule Id.
        :paramtype rule_id: str
        :keyword severity: The rule severity. Known values are: "High", "Medium", "Low",
         "Informational", and "Obsolete".
        :paramtype severity: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleSeverity
        :keyword category: The rule category.
        :paramtype category: str
        :keyword rule_type: The rule type. Known values are: "Binary", "BaselineExpected",
         "PositiveList", and "NegativeList".
        :paramtype rule_type: str or ~azure.mgmt.security.v2020_07_01_preview.models.RuleType
        :keyword title: The rule title.
        :paramtype title: str
        :keyword description: The rule description.
        :paramtype description: str
        :keyword rationale: The rule rationale.
        :paramtype rationale: str
        :keyword query_check: The rule query details.
        :paramtype query_check: ~azure.mgmt.security.v2020_07_01_preview.models.QueryCheck
        :keyword benchmark_references: The benchmark references.
        :paramtype benchmark_references:
         list[~azure.mgmt.security.v2020_07_01_preview.models.BenchmarkReference]
        """
        super().__init__(**kwargs)
        self.rule_id = rule_id
        self.severity = severity
        self.category = category
        self.rule_type = rule_type
        self.title = title
        self.description = description
        self.rationale = rationale
        self.query_check = query_check
        self.benchmark_references = benchmark_references
