# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ActionRuleStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates if the given action rule is enabled or disabled
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ActionRuleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates type of action rule
    """

    SUPPRESSION = "Suppression"
    ACTION_GROUP = "ActionGroup"
    DIAGNOSTICS = "Diagnostics"

class AlertModificationEvent(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reason for the modification
    """

    ALERT_CREATED = "AlertCreated"
    STATE_CHANGE = "StateChange"
    MONITOR_CONDITION_CHANGE = "MonitorConditionChange"
    SEVERITY_CHANGE = "SeverityChange"
    ACTION_RULE_TRIGGERED = "ActionRuleTriggered"
    ACTION_RULE_SUPPRESSED = "ActionRuleSuppressed"
    ACTIONS_TRIGGERED = "ActionsTriggered"
    ACTIONS_SUPPRESSED = "ActionsSuppressed"
    ACTIONS_FAILED = "ActionsFailed"

class AlertRuleState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The alert rule state.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class AlertsSortByFields(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NAME = "name"
    SEVERITY = "severity"
    ALERT_STATE = "alertState"
    MONITOR_CONDITION = "monitorCondition"
    TARGET_RESOURCE = "targetResource"
    TARGET_RESOURCE_NAME = "targetResourceName"
    TARGET_RESOURCE_GROUP = "targetResourceGroup"
    TARGET_RESOURCE_TYPE = "targetResourceType"
    START_DATE_TIME = "startDateTime"
    LAST_MODIFIED_DATE_TIME = "lastModifiedDateTime"

class AlertsSummaryGroupByFields(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SEVERITY = "severity"
    ALERT_STATE = "alertState"
    MONITOR_CONDITION = "monitorCondition"
    MONITOR_SERVICE = "monitorService"
    SIGNAL_TYPE = "signalType"
    ALERT_RULE = "alertRule"

class AlertState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    NEW = "New"
    ACKNOWLEDGED = "Acknowledged"
    CLOSED = "Closed"

class Enum11(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ASC = "asc"
    DESC = "desc"

class Identifier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    MONITOR_SERVICE_LIST = "MonitorServiceList"

class MetadataIdentifier(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Identification of the information to be retrieved by API call
    """

    MONITOR_SERVICE_LIST = "MonitorServiceList"

class MonitorCondition(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    FIRED = "Fired"
    RESOLVED = "Resolved"

class MonitorService(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    APPLICATION_INSIGHTS = "Application Insights"
    ACTIVITY_LOG_ADMINISTRATIVE = "ActivityLog Administrative"
    ACTIVITY_LOG_SECURITY = "ActivityLog Security"
    ACTIVITY_LOG_RECOMMENDATION = "ActivityLog Recommendation"
    ACTIVITY_LOG_POLICY = "ActivityLog Policy"
    ACTIVITY_LOG_AUTOSCALE = "ActivityLog Autoscale"
    LOG_ANALYTICS = "Log Analytics"
    NAGIOS = "Nagios"
    PLATFORM = "Platform"
    SCOM = "SCOM"
    SERVICE_HEALTH = "ServiceHealth"
    SMART_DETECTOR = "SmartDetector"
    VM_INSIGHTS = "VM Insights"
    ZABBIX = "Zabbix"

class Operator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """operator for a given condition
    """

    EQUALS = "Equals"
    NOT_EQUALS = "NotEquals"
    CONTAINS = "Contains"
    DOES_NOT_CONTAIN = "DoesNotContain"

class ScopeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """type of target scope
    """

    RESOURCE_GROUP = "ResourceGroup"
    RESOURCE = "Resource"
    SUBSCRIPTION = "Subscription"

class Severity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    SEV0 = "Sev0"
    SEV1 = "Sev1"
    SEV2 = "Sev2"
    SEV3 = "Sev3"
    SEV4 = "Sev4"

class SignalType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of signal the alert is based on, which could be metrics, logs or activity logs.
    """

    METRIC = "Metric"
    LOG = "Log"
    UNKNOWN = "Unknown"

class SmartGroupModificationEvent(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Reason for the modification
    """

    SMART_GROUP_CREATED = "SmartGroupCreated"
    STATE_CHANGE = "StateChange"
    ALERT_ADDED = "AlertAdded"
    ALERT_REMOVED = "AlertRemoved"

class SmartGroupsSortByFields(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ALERTS_COUNT = "alertsCount"
    STATE = "state"
    SEVERITY = "severity"
    START_DATE_TIME = "startDateTime"
    LAST_MODIFIED_DATE_TIME = "lastModifiedDateTime"

class State(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Smart group state
    """

    NEW = "New"
    ACKNOWLEDGED = "Acknowledged"
    CLOSED = "Closed"

class SuppressionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies when the suppression should be applied
    """

    ALWAYS = "Always"
    ONCE = "Once"
    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"

class TimeRange(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    ONE_H = "1h"
    ONE_D = "1d"
    SEVEN_D = "7d"
    THIRTY_D = "30d"
