# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AgentConfiguration(_serialization.Model):
    """Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar proxy_url: Specifies the URL of the proxy to be used.
    :vartype proxy_url: str
    :ivar incoming_connections_ports: Specifies the list of ports that the agent will be able to
     listen on.
    :vartype incoming_connections_ports: list[str]
    :ivar extensions_allow_list: Array of extensions that are allowed to be installed or updated.
    :vartype extensions_allow_list: list[~azure.mgmt.hybridcompute.models.ConfigurationExtension]
    :ivar extensions_block_list: Array of extensions that are blocked (cannot be installed or
     updated).
    :vartype extensions_block_list: list[~azure.mgmt.hybridcompute.models.ConfigurationExtension]
    :ivar proxy_bypass: List of service names which should not use the specified proxy server.
    :vartype proxy_bypass: list[str]
    :ivar extensions_enabled: Specifies whether the extension service is enabled or disabled.
    :vartype extensions_enabled: str
    :ivar guest_configuration_enabled: Specified whether the guest configuration service is enabled
     or disabled.
    :vartype guest_configuration_enabled: str
    :ivar config_mode: Name of configuration mode to use. Modes are pre-defined configurations of
     security controls, extension allowlists and guest configuration, maintained by Microsoft. Known
     values are: "full" and "monitor".
    :vartype config_mode: str or ~azure.mgmt.hybridcompute.models.AgentConfigurationMode
    """

    _validation = {
        "proxy_url": {"readonly": True},
        "incoming_connections_ports": {"readonly": True},
        "extensions_allow_list": {"readonly": True},
        "extensions_block_list": {"readonly": True},
        "proxy_bypass": {"readonly": True},
        "extensions_enabled": {"readonly": True},
        "guest_configuration_enabled": {"readonly": True},
        "config_mode": {"readonly": True},
    }

    _attribute_map = {
        "proxy_url": {"key": "proxyUrl", "type": "str"},
        "incoming_connections_ports": {"key": "incomingConnectionsPorts", "type": "[str]"},
        "extensions_allow_list": {"key": "extensionsAllowList", "type": "[ConfigurationExtension]"},
        "extensions_block_list": {"key": "extensionsBlockList", "type": "[ConfigurationExtension]"},
        "proxy_bypass": {"key": "proxyBypass", "type": "[str]"},
        "extensions_enabled": {"key": "extensionsEnabled", "type": "str"},
        "guest_configuration_enabled": {"key": "guestConfigurationEnabled", "type": "str"},
        "config_mode": {"key": "configMode", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.proxy_url = None
        self.incoming_connections_ports = None
        self.extensions_allow_list = None
        self.extensions_block_list = None
        self.proxy_bypass = None
        self.extensions_enabled = None
        self.guest_configuration_enabled = None
        self.config_mode = None


class CloudMetadata(_serialization.Model):
    """The metadata of the cloud environment (Azure/GCP/AWS/OCI...).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Specifies the cloud provider (Azure/AWS/GCP...).
    :vartype provider: str
    """

    _validation = {
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.provider = None


class ConfigurationExtension(_serialization.Model):
    """Describes properties that can identify extensions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher: Publisher of the extension.
    :vartype publisher: str
    :ivar type: Type of the extension.
    :vartype type: str
    """

    _validation = {
        "publisher": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.publisher = None
        self.type = None


class ConnectionDetail(_serialization.Model):
    """ConnectionDetail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar private_ip_address: The private endpoint connection private ip address.
    :vartype private_ip_address: str
    :ivar link_identifier: The private endpoint connection link identifier.
    :vartype link_identifier: str
    :ivar group_id: The private endpoint connection group id.
    :vartype group_id: str
    :ivar member_name: The private endpoint connection member name.
    :vartype member_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "private_ip_address": {"readonly": True},
        "link_identifier": {"readonly": True},
        "group_id": {"readonly": True},
        "member_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "private_ip_address": {"key": "privateIpAddress", "type": "str"},
        "link_identifier": {"key": "linkIdentifier", "type": "str"},
        "group_id": {"key": "groupId", "type": "str"},
        "member_name": {"key": "memberName", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.private_ip_address = None
        self.link_identifier = None
        self.group_id = None
        self.member_name = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridcompute.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorDetailAutoGenerated(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.hybridcompute.models.ErrorDetailAutoGenerated]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.hybridcompute.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetailAutoGenerated]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridcompute.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hybridcompute.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseAutoGenerated(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.hybridcompute.models.ErrorDetailAutoGenerated
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetailAutoGenerated"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetailAutoGenerated"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.hybridcompute.models.ErrorDetailAutoGenerated
        """
        super().__init__(**kwargs)
        self.error = error


class ExtensionTargetProperties(_serialization.Model):
    """Describes the Machine Extension Target Version Properties.

    :ivar target_version: Properties for the specified Extension to Upgrade.
    :vartype target_version: str
    """

    _attribute_map = {
        "target_version": {"key": "targetVersion", "type": "str"},
    }

    def __init__(self, *, target_version: Optional[str] = None, **kwargs):
        """
        :keyword target_version: Properties for the specified Extension to Upgrade.
        :paramtype target_version: str
        """
        super().__init__(**kwargs)
        self.target_version = target_version


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)


class ExtensionValue(ProxyResource):
    """Describes a Extension Metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar version: The version of the Extension being received.
    :vartype version: str
    :ivar extension_type: The type of the Extension being received.
    :vartype extension_type: str
    :ivar publisher: The publisher of the Extension being received.
    :vartype publisher: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "version": {"readonly": True},
        "extension_type": {"readonly": True},
        "publisher": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "version": {"key": "properties.version", "type": "str"},
        "extension_type": {"key": "properties.extensionType", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.extension_type = None
        self.publisher = None


class ExtensionValueListResult(_serialization.Model):
    """The List Extension Metadata response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of extension metadata.
    :vartype value: list[~azure.mgmt.hybridcompute.models.ExtensionValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtensionValue]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class PrivateLinkScopesResource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class HybridComputePrivateLinkScope(PrivateLinkScopesResource):
    """An Azure Arc PrivateLinkScope definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: Properties that define a Azure Arc PrivateLinkScope resource.
    :vartype properties: ~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScopeProperties
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "HybridComputePrivateLinkScopeProperties"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.HybridComputePrivateLinkScopeProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties that define a Azure Arc PrivateLinkScope resource.
        :paramtype properties: ~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScopeProperties
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.system_data = None


class HybridComputePrivateLinkScopeListResult(_serialization.Model):
    """Describes the list of Azure Arc PrivateLinkScope resources.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of Azure Arc PrivateLinkScope definitions. Required.
    :vartype value: list[~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScope]
    :ivar next_link: The URI to get the next set of Azure Arc PrivateLinkScope definitions if too
     many PrivateLinkScopes where returned in the result set.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HybridComputePrivateLinkScope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.HybridComputePrivateLinkScope"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: List of Azure Arc PrivateLinkScope definitions. Required.
        :paramtype value: list[~azure.mgmt.hybridcompute.models.HybridComputePrivateLinkScope]
        :keyword next_link: The URI to get the next set of Azure Arc PrivateLinkScope definitions if
         too many PrivateLinkScopes where returned in the result set.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class HybridComputePrivateLinkScopeProperties(_serialization.Model):
    """Properties that define a Azure Arc PrivateLinkScope resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_network_access: Indicates whether machines associated with the private link scope
     can also use public Azure Arc service endpoints. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
    :ivar provisioning_state: Current state of this PrivateLinkScope: whether or not is has been
     provisioned within the resource group it is defined. Users cannot change this value but are
     able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed.
    :vartype provisioning_state: str
    :ivar private_link_scope_id: The Guid id of the private link scope.
    :vartype private_link_scope_id: str
    :ivar private_endpoint_connections: The collection of associated Private Endpoint Connections.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionDataModel]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "private_link_scope_id": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_link_scope_id": {"key": "privateLinkScopeId", "type": "str"},
        "private_endpoint_connections": {
            "key": "privateEndpointConnections",
            "type": "[PrivateEndpointConnectionDataModel]",
        },
    }

    def __init__(self, *, public_network_access: Union[str, "_models.PublicNetworkAccessType"] = "Disabled", **kwargs):
        """
        :keyword public_network_access: Indicates whether machines associated with the private link
         scope can also use public Azure Arc service endpoints. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
        """
        super().__init__(**kwargs)
        self.public_network_access = public_network_access
        self.provisioning_state = None
        self.private_link_scope_id = None
        self.private_endpoint_connections = None


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Default value is "SystemAssigned".
    :vartype type: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Literal["SystemAssigned"]] = None, **kwargs):
        """
        :keyword type: The identity type. Default value is "SystemAssigned".
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class LocationData(_serialization.Model):
    """Metadata pertaining to the geographic location of the resource.

    All required parameters must be populated in order to send to Azure.

    :ivar name: A canonical name for the geographic or physical location. Required.
    :vartype name: str
    :ivar city: The city or locality where the resource is located.
    :vartype city: str
    :ivar district: The district, state, or province where the resource is located.
    :vartype district: str
    :ivar country_or_region: The country or region where the resource is located.
    :vartype country_or_region: str
    """

    _validation = {
        "name": {"required": True, "max_length": 256},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "district": {"key": "district", "type": "str"},
        "country_or_region": {"key": "countryOrRegion", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        city: Optional[str] = None,
        district: Optional[str] = None,
        country_or_region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: A canonical name for the geographic or physical location. Required.
        :paramtype name: str
        :keyword city: The city or locality where the resource is located.
        :paramtype city: str
        :keyword district: The district, state, or province where the resource is located.
        :paramtype district: str
        :keyword country_or_region: The country or region where the resource is located.
        :paramtype country_or_region: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.city = city
        self.district = district
        self.country_or_region = country_or_region


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class Machine(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Describes a hybrid machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar resources: The list of extensions affiliated to the machine.
    :vartype resources: list[~azure.mgmt.hybridcompute.models.MachineExtension]
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.hybridcompute.models.Identity
    :ivar location_data: Metadata pertaining to the geographic location of the resource.
    :vartype location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :ivar agent_configuration: Configurable properties that the user can set locally via the
     azcmagent config command, or remotely via ARM.
    :vartype agent_configuration: ~azure.mgmt.hybridcompute.models.AgentConfiguration
    :ivar service_statuses: Statuses of dependent services that are reported back to ARM.
    :vartype service_statuses: ~azure.mgmt.hybridcompute.models.ServiceStatuses
    :ivar cloud_metadata: The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
    :vartype cloud_metadata: ~azure.mgmt.hybridcompute.models.CloudMetadata
    :ivar os_profile: Specifies the operating system settings for the hybrid machine.
    :vartype os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar status: The status of the hybrid machine agent. Known values are: "Connected",
     "Disconnected", and "Error".
    :vartype status: str or ~azure.mgmt.hybridcompute.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: ~datetime.datetime
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :ivar vm_id: Specifies the hybrid machine unique ID.
    :vartype vm_id: str
    :ivar display_name: Specifies the hybrid machine display name.
    :vartype display_name: str
    :ivar machine_fqdn: Specifies the hybrid machine FQDN.
    :vartype machine_fqdn: str
    :ivar client_public_key: Public Key that the client provides to be used during initial resource
     onboarding.
    :vartype client_public_key: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid machine.
    :vartype os_version: str
    :ivar os_type: The type of Operating System (windows/linux).
    :vartype os_type: str
    :ivar vm_uuid: Specifies the Arc Machine's unique SMBIOS ID.
    :vartype vm_uuid: str
    :ivar os_sku: Specifies the Operating System product SKU.
    :vartype os_sku: str
    :ivar domain_name: Specifies the Windows domain name.
    :vartype domain_name: str
    :ivar ad_fqdn: Specifies the AD fully qualified display name.
    :vartype ad_fqdn: str
    :ivar dns_fqdn: Specifies the DNS fully qualified display name.
    :vartype dns_fqdn: str
    :ivar private_link_scope_resource_id: The resource id of the private link scope this machine is
     assigned to, if any.
    :vartype private_link_scope_resource_id: str
    :ivar parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
     machine is assigned to, if any.
    :vartype parent_cluster_resource_id: str
    :ivar mssql_discovered: Specifies whether any MS SQL instance is discovered on the machine.
    :vartype mssql_discovered: str
    :ivar detected_properties: Detected properties from the machine.
    :vartype detected_properties: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "resources": {"readonly": True},
        "agent_configuration": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "last_status_change": {"readonly": True},
        "error_details": {"readonly": True},
        "agent_version": {"readonly": True},
        "display_name": {"readonly": True},
        "machine_fqdn": {"readonly": True},
        "os_name": {"readonly": True},
        "os_version": {"readonly": True},
        "vm_uuid": {"readonly": True},
        "os_sku": {"readonly": True},
        "domain_name": {"readonly": True},
        "ad_fqdn": {"readonly": True},
        "dns_fqdn": {"readonly": True},
        "detected_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "resources": {"key": "resources", "type": "[MachineExtension]"},
        "identity": {"key": "identity", "type": "Identity"},
        "location_data": {"key": "properties.locationData", "type": "LocationData"},
        "agent_configuration": {"key": "properties.agentConfiguration", "type": "AgentConfiguration"},
        "service_statuses": {"key": "properties.serviceStatuses", "type": "ServiceStatuses"},
        "cloud_metadata": {"key": "properties.cloudMetadata", "type": "CloudMetadata"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "last_status_change": {"key": "properties.lastStatusChange", "type": "iso-8601"},
        "error_details": {"key": "properties.errorDetails", "type": "[ErrorDetail]"},
        "agent_version": {"key": "properties.agentVersion", "type": "str"},
        "vm_id": {"key": "properties.vmId", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "machine_fqdn": {"key": "properties.machineFqdn", "type": "str"},
        "client_public_key": {"key": "properties.clientPublicKey", "type": "str"},
        "os_name": {"key": "properties.osName", "type": "str"},
        "os_version": {"key": "properties.osVersion", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "vm_uuid": {"key": "properties.vmUuid", "type": "str"},
        "os_sku": {"key": "properties.osSku", "type": "str"},
        "domain_name": {"key": "properties.domainName", "type": "str"},
        "ad_fqdn": {"key": "properties.adFqdn", "type": "str"},
        "dns_fqdn": {"key": "properties.dnsFqdn", "type": "str"},
        "private_link_scope_resource_id": {"key": "properties.privateLinkScopeResourceId", "type": "str"},
        "parent_cluster_resource_id": {"key": "properties.parentClusterResourceId", "type": "str"},
        "mssql_discovered": {"key": "properties.mssqlDiscovered", "type": "str"},
        "detected_properties": {"key": "properties.detectedProperties", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        location_data: Optional["_models.LocationData"] = None,
        service_statuses: Optional["_models.ServiceStatuses"] = None,
        cloud_metadata: Optional["_models.CloudMetadata"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        vm_id: Optional[str] = None,
        client_public_key: Optional[str] = None,
        os_type: Optional[str] = None,
        private_link_scope_resource_id: Optional[str] = None,
        parent_cluster_resource_id: Optional[str] = None,
        mssql_discovered: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.hybridcompute.models.Identity
        :keyword location_data: Metadata pertaining to the geographic location of the resource.
        :paramtype location_data: ~azure.mgmt.hybridcompute.models.LocationData
        :keyword service_statuses: Statuses of dependent services that are reported back to ARM.
        :paramtype service_statuses: ~azure.mgmt.hybridcompute.models.ServiceStatuses
        :keyword cloud_metadata: The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
        :paramtype cloud_metadata: ~azure.mgmt.hybridcompute.models.CloudMetadata
        :keyword os_profile: Specifies the operating system settings for the hybrid machine.
        :paramtype os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
        :keyword vm_id: Specifies the hybrid machine unique ID.
        :paramtype vm_id: str
        :keyword client_public_key: Public Key that the client provides to be used during initial
         resource onboarding.
        :paramtype client_public_key: str
        :keyword os_type: The type of Operating System (windows/linux).
        :paramtype os_type: str
        :keyword private_link_scope_resource_id: The resource id of the private link scope this machine
         is assigned to, if any.
        :paramtype private_link_scope_resource_id: str
        :keyword parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
         machine is assigned to, if any.
        :paramtype parent_cluster_resource_id: str
        :keyword mssql_discovered: Specifies whether any MS SQL instance is discovered on the machine.
        :paramtype mssql_discovered: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.resources = None
        self.identity = identity
        self.location_data = location_data
        self.agent_configuration = None
        self.service_statuses = service_statuses
        self.cloud_metadata = cloud_metadata
        self.os_profile = os_profile
        self.provisioning_state = None
        self.status = None
        self.last_status_change = None
        self.error_details = None
        self.agent_version = None
        self.vm_id = vm_id
        self.display_name = None
        self.machine_fqdn = None
        self.client_public_key = client_public_key
        self.os_name = None
        self.os_version = None
        self.os_type = os_type
        self.vm_uuid = None
        self.os_sku = None
        self.domain_name = None
        self.ad_fqdn = None
        self.dns_fqdn = None
        self.private_link_scope_resource_id = private_link_scope_resource_id
        self.parent_cluster_resource_id = parent_cluster_resource_id
        self.mssql_discovered = mssql_discovered
        self.detected_properties = None


class MachineExtension(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Describes a Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type_properties_type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version available.
    :vartype enable_automatic_upgrade: bool
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: dict[str, any]
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: dict[str, any]
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The machine extension instance view.
    :vartype instance_view: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "{object}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "instance_view": {"key": "properties.instanceView", "type": "MachineExtensionInstanceView"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        protected_settings: Optional[Dict[str, Any]] = None,
        instance_view: Optional["_models.MachineExtensionInstanceView"] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type_properties_type: Specifies the type of the extension; an example is
         "CustomScriptExtension".
        :paramtype type_properties_type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version available.
        :paramtype enable_automatic_upgrade: bool
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: dict[str, any]
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: dict[str, any]
        :keyword instance_view: The machine extension instance view.
        :paramtype instance_view: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class MachineExtensionInstanceView(_serialization.Model):
    """Describes the Machine Extension Instance View.

    :ivar name: The machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar status: Instance view status.
    :vartype status: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_handler_version": {"key": "typeHandlerVersion", "type": "str"},
        "status": {"key": "status", "type": "MachineExtensionInstanceViewStatus"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["_models.MachineExtensionInstanceViewStatus"] = None,
        **kwargs
    ):
        """
        :keyword name: The machine extension name.
        :paramtype name: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword status: Instance view status.
        :paramtype status: ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class MachineExtensionInstanceViewStatus(_serialization.Model):
    """Instance view status.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Known values are: "Info", "Warning", and "Error".
    :vartype level: str or ~azure.mgmt.hybridcompute.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "level": {"key": "level", "type": "str"},
        "display_status": {"key": "displayStatus", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "time": {"key": "time", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "_models.StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword code: The status code.
        :paramtype code: str
        :keyword level: The level code. Known values are: "Info", "Warning", and "Error".
        :paramtype level: str or ~azure.mgmt.hybridcompute.models.StatusLevelTypes
        :keyword display_status: The short localizable label for the status.
        :paramtype display_status: str
        :keyword message: The detailed status message, including for alerts and error messages.
        :paramtype message: str
        :keyword time: The time of the status.
        :paramtype time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class MachineExtensionsListResult(_serialization.Model):
    """Describes the Machine Extensions List Result.

    :ivar value: The list of extensions.
    :vartype value: list[~azure.mgmt.hybridcompute.models.MachineExtension]
    :ivar next_link: The uri to fetch the next page of machine extensions. Call ListNext() with
     this to fetch the next page of extensions.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MachineExtension]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MachineExtension"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: The list of extensions.
        :paramtype value: list[~azure.mgmt.hybridcompute.models.MachineExtension]
        :keyword next_link: The uri to fetch the next page of machine extensions. Call ListNext() with
         this to fetch the next page of extensions.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceUpdate(_serialization.Model):
    """The Update Resource model definition.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class MachineExtensionUpdate(ResourceUpdate):
    """Describes a Machine Extension Update.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :vartype force_update_tag: str
    :ivar publisher: The name of the extension handler publisher.
    :vartype publisher: str
    :ivar type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :ivar enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version available.
    :vartype enable_automatic_upgrade: bool
    :ivar auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :vartype auto_upgrade_minor_version: bool
    :ivar settings: Json formatted public settings for the extension.
    :vartype settings: dict[str, any]
    :ivar protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :vartype protected_settings: dict[str, any]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "force_update_tag": {"key": "properties.forceUpdateTag", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "type": {"key": "properties.type", "type": "str"},
        "type_handler_version": {"key": "properties.typeHandlerVersion", "type": "str"},
        "enable_automatic_upgrade": {"key": "properties.enableAutomaticUpgrade", "type": "bool"},
        "auto_upgrade_minor_version": {"key": "properties.autoUpgradeMinorVersion", "type": "bool"},
        "settings": {"key": "properties.settings", "type": "{object}"},
        "protected_settings": {"key": "properties.protectedSettings", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[Dict[str, Any]] = None,
        protected_settings: Optional[Dict[str, Any]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword force_update_tag: How the extension handler should be forced to update even if the
         extension configuration has not changed.
        :paramtype force_update_tag: str
        :keyword publisher: The name of the extension handler publisher.
        :paramtype publisher: str
        :keyword type: Specifies the type of the extension; an example is "CustomScriptExtension".
        :paramtype type: str
        :keyword type_handler_version: Specifies the version of the script handler.
        :paramtype type_handler_version: str
        :keyword enable_automatic_upgrade: Indicates whether the extension should be automatically
         upgraded by the platform if there is a newer version available.
        :paramtype enable_automatic_upgrade: bool
        :keyword auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
         version if one is available at deployment time. Once deployed, however, the extension will not
         upgrade minor versions unless redeployed, even with this property set to true.
        :paramtype auto_upgrade_minor_version: bool
        :keyword settings: Json formatted public settings for the extension.
        :paramtype settings: dict[str, any]
        :keyword protected_settings: The extension can contain either protectedSettings or
         protectedSettingsFromKeyVault or no protected settings at all.
        :paramtype protected_settings: dict[str, any]
        """
        super().__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings


class MachineExtensionUpgrade(_serialization.Model):
    """Describes the Machine Extension Upgrade Properties.

    :ivar extension_targets: Describes the Extension Target Properties.
    :vartype extension_targets: dict[str,
     ~azure.mgmt.hybridcompute.models.ExtensionTargetProperties]
    """

    _attribute_map = {
        "extension_targets": {"key": "extensionTargets", "type": "{ExtensionTargetProperties}"},
    }

    def __init__(self, *, extension_targets: Optional[Dict[str, "_models.ExtensionTargetProperties"]] = None, **kwargs):
        """
        :keyword extension_targets: Describes the Extension Target Properties.
        :paramtype extension_targets: dict[str,
         ~azure.mgmt.hybridcompute.models.ExtensionTargetProperties]
        """
        super().__init__(**kwargs)
        self.extension_targets = extension_targets


class MachineListResult(_serialization.Model):
    """The List hybrid machine operation response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The list of hybrid machines. Required.
    :vartype value: list[~azure.mgmt.hybridcompute.models.Machine]
    :ivar next_link: The URI to fetch the next page of Machines. Call ListNext() with this URI to
     fetch the next page of hybrid machines.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Machine]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Machine"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword value: The list of hybrid machines. Required.
        :paramtype value: list[~azure.mgmt.hybridcompute.models.Machine]
        :keyword next_link: The URI to fetch the next page of Machines. Call ListNext() with this URI
         to fetch the next page of hybrid machines.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MachineUpdate(ResourceUpdate):
    """Describes a hybrid machine Update.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Identity for the resource.
    :vartype identity: ~azure.mgmt.hybridcompute.models.Identity
    :ivar location_data: Metadata pertaining to the geographic location of the resource.
    :vartype location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :ivar os_profile: Specifies the operating system settings for the hybrid machine.
    :vartype os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
    :ivar cloud_metadata: The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
    :vartype cloud_metadata: ~azure.mgmt.hybridcompute.models.CloudMetadata
    :ivar parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
     machine is assigned to, if any.
    :vartype parent_cluster_resource_id: str
    :ivar private_link_scope_resource_id: The resource id of the private link scope this machine is
     assigned to, if any.
    :vartype private_link_scope_resource_id: str
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "location_data": {"key": "properties.locationData", "type": "LocationData"},
        "os_profile": {"key": "properties.osProfile", "type": "OSProfile"},
        "cloud_metadata": {"key": "properties.cloudMetadata", "type": "CloudMetadata"},
        "parent_cluster_resource_id": {"key": "properties.parentClusterResourceId", "type": "str"},
        "private_link_scope_resource_id": {"key": "properties.privateLinkScopeResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.Identity"] = None,
        location_data: Optional["_models.LocationData"] = None,
        os_profile: Optional["_models.OSProfile"] = None,
        cloud_metadata: Optional["_models.CloudMetadata"] = None,
        parent_cluster_resource_id: Optional[str] = None,
        private_link_scope_resource_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity for the resource.
        :paramtype identity: ~azure.mgmt.hybridcompute.models.Identity
        :keyword location_data: Metadata pertaining to the geographic location of the resource.
        :paramtype location_data: ~azure.mgmt.hybridcompute.models.LocationData
        :keyword os_profile: Specifies the operating system settings for the hybrid machine.
        :paramtype os_profile: ~azure.mgmt.hybridcompute.models.OSProfile
        :keyword cloud_metadata: The metadata of the cloud environment (Azure/GCP/AWS/OCI...).
        :paramtype cloud_metadata: ~azure.mgmt.hybridcompute.models.CloudMetadata
        :keyword parent_cluster_resource_id: The resource id of the parent cluster (Azure HCI) this
         machine is assigned to, if any.
        :paramtype parent_cluster_resource_id: str
        :keyword private_link_scope_resource_id: The resource id of the private link scope this machine
         is assigned to, if any.
        :paramtype private_link_scope_resource_id: str
        """
        super().__init__(tags=tags, **kwargs)
        self.identity = identity
        self.location_data = location_data
        self.os_profile = os_profile
        self.cloud_metadata = cloud_metadata
        self.parent_cluster_resource_id = parent_cluster_resource_id
        self.private_link_scope_resource_id = private_link_scope_resource_id


class OperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.hybridcompute.models.OperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationValue]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None


class OperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar display: Display properties.
    :vartype display: ~azure.mgmt.hybridcompute.models.OperationValueDisplay
    :ivar is_data_action: This property indicates if the operation is an action or a data action.
    :vartype is_data_action: bool
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationValueDisplay"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(self, *, display: Optional["_models.OperationValueDisplay"] = None, **kwargs):
        """
        :keyword display: Display properties.
        :paramtype display: ~azure.mgmt.hybridcompute.models.OperationValueDisplay
        """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.display = display
        self.is_data_action = None


class OperationValueDisplay(_serialization.Model):
    """Describes the properties of a Hybrid Compute Operation Value Display.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "operation": {"key": "operation", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OSProfile(_serialization.Model):
    """Specifies the operating system settings for the hybrid machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar computer_name: Specifies the host OS name of the hybrid machine.
    :vartype computer_name: str
    :ivar windows_configuration: Specifies the windows configuration for update management.
    :vartype windows_configuration: ~azure.mgmt.hybridcompute.models.OSProfileWindowsConfiguration
    :ivar linux_configuration: Specifies the linux configuration for update management.
    :vartype linux_configuration: ~azure.mgmt.hybridcompute.models.OSProfileLinuxConfiguration
    """

    _validation = {
        "computer_name": {"readonly": True},
    }

    _attribute_map = {
        "computer_name": {"key": "computerName", "type": "str"},
        "windows_configuration": {"key": "windowsConfiguration", "type": "OSProfileWindowsConfiguration"},
        "linux_configuration": {"key": "linuxConfiguration", "type": "OSProfileLinuxConfiguration"},
    }

    def __init__(
        self,
        *,
        windows_configuration: Optional["_models.OSProfileWindowsConfiguration"] = None,
        linux_configuration: Optional["_models.OSProfileLinuxConfiguration"] = None,
        **kwargs
    ):
        """
        :keyword windows_configuration: Specifies the windows configuration for update management.
        :paramtype windows_configuration:
         ~azure.mgmt.hybridcompute.models.OSProfileWindowsConfiguration
        :keyword linux_configuration: Specifies the linux configuration for update management.
        :paramtype linux_configuration: ~azure.mgmt.hybridcompute.models.OSProfileLinuxConfiguration
        """
        super().__init__(**kwargs)
        self.computer_name = None
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration


class OSProfileLinuxConfiguration(_serialization.Model):
    """Specifies the linux configuration for update management.

    :ivar assessment_mode: Specifies the assessment mode. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.hybridcompute.models.AssessmentModeTypes
    :ivar patch_mode: Specifies the patch mode. Known values are: "ImageDefault",
     "AutomaticByPlatform", "AutomaticByOS", and "Manual".
    :vartype patch_mode: str or ~azure.mgmt.hybridcompute.models.PatchModeTypes
    """

    _attribute_map = {
        "assessment_mode": {"key": "patchSettings.assessmentMode", "type": "str"},
        "patch_mode": {"key": "patchSettings.patchMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        assessment_mode: Optional[Union[str, "_models.AssessmentModeTypes"]] = None,
        patch_mode: Optional[Union[str, "_models.PatchModeTypes"]] = None,
        **kwargs
    ):
        """
        :keyword assessment_mode: Specifies the assessment mode. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype assessment_mode: str or ~azure.mgmt.hybridcompute.models.AssessmentModeTypes
        :keyword patch_mode: Specifies the patch mode. Known values are: "ImageDefault",
         "AutomaticByPlatform", "AutomaticByOS", and "Manual".
        :paramtype patch_mode: str or ~azure.mgmt.hybridcompute.models.PatchModeTypes
        """
        super().__init__(**kwargs)
        self.assessment_mode = assessment_mode
        self.patch_mode = patch_mode


class OSProfileWindowsConfiguration(_serialization.Model):
    """Specifies the windows configuration for update management.

    :ivar assessment_mode: Specifies the assessment mode. Known values are: "ImageDefault" and
     "AutomaticByPlatform".
    :vartype assessment_mode: str or ~azure.mgmt.hybridcompute.models.AssessmentModeTypes
    :ivar patch_mode: Specifies the patch mode. Known values are: "ImageDefault",
     "AutomaticByPlatform", "AutomaticByOS", and "Manual".
    :vartype patch_mode: str or ~azure.mgmt.hybridcompute.models.PatchModeTypes
    """

    _attribute_map = {
        "assessment_mode": {"key": "patchSettings.assessmentMode", "type": "str"},
        "patch_mode": {"key": "patchSettings.patchMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        assessment_mode: Optional[Union[str, "_models.AssessmentModeTypes"]] = None,
        patch_mode: Optional[Union[str, "_models.PatchModeTypes"]] = None,
        **kwargs
    ):
        """
        :keyword assessment_mode: Specifies the assessment mode. Known values are: "ImageDefault" and
         "AutomaticByPlatform".
        :paramtype assessment_mode: str or ~azure.mgmt.hybridcompute.models.AssessmentModeTypes
        :keyword patch_mode: Specifies the patch mode. Known values are: "ImageDefault",
         "AutomaticByPlatform", "AutomaticByOS", and "Manual".
        :paramtype patch_mode: str or ~azure.mgmt.hybridcompute.models.PatchModeTypes
        """
        super().__init__(**kwargs)
        self.assessment_mode = assessment_mode
        self.patch_mode = patch_mode


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateEndpointConnectionProperties"] = None, **kwargs):
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateEndpointConnectionDataModel(_serialization.Model):
    """The Data Model for a Private Endpoint Connection associated with a Private Link Scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM Resource Id of the Private Endpoint.
    :vartype id: str
    :ivar name: The Name of the Private Endpoint.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar properties: The Private Endpoint Connection properties.
    :vartype properties: ~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateEndpointConnectionProperties"] = None, **kwargs):
        """
        :keyword properties: The Private Endpoint Connection properties.
        :paramtype properties: ~azure.mgmt.hybridcompute.models.PrivateEndpointConnectionProperties
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.hybridcompute.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.hybridcompute.models.PrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.hybridcompute.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    :ivar group_ids: List of group IDs.
    :vartype group_ids: list[str]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "group_ids": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpointProperty"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs
    ):
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.hybridcompute.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.hybridcompute.models.PrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None
        self.group_ids = None


class PrivateEndpointProperty(_serialization.Model):
    """Private endpoint which the connection belongs to.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.hybridcompute.models.SystemData
    :ivar properties: Resource properties.
    :vartype properties: ~azure.mgmt.hybridcompute.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.PrivateLinkResourceProperties"] = None, **kwargs):
        """
        :keyword properties: Resource properties.
        :paramtype properties: ~azure.mgmt.hybridcompute.models.PrivateLinkResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.hybridcompute.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: Required DNS zone names of the the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkScopeValidationDetails(_serialization.Model):
    """PrivateLinkScopeValidationDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar public_network_access: Indicates whether machines associated with the private link scope
     can also use public Azure Arc service endpoints. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
    :ivar connection_details: List of Private Endpoint Connection details.
    :vartype connection_details: list[~azure.mgmt.hybridcompute.models.ConnectionDetail]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "connection_details": {"key": "connectionDetails", "type": "[ConnectionDetail]"},
    }

    def __init__(
        self,
        *,
        public_network_access: Union[str, "_models.PublicNetworkAccessType"] = "Disabled",
        connection_details: Optional[List["_models.ConnectionDetail"]] = None,
        **kwargs
    ):
        """
        :keyword public_network_access: Indicates whether machines associated with the private link
         scope can also use public Azure Arc service endpoints. Known values are: "Enabled" and
         "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.hybridcompute.models.PublicNetworkAccessType
        :keyword connection_details: List of Private Endpoint Connection details.
        :paramtype connection_details: list[~azure.mgmt.hybridcompute.models.ConnectionDetail]
        """
        super().__init__(**kwargs)
        self.id = None
        self.public_network_access = public_network_access
        self.connection_details = connection_details


class PrivateLinkServiceConnectionStateProperty(_serialization.Model):
    """State of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar status: The private link service connection status. Required.
    :vartype status: str
    :ivar description: The private link service connection description. Required.
    :vartype description: str
    :ivar actions_required: The actions required for private link service connection.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(self, *, status: str, description: str, **kwargs):
        """
        :keyword status: The private link service connection status. Required.
        :paramtype status: str
        :keyword description: The private link service connection description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ServiceStatus(_serialization.Model):
    """Describes the status and behavior of a service.

    :ivar status: The current status of the service.
    :vartype status: str
    :ivar startup_type: The behavior of the service when the Arc-enabled machine starts up.
    :vartype startup_type: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "startup_type": {"key": "startupType", "type": "str"},
    }

    def __init__(self, *, status: Optional[str] = None, startup_type: Optional[str] = None, **kwargs):
        """
        :keyword status: The current status of the service.
        :paramtype status: str
        :keyword startup_type: The behavior of the service when the Arc-enabled machine starts up.
        :paramtype startup_type: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.startup_type = startup_type


class ServiceStatuses(_serialization.Model):
    """Reports the state and behavior of dependent services.

    :ivar extension_service: The state of the extension service on the Arc-enabled machine.
    :vartype extension_service: ~azure.mgmt.hybridcompute.models.ServiceStatus
    :ivar guest_configuration_service: The state of the guest configuration service on the
     Arc-enabled machine.
    :vartype guest_configuration_service: ~azure.mgmt.hybridcompute.models.ServiceStatus
    """

    _attribute_map = {
        "extension_service": {"key": "extensionService", "type": "ServiceStatus"},
        "guest_configuration_service": {"key": "guestConfigurationService", "type": "ServiceStatus"},
    }

    def __init__(
        self,
        *,
        extension_service: Optional["_models.ServiceStatus"] = None,
        guest_configuration_service: Optional["_models.ServiceStatus"] = None,
        **kwargs
    ):
        """
        :keyword extension_service: The state of the extension service on the Arc-enabled machine.
        :paramtype extension_service: ~azure.mgmt.hybridcompute.models.ServiceStatus
        :keyword guest_configuration_service: The state of the guest configuration service on the
         Arc-enabled machine.
        :paramtype guest_configuration_service: ~azure.mgmt.hybridcompute.models.ServiceStatus
        """
        super().__init__(**kwargs)
        self.extension_service = extension_service
        self.guest_configuration_service = guest_configuration_service


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.hybridcompute.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on a PrivateLinkScope instance.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
