/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.lists.VoidConsumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrongArguments;
import gnu.text.Path;
import gnu.text.SourceError;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import kawa.standard.load;

public class Shell {
    private static Class[] noClasses = new Class[0];
    private static Class[] boolClasses = new Class[]{Boolean.TYPE};
    private static Class[] xmlPrinterClasses = new Class[]{class$gnu$mapping$OutPort == null ? (class$gnu$mapping$OutPort = Shell.class$("gnu.mapping.OutPort")) : class$gnu$mapping$OutPort, class$java$lang$Object == null ? (class$java$lang$Object = Shell.class$("java.lang.Object")) : class$java$lang$Object};
    private static Class[] httpPrinterClasses = new Class[]{class$gnu$mapping$OutPort == null ? (class$gnu$mapping$OutPort = Shell.class$("gnu.mapping.OutPort")) : class$gnu$mapping$OutPort};
    private static Object portArg = "(port)";
    static Object[][] formats = new Object[][]{{"scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.FALSE}, {"readable-scheme", "gnu.kawa.functions.DisplayFormat", "getSchemeFormat", boolClasses, Boolean.TRUE}, {"elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.FALSE}, {"readable-elisp", "gnu.kawa.functions.DisplayFormat", "getEmacsLispFormat", boolClasses, Boolean.TRUE}, {"clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-clisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.FALSE}, {"readable-commonlisp", "gnu.kawa.functions.DisplayFormat", "getCommonLispFormat", boolClasses, Boolean.TRUE}, {"xml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, null}, {"html", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "html"}, {"xhtml", "gnu.xml.XMLPrinter", "make", xmlPrinterClasses, portArg, "xhtml"}, {"cgi", "gnu.kawa.xml.HttpPrinter", "make", httpPrinterClasses, portArg}, {"ignore", "gnu.lists.VoidConsumer", "getInstance", noClasses}, {null}};
    public static String defaultFormatName;
    public static Object[] defaultFormatInfo;
    public static Method defaultFormatMethod;
    static /* synthetic */ Class class$gnu$mapping$OutPort;
    static /* synthetic */ Class class$java$lang$Object;

    public static void setDefaultFormat(String name) {
        defaultFormatName = name = name.intern();
        int i = 0;
        while (true) {
            Object[] info;
            Object iname;
            if ((iname = (info = formats[i])[0]) == null) {
                System.err.println("kawa: unknown output format '" + name + "'");
                System.exit(-1);
            } else if (iname == name) {
                defaultFormatInfo = info;
                try {
                    Class<?> formatClass = Class.forName((String)info[1]);
                    defaultFormatMethod = formatClass.getMethod((String)info[2], (Class[])info[3]);
                }
                catch (Throwable ex) {
                    System.err.println("kawa:  caught " + ex + " while looking for format '" + name + "'");
                    System.exit(-1);
                }
                break;
            }
            ++i;
        }
        if (!defaultFormatInfo[1].equals("gnu.lists.VoidConsumer")) {
            ModuleBody.setMainPrintValues(true);
        }
    }

    public static Consumer getOutputConsumer(OutPort out) {
        Object[] info = defaultFormatInfo;
        if (out == null) {
            return VoidConsumer.getInstance();
        }
        if (info == null) {
            return Language.getDefaultLanguage().getOutputConsumer(out);
        }
        try {
            Object[] args = new Object[info.length - 4];
            System.arraycopy(info, 4, args, 0, args.length);
            int i = args.length;
            while (--i >= 0) {
                if (args[i] != portArg) continue;
                args[i] = out;
            }
            Object format = defaultFormatMethod.invoke(null, args);
            if (format instanceof AbstractFormat) {
                out.objectFormat = (AbstractFormat)format;
                return out;
            }
            return (Consumer)format;
        }
        catch (Throwable ex) {
            throw new RuntimeException("cannot get output-format '" + defaultFormatName + "' - caught " + ex);
        }
    }

    public static void run(Language language, Environment env) {
        Procedure prompter;
        InPort inp = InPort.inDefault();
        if (inp instanceof TtyInPort && (prompter = language.getPrompter()) != null) {
            ((TtyInPort)inp).setPrompter(prompter);
        }
        Shell.run(language, env, inp, OutPort.outDefault(), OutPort.errDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(Language language, Environment env, InPort inp, OutPort pout, OutPort perr) {
        AbstractFormat saveFormat = null;
        if (pout != null) {
            saveFormat = pout.objectFormat;
        }
        Consumer out = Shell.getOutputConsumer(pout);
        try {
            Shell.run(language, env, inp, out, perr, null);
        }
        finally {
            if (pout != null) {
                pout.objectFormat = saveFormat;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void run(Language language, Environment env, InPort inp, Consumer out, OutPort perr, URL url) {
        messages = new SourceMessages();
        saveLanguage = Language.getDefaultLanguage();
        lexer = language.getLexer(inp, messages);
        interactive = inp instanceof TtyInPort;
        lexer.setInteractive(interactive);
        ctx = CallContext.getInstance();
        saveConsumer = null;
        if (out != null) {
            saveConsumer = ctx.consumer;
            ctx.consumer = out;
        }
        if (language != saveLanguage) {
            Language.setDefaultLanguage(language);
        }
        try {
            while (true) {
                opts = 3;
                try {
                    comp = language.parse(lexer, opts, null);
                    sawError = messages.checkErrors(perr, 20);
                    if (comp == null) break;
                    if (sawError) continue;
                    comp.getModule().setName("atInteractiveLevel$" + ++ModuleExp.interactiveCounter);
                    while ((ch = inp.read()) >= 0 && ch != 13 && ch != 10) {
                        if (ch == 32 || ch == 9) continue;
                        inp.unread();
                        break;
                    }
                    if (!ModuleExp.evalModule(env, ctx, comp, url, perr)) continue;
                    if (out instanceof Writer) {
                        ((Writer)out).flush();
                    }
                    if (ch >= 0) continue;
                }
                catch (WrongArguments e) {
                    messages.printAll(perr, 20);
                    if (e.usage != null) {
                        perr.println("usage: " + e.usage);
                    }
                    e.printStackTrace(perr);
                    continue;
                }
                catch (ClassCastException e) {
                    messages.printAll(perr, 20);
                    perr.println("Invalid parameter, was: " + e.getMessage());
                    e.printStackTrace(perr);
                    continue;
                }
                catch (IOException e) {
                    messages.printAll(perr, 20);
                    msg = new SourceError(inp, 'e', "").toString();
                    msg = msg.substring(0, msg.length() - 2);
                    perr.println(msg + " (or later): caught IOException");
                    e.printStackTrace(perr);
                    if (interactive) continue;
                    var17_22 = null;
                    if (out != null) {
                        ctx.consumer = saveConsumer;
                    }
                    if (language == saveLanguage) return;
                    Language.setDefaultLanguage(saveLanguage);
                    return;
                }
                catch (Throwable e) {
                    if (e instanceof SyntaxException && (se = (SyntaxException)e).getMessages() == messages) {
                        se.printAll(perr, 20);
                        se.clear();
                    } else {
                        messages.printAll(perr, 20);
                        e.printStackTrace(perr);
                    }
                    if (!interactive) ** break;
                    continue;
                    var17_23 = null;
                    if (out != null) {
                        ctx.consumer = saveConsumer;
                    }
                    if (language == saveLanguage) return;
                    Language.setDefaultLanguage(saveLanguage);
                    return;
                }
                break;
            }
            var17_24 = null;
            if (out != null) {
                ctx.consumer = saveConsumer;
            }
            if (language == saveLanguage) return;
        }
        catch (Throwable var16_26) {
            var17_25 = null;
            if (out != null) {
                ctx.consumer = saveConsumer;
            }
            if (language == saveLanguage) throw var16_26;
            Language.setDefaultLanguage(saveLanguage);
            throw var16_26;
        }
        Language.setDefaultLanguage(saveLanguage);
    }

    public static void runString(String str, Language language, Environment env) {
        Shell.run(language, env, new CharArrayInPort(str), ModuleBody.getMainPrintValues() ? OutPort.outDefault() : null, OutPort.errDefault());
    }

    public static void runFile(String fname, int skipLines) {
        Environment env = Environment.getCurrent();
        try {
            if (fname.equals("-")) {
                InPort in = InPort.inDefault();
                while (--skipLines >= 0) {
                    in.skipRestOfLine();
                }
                load.loadSource(in, env, null);
            } else {
                load.apply(Path.valueOf(fname), env, false, skipLines);
            }
        }
        catch (SyntaxException e) {
            e.printAll(OutPort.errDefault(), 20);
        }
        catch (FileNotFoundException e) {
            System.err.println("Cannot open file " + fname);
            System.exit(1);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

