# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import HDInsightManagementClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    ApplicationsOperations,
    ClustersOperations,
    ConfigurationsOperations,
    ExtensionsOperations,
    LocationsOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    ScriptActionsOperations,
    ScriptExecutionHistoryOperations,
    VirtualMachinesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class HDInsightManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """HDInsight Management Client.

    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.hdinsight.operations.ClustersOperations
    :ivar applications: ApplicationsOperations operations
    :vartype applications: azure.mgmt.hdinsight.operations.ApplicationsOperations
    :ivar locations: LocationsOperations operations
    :vartype locations: azure.mgmt.hdinsight.operations.LocationsOperations
    :ivar configurations: ConfigurationsOperations operations
    :vartype configurations: azure.mgmt.hdinsight.operations.ConfigurationsOperations
    :ivar extensions: ExtensionsOperations operations
    :vartype extensions: azure.mgmt.hdinsight.operations.ExtensionsOperations
    :ivar script_actions: ScriptActionsOperations operations
    :vartype script_actions: azure.mgmt.hdinsight.operations.ScriptActionsOperations
    :ivar script_execution_history: ScriptExecutionHistoryOperations operations
    :vartype script_execution_history:
     azure.mgmt.hdinsight.operations.ScriptExecutionHistoryOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.hdinsight.operations.Operations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.hdinsight.operations.VirtualMachinesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.hdinsight.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources: azure.mgmt.hdinsight.operations.PrivateLinkResourcesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription credentials which uniquely identify Microsoft Azure
     subscription. The subscription ID forms part of the URI for every service call. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2021-06-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = HDInsightManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.applications = ApplicationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.configurations = ConfigurationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.extensions = ExtensionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.script_actions = ScriptActionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.script_execution_history = ScriptExecutionHistoryOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "HDInsightManagementClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details) -> None:
        self._client.__exit__(*exc_details)
