/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.Iterator;

public class Predicate_current_char_conversion
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            CharConvBacktrackInfo bi = (CharConvBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        if (args[0] instanceof AtomTerm) {
            if (((AtomTerm)args[0]).value.length() != 1) {
                PrologException.representationError(TermConstants.characterAtom);
            }
        } else if (!(args[0] instanceof VariableTerm)) {
            PrologException.representationError(TermConstants.characterAtom);
        }
        if (args[1] instanceof AtomTerm) {
            if (((AtomTerm)args[1]).value.length() != 1) {
                PrologException.representationError(TermConstants.characterAtom);
            }
        } else if (!(args[1] instanceof VariableTerm)) {
            PrologException.representationError(TermConstants.characterAtom);
        }
        if (args[0] instanceof VariableTerm && args[1] instanceof VariableTerm) {
            CharConvBacktrackInfo bi = new CharConvBacktrackInfo();
            bi.startUndoPosition = interpreter.getUndoPosition();
            bi.arg0 = args[0];
            bi.arg1 = args[1];
            return this.nextSolution(interpreter, bi);
        }
        if (args[0] instanceof VariableTerm) {
            CharConvBacktrackInfo bi = new CharConvBacktrackInfo();
            bi.startUndoPosition = interpreter.getUndoPosition();
            bi.arg0 = args[0];
            bi.charIt = interpreter.getEnvironment().getConversionTable().convertsTo(((AtomTerm)args[1]).value.charAt(0)).iterator();
            return this.nextSolution(interpreter, bi);
        }
        if (args[1] instanceof VariableTerm) {
            AtomTerm res = AtomTerm.get(Character.toString(interpreter.getEnvironment().getConversionTable().convert(((AtomTerm)args[0]).value.charAt(0))));
            return interpreter.unify(args[1], res);
        }
        PrologException.systemError();
        return -1;
    }

    private int nextSolution(Interpreter interpreter, CharConvBacktrackInfo bi) throws PrologException {
        if (bi.charIt != null) {
            while (bi.charIt.hasNext()) {
                AtomTerm res = AtomTerm.get(Character.toString(bi.charIt.next().charValue()));
                int rc = interpreter.unify(bi.arg0, res);
                if (rc == -1) {
                    interpreter.undo(bi.startUndoPosition);
                    continue;
                }
                interpreter.pushBacktrackInfo(bi);
                return 0;
            }
        } else {
            while (bi.counter < '\u10ffff') {
                if (!Character.isDefined(bi.counter)) {
                    bi.counter = (char)(bi.counter + '\u0001');
                    continue;
                }
                AtomTerm res = AtomTerm.get(Character.toString(bi.counter));
                int rc = interpreter.unify(bi.arg0, res);
                if (rc == -1) {
                    bi.counter = (char)(bi.counter + '\u0001');
                    interpreter.undo(bi.startUndoPosition);
                    continue;
                }
                AtomTerm res2 = AtomTerm.get(Character.toString(interpreter.getEnvironment().getConversionTable().convert(bi.counter)));
                rc = interpreter.unify(bi.arg1, res2);
                if (rc == -1) {
                    bi.counter = (char)(bi.counter + '\u0001');
                    interpreter.undo(bi.startUndoPosition);
                    continue;
                }
                bi.counter = (char)(bi.counter + '\u0001');
                interpreter.pushBacktrackInfo(bi);
                return 0;
            }
        }
        return -1;
    }

    private static class CharConvBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Term arg0;
        Term arg1;
        Iterator<Character> charIt;
        char counter;

        CharConvBacktrackInfo() {
            super(-1, -1);
        }
    }
}

