/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.interpreter;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.AtomicTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.PrologCode;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.interpreter.ExceptionHandlerInfo;
import gnu.prolog.vm.interpreter.InterpretedByteCode;
import gnu.prolog.vm.interpreter.instruction.IAllocate;
import gnu.prolog.vm.interpreter.instruction.ICall;
import gnu.prolog.vm.interpreter.instruction.ICreateCompoundTerm;
import gnu.prolog.vm.interpreter.instruction.ICut;
import gnu.prolog.vm.interpreter.instruction.IFail;
import gnu.prolog.vm.interpreter.instruction.IJump;
import gnu.prolog.vm.interpreter.instruction.IPushArgument;
import gnu.prolog.vm.interpreter.instruction.IPushConstant;
import gnu.prolog.vm.interpreter.instruction.IPushEnvironment;
import gnu.prolog.vm.interpreter.instruction.IRetryMeElse;
import gnu.prolog.vm.interpreter.instruction.IReturn;
import gnu.prolog.vm.interpreter.instruction.ISaveCut;
import gnu.prolog.vm.interpreter.instruction.IStoreEnvironment;
import gnu.prolog.vm.interpreter.instruction.IThrow;
import gnu.prolog.vm.interpreter.instruction.ITrue;
import gnu.prolog.vm.interpreter.instruction.ITrustMe;
import gnu.prolog.vm.interpreter.instruction.ITryMeElse;
import gnu.prolog.vm.interpreter.instruction.IUnify;
import gnu.prolog.vm.interpreter.instruction.Instruction;
import gnu.prolog.vm.interpreter.instruction.RetryInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InterpretedCodeCompiler {
    public static final CompoundTermTag unifyTag = CompoundTermTag.get("=", 2);
    public static final CompoundTermTag throwTag = CompoundTermTag.get("throw", 1);
    public static final CompoundTermTag catchTag = CompoundTermTag.get("catch", 3);
    public static final Instruction[] instructionArrayConstant = new Instruction[0];
    public static final ExceptionHandlerInfo[] exceptionHandlerArrayConstant = new ExceptionHandlerInfo[0];
    protected List<Instruction> code = new ArrayList<Instruction>();
    protected List<ExceptionHandlerInfo> exceptionHandlers = new ArrayList<ExceptionHandlerInfo>();
    protected int currentCodePosition = 0;
    protected int allocatedReserved = 0;
    protected Map<Term, Integer> variableToEnvironmentIndex = new HashMap<Term, Integer>();
    protected CompoundTermTag codeTag;
    protected int numberOfReserved = 1;
    protected List<Integer> cutPositionStack = new ArrayList<Integer>();
    protected List<Term> passedClauses;

    public InterpretedCodeCompiler(List<Term> clauses) {
        this.passedClauses = clauses;
    }

    protected int allocReserved() {
        return this.allocatedReserved++;
    }

    void compileTermCreation(Term term) throws PrologException {
        if (term instanceof VariableTerm) {
            this.iPushEnvironment(this.getEnvironmentIndex((VariableTerm)term));
        } else if (term instanceof AtomicTerm) {
            this.iPushConstant((AtomicTerm)term);
        } else if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            for (Term arg : ct.args) {
                this.compileTermCreation(arg);
            }
            this.iCreateCompoundTerm(ct.tag);
        } else {
            PrologException.systemError();
        }
    }

    void compileHead(Term headTerm) throws PrologException {
        if (headTerm instanceof AtomTerm) {
            if (this.codeTag == null) {
                this.codeTag = CompoundTermTag.get((AtomTerm)headTerm, 0);
            }
        } else if (headTerm instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)headTerm;
            for (int i = 0; i < ct.tag.arity; ++i) {
                this.iPushArgument(i);
                this.compileTermCreation(ct.args[i]);
                this.iUnify();
            }
            if (this.codeTag == null) {
                this.codeTag = ct.tag;
            }
        } else {
            PrologException.typeError(TermConstants.callableAtom, headTerm);
        }
    }

    void compileBody(Term body) throws PrologException {
        if (body instanceof VariableTerm) {
            this.compileTermCreation(body);
            this.iCall(TermConstants.callTag);
        } else if (body instanceof AtomTerm) {
            if (body == TermConstants.cutAtom) {
                this.iCut(this.getCutPosition());
            } else if (body == TermConstants.trueAtom) {
                this.iTrue();
            } else if (body == TermConstants.failAtom) {
                this.iFail();
            } else {
                this.iCall(CompoundTermTag.get((AtomTerm)body, 0));
            }
        } else if (body instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)body;
            CompoundTermTag tag = ct.tag;
            if (tag == TermConstants.conjunctionTag) {
                this.compileBody(ct.args[0]);
                this.compileBody(ct.args[1]);
            } else if (tag == TermConstants.disjunctionTag) {
                if (ct.args[0] instanceof CompoundTerm && ((CompoundTerm)ct.args[0]).tag == TermConstants.ifTag) {
                    CompoundTerm ct2 = (CompoundTerm)ct.args[0];
                    this.compileIfThenElse(ct2.args[0], ct2.args[1], ct.args[1]);
                } else {
                    ITryMeElse tryMeElse = this.iTryMeElse(-1);
                    this.compileBody(ct.args[0]);
                    IJump jump = this.iJump(-1);
                    ITrustMe trustMe = this.iTrustMe();
                    tryMeElse.retryPosition = trustMe.codePosition;
                    this.compileBody(ct.args[1]);
                    jump.jumpPosition = this.currentCodePosition;
                }
            } else if (tag == throwTag) {
                this.compileTermCreation(ct.args[0]);
                this.iThrow();
            } else if (tag == TermConstants.ifTag) {
                this.compileIfThenElse(ct.args[0], ct.args[1], TermConstants.failAtom);
            } else if (tag == catchTag) {
                ExceptionHandlerInfo eh = new ExceptionHandlerInfo();
                eh.startPosition = this.currentCodePosition;
                this.compileTermCreation(ct.args[0]);
                this.iCall(TermConstants.callTag);
                eh.endPosition = this.currentCodePosition;
                IJump jumpOut = this.iJump(-1);
                eh.handlerPosition = this.currentCodePosition;
                int coughtTermPos = this.allocReserved();
                int handlerCutPos = this.allocReserved();
                this.iStoreEnvironment(coughtTermPos);
                this.iSaveCut(handlerCutPos);
                ITryMeElse tryMeElse = this.iTryMeElse(-1);
                this.iPushEnvironment(coughtTermPos);
                this.compileTermCreation(ct.args[1]);
                this.iUnify();
                this.iCut(handlerCutPos);
                this.compileTermCreation(ct.args[2]);
                this.iCall(TermConstants.callTag);
                IJump jump = this.iJump(-1);
                ITrustMe trustMe = this.iTrustMe();
                tryMeElse.retryPosition = trustMe.codePosition;
                this.iPushEnvironment(coughtTermPos);
                this.iThrow();
                jump.jumpPosition = this.currentCodePosition;
                jumpOut.jumpPosition = this.currentCodePosition;
                this.addExceptionHandler(eh);
            } else if (tag == unifyTag) {
                this.compileTermCreation(ct.args[0]);
                this.compileTermCreation(ct.args[1]);
                this.iUnify();
            } else {
                int n = tag.arity;
                for (int i = 0; i < n; ++i) {
                    this.compileTermCreation(ct.args[i]);
                }
                this.iCall(tag);
            }
        } else {
            PrologException.typeError(TermConstants.callableAtom, body);
        }
    }

    void compileIfThenElse(Term ifTerm, Term thenTerm, Term elseTerm) throws PrologException {
        int envPos = this.allocReserved();
        this.iSaveCut(envPos);
        ITryMeElse tryMeElse = this.iTryMeElse(-1);
        this.pushCutPosition(envPos);
        this.compileBody(ifTerm);
        this.iCut(envPos);
        this.popCutPosition();
        this.compileBody(thenTerm);
        IJump jump = this.iJump(-1);
        ITrustMe trustMe = this.iTrustMe();
        tryMeElse.retryPosition = trustMe.codePosition;
        this.compileBody(elseTerm);
        jump.jumpPosition = this.currentCodePosition;
    }

    int getReservedEnvironemt(Term body) throws PrologException {
        int rc = 0;
        if (body instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)body;
            CompoundTermTag tag = ct.tag;
            if (tag == TermConstants.conjunctionTag) {
                rc += this.getReservedEnvironemt(ct.args[0]);
                rc += this.getReservedEnvironemt(ct.args[1]);
            } else if (tag == TermConstants.disjunctionTag) {
                if (ct.args[0] instanceof CompoundTerm && ((CompoundTerm)ct.args[0]).tag == TermConstants.ifTag) {
                    CompoundTerm ct2 = (CompoundTerm)ct.args[0];
                    ++rc;
                    rc += this.getReservedEnvironemt(ct2.args[0]);
                    rc += this.getReservedEnvironemt(ct2.args[1]);
                    rc += this.getReservedEnvironemt(ct.args[1]);
                } else {
                    rc += this.getReservedEnvironemt(ct.args[0]);
                    rc += this.getReservedEnvironemt(ct.args[1]);
                }
            } else if (tag == TermConstants.ifTag) {
                ++rc;
                rc += this.getReservedEnvironemt(ct.args[0]);
                rc += this.getReservedEnvironemt(ct.args[1]);
            } else if (tag == catchTag) {
                rc += 2;
            }
        }
        return rc;
    }

    int getAllVariables(Term term, int currentEnvPositon) {
        if (term instanceof VariableTerm) {
            if (!this.variableToEnvironmentIndex.containsKey(term)) {
                this.variableToEnvironmentIndex.put(term, currentEnvPositon++);
            }
        } else if (term instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)term;
            int n = ct.tag.arity;
            Term[] args = ct.args;
            for (int i = 0; i < n; ++i) {
                currentEnvPositon = this.getAllVariables(args[i], currentEnvPositon);
            }
        }
        return currentEnvPositon;
    }

    public static Term rdereferenced(Term term) {
        if ((term = term.dereference()) instanceof CompoundTerm) {
            CompoundTerm ct1 = (CompoundTerm)term;
            int n = ct1.tag.arity;
            Term[] args1 = ct1.args;
            Term[] args2 = new Term[n];
            for (int i = 0; i < n; ++i) {
                args2[i] = InterpretedCodeCompiler.rdereferenced(args1[i]);
            }
            term = new CompoundTerm(ct1.tag, args2);
        }
        return term;
    }

    void compileClause(Term clause) throws PrologException {
        if (clause instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)clause;
            if (ct.tag == TermConstants.clauseTag) {
                this.compileHead(ct.args[0]);
                this.compileBody(ct.args[1]);
                return;
            }
        }
        this.compileHead(clause);
    }

    public static PrologCode compile(List<Term> passedClauses) throws PrologException {
        return new InterpretedCodeCompiler(passedClauses).compilePredicate();
    }

    PrologCode compilePredicate() throws PrologException {
        ArrayList<Term> clauses = new ArrayList<Term>();
        int n = this.passedClauses.size();
        if (n == 0) {
            this.iFail();
        } else {
            Iterator<Term> iclauses = this.passedClauses.iterator();
            while (iclauses.hasNext()) {
                clauses.add(InterpretedCodeCompiler.rdereferenced(iclauses.next()));
            }
            this.numberOfReserved = 1;
            for (Term term : clauses) {
                if (!(term instanceof CompoundTerm)) continue;
                CompoundTerm ct = (CompoundTerm)term;
                if (ct.tag != TermConstants.clauseTag) continue;
                this.numberOfReserved += this.getReservedEnvironemt(ct.args[1]);
            }
            int environmentSize = this.numberOfReserved;
            iclauses = clauses.iterator();
            while (iclauses.hasNext()) {
                environmentSize = this.getAllVariables(iclauses.next(), environmentSize);
            }
            this.iAllocate(environmentSize, this.numberOfReserved);
            int envPos = this.allocReserved();
            this.iSaveCut(envPos);
            this.pushCutPosition(envPos);
            n = clauses.size();
            if (n > 1) {
                ArrayList<IJump> jumps = new ArrayList<IJump>();
                RetryInstruction prv = this.iTryMeElse(-1);
                this.compileClause((Term)clauses.get(0));
                jumps.add(this.iJump(-1));
                for (int i = 1; i < n - 1; ++i) {
                    prv.retryPosition = this.currentCodePosition;
                    prv = this.iRetryMeElse(-1);
                    this.compileClause((Term)clauses.get(i));
                    jumps.add(this.iJump(-1));
                }
                prv.retryPosition = this.currentCodePosition;
                this.iTrustMe();
                this.compileClause((Term)clauses.get(n - 1));
                Iterator i$ = jumps.iterator();
                while (i$.hasNext()) {
                    IJump jump2;
                    IJump jump = jump2 = (IJump)i$.next();
                    jump.jumpPosition = this.currentCodePosition;
                }
            } else {
                this.compileClause((Term)clauses.get(0));
            }
            this.iReturn();
            this.popCutPosition();
        }
        Instruction[] instr = this.code.toArray(instructionArrayConstant);
        ExceptionHandlerInfo[] ehs = this.exceptionHandlers.toArray(exceptionHandlerArrayConstant);
        return new InterpretedByteCode(this.codeTag, instr, ehs);
    }

    int getEnvironmentIndex(VariableTerm term) {
        return this.variableToEnvironmentIndex.get(term);
    }

    void pushCutPosition(int envPos) {
        this.cutPositionStack.add(envPos);
    }

    int popCutPosition() {
        return this.cutPositionStack.remove(this.cutPositionStack.size() - 1);
    }

    int getCutPosition() {
        return this.cutPositionStack.get(this.cutPositionStack.size() - 1);
    }

    void addInstruction(Instruction i) {
        i.codePosition = this.currentCodePosition++;
        this.code.add(i);
    }

    IAllocate iAllocate(int environmentSize, int numberOfReserved) {
        IAllocate rc = new IAllocate(environmentSize, numberOfReserved);
        this.addInstruction(rc);
        return rc;
    }

    ICall iCall(CompoundTermTag tag) {
        ICall rc = new ICall(tag);
        this.addInstruction(rc);
        return rc;
    }

    ICreateCompoundTerm iCreateCompoundTerm(CompoundTermTag tag) {
        ICreateCompoundTerm rc = new ICreateCompoundTerm(tag);
        this.addInstruction(rc);
        return rc;
    }

    ICut iCut(int envPos) {
        ICut rc = new ICut(envPos);
        this.addInstruction(rc);
        return rc;
    }

    IFail iFail() {
        IFail rc = new IFail();
        this.addInstruction(rc);
        return rc;
    }

    IJump iJump(int pos) {
        IJump rc = new IJump(pos);
        this.addInstruction(rc);
        return rc;
    }

    IPushArgument iPushArgument(int i) {
        IPushArgument rc = new IPushArgument(i);
        this.addInstruction(rc);
        return rc;
    }

    IPushConstant iPushConstant(AtomicTerm term) {
        IPushConstant rc = new IPushConstant(term);
        this.addInstruction(rc);
        return rc;
    }

    IPushEnvironment iPushEnvironment(int envIdx) {
        IPushEnvironment rc = new IPushEnvironment(envIdx);
        this.addInstruction(rc);
        return rc;
    }

    IRetryMeElse iRetryMeElse(int retryPos) {
        IRetryMeElse rc = new IRetryMeElse(retryPos);
        this.addInstruction(rc);
        return rc;
    }

    IReturn iReturn() {
        IReturn rc = new IReturn();
        this.addInstruction(rc);
        return rc;
    }

    ISaveCut iSaveCut(int envPos) {
        ISaveCut rc = new ISaveCut(envPos);
        this.addInstruction(rc);
        return rc;
    }

    IStoreEnvironment iStoreEnvironment(int envPos) {
        IStoreEnvironment rc = new IStoreEnvironment(envPos);
        this.addInstruction(rc);
        return rc;
    }

    ITryMeElse iTryMeElse(int retryPos) {
        ITryMeElse rc = new ITryMeElse(retryPos);
        this.addInstruction(rc);
        return rc;
    }

    IThrow iThrow() {
        IThrow rc = new IThrow();
        this.addInstruction(rc);
        return rc;
    }

    ITrue iTrue() {
        ITrue rc = new ITrue();
        this.addInstruction(rc);
        return rc;
    }

    ITrustMe iTrustMe() {
        ITrustMe rc = new ITrustMe();
        this.addInstruction(rc);
        return rc;
    }

    IUnify iUnify() {
        IUnify rc = new IUnify();
        this.addInstruction(rc);
        return rc;
    }

    void addExceptionHandler(ExceptionHandlerInfo eh) {
        this.exceptionHandlers.add(eh);
    }
}

