/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.database;

import gnu.prolog.database.Module;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Predicate {
    public static final int UNDEFINED = -1;
    public static final int CONTROL = 0;
    public static final int BUILD_IN = 1;
    public static final int USER_DEFINED = 2;
    public static final int EXTERNAL = 3;
    protected int type = -1;
    protected CompoundTermTag tag;
    protected List<Term> clauses = new ArrayList<Term>();
    protected boolean propertiesLocked = false;
    protected boolean dynamicFlag = false;
    protected String javaClassName;
    protected Set<String> files = new HashSet<String>();
    protected Module module;

    public Predicate(Module module, CompoundTermTag tag) {
        this.tag = tag;
        this.module = module;
    }

    public List<Term> getClauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (this.type != -1) {
            throw new IllegalStateException("Type of predicate is already set.");
        }
        this.type = type;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public void setJavaClassName(String javaClassName) {
        if (this.javaClassName != null) {
            throw new IllegalStateException("Java class name could not be changed after it was set.");
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Java class name could be only for control construct, build in  or external predicate.");
            }
        }
        this.javaClassName = javaClassName;
        this.propertiesLocked = true;
    }

    public AtomTerm getFunctor() {
        return this.tag.functor;
    }

    public int getArity() {
        return this.tag.arity;
    }

    public CompoundTermTag getTag() {
        return this.tag;
    }

    public void addClauseLast(Term clause) {
        if (this.type != 2) {
            throw new IllegalStateException("clauses could be added only to user defined predicate");
        }
        this.propertiesLocked = true;
        this.clauses.add(clause);
        this.module.predicateUpdated(this.tag);
    }

    public void addClauseFirst(Term clause) {
        if (this.type != 2) {
            throw new IllegalStateException("clauses could be added only to user defined predicate");
        }
        this.propertiesLocked = true;
        if (this.clauses.size() == 0) {
            this.clauses.add(clause);
        } else {
            this.clauses.add(0, clause);
        }
        this.module.predicateUpdated(this.tag);
    }

    public void removeClause(Term clause) {
        this.clauses.remove(clause);
        this.module.predicateUpdated(this.tag);
    }

    public boolean arePropertiesLocked() {
        return this.propertiesLocked;
    }

    public boolean isDynamic() {
        return this.dynamicFlag;
    }

    public void setDynamic() {
        if (this.type != 2) {
            throw new IllegalStateException("only user defined predicate may be declared dynamic");
        }
        if (this.dynamicFlag) {
            return;
        }
        if (this.propertiesLocked) {
            throw new IllegalStateException("dynamic property of predicate could not be changed");
        }
        this.dynamicFlag = true;
    }

    public static Term prepareClause(Term clause) {
        Term body;
        Term head;
        if ((clause = clause.dereference()) instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)clause;
            if (ct.tag == TermConstants.clauseTag) {
                head = Predicate.prepareHead(ct.args[0].dereference());
                body = Predicate.prepareBody(ct.args[1].dereference());
            } else {
                head = Predicate.prepareHead(clause);
                body = TermConstants.trueAtom;
            }
        } else if (clause instanceof AtomTerm) {
            head = Predicate.prepareHead(clause);
            body = TermConstants.trueAtom;
        } else {
            throw new IllegalArgumentException("not callable");
        }
        return new CompoundTerm(TermConstants.clauseTag, head, body);
    }

    public static Term prepareHead(Term head) {
        if (head instanceof VariableTerm) {
            throw new IllegalArgumentException("head cannot be a variable");
        }
        if (head instanceof AtomTerm) {
            return head;
        }
        if (head instanceof CompoundTerm) {
            return head;
        }
        throw new IllegalArgumentException("head cannot be converted to predication");
    }

    public static Term prepareBody(Term body) {
        if (body instanceof VariableTerm) {
            return new CompoundTerm(TermConstants.callTag, body);
        }
        if (body instanceof AtomTerm) {
            return body;
        }
        if (body instanceof CompoundTerm) {
            CompoundTerm ct = (CompoundTerm)body;
            if (ct.tag == TermConstants.conjunctionTag || ct.tag == TermConstants.disjunctionTag || ct.tag == TermConstants.ifTag) {
                return new CompoundTerm(ct.tag, Predicate.prepareBody(ct.args[0].dereference()), Predicate.prepareBody(ct.args[1].dereference()));
            }
            return body;
        }
        throw new IllegalArgumentException("body cannot be converted to goal");
    }
}

