/*------------------------------------------------------------------------

      File:  cmdConflict.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:54, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdConflict.c	1.2\t1/19/92";

#include "global.h"

int
cmdConflict(ClientData client_data,
	    Tcl_Interp* interp,
	    int argc,
	    char* argv[])
{
  static char fullname[1024];
  char** pathlist;
  char** modulelist;
  char*  modulepath = getenv("MODULEPATH");
  int    i, j, k, numpaths, nummodules;

  if(argc < 2) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " conflicting-modules\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & (M_REMOVE | M_SWITCH)) {
    return TCL_OK;
  }

  if(! modulepath) {
    Tcl_AppendResult(interp, "MODULEPATH environment variable not set", NULL);
    return TCL_ERROR;
  }

  if(flags & M_DISPLAY)
    fprintf(stderr, "Conflicts with (ORed): ");

  for(i = 1; argv[i]; i++) {
    pathlist = SplitIntoList(interp, modulepath, &numpaths);

    for(j = 0; j < numpaths; j++) {
      if((modulelist = 
	  SortedDirList(interp, pathlist[j], argv[i], &nummodules)) == NULL)
	 continue;

      for(k = 0; k < nummodules; k++) {
	if(flags & M_DISPLAY) {
	  fprintf(stderr, " %s", modulelist[k]);
	} else if(IsLoaded(modulelist[k])) {
	  Tcl_AppendResult(interp, "module conflicts with the currently",
			   " loaded module '", modulelist[k], "'", NULL);
	  return TCL_ERROR;
	}
      }
    }
  }
  if(flags & M_DISPLAY)
    fprintf(stderr, "\n");

  return TCL_OK;
}

int
cmdPrereq(ClientData client_data,
	    Tcl_Interp* interp,
	    int argc,
	    char* argv[])
{
  char** pathlist;
  char** modulelist;
  char*  modulepath = getenv("MODULEPATH");
  char*  notloaded_flag = argv[1];
  int    i, j, k, numpaths, nummodules;
	      
  if(argc < 2) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " prerequsite-modules\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & M_REMOVE) {
    return TCL_OK;
  }

  if(flags & M_DISPLAY)
    fprintf(stderr, "Prequisites are (ORed): ");

  for(i = 1; argv[i] && notloaded_flag; i++) {
    pathlist = SplitIntoList(interp, modulepath, &numpaths);

    for(j = 0; j < numpaths && notloaded_flag; j++) {
      if((modulelist = 
	  SortedDirList(interp, pathlist[j], argv[i], &nummodules)) == NULL)
	 continue;

      for(k = 0; k < nummodules && notloaded_flag; k++) {
	if(flags & M_DISPLAY) {
	  fprintf(stderr, " %s", modulelist[k]);
	} else if(! IsLoaded(modulelist[k])) {
	  notloaded_flag = argv[i];
	} else {
	  notloaded_flag = NULL;
	}
      }
    }
  }

  if(flags & M_DISPLAY) {
    fprintf(stderr, "\n");
    return TCL_OK;
  }

  if(notloaded_flag) {
    Tcl_AppendResult(interp, "module '", notloaded_flag, 
		     "' is a prerequisite for module '", current_module, 
		     "'\n\t\tand '", notloaded_flag, 
		     "' is not currently loaded", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

