/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Provides some general help by listing the different commands.  It will
 *  also allow for a modulefile to provide some module-specific help by
 *  calling a Tcl procedure.
 *	
 * $Log: ModuleCmd_Help.c,v $
 *
 *
 * Revision 1.1  1992/11/05  23:47:14  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Help.c,v 2.0 1993/02/20 23:59:58 jlf Exp jlf $";

#include "global.h"

int  ModuleCmd_Help(Tcl_Interp* interp,
		    int         argc,
		    char*       argv[])
{
    if(argc > 0) {
	PerModuleHelp(interp, argc, argv);
    } else {
	fprintf(stderr, "\n  Available Commands and Usage:\n\n");
	
	fprintf(stderr, "\t+  add|load\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  rm|unload\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  switch\tmodulefile1 modulefile2\n");
	fprintf(stderr, "\t+  display\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  avail\tpath [path]\n");
	fprintf(stderr, "\t+  use\t\tdir [dir ...]\n");
	fprintf(stderr, "\t+  use -append\tdir [dir ...]\n");
	fprintf(stderr, "\t+  unuse\tdir [dir ...]\n");
	fprintf(stderr, "\t+  update\n");
	fprintf(stderr, "\t+  purge\n");
	fprintf(stderr, "\t+  list\n");
	fprintf(stderr, "\t+  clear\n");
	fprintf(stderr, "\t+  help\t\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  initadd\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  initrm\tmodulefile [modulefile ...]\n");
	fprintf(stderr, "\t+  initswitch\tmodulefile1 modulefile2\n");
	fprintf(stderr, "\t+  initlist\n");
	fprintf(stderr, "\t+  initclear\n\n");
    }

  return TCL_OK;
}

int  PerModuleHelp(Tcl_Interp* interp,
		    int         argc,
		    char*       argv[])
{
    int          i, result;
    Tcl_Interp*  help_interp; 
    char         modulefile[1024];
    char         modulename[1024];
    Tcl_CmdBuf   cmdbuf;

    cmdbuf = Tcl_CreateCmdBuf();

    for(i=0; i<argc; i++) {
	help_interp = Tcl_CreateInterp();

	if(Locate_ModuleFile(help_interp, argv[i], modulename, modulefile)) {
	    fprintf(stderr, "\n*** Can't find a modulefile for %s ***\n", 
		    argv[i]);
	    continue;
	}
        current_module = modulename;

	fprintf(stderr, "\n----------- Module Specific Help for '%s' %.*s-------\n\n", 
		current_module, 20-strlen(current_module), "--------------------");

	result = CallModuleProcedure(help_interp, cmdbuf, modulefile, "ModulesHelp", 1);

	if(result == TCL_ERROR) {
	    fprintf(stderr, "\t*** No Module Specific Help for %s ***\n", 
		    current_module);
	}

	Tcl_DeleteInterp(help_interp);
    }
    fprintf(stderr, "\n");

    Tcl_DeleteCmdBuf(cmdbuf);

    return TCL_OK;
}


/*

  fprintf(stderr, "    * Load the given modulefiles into the current working environment.\n\n");

  fprintf(stderr, "    * Remove the given modules from the current working environment.\n\n");

  fprintf(stderr, "    * Switch two similar modulefiles in place\n\n");

  fprintf(stderr, "    * Display the environment changes each given modulefile makes.\n");
  fprintf(stderr, "        May also display licensing or other usage issues\n\n");

  fprintf(stderr, "    * List the currently loaded modulefiles\n\n");

  fprintf(stderr, "    * Lists all of the modules that are currently available to be loaded\n");
  fprintf(stderr, "    * Modules with multple versions are denoted by a '/' after the name\n");
  fprintf(stderr, "    * Passing one of these as an argument shows the different versions\n\n");

  fprintf(stderr, "    * All of these commands are used to manipulate a 'module load' command\n");
  fprintf(stderr, "         in your shell's .startup file.  They work on the first 'module load'\n");
  fprintf(stderr, "         encountered.\n");
	  
*/
