/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"

char *exit_val[] = {
  "Done", "Hangup", "Interrupted", "Quit", "Illegal Instruction",
  "Trace Trap", "IOT", "EMT", "FP Exception", "Killed", "Bus Error",
  "Segmentation Fault", "Bad Arg", "Broken pipe", "Alarm Clock", "Terminated",
  0, "Stopped (signal)", "Stopped", 0, 0, "Stopped (TTY input)",
  "Stopped (TTY output)", 0, "CPU Time Limit Expired",
  "Filesize Limit Exceeded", "Virtual Time Alarm", "Profiler Timer Alarm",
  0, "USR 1", "USR 2"
};

#ifdef NOSETENV
  extern char **environ;
#endif

void check_children(), cleanup(), *malloc();
char *getline(),***split_line(),***parse_alias(), ***parse_wildcards();
char ***parse_shellvars(), ***parse_assigns();

char **history, **_mailnotice = NULL, **_homedirs, **_cdpath;
char _source = FALSE, newmail = TRUE, _insert = TRUE, _notypeahead = FALSE;
char *_prompt, *_statline, *_home, **_mbox, **PATH, _nohup = FALSE;
char _loginshell = FALSE, _killjobs = FALSE, _inpipe = FALSE;
char _restricted = FALSE;
int _maxhist = 30, curhist = 0, _joblimit = 0, _failat = 1, _mailchkint = 60;
int _statint = 30;
char _verbose = FALSE, _willverbose = FALSE, _interactive = TRUE;
char _echo = FALSE, _willecho = FALSE, _noexec = FALSE, _oneline = FALSE;
char _fast = FALSE, _terminate = FALSE, _nobgnull = FALSE, _nofork = FALSE;
char _glob = TRUE, _nonomatch = FALSE, _nodots = FALSE;
char _noclobber = FALSE, _noassigns = FALSE, *_sourcefile = NULL, *_term[11];
struct timeval *_timeout = NULL, timeout;

struct _setvar *sets[37], *statvar;
struct _alias *alias[128];
char _glvl = 0, *_kbuf[MAX_GLVL], _kmax[MAX_GLVL];
struct custom_keys **keys[MAX_GLVL];
int max_ent, _pgrp, _status = 0;
unsigned long SIGMASK = ~sigmask(SIGPIPE), TIMEON;
struct proc_tab *proc;

char ***file;
int fptr,err;

char buf[1025],path[1025];

main(argc,argv,env)
int argc;
char **argv;
char **env;
{
  char *str,i;

/* NeXT hack for giving us an environment we can work with. */
#ifdef NOSETENV
  char **en;

  for(i=0;environ[i];i++);
  en = (char **)malloc(sizeof(char **) * i+1);
  for(i=0;environ[i];i++) en[i] = SCOPY(environ[i]);
  en[i] = NULL;
  environ = en;
#endif

  for(i=0;i<32;i++) signal(i,SIG_IGN);
  signal(SIGCHLD,check_children);
  signal(SIGHUP,cleanup);
  signal(SIGSEGV,cleanup);

  setbuf(stdin,NULL);
  setbuf(stdout,NULL);
  setbuf(stderr,NULL);
  TIMEON = time(0);
  parse_args(argc,argv);
  init();
  init_term();
  if (_interactive) source(GLOBAL_INIT);
  check_mail(TRUE);
  if (argv[0][0] == '-' || !strcmp(argv[0],"su")) second_pass();
  if (argv[0][0] == '-') {
    _loginshell = TRUE;
    sprintf(path,"%s/%s",_home,SHELL_LOGIN);
    source(path);
    load_hist();
  }
  if (!_fast) {
    sprintf(path,"%s/%s",_home,SHELL_INIT);
    source(path);
  }

  if (_willverbose) makenull("verbose");
  if (_willecho) makenull("echo");

  if (_interactive && _term[KS]) fputs(_term[KS],stdout);
  if (_sourcefile) {
    source(_sourcefile);
    exit(0);
  }

  for(;;) {
    err = 0;
    str = getline();
    add_history(str);
    i = run2(str);
    if (_oneline) exit(0);
    check_mail(FALSE);
    if (_term[KS]) fputs(_term[KS],stdout);
  }
}

source(fil)
char *fil;
{
  char ***arg = NULL, *str, *p, flg = TRUE;
  int d, i, j, nt;
  FILE *in, *fdopen();

  if (fil) {
    if ((d = open(fil,O_RDONLY)) < 0) return -1;
    in = fdopen(d,"r");
  } else {
    p = _prompt;
    _prompt = "? ";
  }

  _source = TRUE;
  err = fptr = j = path[1025] = 0;
  file = (char ***)calloc(nt=5,sizeof(char **));
  while(flg) {
    if (fil) {
      if (!fgets(path,1024,in)) break;
      i = strlen(path);
      if (path[i-1] == '\n') path[i-1] = 0;
      arg = split_line(path);
    } else {
      str = getline();
      arg = split_line(str);
    }
    for(i=0;arg[i];i++) {
      if (j == nt) file = (char ***)realloc(file,sizeof(char **) * (nt+=5));
      file[j++] = arg[i];
      if (!fil && !strcmp(arg[i][0],"exit")) flg = FALSE;
    }
    free(arg);
  }
  if (j == nt) file = (char ***)realloc(file,sizeof(char **) * (++nt));
  file[j] = NULL;
  if (fil) {
    fclose(in);
    close(d);
  }

  while(file[fptr]) {
    run(fptr);
    if (err < 0) {
      switch (err) {
        case ERR_BREAK:
	  fprintf(stderr,"break: break outside of loop or switch.\n");
	  break;
	case ERR_CONTINUE:
	  fprintf(stderr,"continue: continue outside of loop.\n");
	  break;
	case ERR_GOTO:
	  err = 0;
	  break;
      }
    }
    if (err || badstat(_status)) break;
    fptr++;
  }
  _source = FALSE;
  free_arg(file);
  if (!fil) _prompt = p;
  return 0;
}

/*
 * This routine makes a process table entry for our process.
 * Called by exec only, so we won't block SIGCHLD here, cause it already
 * will be by the time it's called.
 */
get_proc_ent()
{
  short i,j;

  for(i=0;i<max_ent;i++)
    if (proc[i].pid == 0) return i;
  i = max_ent;
  proc = (struct proc_tab *)realloc(proc,(max_ent += 2) * sizeof(struct proc_tab));
  for(j=i;j<max_ent;j++) proc[j].pid = 0;
  return i;
}

/*
 * This is surprisingly where most of the job control lies.  The rest is
 * just waking up and stopping processes.
 */
void check_children()
{
  int pid,i,j,tpgrp,flg;
  union wait st;
  char tmp[40];

  while ((pid = wait3(&st,WNOHANG | WUNTRACED,NULL)) > 0) {
    for(i=0;i<max_ent;i++)
      if (pid == proc[i].pid) {
	flg = TRUE;
	if (proc[i].bg) flg = FALSE;
	else if (proc[i].pipe) {
	  for(j=0;j<max_ent;j++)
	    if (j != i && proc[j].pid && proc[j].pipe == proc[i].pipe && !proc[j].status) {
	      flg = FALSE;
	      break;
	    }
	}
	if (WIFSTOPPED(st)) {
	  if (flg) tcsetpgrp(TTY,_pgrp);
	  switch(st.w_stopsig) {
	    case SIGTTIN:
	    case SIGTTOU:
	    case SIGSTOP:
	    case SIGTSTP:
	      tpgrp = tcgetpgrp(TTY);
	      if (tpgrp == _pgrp && (!proc[i].pipe || proc[i].pipe == proc[i].pid))
	        printf("\n [%d] (%d) %-30s %s\n",i,pid,exit_val[st.w_stopsig],proc[i].cmd);
	      proc[i].status = st.w_stopsig;
	      break;
	  }
	} else if (WIFEXITED(st)) {
	  if (flg) tcsetpgrp(TTY,_pgrp);
	  tpgrp = tcgetpgrp(TTY);
	  if (proc[i].bg && tpgrp == _pgrp && (!proc[i].pipe || proc[i].pipe == proc[i].pid))
	    printf("\n [%d] (%d) %-30s %s\n",i,pid,exit_val[st.w_termsig],proc[i].cmd);
	  _status = st.w_termsig? st.w_termsig<<8 : st.w_retcode;
	  proc[i].pid = 0;
	  free(proc[i].cmd);
	} else if (WIFSIGNALED(st)) {
	  switch(st.w_termsig) {
	    case SIGCONT:
	      proc[i].status = STAT_RUNNING;
	      tcsetpgrp(TTY,proc[i].pgrp);
	      return;
	    default:
	      if (flg) tcsetpgrp(TTY,_pgrp);
	      tpgrp = tcgetpgrp(TTY);
	      if (_pgrp == tpgrp) {
		sprintf(tmp,"%s%s",exit_val[st.w_termsig],(st.w_coredump?" (core dumped)":""));
		if (proc[i].bg && (!proc[i].pipe || proc[i].pipe == proc[i].pid))
		  printf("\n [%d] (%d) %-30s %s\n",i,pid,tmp,proc[i].cmd);
		else if (st.w_termsig) printf("%s\n",tmp);
	      }
	      proc[i].pid = 0;
	      free(proc[i].cmd);
	      _status = st.w_termsig? st.w_termsig<<8 : st.w_retcode;
	      break;
	  }
	}
      }
  }
  return;
}

check_mail(f)
char f;
{
  static int i;
  static time_t last = 0;
  struct stat lbuf;

  if (!_mbox) {
    newmail = FALSE;
    return;
  }
  if (!f && last+_mailchkint > time(0)) return;
  last = time(0);
  for(i=0;_mbox[i];i++) {
    stat(_mbox[i],&lbuf);
    if (((lbuf.st_mtime > lbuf.st_atime) && (lbuf.st_size != 0))) {
      if (!newmail) {
	if (_mailnotice) printf("\n%s",_mailnotice[0]);
	else printf("\nYou have new mail");
	if (i) printf(" in %s.\n",_mbox[i]);
	else puts(".");
	newmail = TRUE;
      }
    } else newmail = FALSE;
  }
}

/*
 * Called if we have an error we can't deal with. Give a very detailed
 * error message so the user knows what's going on.
 */
void cleanup()
{
  printf("oops...\n");
  exit(0);
}

parse_args(n,arg)
int n;
char **arg;
{
  char ***tmp;
  int i=1,x;

  while(arg[i]) {
    if (arg[i][0] == '-') {
      for(x=1;arg[i][x];x++) {
	switch(arg[i][x]) {
	  case 'c':			/* ignores other args */
	    if (!arg[i+1]) exit(1);
	    init();
	    init_term();
	    if (!_fast) {
	      sprintf(path,"%s/%s",_home,SHELL_INIT);
	      source(path);
	    }
	    tmp = split_line(arg[i+1]);
	    tmp = parse_alias(tmp);
	    tmp = parse_shellvars(tmp);
	    if (!_noassigns) tmp = parse_assigns(tmp);
	    if (_glob) tmp = parse_wildcards(tmp);
	    for(x=0;tmp[x];x++) {
	      EXEC(tmp[x]);
	      pwait();
	    }
	    exit(0);
	  case 'e':
	    _terminate = TRUE;		/* only when sourcing! */
	    break;
	  case 'f':
	    _fast = TRUE;
	    break;
	  case 'i':
	    _interactive = TRUE;	/* redundant */
	    break;
	  case 'n':
	    _noexec = TRUE;
	    break;
	  case 's':
	    _interactive = FALSE;
	    break;
	  case 't':
	    _oneline = TRUE;
	    break;
	  case 'v':
	    _willverbose = TRUE;
	    break;
	  case 'V':
	    _verbose = TRUE;
	    break;
	  case 'x':
	    _willecho = TRUE;
	    break;
	  case 'X':
	    _echo = TRUE;
	    break;
	}
      }
    } else {
      if (_sourcefile) {
        fprintf(stderr,"ssh: Too many arguments\n");
	exit(1);
      }
      _sourcefile = arg[i];
    }
    i++;
  }
}

run(line)
int line;
{
  char **arg;
  int i;

  if (_verbose) {
    for(i=0;file[line][i];i++) {
      fputs(file[line][i],stdout);
      if (file[line][i+1]) fputc(' ',stdout);
    }
    fputc('\n',stdout);
  } else for(i=0;file[line][i];i++);
  arg = (char **)malloc(sizeof(char *) * (i+1));
  for(i=0;file[line][i];i++)
    arg[i] = (char *)strcpy(malloc(strlen(file[line][i])+1),file[line][i]);
  arg[i] = NULL;

  arg = (char **)exchange_alias(arg);
  arg = (char **)evalvars(arg);
  if (!_noassigns) arg = (char **)eval_assigns(arg);
  if (_glob) arg = (char **)match_wildcards(arg);
  EXEC(arg);
  pwait();
  statvar->sv.val = _status;
  free_list(arg);
  return 0;
}

run2(s)
char *s;
{
  char ***arg;
  int i;

  if (_verbose) puts(s);
  arg = split_line(s);
  arg = parse_alias(arg);
  arg = parse_shellvars(arg);
  if (!_noassigns) arg = parse_assigns(arg);
  if (_glob) arg = parse_wildcards(arg);
  if (err) {
    free_arg(arg);
    statvar->sv.val = _status = err;
    return -1;
  }
  if (arg[0][0] == NULL) {
    free_arg(arg);
    return -1;
  }
  for(i=0;arg[i];i++) {
    EXEC(arg[i]);
    pwait();
    statvar->sv.val = _status;
    if (badstat(_status)) {
      free_arg(arg);
      return -1;
    }
  }
  free_arg(arg);
  return 0;
}
