/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"
#include <sgtty.h>

extern char *_prompt, *_statline, **history, *_kbuf[MAX_GLVL], _kmax[MAX_GLVL];
extern char _insert, _glvl, _verbose, _notypeahead, _glob, *_term[11];
extern int _maxhist, curhist, err;
extern struct custom_keys **keys[MAX_GLVL];
extern char buf[1025], *errstr, *erru, _noassigns;

struct sgttyb OTTY, STTY;
char **files, **dirget();

char str[256], prompt[81], *pline(), *index();
int pos, len, refresh();
extern struct timeval *_timeout;

char *getline()
{
  char tstr[2], prefix[20], flg, fk = 0, ic = 0, bs = 0, *ptr = NULL;
  char ***arg;
  short hist = curhist;
  int i, j, x, s, e, r, kp = 0, ch;
  struct custom_keys *KEY;

  tstr[1] = 0;
  pos = len = 0;

  noecho();

  if (_statline && _term[HS]) printf("%s%s%s%s%s",_term[DS],_term[TS],pline(_statline,1023,1023),_term[CE],_term[FS]);
  strcpy(prompt,pline(_prompt,80,80));
  printf("\r%s",prompt);

  do {
    if (_timeout) {
      j = 1;
      i = select(1,&j,NULL,NULL,_timeout);
      if (!i) {
	printf("\r%slogout%s\n",prompt,_term[CE]);
	files = (char **)calloc(2,sizeof(char *));
	files[0] = "logout";
	files[1] = NULL;
	logout(1,files);
      }
    }
    if ((ch = getchar()) == EOF) cleanup();

    if (bs) {
      tstr[0] = ch;
      insertstr(tstr);
      bs = ch = 0;
      continue;
    }
    if (ic) {
      if (ch >= '@' && ch <= '_') tstr[0] = ch - '@';
      else if (ch >= 'a' && ch <= 'z') tstr[0] = (ch - 'a')+1;
      else tstr[0] = ch;
      insertstr(tstr);
      ic = ch = 0;
      continue;
    }
    if (fk == 0 && (ptr = index(_kbuf[_glvl],ch)) && _kmax[_glvl] > 0) {
      kp = (int)(ptr - _kbuf[_glvl]);
      if (!keys[_glvl][kp]->key[1]) goto PROCESS;
      else {
	prefix[fk++] = ch;
	prefix[fk] = ch = 0;
	if (fk == _kmax[_glvl]) {
	  insertstr(prefix);
	  fk = 0;
	}
	continue;
      }
    } else if (fk == 0) {
      if (ch == '\n' || ch == '\r') break;
      tstr[0] = ch;
      insertstr(tstr);
      ch = 0;
      continue;
    }
    if (fk > 0 && fk <= _kmax[_glvl]) {
      prefix[fk++] = ch;
      prefix[fk] = 0;
      flg = TRUE;
      for(i=kp;i<strlen(_kbuf[_glvl]);i++) {
	if (strlen(keys[_glvl][i]->key) == fk && !strcmp(keys[_glvl][i]->key,prefix)) {
	  kp = i;
	  goto PROCESS;
	}
	if (keys[_glvl][i]->key[fk-1] == prefix[fk-1]) flg = FALSE;
      }
      if (flg || fk == _kmax[_glvl]) {
	insertstr(prefix);
	kp = prefix[0] = fk = ch = 0;
	continue;
      }
    }
    continue;
  
PROCESS:
    prefix[0] = fk = 0;
    KEY = keys[_glvl][kp];
    if (KEY->func > 0) {
      switch(KEY->func) {
	case 1:		/* up */
	  if (hist > 0) {
	    hist--;
	    strcpy(str,history[hist]);
	    pos = len = strlen(history[hist]);
	    printf("\r%s%s",prompt,_term[CE]);
	    output(str);
	  } else {
	    hist = -1;
	    if (str[0]) printf("\r%s%s",prompt,_term[CE]);
	    str[0] = len = pos = 0;
	  }
	  break;
	case 2:		/* down */
	  if (hist < curhist-1) {
	    hist++;
	    strcpy(str,history[hist]);
	    pos = len = strlen(history[hist]);
	    printf("\r%s%s",prompt,_term[CE]);
	    output(str);
	  } else {
	    hist = curhist;
	    if (str[0]) printf("\r%s%s",prompt,_term[CE]);
	    str[0] = 0;
	    len = pos = 0;
	  }
	  break;
	case 3:		/* left */
	  if (pos > 0) {
	    putchar('\b');
	    pos--;
	  }
	  break;
	case 4:		/* right */
	  if (pos < len) outch(str[pos++]);
	  break;
	case 5:		/* delete / backspace */
	  delch();
	  break;
	case 6:		/* toggle insert/overwrite */
	  _insert ^= 1;
	  break;
	case 7:		/* move to beginning of line */
	  if (pos > 0) {
	    printf("\r%s",prompt);
	    pos = 0;
	  }
	  break;
	case 8:		/* delete to the right */
	  if (pos < len) {
	    outch(str[pos++]);
	    delch();
	  }
	  break;
	case 9:		/* move to EOL */
	  if(pos < len) {
	    str[len] = 0;
	    output(str+pos);
	    pos = len;
	  }
	  break;
	case 10:	/* kill to EOL */
	  if (pos < len) {
	    printf("%s",_term[CE]);
	    str[len = pos] = 0;
	  }
	  break;
	case 11:	/* restore line */
	  str[pos = len]=0;
	  printf("\r%s%s",prompt,_term[CE]);
	  output(str);
	  break;
	case 12:	/* Kill line */
	  if (len>0) printf("\r%s%s",prompt,_term[CE]);
	  str[len = pos = 0] = 0;
	  break;
	case 13:	/* quoted insert */
	  bs = 1;
	  break;
	case 14:	/* find matching history */
	  if (len == 0) break;
	  str[len] = 0;
	  for(i=hist-1;i>=0;i--) {
	    for(j=0;str[j] && str[j] == history[i][j];) j++;
	    if (str[j]) continue;
	    strcpy(str,history[hist = i]);
	    pos = len = strlen(str);
	    printf("\r%s%s",prompt,_term[CE]);
	    output(str);
	    break;
	  }
	  if (i < 0) putchar('\007');
	  break;
	case 15:	/* kill to BOL */
	  if (pos > 0) {
	    str[len] = 0;
	    for(i=pos;i<=len;i++) str[i-pos] = str[i];
 	    len -= pos;
	    pos = 0;
	    printf("\r%s",prompt);
	    if (len > 0) {
	      output(str);
	      printf("%s\r%s",_term[CE],prompt);
	    } else printf("%s",_term[CE]);
	  }
	  break;
	case 16:	/* filename completion */
	  str[len] = 0;
	  i = isspace(str[pos]) || !str[pos]? pos-1 : pos;
	  if (isspace(str[i]) || !str[i]) {
	    putchar('\007');
	    break;
	  }
	  while(!isspace(str[i]) && i > 0) i--;
	  if (isspace(str[i])) s = ++i;
	  else s = i;
	  j = 0;
	  while(!isspace(str[i]) && str[i]) buf[j++] = str[i++];
	  e = i;
	  buf[j] = 0;
	  if (!(r = (isregex(buf)==2))) {
	    buf[j++] = '*';
	    buf[j] = 0;
	  }
	  files = (char **)calloc(5,sizeof(char *));
	  i = 1;
	  files[1] = NULL;
	  files = dirget(buf,files,&i,0,NULL,r == 1,0);
	  if (!i || err) {
	    putchar('\007');
	    if (err == ERR_NO_USER) free(erru);
	    else if (err == ERR_NO_MATCH) free(errstr);
	    err = 0;
	    break;
	  }
	  if (!isspace(pos))
	    for(i=pos;!isspace(i) && str[i];i++,pos++) outch(str[i]);
	  for(i=0;str[i+(e-1)];i++) str[s+i] = str[i+e];
	  if (pos == len) for(i=0;i<(e-s);i++) printf("\b \b");
	  else for(i=0;i<(e-s);i++) delch();
	  len -= e-s;
	  str[len] = 0;
	  pos = s;
	  if (pos == len) {
	    strcat(str,files[0]);
	    output(files[0]);
	    len += strlen(files[0]);
	    pos += strlen(files[0]);
	  } else insertstr(files[0]);
	  free_list(files);
	  break;
	case 17:	/* word left */
	  if (pos > 0) {
	    while(pos > 0 && isspace(str[pos])) {
	      putchar('\b');
	      pos--;
	    }
	    while(pos > 0 && !isspace(str[pos])) {
	      putchar('\b');
	      pos--;
	    }
	  }
	  break;
	case 18:	/* word right */
	  if (pos < len) {
	    while(pos < len && isspace(str[pos])) outch(str[pos++]);
	    while(pos < len && !isspace(str[pos])) outch(str[pos++]);
	  }
	  break;
	case 19:	/* Expand line */
	  str[len] = 0;
	  arg = (char ***)split_line(str);
	  arg = (char ***)parse_alias(arg);
	  arg = (char ***)parse_shellvars(arg);
	  if (!_noassigns) arg = (char ***)parse_assigns(arg);
	  if (_glob) arg = (char ***)parse_wildcards(arg);
	  if (err) {
	    free_arg(arg);
	    putchar('\007');
	    break;
	  }
	  pos = 0;
	  for(i=0;arg[i];i++) {
	    for(j=0;arg[i][j];j++) {
	      if ((pos+strlen(arg[i][j])) > 254) {
		str[len = --pos] = 0;
		printf("\r%s%s",prompt,_term[CE]);
		output(str);
		free_arg(arg);
		return str;
	      }
	      for(x=0;arg[i][j][x];x++)
		str[pos++] = arg[i][j][x];
	      str[pos++] = ' ';
	    }
	    if (arg[i+1]) {
	      str[pos++] = ';';
	      str[pos++] = ' ';
	    }
	  }
	  str[len = --pos] = 0;
	  printf("\r%s%s",prompt,_term[CE]);
	  output(str);	  
	  free_arg(arg);
	  break;
	case 20:	/* kill word */
	  if (len > 0) {
	    str[len] = 0;
	    if (!isspace(str[pos]))
	      for(;pos<len && !isspace(str[pos]);pos++) outch(str[pos]);
	    if (pos > 0 && isspace(str[pos-1]))
	      for(;pos>0 && isspace(str[pos]);pos--) putchar('\b');
	    if (pos > 0) {
	      if (pos == len) {
		for(;pos > 0 && !isspace(str[pos]);pos--) printf("\b \b");
		str[len = pos] = 0;
	      } else {
		for(i=pos-1; i> 0 && !isspace(str[i]); i--) delch();
		delch();
		for(j=0;str[pos+j];j++) str[i+j] = str[pos+j];
		str[len = (i+j)] = 0;
		pos = i;
	      }
	    }
	  }
	  break;
	case 21:	/* Make next char a control char */
	  ic = 1;
	  break;
	default:
	  putchar('\007');
	  break;
      }
    } else if (KEY->gold) {
      _glvl = KEY->glvl;
    } else {
      if (KEY->clr) {
	if (pos || (!pos && len)) printf("\r%s%s",prompt,_term[CE]);
	str[len = pos = 0] = 0;
      }
      insertstr(KEY->cmd);
      if (KEY->rtn) break;
      ch = 0;
    }
  } while(ch != '\n' && ch != '\r');
  echo();
  putchar('\n');
  str[len] = 0;
  if (str[0] == '!') {	/* uh oh... we got a csh user on our hands! */
    if (!str[1]) return str;	/* just a measly ! */
    if (str[1] == '!') {
      strcpy(str,history[curhist-1]);
      if (_verbose) puts(str);
      return str;
    }
    for(i=1;isdigit(str[i]);i++);
    if (str[i]) {	/* has to be a string */
      for(i=curhist-1;i>=0;i--) {
	for(j=0;str[j+1] && str[j+1] == history[i][j];) j++;
	if (str[j+1]) continue;
	strcpy(str,history[i]);
	if (_verbose) puts(str);
	return str;
      }
      /* no match, just return as is */
    } else {		/* has to be a number */
      i = atoi(str+1);
      if (i < 0 || i >= curhist) return str;
      strcpy(str,history[i]);
      if (_verbose) puts(str);
      return str;
    }
  }
  return str;
}

insertstr(istr)
char *istr;
{
  int i,j = strlen(istr);

  if (_insert && pos < len) {
    str[len] = 0;
    if (_term[IC]) {
      for(i=len;i>=pos;i--) str[i+j] = str[i];
      for(i=0;istr[i];i++) {
	if (len >= 254) {
	  putchar('\007');
	  return;
	}
	printf("%s",_term[IC]);
	outch(istr[i]);
	str[pos] = istr[i];
	pos++;
	len++;
      }
    } else {
      for(i=len;i>=pos;i--) str[i+j] = str[i];
      str[pos] = 0;
      output(istr);
      output(str+pos+j);
      printf("\r%s",prompt);
      if (pos > 0) output(str);
      for(i=0;istr[i];i++) {
	if (len >= 254) {
	  putchar('\007');
	  return;
	}
	outch(istr[i]);
	str[pos] = istr[i];
	pos++;
	len++;
      }
    }
  } else
    for(i=0;istr[i];i++) {
      if (len >= 254) {
	putchar('\007');
	return;
      }
      outch(istr[i]);
      str[pos] = istr[i];
      if(pos==len) len++;
      pos++;
    }
}

output(str)
char *str;
{
  int i=0;
  while(str[i]) outch(str[i++]);
  return;
}

outch(ch)
char ch;
{
  if (ch > 127) ch -= 128;
  if (ch<32) {
    if (_term[SO]) printf("%s%c%s",_term[SO],ch+64,_term[SE]);
    else printf("^%c",ch+64);
  } else if (ch == 127) {
    if (_term[SO]) printf("%s?%s",_term[SO],_term[SE]);
    else printf("^?");
  } else putchar(ch);
}

noecho()
{
  ioctl(0,TIOCGETP,&OTTY);
  bcopy(&OTTY,&STTY,sizeof(struct sgttyb));
  OTTY.sg_flags |= CBREAK;		/* RAW */
  OTTY.sg_flags &= ~ECHO;
  if (_notypeahead) ioctl(0,TIOCSETP,&OTTY);
  else ioctl(0,TIOCSETN,&OTTY);
}

echo()
{
  OTTY.sg_flags &= ~CBREAK;	/* RAW */
  OTTY.sg_flags |= ECHO;
  ioctl(0,TIOCSETN,&OTTY);
}

delch()
{
  char e;
  int i;

  if(pos > 0) {
    e = (str[pos-1]<32 && !_term[SO])? 2 : 1;
    str[len] = 0;
    while(e) {
      if (_insert) {
	if (pos < len) {
	  if (_term[DC]) printf("\b%s",_term[DC]);
	  else {
	    str[pos-1] = 0;
	    fputc('\b',stdout);
	    output(str+pos);
	    printf(" \r%s",prompt);
	    output(str);
	  }
	  for(i=pos;i<len;i++) str[i-1] = str[i];
	  len--; pos--;
	} else {
	  str[pos = --len] = 0;
	  fputs("\b \b",stdout);
	}
      }	else {
	printf("\b \b");
	str[--pos] = ' ';
      }
      e--;
    }
  }
}
