/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */

#include "shell.h"

#define hash(x)	(isalpha(x)? (x & 31) + 10 : isdigit(x)? x - '0' : x == '_' ? 10 : -1)

struct _assign {
  char *name;
  char *path;
  struct _assign *next;
} *assign[37];

char *malloc(), *strcpy(), *evalassign(), **eval_assigns();
extern char buf[1025],path[1025];
extern int a,b,c,d;

char ***parse_assigns(arg)
char ***arg;
{
  int i;

  for(i=0;arg[i];i++)
    arg[i] = eval_assigns(arg[i]);

  return arg;
}

char **eval_assigns(arg)
char **arg;
{
  int i,n = 0;

  for(i=0;arg[i];i++) {
    if (*arg[i] == '(' && !arg[i][1]) n++;
    if (*arg[i] == ')' && !arg[i][1]) n -= (n?1:0);
    if (!n) arg[i] = evalassign(arg[i]);
  }
  return arg;
}

char *evalassign(w)
char *w;
{
  int i;
  char *p, *s = w, *tmp;
  struct _assign *ptr;

  if (*w == '\'' || *w == '"') return w;

  if (!(p = (char *)index(w,':'))) return w;
  for(i=0;w < p;i++) buf[i] = *w++;
  buf[i] = 0;
  w++;
  ptr = assign[hash(*buf)];
  while (ptr) {
    if (!strcmp(ptr->name,buf)) break;
    ptr = ptr->next;
  }
  if (!ptr) return s;
  tmp = strcpy((char *)malloc(strlen(ptr->path)+strlen(w)+1),ptr->path);
  strcat(tmp,w);
  free(s);
  return tmp;
}

ASSIGN(n,arg,fout,ferr)
int n;
char **arg;
FILE *fout,*ferr;
{
  struct _assign *p, *t, *s;
  struct stat st;

  if (n == 1) {
    for(a=0;a<37;a++) {
      p = assign[a];
      while (p != NULL) {
	fprintf(fout,"%s:\t%s\n",p->name,p->path);
	p = p->next;
      }
    }
    return 0;
  }
  if (n == 2) {
    if ((a = hash(*arg[1])) < 0) return 1;
    p = assign[a];
    while (p != NULL) {
      if (!strcmp(p->name,arg[1])) {
	fprintf(fout,"%s:\t%s\n",p->name,p->path);
	return 0;
      }
      p = p->next;
    }
    return 0;
  }

  if (n > 3) {
    fprintf(ferr,"assign: too many arguments.\n");
    return 1;
  }
  if (!(a = strlen(arg[1])) || !(b = strlen(arg[2]))) {
    fprintf(ferr,"assign: invalid null assignment.\n");
    return 1;
  }
  if (a > 80) {
    fprintf(ferr,"assign: assignment name too long.\n");
    return 1;
  }
  if (arg[1][a-1] == ':') arg[1][--a] = 0;
  for(d=0;arg[1][d];d++)
    if (hash(arg[1][d]) < 0) {
      fprintf(ferr,"assign: illegal assignment name %s.\n",arg[1]);
      return 1;
    }

  t = (struct _assign *)malloc(sizeof(struct _assign));
  t->name = strcpy(malloc(strlen(arg[1])+1),arg[1]);
  stat(arg[2],&st);
  if ((st.st_mode & S_IFMT) == S_IFDIR && arg[2][b-1] != '/') {
    t->path = strcpy(malloc(strlen(arg[2])+2),arg[2]);
    strcat(t->path,"/");
  } else t->path = strcpy(malloc(strlen(arg[2])+1),arg[2]);

  s = p =  assign[b = hash(*arg[1])];
  while(p) {
    if (!(a=strcmp(p->name,t->name))) {
      free(p->path);
      p->path = t->path;
      free(t->name);
      free(t);
      return 0;
    }
    if (a < 0) break;
    s = p;
    p = p->next;
  }
  t->next = p;
  if (p == assign[b] && s == assign[b]) assign[b] = t;
  else s->next = t;
  return 0;  
}

UNASSIGN(n,arg,fout,ferr)
int n;
char **arg;
FILE *fout,*ferr;
{
  struct _assign *p, *s;
  if (n == 1) {
    fprintf(ferr,"unassign: not enough arguments.\n");
    return 1;
  }
  for(a=1;arg[a];a++) {
    s = p = assign[c = hash(*arg[a])];
    while (p) {
      if (!(b = strcmp(p->name,arg[a]))) {
	if (s == assign[c]) assign[c] = p->next;
	else s->next = p->next;
	free(p->name);
	free(p->path);
	free(p);
	break;
      }
      if (b < 0) break;
      s = p;
      p = p->next;
    }
  }
  return 0;
}
