/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

/*****************************************
 * 
 * draw those coordinate boxies
 *
 *****************************************/

#include <gl.h>
#include <device.h>
#include <math.h>
#include "graph.h"

extern int    *obj_style;
extern Obj    *obj;
extern Box    *box;
extern Light  *light;
extern Menu   *menu;
extern Slice  *slice;
extern View   view;
extern Flag   flag;
extern float  factor;
extern float  get_angle();
extern int    mat_index,obj_index;
extern float  sizze;
extern oview *ooview;
/* 
 * coordinate for the boxies 
 */
float          obox[8][3],small_obox[8][3],v_coor[8][3];

/*********************************************
 *
 * initialize the coordinates 
 *
 *********************************************/
obj_box_coor()
{
  register int i;
  register float c_x,c_y,c_z;

  obox[0][0]= ooview->xmin; obox[0][1]= ooview->ymin; obox[0][2]= ooview->zmin;
  obox[1][0]= ooview->xmax; obox[1][1]= ooview->ymin; obox[1][2]= ooview->zmin;
  obox[2][0]= ooview->xmax; obox[2][1]= ooview->ymax; obox[2][2]= ooview->zmin;
  obox[3][0]= ooview->xmin; obox[3][1]= ooview->ymax; obox[3][2]= ooview->zmin;
  obox[4][0]= ooview->xmin; obox[4][1]= ooview->ymin; obox[4][2]= ooview->zmax;
  obox[5][0]= ooview->xmax; obox[5][1]= ooview->ymin; obox[5][2]= ooview->zmax;
  obox[6][0]= ooview->xmax; obox[6][1]= ooview->ymax; obox[6][2]= ooview->zmax;
  obox[7][0]= ooview->xmin; obox[7][1]= ooview->ymax; obox[7][2]= ooview->zmax;

  c_x = 0.5*(ooview->xmax + ooview->xmin);
  c_y = 0.5*(ooview->ymax + ooview->ymin);
  c_z = 0.5*(ooview->zmax + ooview->zmin);
  for(i = 0; i < 8; i++) 
    {
      small_obox[i][0] = c_x + obox[i][0] * 0.1; 
      small_obox[i][1] = c_y + obox[i][1] * 0.1; 
      small_obox[i][2] = c_z + obox[i][2] * 0.1; 
    }
}
/******************************************/
view_box_coor()
{
  float tg,tgas,left,right,bottom,top;

  if(view.proj_flag == ORTHOGONAL)
    {
      v_coor[0][0] = view.left; v_coor[0][1] = view.bottom;
      v_coor[0][2] = - view.near;
      v_coor[1][0] = view.right; v_coor[1][1] = view.bottom;
      v_coor[1][2] = - view.near;
      v_coor[2][0] = view.right; v_coor[2][1] = view.top;
      v_coor[2][2] = - view.near;
      v_coor[3][0] = view.left; v_coor[3][1] = view.top;
      v_coor[3][2] = - view.near;
      v_coor[4][0] = view.left; v_coor[4][1] = view.bottom;
      v_coor[4][2] = - view.far;
      v_coor[5][0] = view.right; v_coor[5][1] = view.bottom;
      v_coor[5][2] = - view.far;
      v_coor[6][0] = view.right; v_coor[6][1] = view.top;
      v_coor[6][2] = - view.far;
      v_coor[7][0] = view.left; v_coor[7][1] = view.top;
      v_coor[7][2] = - view.far;
    }

  else if(view.proj_flag == PERSPECTIVE)
    {
      tg = tan(D2R* view.fovy/2.0);
      tgas = tg* view.aspect;

      left = - view.pnear* tgas; right = - left;
      bottom = - view.pnear* tg; top = - bottom;
      
      v_coor[0][0] = left; v_coor[0][1] = bottom; v_coor[0][2] = - view.pnear;
      v_coor[1][0] = right; v_coor[1][1] = bottom; v_coor[1][2]= - view.pnear;
      v_coor[2][0] = right; v_coor[2][1] = top; v_coor[2][2] = - view.pnear;
      v_coor[3][0] = left; v_coor[3][1] = top; v_coor[3][2] = - view.pnear;
 
      left = - view.pfar* tgas; right = - left;
      bottom = - view.pfar* tg; top = - bottom;
      
      v_coor[4][0] = left; v_coor[4][1] = bottom; v_coor[4][2] = - view.pfar;
      v_coor[5][0] = right; v_coor[5][1] = bottom; v_coor[5][2] = - view.pfar;
      v_coor[6][0] = right; v_coor[6][1] = top; v_coor[6][2] = - view.pfar;
      v_coor[7][0] = left; v_coor[7][1] = top; v_coor[7][2] = - view.pfar;
    }
}
/****************************************************************/
/*
 * actual drawing 
 */

mk_ov_box()
{
  int i; 

  if(flag.cmap_flag) color(0);
  else cpack(0x00000000);
  clear(); 

  zbuffer(1);lsetdepth(0,0x007fff);  zclear();

  depthcue(1); 
  if(flag.cmap_flag)
    lshaderange(2561,2815,0,0x007fff);
  else lRGBrange(0,0,0,0,120,255,0,0x007fff);
  draw_coor(2.5* sizze,1);

  if(flag.cmap_flag)
    lshaderange(3329,3583,0,0x007fff);
  else lRGBrange(0,0,0,255,255,0,0,0x007fff);
  pushmatrix();
/*
  draw the big object box. all objects defined is in this box.
  */
  if( flag.mode_flag < 2)
    {
      if(!flag.mode_flag) 
	translate(view.x_trans,view.y_trans,view.z_trans);
      scale(view.x_scale,view.y_scale,view.z_scale);
      set_rotation(view.rot_old_flag, view.x_rot,view.y_rot,view.z_rot);
      if(flag.mode_flag) 
	translate(view.x_trans,view.y_trans,view.z_trans);
    }
  else  /* if (flag.mode_flag >= 2 ) */
    {
      if(flag.mode_flag == 2) 
	translate(view.x_trans,view.y_trans,view.z_trans); 
      scale(view.x_scale,view.y_scale,view.z_scale);
      set_rotation(view.rot_old_flag,
		   box->brx + view.x_rot,
		   box->bry + view.y_rot,
		   box->brz + view.z_rot); 
      if(flag.mode_flag == 3) 
	translate(view.x_trans,view.y_trans,view.z_trans); 
    }
  
  make_box(obox);  
  draw_coor(1.4* sizze,1);  
  
  if( flag.mode_flag == 2 || flag.mode_flag == 3) 
    popmatrix();

/* 
 *  draw the small box, one for each object 
 */

  if(flag.cmap_flag)
    lshaderange(3585,3839,0,0x007fff);
  else
    lRGBrange(0,0,0,255,0,255,0,0x007fff);

  for(i =0; i < obj_style[0]; i++) 
    {
      if( ( (obj+ i)->draw))
	{
	pushmatrix();

	if(flag.mode_flag < 2 )
	  {
	    if(!flag.mode_flag) 
	      translate((obj +i)->x_trans,(obj +i)->y_trans,(obj +i)->z_trans);
	    scale(((obj+i)->x_scale),((obj +i)->y_scale),((obj +i)->z_scale));
	    set_rotation((obj+i)->rot_old,(obj +i)->x_rot, 
			 (obj +i)->y_rot,(obj +i)->z_rot ); 
	    if(flag.mode_flag) 
	      translate((obj +i)->x_trans,(obj +i)->y_trans,(obj +i)->z_trans);
	  }

	if(flag.mode_flag >= 2 )
	  {
	    if(flag.mode_flag == 2) 
	      translate( (obj +i)->x_trans + view.x_trans, 
			(obj +i)->y_trans + view.y_trans ,
			(obj +i)->z_trans + view.z_trans );
	    scale( ((obj +i)->x_scale) * view.x_scale, 
		  ((obj +i)->y_scale) * view.y_scale,  
		  ((obj +i)->z_scale) * view.z_scale);
	    set_rotation((obj+i)->rot_old,(obj +i)->x_rot + view.x_rot,
			 (obj +i)->y_rot + view.y_rot, 
			 (obj +i)->z_rot + view.z_rot); 
	    if(flag.mode_flag == 3) 
	      translate( (obj +i)->x_trans + view.x_trans, 
			(obj +i)->y_trans + view.y_trans ,
			(obj +i)->z_trans + view.z_trans );
	  }
	make_box(small_obox);    
	if( flag.coor_flag) draw_coor(0.30*sizze,0);
	
	popmatrix();
      }
  }

  if(flag.mode_flag < 2 )
    popmatrix();

/*
  draw the viewing box, everything you see on the screen is the 
  inside this box.
  */

  if(flag.cmap_flag)
    lshaderange(2817,3071,0,0x007fff);  
  else 
    lRGBrange(0,0,0,0,255,0,0,0x007fff);

  if(view.view_change)
    { set_new_angle(); view.view_change = 0;}
  if(view.proj_change)
    {view_box_coor();  view.proj_change = 0;}
  move(view.px,view.py,view.pz);
  draw(view.vx,view.vy,view.vz);
  pushmatrix();
  translate(view.vx ,view.vy,view.vz);
  rotate(- view.theta,'y'); 
  rotate(- view.phi,'x'); 
  rotate(view.twist,'z'); 
  make_box(v_coor);
  draw_coor( sizze,1);
  popmatrix();

/*
 *  draw the slice plane direction and the light source direction,
 *  whenever aviable
 */
  
  if(flag.slice){
    draw_s_direc(); }
  depthcue(0); 
  if(flag.light) draw_l_direc();

}
/*********************************************************************/
/*
 * function which draw the slice plane normal.
 */

draw_s_direc() 
{
  float xx1,yy1,zz1,xx2,yy2,zz2;
  float temp1;
  
  temp1 = slice->scale * slice->dist;

  xx1 = - slice->vx; yy1 = - slice->vy; zz1 = - slice->vz;

  xx2 =  temp1 * slice->vx;
  yy2 =  temp1 * slice->vy;
  zz2 =  temp1 * slice->vz;

  move(xx1,yy1,zz1);
  draw(xx2,yy2,zz2);
  cmov(xx2,yy2,zz2);
  charstr("pn");
}

/******************************************************************/
/*
 * draw the light direction 
 */

draw_l_direc()
{
  float lcolor[3];
  int  i;
  char str[3];

  for(i = 0; i<8; i++)
    {
      if((light+i)->on)
	{
	  lcolor[0]= *((light+i)->token +1);
	  lcolor[1]= *((light+i)->token +2);
	  lcolor[2]= *((light+i)->token +3);
	  c3f(lcolor);
	  move(0.,0.,0.); 
	  draw(*((light+i)->token + 5),*((light+i)->token +6),
	       *((light+i)->token +7));
	  /*
	   * for spot light, direction is different
	   * Take care of it later.
	   */
          (void)	  sprintf(str,"L%d",i+1);
	  cmov(*((light+i)->token + 5),*((light+i)->token +6),
	       *((light+i)->token +7));
	  charstr(str);	  
	}
    }
}

/**************************************************************************/
/* 
 * draw the coordinate system
 */
draw_coor(leng,aix)
     float leng; int aix;
{
  move(0.0,0.0,0.0);       draw(leng,0.,0.);
  if(aix) 
    {cmov(leng,0.,0.);     charstr("X"); }
  move(0.0,0.0,0.0);       draw(0.,leng,0.);
  if(aix)
    {cmov(0.,leng,0.);     charstr("Y");}
  move(0.0,0.0,0.0);       draw(0.,0.,leng);
  if(aix)
    { cmov(0.,0.,leng);    charstr("Z");}
}

/***********************************************************************/
/*
 * update the angle for draw the projection box whenever necessary
 */
set_new_angle()
{
  float sinofs,cosofs,dn1,dn2;

  dn1 = sqrt( (view.px - view.vx) *(view.px - view.vx) +
	     (view.pz - view.vz) *(view.pz - view.vz));
  dn2 = sqrt( dn1 * dn1 + (view.py - view.vy) *(view.py - view.vy) );
  
  if(dn1 <= 0.00001) {
    view.theta = 0; view.phi = (short ) (1.5708 * R2D);
    return; }

  sinofs =  (view.px - view.vx)/dn1;
  cosofs =  (view.vz - view.pz)/dn1;
  view.theta = (short) (get_angle(sinofs,cosofs) * R2D );
  
  sinofs = (view.vy - view.py)/dn2;
  cosofs = dn1/dn2;
  view.phi = (short) (get_angle(sinofs,cosofs) * R2D );
}

/***********************************************************/
/*
 * draw the box
 */
make_box(temp)
     float temp[8][3];
{
  bgnline();
  v3f(temp[0]);   v3f(temp[1]);   v3f(temp[2]);   v3f(temp[3]);
  v3f(temp[0]);   v3f(temp[4]);   v3f(temp[5]);   v3f(temp[6]);
  v3f(temp[7]);   v3f(temp[4]);
  endline();
  bgnline();
  v3f(temp[1]);   v3f(temp[5]);
  endline();
  bgnline();
  v3f(temp[2]);   v3f(temp[6]);
  endline();
  bgnline();
  v3f(temp[3]);  v3f(temp[7]);
  endline();
}

/*********************************
 * change_box()
 * change the size and position
 * of the object in the box window
 *
**********************************/
change_box()
{
  int menu_val, menu_val1, dev, x0, x1, dx; 
  short val;

  flag.redraw = 0;
  menu_val = dopup(menu->obj_menu);
  if(menu_val <= 0){qreset();  flag.redraw = 1;  return; }
 tryagain:
  if(menu_val == 1) menu_val1 = dopup(menu->rot_menu);
  else if(menu_val == 2) menu_val1 = dopup(menu->scale_menu);
  else if(menu_val == 3) menu_val1 = dopup(menu->trans_menu);
  if(menu_val1 <= 0) {qreset();  flag.redraw = 1; return; }

  x0 = getvaluator(MOUSEX);
 try1:
  while(!qtest())
    {
      x1 = getvaluator(MOUSEX);
      dx = x1 - x0;
      switch(menu_val)
	{
	case 2:
	  if(menu_val1 == 1)
	    {
	        box->x_scale += 0.0005* (float) dx;
		box->y_scale += 0.0005* (float) dx;
		box->z_scale += 0.0005* (float) dx;
	      }
	  else if(menu_val1 == 2)  box->x_scale += 0.0005* (float) dx;
	  else if(menu_val1 == 3)  box->y_scale += 0.0005* (float) dx;
	  else if(menu_val1 == 4)  box->z_scale += 0.0005* (float) dx;
	  break;
	case 1:
	  if(menu_val1 == 1) {
	    box->x_rot += (short)(0.05*(float) dx);
	    box->x_rot %= 3600; }
	  else if(menu_val1 == 2) {
	    box->y_rot += (short)(0.05*(float) dx);
	    box->y_rot %= 3600; }
	  else if(menu_val1 == 3) {
	    box->z_rot += (short)(0.05*(float) dx);
	    box->z_rot %= 3600; }	    
	  break;
	case 3:
	  if(menu_val1 == 1)  box->x_trans += factor * (float) dx;
	  else if(menu_val1 == 2)  box->y_trans += factor * (float) dx;
	  else if(menu_val1 == 3)  box->z_trans += factor * (float) dx;
	  break;	  
	default:
	  break;
	}
      make_object();
    }
  dev = qread(&val);
  if(dev == INPUTCHANGE) goto try1;
  if(dev == RIGHTMOUSE)  goto tryagain;
  flag.redraw = 1;  
}

/*****************************************************************/
