/*
 * Decompiled with CFR 0.152.
 */
package cryptix.security.rsa;

import cryptix.math.BigInteger;
import cryptix.math.BigNum;
import cryptix.security.rsa.PublicKey;

public class SecretKey
extends PublicKey {
    protected BigInteger d_;
    protected BigInteger p_;
    protected BigInteger q_;
    protected BigInteger u_;

    protected SecretKey() {
    }

    public SecretKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) {
        super(bigInteger, bigInteger2);
        this.d_ = new BigInteger(bigInteger3);
        this.p_ = new BigInteger(bigInteger4);
        this.q_ = new BigInteger(bigInteger5);
        this.u_ = new BigInteger(bigInteger6);
    }

    public final BigInteger d() {
        return new BigInteger(this.d_);
    }

    public final BigInteger p() {
        return new BigInteger(this.p_);
    }

    public final BigInteger q() {
        return new BigInteger(this.q_);
    }

    public final BigInteger u() {
        return new BigInteger(this.u_);
    }

    public BigInteger decrypt(BigInteger bigInteger) {
        return this.cryptFast(this.d_, bigInteger);
    }

    public BigInteger encrypt(BigInteger bigInteger) {
        return this.cryptFast(this.e_, bigInteger);
    }

    public final BigInteger cryptFast(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = (BigInteger)this.p_.clone();
        BigInteger bigInteger4 = (BigInteger)this.q_.clone();
        bigInteger3.dec();
        bigInteger4.dec();
        BigInteger bigInteger5 = new BigInteger().mod(bigInteger, bigInteger3);
        BigInteger bigInteger6 = new BigInteger().mod(bigInteger, bigInteger4);
        BigInteger bigInteger7 = new BigInteger().mod(bigInteger2, this.p_).modExp(bigInteger5, this.p_);
        BigInteger bigInteger8 = new BigInteger().mod(bigInteger2, this.q_).modExp(bigInteger6, this.q_);
        BigInteger bigInteger9 = new BigInteger().sub(bigInteger8, bigInteger7);
        BigInteger bigInteger10 = BigInteger.zero();
        if (bigInteger9.cmp(bigInteger10) < 0) {
            bigInteger9.add(bigInteger9, this.q_);
        }
        bigInteger8.mul(bigInteger9, this.u_);
        bigInteger9.mod(bigInteger8, this.q_);
        bigInteger8.mul(bigInteger9, this.p_);
        bigInteger9.add(bigInteger8, bigInteger7);
        return bigInteger9;
    }

    public final String insane() {
        BigInteger bigInteger = new BigInteger().mul(this.p_, this.q_);
        if (this.n_.cmp(bigInteger) != 0) {
            return "pq != n";
        }
        if (this.p_.cmp(this.q_) >= 0) {
            return "p >= q";
        }
        BigNum.modMul(bigInteger, this.p_, this.u_, this.q_);
        if (bigInteger.cmp(BigInteger.one) != 0) {
            return "(p*u) mod q != 1";
        }
        return null;
    }

    public final String test() {
        String string = this.insane();
        if (string != null) {
            return string;
        }
        new StringBuffer();
        int n = 7;
        byte[] byArray = new byte[16];
        int n2 = 0;
        while (n2 < 16) {
            byArray[n2++] = n;
            n = (byte)(n + 3);
        }
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = this.encrypt(bigInteger);
        BigInteger bigInteger3 = this.decrypt(bigInteger2);
        if (bigInteger.cmp(bigInteger3) != 0) {
            return "Key test failed " + bigInteger + "\nis not" + bigInteger3;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\nd:" + this.d_ + "\np:" + this.p_ + "\nq:" + this.q_ + "\nu:" + this.u_;
    }
}

