/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.cipher;

import cryptix.CryptixException;
import cryptix.provider.cipher.NativeLink;
import cryptix.util.core.Debug;
import cryptix.util.core.LinkStatus;
import java.io.PrintWriter;
import java.security.Cipher;
import java.security.Key;
import java.security.KeyException;
import java.security.SymmetricCipher;

public final class RC2
extends Cipher
implements SymmetricCipher {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel((String)"RC2");
    private static final PrintWriter err = Debug.getOutput();
    private static NativeLink linkStatus = new NativeLink("RC2", 2, 3);
    private long native_cookie;
    private Object native_lock;
    private static final int[] S_BOX;
    private int[] sKey = new int[64];
    public static final int BLOCK_SIZE = 8;

    private static void debug(String string) {
        err.println("RC2: " + string);
    }

    public static LinkStatus getLinkStatus() {
        return linkStatus;
    }

    private void link() {
        NativeLink nativeLink = linkStatus;
        synchronized (nativeLink) {
            block8: {
                try {
                    if (linkStatus.attemptLoad()) {
                        linkStatus.checkVersion(RC2.getLibMajorVersion(), RC2.getLibMinorVersion());
                        linkStatus.check(this.native_clinit());
                    }
                    if (linkStatus.useNative()) {
                        linkStatus.check(this.native_init());
                        this.native_lock = new Object();
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    linkStatus.fail((Throwable)unsatisfiedLinkError);
                    if (debuglevel <= 2) break block8;
                    RC2.debug(unsatisfiedLinkError.getMessage());
                }
            }
            if (debuglevel > 2) {
                RC2.debug("Using native library? " + (this.native_lock != null));
            }
            return;
        }
    }

    private static native int getLibMajorVersion();

    private static native int getLibMinorVersion();

    private native String native_clinit();

    private native String native_init();

    private native String native_ks(long var1, byte[] var3);

    private native int native_crypt(long var1, byte[] var3, int var4, byte[] var5, int var6, boolean var7);

    private native String native_finalize();

    public RC2() {
        super(false, false, "Cryptix");
        this.link();
    }

    protected final void finalize() {
        if (this.native_lock != null) {
            Object object = this.native_lock;
            synchronized (object) {
                String string = this.native_finalize();
                if (string != null) {
                    RC2.debug(String.valueOf(string) + " in native_finalize");
                }
                return;
            }
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public int engineBlockSize() {
        return 8;
    }

    public void engineInitEncrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    public void engineInitDecrypt(Key key) throws KeyException {
        this.makeKey(key);
    }

    protected int engineUpdate(byte[] object, int n, int n2, byte[] byArray, int n3) {
        Object object2;
        boolean bl;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = n2 / 8;
        n2 = n4 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (object == byArray && (n3 >= n && (long)n3 < (long)n + (long)n2 || n >= n3 && (long)n < (long)n3 + (long)n2)) {
            object2 = new byte[n2];
            System.arraycopy(object, n, object2, 0, n2);
            object = object2;
            n = 0;
        }
        if (this.native_lock != null) {
            object2 = this.native_lock;
            synchronized (object2) {
                if (n < 0 || (long)n + (long)n2 > (long)((byte[])object).length || n3 < 0 || (long)n3 + (long)n2 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException(String.valueOf(this.getAlgorithm()) + ": Arguments to native_crypt would cause a buffer overflow");
                }
                int n5 = 0;
                while (n5 < n4) {
                    if (this.native_crypt(this.native_cookie, (byte[])object, n, byArray, n3, bl) == 0) {
                        throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Error in native code");
                    }
                    n += 8;
                    n3 += 8;
                    ++n5;
                }
            }
        } else if (bl) {
            int n6 = 0;
            while (n6 < n4) {
                this.blockEncrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                this.blockDecrypt((byte[])object, n, byArray, n3);
                n += 8;
                n3 += 8;
                ++n7;
            }
        }
        return n2;
    }

    private void makeKey(Key key) throws KeyException {
        Object object;
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new KeyException("Null RC2 user key");
        }
        int n = byArray.length;
        if (n > 128) {
            throw new KeyException("Invalid RC2 user key size");
        }
        if (this.native_lock != null) {
            object = this.native_lock;
            synchronized (object) {
                try {
                    linkStatus.check(this.native_ks(this.native_cookie, byArray));
                    Object var5_5 = null;
                    return;
                }
                catch (Error error) {
                    this.native_finalize();
                    this.native_lock = null;
                    if (debuglevel > 0) {
                        RC2.debug(String.valueOf(error) + ". Will use 100% Java.");
                    }
                }
            }
        }
        object = new int[128];
        int n2 = 0;
        while (n2 < n) {
            object[n2] = byArray[n2] & 0xFF;
            ++n2;
        }
        int n3 = n;
        while (n3 < 128) {
            object[n3] = S_BOX[object[n3 - n] + object[n3 - 1] & 0xFF];
            ++n3;
        }
        object[128 - n] = S_BOX[object[128 - n] & 0xFF];
        int n4 = 127 - n;
        while (n4 >= 0) {
            object[n4] = S_BOX[object[n4 + n] ^ object[n4 + 1]];
            --n4;
        }
        int n5 = 63;
        while (n5 >= 0) {
            this.sKey[n5] = (object[n5 * 2 + 1] << 8 | object[n5 * 2]) & 0xFFFF;
            --n5;
        }
    }

    private void blockEncrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
        int n6 = byArray[n++] & 0xFF | (byArray[n] & 0xFF) << 8;
        int n7 = 0;
        int n8 = 0;
        while (n8 < 16) {
            n3 = n3 + (n4 & ~n6) + (n5 & n6) + this.sKey[n7++] & 0xFFFF;
            n3 = n3 << 1 | n3 >>> 15;
            n4 = n4 + (n5 & ~n3) + (n6 & n3) + this.sKey[n7++] & 0xFFFF;
            n4 = n4 << 2 | n4 >>> 14;
            n5 = n5 + (n6 & ~n4) + (n3 & n4) + this.sKey[n7++] & 0xFFFF;
            n5 = n5 << 3 | n5 >>> 13;
            n6 = n6 + (n3 & ~n5) + (n4 & n5) + this.sKey[n7++] & 0xFFFF;
            n6 = n6 << 5 | n6 >>> 11;
            if (n8 == 4 || n8 == 10) {
                n5 += this.sKey[(n4 += this.sKey[(n3 += this.sKey[n6 & 0x3F]) & 0x3F]) & 0x3F];
                n6 += this.sKey[n5 & 0x3F];
            }
            ++n8;
        }
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)n6;
        byArray2[n2] = (byte)(n6 >>> 8);
    }

    private void blockDecrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
        int n4 = byArray[n + 2] & 0xFF | (byArray[n + 3] & 0xFF) << 8;
        int n5 = byArray[n + 4] & 0xFF | (byArray[n + 5] & 0xFF) << 8;
        int n6 = byArray[n + 6] & 0xFF | (byArray[n + 7] & 0xFF) << 8;
        int n7 = 63;
        int n8 = 15;
        while (n8 >= 0) {
            n6 = (n6 >>> 5 | n6 << 11) & 0xFFFF;
            n6 = n6 - (n3 & ~n5) - (n4 & n5) - this.sKey[n7--] & 0xFFFF;
            n5 = (n5 >>> 3 | n5 << 13) & 0xFFFF;
            n5 = n5 - (n6 & ~n4) - (n3 & n4) - this.sKey[n7--] & 0xFFFF;
            n4 = (n4 >>> 2 | n4 << 14) & 0xFFFF;
            n4 = n4 - (n5 & ~n3) - (n6 & n3) - this.sKey[n7--] & 0xFFFF;
            n3 = (n3 >>> 1 | n3 << 15) & 0xFFFF;
            n3 = n3 - (n4 & ~n6) - (n5 & n6) - this.sKey[n7--] & 0xFFFF;
            if (n8 == 11 || n8 == 5) {
                n6 = n6 - this.sKey[n5 & 0x3F] & 0xFFFF;
                n5 = n5 - this.sKey[n4 & 0x3F] & 0xFFFF;
                n4 = n4 - this.sKey[n3 & 0x3F] & 0xFFFF;
                n3 = n3 - this.sKey[n6 & 0x3F] & 0xFFFF;
            }
            --n8;
        }
        byArray2[n2++] = (byte)n3;
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)n6;
        byArray2[n2] = (byte)(n6 >>> 8);
    }

    static {
        int[] nArray = new int[256];
        nArray[0] = 217;
        nArray[1] = 120;
        nArray[2] = 249;
        nArray[3] = 196;
        nArray[4] = 25;
        nArray[5] = 221;
        nArray[6] = 181;
        nArray[7] = 237;
        nArray[8] = 40;
        nArray[9] = 233;
        nArray[10] = 253;
        nArray[11] = 121;
        nArray[12] = 74;
        nArray[13] = 160;
        nArray[14] = 216;
        nArray[15] = 157;
        nArray[16] = 198;
        nArray[17] = 126;
        nArray[18] = 55;
        nArray[19] = 131;
        nArray[20] = 43;
        nArray[21] = 118;
        nArray[22] = 83;
        nArray[23] = 142;
        nArray[24] = 98;
        nArray[25] = 76;
        nArray[26] = 100;
        nArray[27] = 136;
        nArray[28] = 68;
        nArray[29] = 139;
        nArray[30] = 251;
        nArray[31] = 162;
        nArray[32] = 23;
        nArray[33] = 154;
        nArray[34] = 89;
        nArray[35] = 245;
        nArray[36] = 135;
        nArray[37] = 179;
        nArray[38] = 79;
        nArray[39] = 19;
        nArray[40] = 97;
        nArray[41] = 69;
        nArray[42] = 109;
        nArray[43] = 141;
        nArray[44] = 9;
        nArray[45] = 129;
        nArray[46] = 125;
        nArray[47] = 50;
        nArray[48] = 189;
        nArray[49] = 143;
        nArray[50] = 64;
        nArray[51] = 235;
        nArray[52] = 134;
        nArray[53] = 183;
        nArray[54] = 123;
        nArray[55] = 11;
        nArray[56] = 240;
        nArray[57] = 149;
        nArray[58] = 33;
        nArray[59] = 34;
        nArray[60] = 92;
        nArray[61] = 107;
        nArray[62] = 78;
        nArray[63] = 130;
        nArray[64] = 84;
        nArray[65] = 214;
        nArray[66] = 101;
        nArray[67] = 147;
        nArray[68] = 206;
        nArray[69] = 96;
        nArray[70] = 178;
        nArray[71] = 28;
        nArray[72] = 115;
        nArray[73] = 86;
        nArray[74] = 192;
        nArray[75] = 20;
        nArray[76] = 167;
        nArray[77] = 140;
        nArray[78] = 241;
        nArray[79] = 220;
        nArray[80] = 18;
        nArray[81] = 117;
        nArray[82] = 202;
        nArray[83] = 31;
        nArray[84] = 59;
        nArray[85] = 190;
        nArray[86] = 228;
        nArray[87] = 209;
        nArray[88] = 66;
        nArray[89] = 61;
        nArray[90] = 212;
        nArray[91] = 48;
        nArray[92] = 163;
        nArray[93] = 60;
        nArray[94] = 182;
        nArray[95] = 38;
        nArray[96] = 111;
        nArray[97] = 191;
        nArray[98] = 14;
        nArray[99] = 218;
        nArray[100] = 70;
        nArray[101] = 105;
        nArray[102] = 7;
        nArray[103] = 87;
        nArray[104] = 39;
        nArray[105] = 242;
        nArray[106] = 29;
        nArray[107] = 155;
        nArray[108] = 188;
        nArray[109] = 148;
        nArray[110] = 67;
        nArray[111] = 3;
        nArray[112] = 248;
        nArray[113] = 17;
        nArray[114] = 199;
        nArray[115] = 246;
        nArray[116] = 144;
        nArray[117] = 239;
        nArray[118] = 62;
        nArray[119] = 231;
        nArray[120] = 6;
        nArray[121] = 195;
        nArray[122] = 213;
        nArray[123] = 47;
        nArray[124] = 200;
        nArray[125] = 102;
        nArray[126] = 30;
        nArray[127] = 215;
        nArray[128] = 8;
        nArray[129] = 232;
        nArray[130] = 234;
        nArray[131] = 222;
        nArray[132] = 128;
        nArray[133] = 82;
        nArray[134] = 238;
        nArray[135] = 247;
        nArray[136] = 132;
        nArray[137] = 170;
        nArray[138] = 114;
        nArray[139] = 172;
        nArray[140] = 53;
        nArray[141] = 77;
        nArray[142] = 106;
        nArray[143] = 42;
        nArray[144] = 150;
        nArray[145] = 26;
        nArray[146] = 210;
        nArray[147] = 113;
        nArray[148] = 90;
        nArray[149] = 21;
        nArray[150] = 73;
        nArray[151] = 116;
        nArray[152] = 75;
        nArray[153] = 159;
        nArray[154] = 208;
        nArray[155] = 94;
        nArray[156] = 4;
        nArray[157] = 24;
        nArray[158] = 164;
        nArray[159] = 236;
        nArray[160] = 194;
        nArray[161] = 224;
        nArray[162] = 65;
        nArray[163] = 110;
        nArray[164] = 15;
        nArray[165] = 81;
        nArray[166] = 203;
        nArray[167] = 204;
        nArray[168] = 36;
        nArray[169] = 145;
        nArray[170] = 175;
        nArray[171] = 80;
        nArray[172] = 161;
        nArray[173] = 244;
        nArray[174] = 112;
        nArray[175] = 57;
        nArray[176] = 153;
        nArray[177] = 124;
        nArray[178] = 58;
        nArray[179] = 133;
        nArray[180] = 35;
        nArray[181] = 184;
        nArray[182] = 180;
        nArray[183] = 122;
        nArray[184] = 252;
        nArray[185] = 2;
        nArray[186] = 54;
        nArray[187] = 91;
        nArray[188] = 37;
        nArray[189] = 85;
        nArray[190] = 151;
        nArray[191] = 49;
        nArray[192] = 45;
        nArray[193] = 93;
        nArray[194] = 250;
        nArray[195] = 152;
        nArray[196] = 227;
        nArray[197] = 138;
        nArray[198] = 146;
        nArray[199] = 174;
        nArray[200] = 5;
        nArray[201] = 223;
        nArray[202] = 41;
        nArray[203] = 16;
        nArray[204] = 103;
        nArray[205] = 108;
        nArray[206] = 186;
        nArray[207] = 201;
        nArray[208] = 211;
        nArray[210] = 230;
        nArray[211] = 207;
        nArray[212] = 225;
        nArray[213] = 158;
        nArray[214] = 168;
        nArray[215] = 44;
        nArray[216] = 99;
        nArray[217] = 22;
        nArray[218] = 1;
        nArray[219] = 63;
        nArray[220] = 88;
        nArray[221] = 226;
        nArray[222] = 137;
        nArray[223] = 169;
        nArray[224] = 13;
        nArray[225] = 56;
        nArray[226] = 52;
        nArray[227] = 27;
        nArray[228] = 171;
        nArray[229] = 51;
        nArray[230] = 255;
        nArray[231] = 176;
        nArray[232] = 187;
        nArray[233] = 72;
        nArray[234] = 12;
        nArray[235] = 95;
        nArray[236] = 185;
        nArray[237] = 177;
        nArray[238] = 205;
        nArray[239] = 46;
        nArray[240] = 197;
        nArray[241] = 243;
        nArray[242] = 219;
        nArray[243] = 71;
        nArray[244] = 229;
        nArray[245] = 165;
        nArray[246] = 156;
        nArray[247] = 119;
        nArray[248] = 10;
        nArray[249] = 166;
        nArray[250] = 32;
        nArray[251] = 104;
        nArray[252] = 254;
        nArray[253] = 127;
        nArray[254] = 193;
        nArray[255] = 173;
        S_BOX = nArray;
    }
}

