/* Copyright (c) 1989 Michel Fortier and Peter A. Buhr */

/* 
 * this file contains several routines to store
 * strings for later use
 */

#include <stdio.h>
#include <strings.h>
#include "uMpp.h"
#include "uBuffer.h"

/* 
 * GLOBAL VARIABLES
 */

int lineno; 		/* current line number */
FILE *foutput;		/* where to write the output */
char *MonBuffer;	/* string for stored string */
int  no_echo;		/* store caracter ? */
int  PrBuffer_length;	/* length of printing buffer */
int  PrBuffer_max;	/* maximum length of printing buffer */
int  MonBuffer_length;	/* length of storing buffer */
int  MonBuffer_max;	/* maximum length of storing buffer */
char *PrBuffer;		/* printing buffer */

/*
 * initialise lengths and buffers of all variables
 */

void init_MonBuffer()
{
    PrBuffer_max = 80;
    PrBuffer = ( char * )xmalloc( PrBuffer_max );
    PrBuffer_length = 0;
    PrBuffer[ 0 ] = '\0';
    
    MonBuffer_max = 80;
    MonBuffer = ( char * )xmalloc( MonBuffer_max );
    MonBuffer_length = 0;
    MonBuffer[ 0 ] = '\0';
}

/*
 * store caracter in printing buffer
 */

void echo( c )
    char c;
{
    if ( PrBuffer_length + 1 >= PrBuffer_max ) {
	PrBuffer_max += 80;
	PrBuffer = ( char * )xrealloc( PrBuffer, PrBuffer_max );
    }
    PrBuffer[ PrBuffer_length ] = c;
    PrBuffer_length += 1;
    PrBuffer[ PrBuffer_length ] = '\0';
}

/*
 * print printing buffer
 * and store in appropriate buffer if necessary
 */

void printbuffer( code )
    int code;
{
    int i;

    if ( no_echo > 1 ) {
	while ( MonBuffer_length + PrBuffer_length >= MonBuffer_max ) {
	    MonBuffer_max += 80;
	    MonBuffer = ( char * )xrealloc( MonBuffer, MonBuffer_max );
	}
	strcpy( &MonBuffer[ MonBuffer_length ], PrBuffer );
	MonBuffer_length += PrBuffer_length;
    } else {
	fprintf( foutput, "%s", PrBuffer );
    }
    PrBuffer_length = 0;
    PrBuffer[ 0 ] = '\0';
    if ( no_echo == 1 && code == 1 ) {
	no_echo = 2;
    }
}

/*
 * add "int" type in FrontType buffer for function without type
 */

void add_type_int()
{
    if ( MonBuffer_length + 4 == MonBuffer_max ) {
	MonBuffer_max += 80;
	MonBuffer = ( char * )xrealloc( MonBuffer, MonBuffer_max );
    }
    strcpy( &MonBuffer[ MonBuffer_length ], "int " );
    MonBuffer_length += 4;
}

/* 
 * add parameter list to BackType
 */

void add_arg()
{
    if ( MonBuffer_length + 2 == MonBuffer_max ) {
	MonBuffer_max += 80;
	MonBuffer = ( char * )xrealloc( MonBuffer, MonBuffer_max );
    }
    strcpy( &MonBuffer[ MonBuffer_length ], "()" );
    MonBuffer_length += 2;
}

