/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * moncc.c -- Command for compiling programs that contain uSystem monitors and concurrency routines.
 * 
 * Author          : Richard A. Stroobosscher
 * Created On      : Mon Feb  5 22:18:17 1990
 * Last Modified By: Peter A. Buhr
 * Last Modified On: Wed Jan  9 14:15:15 1991
 * Update Count    : 41
 */

#include <stdio.h>
#include <strings.h>
#include <uUnix.h>
#include <shell.h>
#include <vstrcat.h>

#define MAX 1024

char *home = HOME;

void main( int argc, char *argv[] ) {

    int i;
    char *dir = "/release";
    char *ver = "Version 4.3.2";
    char *vmsg = "(release)";
    char *cppmsg = "";
    char flags[MAX] = " -D__U_MONITOR__";
    char com[MAX] = "";
    char arg[MAX] = "";
    char opt[MAX] = "";
    
    int heading_flag = 1;
    int verbose_flag = 0;

    for ( i = 1; i < argc; i += 1 ) {
	if ( argv[i][0] == '-' ) {
	    if ( strcmp( argv[i], "-MON" ) == 0 ) {
		cppmsg = "(only-preprocess)";
		strcat( flags, " -D__MON__" );
	    } else if ( strcmp( argv[i], "-monwork" ) == 0 ) {
		vmsg = "(work)";
		dir = "/work";
		strcat( flags, " -D__MONWORK__" );
	    } else if ( strcmp( argv[i], "-quiet" ) == 0 ) {
		vstrcat( arg, " ", argv[i], 0 );
		heading_flag = 0;
	    } else {
		vstrcat( arg, " ", argv[i], 0 );
		if ( strcmp( argv[i], "-v" ) == 0 ) {
		    verbose_flag = 1;
		} /* if */
	    } /* if */
	} else {
	    vstrcat( arg, " ", argv[i], 0 );
	} /* if */
    } /* for */
    
    if ( heading_flag ) {
	fprintf( stderr, "uMonitor %s %s %s\n", ver, vmsg, cppmsg );
    } /* if */

    vstrcat( com, home,
	    "/bin/concc -b../../monitor", dir, "/bin/", flags,
	    " -I", home, "/monitor", dir, "/inc", opt, arg, 0 );

    if ( verbose_flag ) {
	fprintf( stderr, "moncc\n %s\n", com );
    } /* if */
    
    exit( shell( com ) );
}

/* Local Variables: */
/* compile-command: "dmake -k" */
/* End: */
