/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uIdle.i -- 
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Thu Nov  8 10:59:18 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:29:59 1990
 * Update Count     : 5
 */

static void uIdle( uTaskQueue *ready ) {

    /*
     * Spin for a user defined period of time or until work appears.
     * If no work appears, pause until restarted by a sigalrm generated
     * by a task being put on the ready queue for this cluster.
     */

    int i;
    int spin = uWorkProcessor->cluster->spin * U_RESOLUTION;
    
    for ( i = 0; i < spin; i += U_CALIBRATE ) {

	if ( uWorkProcessor->stop ) {			/* if the processor is scheduled for termination, return. */
	    return;
	} /* exit */

	if ( ! uTaskQueueEmpty( ready ) ) {		/* if work appears on the ready queue, return. */
	    return;
	} /* exit */

    } /* for */

#ifndef __U_CALIBRATE__

    {
	int mask;
	
	uAcquireTaskQueue( ready );			/* lock the ready queue */
	if ( uTaskQueueEmpty( ready ) ) {		/* if no work on the ready queue */
	    mask = uSigBlock( uSigMask( SIGALRM ) );	/* block SIGALRM signals and save the old signal mask */
	    uSetAlarm( 0 );				/* do not generate any more SIGALRMS until woken up */
	    if ( ! uWorkProcessor->stop ) {		/* if processor not stopped */
		uWorkProcessor->state = U_IDLE;		/* change this processor's state to idle */
		ready->idle = U_TRUE;			/* set the idle flag so that processors get woken up */
		uReleaseTaskQueue( ready );		/* unlock the ready queue */
		uSigPause( mask );			/* unblock SIGALRM signals and pause until a signal is received */
		uSigSetMask( mask );			/* restore old signal mask */
		uWorkProcessor->state = U_BUSY;		/* set state back to busy just to make sure */
	    } else {
		uReleaseTaskQueue( ready );		/* unlock the ready queue */
		uSigSetMask( mask );			/* restore old signal mask */
	    } /* if */
	} else {
	    uReleaseTaskQueue( ready );			/* unlock the ready queue */
	} /* if */
    }
    
#endif
    
} /* uIdle */

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
