/*                              -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uUnix.i -- declarations of UNIX system calls.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Mon Aug 27 14:42:21 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Mon Mar  4 18:24:45 1991
 * Update Count     : 143
 */ 

#ifndef __U_UNIXH__
#define __U_UNIXH__

/*
 * The #define __U_STDC__ indicates that the uSystem is running on a machine with
 * an ANSI compiler and ANSI header files. This will be generalized when more ANSI
 * environments are available.
 */

#if defined( sgi ) || defined( __sgi__ )		/* this will be made more general in the future */
#define __U_STDC__
#endif

/*
 * ultrix 4.1 has some prototypes defined.
 * uSystem needs some work to support ultrix 4.1
 * This line is edited on configuration
 */
#if defined( ultrix ) || defined( __ultrix__ )
#define __U_STDC__		/* uUltrixStupidity */
#endif

#ifdef __U_STDC__					/* ANSI HEADER FILES AVAILABLE */
#include <stdlib.h>					/* Many useful definitions */
#else
/* Must provide our own definitions */

extern int errno;					/* error number definition */

/* fake stdlib.h */

extern void *malloc( unsigned ); 
extern void *realloc( void *, unsigned );
extern void free( void * ); 
extern int abort( void ); 
extern void exit( int ); 
extern char *getenv( const char * );
#if !defined( apollo ) && !defined( __apollo__ )
extern int system( const char * );
#endif

/* fake stdio.h */

#ifndef __apollo__					/* apollo has prototypes for stdio functions */

#include <stdio.h>

extern FILE *fopen( const char *, const char * ); 
extern char *fgets( char *, int, FILE * ); 
extern char *gets( char * ); 
extern int fclose( FILE * ); 
extern int fflush( FILE * ); 
extern int fgetc( FILE * ); 
extern int printf( const char *, ... );
extern int fprintf( FILE *, const char *, ... );
extern char *sprintf();					/* problems with () and ... */
extern int vprintf( const char *, ...);
extern int vfprintf( FILE *, const char *, ... );
extern char *vsprintf( char *, const char *, ... );
extern int fputc( int, FILE * ); 
extern int puts( const char * ); 
extern int fputs( const char *, FILE * ); 
extern int scanf( const char *, ... );
extern int fscanf( FILE *, const char *, ... );
extern int sscanf( const char *, const char *, ... );
extern int ungetc( int, FILE * ); 
extern int fread( char *, int, int, FILE * );
extern int fwrite( const char *, int, int, FILE * );
extern void rewind( FILE * );
extern int fseek( FILE *, long, int );
extern FILE * freopen( const char *, const char *, FILE * ); 
extern int _filbuf( FILE * ); 
extern int _flsbuf( unsigned, FILE * ); 

#ifndef clearerr					/* this is a macro on some machines, a function on others */
extern int clearerr( FILE * );
#endif /* clearerr */

#endif /* __apollo__ */

#endif /* __U_STDC__ */

#include <stdio.h>

/* These look like they should be in ANSI C, but are not standard */

extern int _doprnt( char *, void *, FILE * );
extern int _doscan( FILE *, char *, void * );
 
/* Error number stuff */

#include <errno.h>					/* error number definitions */

/* Unix stuff */

/*
 * We could use the SGI definitions, except that there is
 * a non-ANSI C-preprocessor directive in one of their files,
 * which GCC (correctly) doesn't like.
 */

#if defined( sgi ) || defined( __sgi__ )
#include <bsd/sys/types.h>
#else
#include <sys/types.h>
#endif
#include <sys/stat.h>
    
/* profile calls */

extern void etext();
extern char *_mon_file;
extern void monstartup( int, void (*)( void ) );

/* process management */

extern int fork( void ); 
extern int wait( void * );
#ifdef __sgi__
#include <sys/prctl.h>
#endif

#ifndef getpid						/* this is a macro on some machines, a function on others */
extern int getpid( void ); 
#endif /* getpid */

extern int getpgrp( int ); 
extern void setpgrp( int, int ); 

extern int kill( int, int ); 
extern int killpg( int, int ); 
 
extern int open( const char *, int, int ); 
extern int close( int );
extern int flush( int );
extern int read( int, char *, int ); 
extern int write( int, const char *, int ); 
extern off_t lseek( int, off_t, int ); 
extern int fsync( int ); 
extern int fcntl();					/* problems with () and ... */
extern int unlink( const char * );
extern int fstat( int, struct stat * );
extern int select( int, fd_set *, fd_set *, fd_set *, void * );

/* socket management */

#if defined( __U_STDC__ ) && ( !defined( ultrix ) && !defined( __ultrix__ ) ) /* ANSI HEADER FILES AVAILABLE */
#include <sys/socket.h>
#else
extern int accept( int, void *, int * );
extern int bind( int, void *, int );
extern int connect( int, void *, int );
extern int getsockname( int, void *, int * );
extern int listen( int, int );
extern int socket( int, int, int );
#endif


/* miscellaneous non-ANSI library routines */

#if !defined( apollo ) && !defined( __apollo__ )
extern char *index( const char *, int );
#endif
extern void bzero( void *, unsigned );
extern void bcopy( const void *, void *, unsigned );

/* signal management */

extern int setitimer();
extern int sigblock( int );
extern int sigsetmask( int );
extern int sigpause( int );

/* shared memory management */

#ifdef __sequent__
extern void *shmalloc( unsigned ); 
extern void shfree( void * ); 
extern void *shrealloc( void *, unsigned ); 
#endif

#ifdef __encore__
extern int share_malloc_init( int );
extern void *share_malloc( unsigned );
extern void *share_free( void * );

#define U_SHARED_HEAP_SIZE (1024 * 1024)
#endif

#endif /* __U_UNIXH__ */
