/* Copyright (c) 1989 P. A. Buhr */

#include <uMonitor.h>

typedef int EventCounter;
typedef int Sequencer;

typedef struct {
    Sequencer Seq;
    EventCounter Event;
} SeqEvent;

uMonitor {
    uEntry int Ticket( SeqEvent *SE ) {
	SE->Seq += 1;
	return( SE->Seq );
    } /* Ticket */
    
    uEntry int readSequencer( SeqEvent *SE ) {
	return( SE->Seq );
    } /* readSequencer */
}

uMonitor ( PriorityAutomaticSignal ) {
    uEntry EventCounter readEvent( SeqEvent *SE ) {
	return( SE->Event );
    } /* readEvent */
    
    uEntry Advance( SeqEvent *SE ) {
	SE->Event += 1;
    } /* Advance */
    
    uEntry Await( SeqEvent *SE, int v ) {
	uWaitUntil SE->Event >= v ;
    } /* Await */
}

#define QueueSize 10

struct queue {
    int front;						/* position of front of queue */
    int back;						/* position of back of queue */
    int queue[QueueSize + 1];				/* queue of integers */
}; /* queue */

struct queue buffer = { 0, 1 };				/* bounded buffer, initialize front & back */

SeqEvent in = { 0, 0 }, out = { 0, 10 };

void Producer( int NoOfItems ) {
    int item, i;
    
    for ( i = 1; i <= NoOfItems; i += 1 ) {
	item = random( ) % 100;
	Await( &out, Ticket( &out ) );
	
	uPrintf( " Producer:%x, value:%2d\n", uThisTask( ), item );
	buffer.queue[buffer.back] = item;		/* insert element in queue */
	buffer.back = ( buffer.back + 1 ) % ( QueueSize + 1 );
	
	Advance( &in );
    } /* for */
    uDie( NULL, 0 );
} /* Producer */

void Consumer( int NoOfItems ) {
    int i, item;
    
    for ( i = 1; i <= NoOfItems; i += 1 ) {
	Await( &in, Ticket( &in ) );
	
	buffer.front = ( buffer.front + 1 ) % ( QueueSize + 1 );
	item = buffer.queue[buffer.front];		/* remove element from queue */
	
	Advance( &out );
	uPrintf( "Consumer :%x, value:%2d\n", uThisTask( ), item );
    } /* for */
    uDie( NULL, 0 );
} /* Consumer */

#define Items 100

void uMain( ) {
    uTask Cons, Prod1, Prod2;
    
    Cons = uEmit( Consumer, Items * 2 );
    Prod1 = uEmit( Producer, Items );
    Prod2 = uEmit( Producer, Items );
    
    uAbsorb( Cons, NULL, 0 );
    uAbsorb( Prod1, NULL, 0 );
    uAbsorb( Prod2, NULL, 0 );
    uPrintf( "successful completion\n" );
} /* main */
