/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Michel Fortier 1990
 * 
 * uMonBench.c -- benchmark test on the monitor facilities of the uMonitor
 *    preprocessor. It will run on the BSD and System V OSs.
 * 
 * Author           : Peter A. Buhr
 * Created On       : Thu Feb 15 10:13:32 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Tue Dec 18 22:24:54 1990
 * Update Count     : 21
 */

#include <uMonitor.h>
#include <Time.i>

/*
 * Time to get in an out of a monitor entry routine.
 */

uMonitor Entry( MONITORTYPE ) {
    uEntry void EntryRtn( void ) {}
} /* Entry */

void EntryTest( int N ) {
    int StartTime, EndTime;
    int i;

    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	EntryRtn( );
    } /* for */
    
    EndTime = Time();
    uPrintf( "& %d", ( EndTime - StartTime ) / N );

    uDie(NULL,0);
} /* EntryTest */

/*
 * Time to transfer 16 bytes bidirectionally between 2 tasks that are
 * communicating through a monitor.
  */

extern void bcopy();

uMonitor SRR( MONITORTYPE ) {
    uCondition send_queue = U_CONDITION, rec_queue = U_CONDITION;
    void *sender_sbuf, *sender_rbuf, *receiver_rbuf;
    int sender_slen, sender_rlen, receiver_rlen;

    uEntry void mon_send( void *rbuf, int rlen, void *sbuf, int slen ) {
	sender_rbuf = rbuf;				/* store reply area for the replier */
	sender_rlen = rlen;

	if ( uCondLength( &rec_queue ) == 0 ) {		/* receiver waiting ? */
	    sender_sbuf = sbuf;				/* store send message for the receiver */
	    sender_slen = slen;
	} else {
	    bcopy( sbuf, receiver_rbuf, slen );		/* copy sender message to receiver */
	    uSignal rec_queue;
	} /* if */
	uWait send_queue;
    } /* send */

    uEntry void mon_receive( void *rbuf, int rlen ) {
	receiver_rbuf = rbuf;				/* store receiver area for the sender */
	receiver_rlen = rlen;
	
	if ( uCondLength( &send_queue ) == 0 ) {	/* sender waiting ? */
	    uWait rec_queue;
	} else {
	    bcopy( sender_sbuf, rbuf, sender_slen );	/* copy sender message to receiver */
	} /* if */
    } /* receive */

    uEntry void mon_reply( void *sbuf, int slen ) {
	bcopy( sbuf, sender_rbuf, slen );		/* copy reply message to sender */

	uSignal send_queue;				/* signal the sender */
    } /* reply */
} /* SRR */

void ReceiveReply( int N ) {
    int i;
    char message[16];

    for( i = 0; i < N; i += 1 ) {
	mon_receive( message, sizeof( message ) );
	/* uPrintf( "ReceiveReply, received message:%s\n", message ); */
	/* message[0] += 1; */
	mon_reply( message, sizeof( message ) );
    } /* for */
    uDie(NULL,0);
} /* ReceiveReply */

void Send( int N ) {
    int StartTime, EndTime;
    int i;
    uTask replier;
    char message[16];

    replier = uEmit( ReceiveReply, N );

    /* message[0] = 'A'; */
    /* message[1] = '\0'; */
    
    StartTime = Time();

    for ( i = 0; i < N; i += 1 ) {
	/* uPrintf( "Send, sent message:%s\n", message ); */
	mon_send( message, sizeof( message ), message, sizeof( message ) );
	/* uPrintf( "Send, received message:%s\n", message ); */
    } /* for */
    
    EndTime = Time();
    uPrintf( "\t& %d", ( EndTime - StartTime ) / N );

    uAbsorb( replier, NULL, 0 );
    uDie(NULL,0);
} /* Send */

void uStart( void ) {
    uSetTimeSlice( 0 );					/* turn off time slice */
} /* uStart */

void uMain() {
    const int NoOfTimes = 10000;

    uPrintf( "monitor\tsend/rec/reply,\n" );
    uPrintf( "entry\t16 bytes\n" );
    uPrintf( "\tbidirectional\n" );

    uAbsorb( uEmit( EntryTest, NoOfTimes ), NULL, 0 );

    uAbsorb( uEmit( Send, NoOfTimes ), NULL, 0 );

    uPrintf( "\t\\\\\n" );

    uDie( NULL, 0 );
} /* uMain */

/* Local Variables: */
/* compile-command: "dmake -k" */
/* End: */
