/*
 * sunrpctest.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/02/11 23:29:58 $
 */

/*
 * Ping-pong test of SUNRPC
 */

#include "xkernel.h"
#include "sunrpc.h"

/*
 * These definitions describe the lower protocol
 */
#define HOST_TYPE IPhost
#define INIT_FUNC sunrpctest_init
#define TRACE_VAR sunrpctestp
#define PROT_STRING "sunrpc"

static	HOST_TYPE SERVER = SITE_SERVER_IP;
static	HOST_TYPE CLIENT = SITE_CLIENT_IP;
static	long	prog = 100, proc = 5, vers = 2;
static	long	clientPort = 2000, serverPort = 1002;

#define TRIPS 100
#define TIMES 1
#define DELAY 3
/*
 * Define to do timing calculations
 */
#define TIME
#define SAVE_SERVER_SESSN
#define RPCTEST
#define CUSTOM_ASSIGN

static void
setServer( p )
    Part	*p;
{
    partPush(*p, &SERVER);	/* IP host 		*/
    partPush(*p, &serverPort);
    partPush(*p, &prog);
    partPush(*p, &vers);
    partPush(*p, &proc);
}

static void
serverSetPart( p )
    Part	*p;
{
    partInit(p, 1);
    setServer(p);
}


static void
clientSetPart( p )
    Part	*p;
{
    partInit(p, 2);
    setServer(p);
#if 1
    partPush(p[1], ANY_HOST);
    partPush(p[1], &clientPort);
#endif    
}


static int lens[] = { 
  1000, 2000, 4000, 8000, 16000
};


#include "common_test.c"


static void
testInit()
{
}
