/*
 * blasttest.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/02/11 23:20:40 $
 */

/*
 * Ping-pong test of BLAST
 */

#include "xkernel.h"
#include "blast.h"

/*
 * These definitions describe the lower protocol
 */
#define HOST_TYPE IPhost
#define INIT_FUNC blasttest_init
#define TRACE_VAR blasttestp
#define PROT_STRING "blast"

static HOST_TYPE SERVER = SITE_SERVER_IP;
static HOST_TYPE CLIENT = SITE_CLIENT_IP;

#define TRIPS 100
#define TIMES 1
#define DELAY 3
/*
 * Define to do timing calculations
 */
#define TIME


static int lens[] = { 
  1, 1000, 2000, 4000, 8000, 16000
};


#define USE_KILL_TICKET

#ifdef USE_KILL_TICKET
#define CUSTOM_CLIENT_DEMUX
#define CUSTOM_SERVER_DEMUX
void	customClientDemux();
void	customServerDemux();
#endif USE_KILL_TICKET



#define SAVE_SERVER_SESSN


#include "common_test.c"

static void
testInit()
{
}

#ifdef USE_KILL_TICKET

void
customClientDemux( self, lls, dg )
    XObj	self, lls;
    Msg		*dg;
{
    if ( clientPushResult == 0 ) return;
    if (xControl(clientDownSes, FREERESOURCES,
		 (char *)&clientPushResult, sizeof(int))) {
	printf("FREERESOURCES on client session failed\n");
    }
}


void
customServerDemux( self, lls, dg )
    XObj	self, lls;
    Msg		*dg;
{
    if ( serverPushResult == 0 ) return;
    if (xControl(lls, FREERESOURCES,
		 (char *)&serverPushResult, sizeof(int))) {
	printf("FREERESOURCES on server session failed\n");
    }
}

#endif USE_KILL_TICKET
