/*
 * ip_i.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.24 $
 * $Date: 1992/02/05 20:14:11 $
 */

#ifndef ip_i_h
#define ip_i_h

#ifndef ip_h
#include "ip.h"
#endif

#ifndef upi_h
#include "upi.h"
#endif

#ifndef eth_h
#include "eth.h"
#endif


#define	IPHLEN	(sizeof(IPheader))

#define IPVERS	(4 << 4)
#define VERS_MASK 0xf0
#define HLEN_MASK 0x0f
#define GET_HLEN(h) ((h)->vers_hlen & HLEN_MASK)
#define GET_VERS(h) ( ((h)->vers_hlen & VERS_MASK) >> 4 )

#define IPMAXINTERFACES  10
#define IPOPTPACKET 512
#define IPMAXPACKET 65000*4	/* I mean maximum possible for protocol */
#define IPDEFAULTDGTTL  30
#define IP_GC_INTERVAL 30 * 1000 * 1000		/* 30 seconds */

/* fragment stuff */
#define DONTFRAGMENT  0x4000
#define MOREFRAGMENTS  0x2000
#define FRAGOFFMASK   0x1fff
#define FRAGOFFSET(fragflag)  ((fragflag) & FRAGOFFMASK)
#define COMPLETEPACKET(hdr) (!((hdr).frag & (FRAGOFFMASK | MOREFRAGMENTS)))
#define INFINITE_OFFSET      65000

#define IP_AND( x, y, z ) {	\
	(x).a = (y).a & (z).a;	\
	(x).b = (y).b & (z).b;	\
	(x).c = (y).c & (z).c;	\
	(x).d = (y).d & (z).d;	\
      }

typedef struct ipheader {
  	u_char 	vers_hlen;	/* high 4 bits are version, low 4 are hlen */
	u_char  type;
	u_short	dlen;
	u_short ident;
	u_short frag;
	u_char  time;
	u_char  prot;
	u_short checksum;
  	IPhost	source;		/* source address */
  	IPhost	dest;		/* destination address */
}	IPheader; 

typedef struct {
    long	type;
    ETHhost	host;
} ETHaddr;

typedef struct ipinterfaceinfo {
  XObj 		arpprotl;	/* arp protocol for this interface */
  XObj		ethprotl;	/* eth protocol for this interface */
  IPhost	myipaddr;	/* my ip address for this interface */
  IPhost	ipbcast;	/* ip broadcast address for this interface */
  IPhost 	netmask;
  ETHhost	myethhost;	/* my eth address for this interface */
} 	IPinterfaceinfo;

typedef struct pstate {
  IPinterfaceinfo interface[IPMAXINTERFACES];
  int		  n_interfaces;
  Map             activeMap;
  Map             passiveMap;
  Map             passiveSpecMap;
  Map		  fragMap;
}               PSTATE;

typedef struct sstate {
    IPheader	hdr;
    IPhost	dest;
    int		mtu;		   /* maximum transmission unit on intface */
    XObj	llp;		   /* protocol for current lower interface */
} SSTATE;

/*
 * The active map is keyed on the local and remote hosts rather than
 * the lls because the lls may change due to routing while the hosts
 * in the IP header will not.
 */
typedef struct {
    long	protNum;
    IPhost	remote;	/* remote host  */
    IPhost	local;	/* local host	*/
}	ActiveId;

typedef long	PassiveId;

typedef struct {
    long	prot;
    IPhost	host;
} PassiveSpecId;


/*
 * fragmentation structures
 */

typedef struct {
    IPhost source, dest;
    u_char prot;
    u_char pad;
    u_short seqid;
} FragId;

typedef struct hole_ent {
    u_short first, last;
} Hole_ent;

#define RHOLE  1
#define RFRAG  2

typedef struct fragif {
    u_char type;
    union {
	Hole_ent  *hole;
	Msg	  frag;
    } data;
    struct fragif *next, *prev;
} Fraginfo;

typedef struct Fragtable {
    u_short  	nholes;
    Fraginfo 	*listhead;
    Bind     	binding;
    bool	gcMark;
} Fragtable;

#define ERR_FRAG ((Fragtable *)-1)

#include "route.h"

#ifdef __STDC__

void	free_fragtable( Fragtable * );
int	ipRemoteNet( PSTATE *, IPhost *, route *);
int	ipSameNet( PSTATE *, IPhost *, route *);
void	ipRouteChanged( PSTATE *, route *,
			        int (*)(PSTATE *, IPhost *, route *) );
XObj 	ipGetInterface(PSTATE *, IPhost *);
int	ipControlProtl(XObj self, int opcode, char *buf, int len);
int	ipControlSessn(XObj self, int opcode, char *buf, int len);
IPinterfaceinfo *	ipLookupIfInfo(PSTATE *, XObj );

void	initNetMaskMap( void );
void	ipNetMask( IPhost *mask, IPhost *host );

#else

void	free_fragtable();
int	ipRemoteNet();
int	ipSameNet();
void	ipRouteChanged();
XObj 	ipGetInterface();
int	ipControlProtl();
int	ipControlSessn();
IPinterfaceinfo *	ipLookupIfInfo();

void	initNetMaskMap();
void	ipNetMask();

#endif

extern int traceipp;

#endif /* ip_i_h */
