/* 
 * chan_internal.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.13 $
 * $Date: 1992/02/05 20:14:10 $
 */
 
#ifndef chan_internal_h
#define chan_internal_h

#define CHANHLEN  		sizeof(CHAN_HDR) 
#define CHANEXTIDLEN 		sizeof(EXT_ID);
/* 
 * START_SEQ must be > 0
 */
#define START_SEQ 		1
 
/*--- Message types */
/* 
 * From client to server
 */
#define REQUEST			((unsigned short) 0x0100)
#define CLNT_EXPLICIT_ACK    	((unsigned short) 0x2000)
/* 
 * From server to client
 */
#define PROBE           	((unsigned short) 0x0200)
#define REPLY           	((unsigned short) 0x0800)
#define SVC_EXPLICIT_ACK    	((unsigned short) 0x1000)

/*--- True flags */
#define ACK_REQUESTED   	((unsigned short) 0x0001)

/*--- Direction field values */
#define CLIENT 			1
#define SERVER 			2

typedef enum {
    SUCCESS, FAILURE
} ReplyValue;

typedef enum {
    /*--- Server states */
    SVC_EXECUTE = 1,	/* Sent msg up, waiting for answer */
    SVC_WAIT,		/* Waiting for an ACK of the reply */
    SVC_IDLE,
    /*--- Client states */
    CLNT_WAIT,
    CLNT_FREE
} SES_STATE;


/*--- Message sequence possible status */
typedef enum {
  	old, current, new
} SEQ_STAT;

typedef u_int	SeqNum;

/*--- Channel Header structure */ 
typedef struct  {
    u_short	chan;
    u_int	prot_id;
    SeqNum	seq;
    u_short 	flags;
    u_int	boot_id;
    u_int	len;
} CHAN_HDR;


typedef struct {
    Msg	m;
    char valid;
} ChanMsg;

typedef struct {
    XObj	ses;
    SeqNum	seq;
} TimeoutState;

/*--- Channel State structure */
typedef struct {
        SES_STATE 	cur_state;
	int 		direction;
        int 		wait;
        int 		tries;
        Event 		event;
	TimeoutState	*evState;
	CHAN_HDR 	hdr;
	ChanMsg		saved_msg;
	/* 
	 * client only
	 */
	ReplyValue	replyValue;
        Msg 		*answer;
        Semaphore 	reply_sem;
        int 		ticket;
} CHAN_STATE;

/*--- Protocol state structure */
typedef struct {
	Map 		active_server_map;
	Map 		active_client_map;
	Map 		passive_map;
	unsigned short 	channel_number;
} PSTATE;

/*--- Ids used to demux to active sessions */
typedef struct {
        unsigned short direction;
	unsigned short chan;
	XObj down_s;
        unsigned int prot_id;
} ActiveID;

/*--- prot_id serves as passive key to demux to passive sessions */
typedef unsigned int PassiveID;


/*--- Delays are specified in microseconds! */
#define MAX_SERVER_WAIT 	20 * 1000 * 1000	/* 20 seconds */
#define SERVER_WAIT 		4 * 1000 * 1000		/* 4 seconds */
#define CLIENT_WAIT 		1 * 1000 * 1000		/* 1 second */


/*--- We still need to figure out a good delay, may need to query
      bottom protocol for hints. */
#define CHAN_CLNT_DELAY(m) 	(CLIENT_WAIT + 2*100)
#define CHAN_SVC_DELAY(m)  	(SERVER_WAIT + 2*100)
/* 
 * TRIES -- number of timeouts before giving up (e.g., if CLIENT_TRIES
 * is 2, the client will give up on the second timeout.)
 * Note that both client and server timeouts use exponential backoff
 */
#define CLIENT_TRIES 		5
#define SERVER_TRIES		3


#define msg_valid(M)	((M).valid = 1)
#define msg_clear(M)	((M).valid = 0)
#define msg_isnull(M)	((M).valid == 0)
#define msg_flush(M) 	{ if ((M).valid) {  msgDestroy(&(M).m);  \
			    	 	    (M).valid=0; } }

#define MAX(x,y) 		((x)>(y) ? (x) : (y))
#define MIN(x,y) 		((x)<(y) ? (x) : (y))

#ifdef __STDC__

int	chanCheckMsgLen( u_int, Msg * );
SEQ_STAT chanCheckSeq( u_int, u_int );
xkern_return_t	chanCloseSessn( XObj );
int	chanControlSessn( XObj, int, char *, int );
void	chanFreeResources( XObj );
long	chanGetProtNum( XObj, XObj );
xkern_return_t 	chanOpenEnable( XObj, XObj, XObj, Part * );
xkern_return_t 	chanOpenDisable( XObj, XObj, XObj, Part * );
void 	chanReply( XObj, CHAN_HDR *, int );
char * 	chanStateStr( int );
XObj 	chanSvcOpen( XObj, Enable *, XObj, int, int );
void	chanHdrStore( void *, char *, long, void * );
XObj	chanOpen( XObj, XObj, XObj, Part * );
char * 	chanStatusStr( SEQ_STAT );
void 	pChanHdr( CHAN_HDR * );

#else

int	chanCheckMsgLen();
SEQ_STAT chanCheckSeq();
xkern_return_t	chanCloseSessn();
int	chanControlSessn();
void	chanFreeResources();
long	chanGetProtNum();
xkern_return_t 	chanOpenEnable();
xkern_return_t 	chanOpenDisable();
void 	chanReply();
char * 	chanStateStr();
XObj 	chanSvcOpen();
void	chanHdrStore();
XObj	chanOpen();
char * 	chanStatusStr();
void 	pChanHdr();

#endif


extern	int	tracechanp;

#endif
