/* 
 * arp_table.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.2 $
 * $Date: 1992/01/14 22:13:28 $
 */

#ifdef __STDC__

/*
 * arpLookup -- Find the ETH host equivalent of the given IP host.
 * If the value is not in the table, network ARP requests will be sent.
 * Returns 0 if the lookup was successful and -1 if it was not.
 */
int	arpLookup( IPhost *, ETHhost * );

/*
 * arpRevLookup -- Find the IP host equivalent of the given ETH host.
 * If the value is not in the table, network RARP requests will be sent.
 * Returns 0 if the lookup was successful and -1 if it was not.
 */
int	arpRevLookup( IPhost *, ETHhost * );

/*
 * arpRevLookupTable -- Find the IP host equivalent of the given ETH host.
 * Only looks in the local table, does not send network requests.
 * Returns 0 if the lookup was successful and -1 if it was not.
 */
int	arpRevLookupTable( IPhost *, ETHhost * );

/*
 * Initialize the arp table.
 */
void	arpTableInit( void );

/*
 * Save the IPhost<->ETHhost binding, releasing any previous bindings
 * that either of these addresses might have had.  Unblocks processes
 * waiting for this binding.  One of ip or eth can be
 * null, in which case the blocked processes will be freed and told that
 * the address could not be resolved
 */
void 	arpSaveBinding( IPhost *ip, ETHhost *eth );


/*
 * arpLock -- lock the entry with the given IP host so the entry always
 * remains in the cache.
 */
void	arpLock( IPhost *h );


#endif  __STDC__
