/* 
 * upi_inline.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.8 $
 * $Date: 1992/01/31 05:57:22 $
 */

#ifndef upi_inline_h
#define upi_inline_h

/*
 * definitions of xPop and xCallPop
 *
 * In OPTIMIZE mode (GCC):
 *    These are inline functions, so this file should be included by
 *    all source files which invoke these functions.
 *
 * In DEBUG mode (or not using GCC):
 *    These are the definitions of normal functions, so this file should
 *    only be included by a single source file.
 */

#if defined(NDEBUG) && defined(__GNUC__)
#  define FUNC_TYPE extern inline xkern_return_t
#else
#  define FUNC_TYPE xkern_return_t
#endif


/*
 * OP_COUNTS controls whether session reference counts are raised and
 * lowered around each operation in order to count the number of
 * operations "outstanding" on that session
 */
#define OP_COUNTS	



#ifdef OP_COUNTS
#define INC_REF_COUNT(sessn, func) 					\
  {									\
    (sessn)->rcnt++;							\
    xTrace4(protocol, 5, "%s increased ref count of %x[%s] to %d",	\
	    (func), sessn, (sessn)->myprotl->name, (sessn)->rcnt);	\
  }
#else
#define INC_REF_COUNT(s, func) 1
#endif
  	

#define DEC_REF_COUNT_UNCOND(sessn, func)				\
  {									\
    if (--(sessn)->rcnt <= 0) {						\
	xTrace4(protocol, 5,						\
		"%s -- ref count of %x[%s] is %d, calling close",	\
		(func), s, (sessn)->myprotl->name, (sessn)->rcnt);	\
	(*(sessn)->close)(sessn);					\
    } else {								\
	xTrace4(protocol, 5,						\
		"%s -- decreased ref count of %x[%s] to %d",		\
		(func), s, (sessn)->myprotl->name, (sessn)->rcnt);	\
    }									\
  }


#ifdef OP_COUNTS
#define DEC_REF_COUNT(s, func) DEC_REF_COUNT_UNCOND((s), (func))
#else
#define DEC_REF_COUNT(s, func) 1
#endif  


FUNC_TYPE
xPop(s, ds, msg)
    XObj s;
    XObj ds;
    Msg *msg;
{
    xkern_return_t retVal;
    
    xAssert(!(int)ds || xIsSession(ds));
    INC_REF_COUNT(s, "xPop");
    xTrace2(protocol, 3, "Calling pop[%s], %d bytes", s->myprotl->name,
	    msgLen(msg));
    retVal = (*s->pop)(s, ds, msg);
    DEC_REF_COUNT(s, "xPop");
    return retVal;
}


FUNC_TYPE
xCallPop(s, ds, msg, replyMsg)
    XObj s;
    XObj ds;
    Msg *msg;
    Msg *replyMsg;
{
    xkern_return_t retVal;
    
    xAssert(!(int)ds || xIsSession(ds));
    INC_REF_COUNT(s, "xCallPop");
    xTrace2(protocol, 3, "Calling callpop[%s], %d bytes", s->myprotl->name,
	    msgLen(msg));
    retVal =  (*s->callpop)(s, ds, msg, replyMsg);
    xTrace2(protocol, 3, "callpop[%s] returns %d bytes", s->myprotl->name,
	    msgLen(replyMsg));
    DEC_REF_COUNT(s, "xCallPop");
    return retVal;
}


#endif	! upi_inline_h

