/* 
 * system.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * global definitions, and system definitions.
 */

#ifndef system_h
#define system_h

#ifndef debug_h
#include "debug.h"
#endif

extern char *strcpy();
extern char *alloca(), *calloc(), *realloc();

extern char *malloc();

#ifdef sparc					/* using sun malloc/free */
extern int free();
#else
extern void free();
#endif sparc

/* sparc change: don't define sprintf on sparc either  cjt */
#if (defined sun && ! defined sparc)
extern char *sprintf();
#endif

typedef long *Unspec;
typedef unsigned long ProcessId;
typedef unsigned long ContextId;

#ifndef NULL
#define NULL	0
#endif
#define MAXUNSIGNED	((unsigned) (-1)

void splx();
int  spl7();
#define INIT_STACK_SIZE 1024

#define BYTES_PER_WORD	4

#define CLICKS_PER_SEC 100	/* Clock interrupts per second */

#define min(A, B) ((A) < (B) ? (A) : (B))
#define max(A, B) ((A) > (B) ? (A) : (B))
#define ROUNDUP(A, B)   ((((Bit32) (A)) + ((B) - 1)) & (~((B)-1)))
#define ROUNDDOWN(A, B)  (((Bit32) (A)) & (~((B)-1)))
#define BETWEEN(A,B,C) ((A) <= (B) && (B) < (C))

typedef	char	*mapKeyPtr_t;
typedef	int	mapVal_t;

typedef char	*statePtr_t;

typedef int	boolean;

#ifndef	TRUE
#define	TRUE	1
#define FALSE	0
#endif

#define	SUCCESS_RET_VAL		0
#define	FAILURE_RET_VAL		(-1)

#define	LO_BYTE_OF_2(word)	 ((u_char) (0xff & (unsigned) word))
#define HI_BYTE_OF_2(word)	 ((u_char) (((unsigned) word) >> 8 ))
#define CAT_BYTES(hiByte,loByte) ((((unsigned)hiByte)<<8) + (unsigned)loByte)

#endif system_h
