/*
 * prottbl.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.3 $
 * $Date: 1992/02/05 21:34:17 $
 */

/* 
 * Interface to the protocol table utility
 */

#ifndef prottbl_h
#define prottbl_h

#ifndef upi_h
#include "upi.h"
#endif

/* 
 * protTblBuild -- add the entries in the specified file to the table
 * returns non-zero if there were problems
 */
#ifdef __STDC__
extern int	protTblBuild( char *filename );
#endif

/* 
 * return the protocol id number of the protocol by looking in the table.
 * If no entry for this protocol exists, -1 is returned.
 */
extern long	protTblGetId(
#ifdef __STDC__
			 char *protocolName
#endif
			 );

/* 
 * relProtNum -- return the number of hlp relative to llp.  If this
 * number can not be determined from the table, -1 is returned.  This
 * should be considered an error.
 */
extern long	relProtNum(
#ifdef __STDC__
			   XObj hlp, XObj llp
#endif
			   );

#endif !prottbl_h
